/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.IOException;
import java.io.InputStream;
import oracle.forms.common.Charsets;
import oracle.forms.registry.MessageGenerator;

public class ConnectionException
extends IOException {
    protected static final String CONTENT_PREFIX = "ifError:";
    public static final String CONTENT_TYPE = "text/plain";
    public static final int TYPE_GENERAL = 0;
    public static final int TYPE_NOSERVLETSESSIONID = 1;
    public static final int TYPE_MULTIPLE_SESSIONS = 2;
    public static final int TYPE_PROCESS_CREATE_FAIL = 4;
    public static final int TYPE_PROCESS_STARTUP_FAIL = 5;
    public static final int TYPE_PROCESS_DEAD = 6;
    public static final int TYPE_SESSION_MIGRATION = 7;
    public static final int TYPE_OID_CONN = 8;
    public static final int TYPE_OID_AUTH = 9;
    public static final int TYPE_SSO_AUTH_FAIL = 10;
    public static final int TYPE_RESPONSE_PENDING = 11;
    public static final int TYPE_ERROR_WRITING_RESPONSE = 12;
    public static final int TYPE_SSO_BAD_CFG = 13;
    public static final int TYPE_PROCESS_CREATE_REJECTED = 14;
    public static final int TYPE_USER_ERROR = 15;
    private int mErrorType;
    private Object[] mValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionException createConnectionException(InputStream inputStream, int n) {
        String string = null;
        try {
            byte[] byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            int n4 = 0;
            try {
                while (n2 > 0) {
                    n3 = inputStream.read(byArray, n4, n2);
                    if (n3 <= 0) {
                        break;
                    }
                    n2 -= n3;
                    n4 += n3;
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            string = new String(byArray, Charsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ConnectionException(string);
    }

    public ConnectionException(int n) {
        this.mErrorType = n;
    }

    public ConnectionException(int n, String string, Object[] objectArray) {
        super(string);
        this.mErrorType = n;
        this.mValues = objectArray;
    }

    public ConnectionException(int n, String string) {
        this(n, string, (Object[])null);
    }

    public ConnectionException(int n, String string, Object object) {
        this(n, string, new Object[]{object});
    }

    public ConnectionException(int n, String string, Throwable throwable) {
        this(n, string);
        this.initCause(throwable);
    }

    public ConnectionException(String string) {
        super(string.substring(string.indexOf(47) + 1));
        String string2 = string.substring(string.indexOf(58) + 1, string.indexOf(47));
        try {
            this.mErrorType = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.mErrorType = 0;
        }
    }

    public Object[] getValues() {
        return this.mValues;
    }

    public byte[] getBytes(MessageGenerator messageGenerator, String string) {
        String string2;
        switch (this.mErrorType) {
            case 7: 
            case 11: {
                string2 = this.getMessage();
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 15: {
                string = null;
            }
            default: {
                string2 = messageGenerator.getMessage(this.getMessage(), this.getValues());
                if (string == null) break;
                string2 = string2 + "\n\n" + messageGenerator.getText(string, null);
            }
        }
        String string3 = CONTENT_PREFIX + Integer.toString(this.mErrorType) + "/" + string2;
        return string3.getBytes(Charsets.UTF_8);
    }

    public boolean isOfType(int n) {
        return this.mErrorType == n;
    }

    public boolean requiresSysadminAction() {
        switch (this.mErrorType) {
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                return false;
            }
        }
        return true;
    }

    public boolean isFatal() {
        switch (this.mErrorType) {
            case 7: 
            case 11: {
                return false;
            }
        }
        return true;
    }
}

