/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.awt.Desktop;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import oracle.forms.common.Utils;
import oracle.forms.registry.MessageGenerator;

public class BrowserCookies {
    private static final boolean DEBUG_COOKIES = false;

    private BrowserCookies() {
    }

    public static void launchBrowserWithCookies(String string, boolean bl, String string2) {
        Object object;
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        CookieStore cookieStore = cookieManager.getCookieStore();
        String[] stringArray = string.split("\\?", 2);
        String string3 = stringArray[0];
        URI uRI = null;
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println(uRISyntaxException.getMessage());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        List<HttpCookie> list = cookieStore.get(uRI);
        for (HttpCookie httpCookie : list) {
            if (httpCookie.getMaxAge() != -1L) continue;
            if (httpCookie.getName().equals(string2)) {
                bl2 = true;
                if (httpCookie.isHttpOnly()) {
                    stringBuilder.append(';');
                }
            } else if (httpCookie.isHttpOnly()) continue;
            stringBuilder.append(httpCookie.getName());
            stringBuilder.append('=');
            stringBuilder.append(httpCookie.getValue());
            if (httpCookie.getPath() != null) {
                stringBuilder.append("; Path=");
                stringBuilder.append(httpCookie.getPath());
            }
            stringBuilder.append('\u001e');
        }
        if (bl2) {
            int n;
            object = ";jsessionid=";
            if (!string2.equals("JSESSIONID")) {
                object = ";" + string2 + "=";
            }
            if ((n = string3.indexOf((String)object)) > 0) {
                string3 = string3.substring(0, n);
            }
        }
        object = new StringBuilder();
        int n = 63;
        ((StringBuilder)object).append(string3);
        if (stringBuilder.length() > 0 || bl) {
            stringBuilder.append(";;");
            stringBuilder.append(string3);
            ((StringBuilder)object).append("?ifhash=");
            ((StringBuilder)object).append(Utils.urlEncode(stringBuilder.toString()));
            n = 38;
        }
        if (stringArray.length > 1) {
            ((StringBuilder)object).append((char)n);
            ((StringBuilder)object).append(stringArray[1]);
        }
        Browser browser = new Browser(((StringBuilder)object).toString());
        Thread thread = new Thread(browser);
        thread.start();
    }

    static class Browser
    implements Runnable {
        private String mServerURL;

        public Browser(String string) {
            this.mServerURL = string;
        }

        @Override
        public void run() {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(this.mServerURL));
                }
                catch (IOException | URISyntaxException exception) {
                    System.out.println(exception.getMessage());
                }
            } else {
                MessageGenerator messageGenerator = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault());
                System.out.println(messageGenerator.getMessage("FRM-92493"));
            }
        }
    }
}

