/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.displayFilter.CharEchoFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterTiler;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.InputEventUtils;
import oracle.forms.api.FException;
import oracle.forms.api.IObject;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.PatternProducer;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ButtonItem;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.FormWindow;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.JavaContainer;
import oracle.forms.handler.PopupHelpItem;
import oracle.forms.handler.RadioButtonItem;
import oracle.forms.handler.TabControl;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.handler.TreeItem;
import oracle.forms.properties.Alignment;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.CaseRestriction;
import oracle.forms.properties.ID;
import oracle.forms.properties.ImageScrollPolicy;
import oracle.forms.properties.LanguageDirection;
import oracle.forms.properties.Property;
import oracle.forms.properties.WrapStyle;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.test.Test;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.FScrollBox;
import oracle.forms.ui.FSplitter;
import oracle.forms.ui.FormsTabPanel;
import oracle.forms.ui.IView;
import oracle.forms.ui.OracleBorderPainter;
import oracle.forms.ui.VButton;
import oracle.forms.ui.VTextField;

public class UICommon
implements MessageHandler,
Test,
IHandler,
KeyListener {
    private IView mView;
    private static final boolean DO_ZORDER_HACK = false;
    private static HashMap<Color, OracleBorderPainter> sPainters = null;
    private static HashMap<Color, OracleBorderPainter> sRolloverPainters = null;
    private MessageHandler mHandler;
    private Component mComponent;
    private String mName;
    private int mHandlerId = 0;
    private Runform mDispatcher = null;
    private Main mMainApplet = null;
    private String mBGPattern = "transparent";
    private int mBGColor = 255;
    private int mFGColor = 0;
    private Insets mInsets = null;
    private int mFontIndex = 0;
    private int mEventMode;
    private boolean mBordered = false;
    private byte mBorderWidth = 0;
    private int mDirection = 1;
    private static Component sExpectedFocusIn;
    private static Component sExpectedFocusOut;
    private static boolean sFocusHidden;
    protected Point mPosition = new Point(0, 0);
    protected Point mSize = new Point(0, 0);
    private static DisplayStringFilter sPasswordFilter;
    private static Hashtable sFocusChanges;
    private static Vector sFocusChangesInactiveApplet;
    private PatternProducer mPatternProducer;
    private static Object sKeyEventTarget;
    private static MouseEvent sNeedScrollbarMouseReleasedEvent;
    public static final int UI_EVENTMASK_NONE = 0;
    public static final int UI_EVENTMASK_MOUSECLICK = 1;
    public static final int UI_EVENTMASK_MOUSEMOTION = 2;
    public static final int UI_EVENTMASK_MOUSECROSSING = 4;
    public static final int UI_EVENTMASK_KEY = 8;
    public static final int UI_EVENTMASK_POPUPMENU = 256;
    public static final int UI_EVENTMASK_ALL = -1;
    public static final int UI_EVENTMASK_SUPPORTED = 271;
    public static final byte UI_DIRECTION_DEFAULT = 0;
    public static final byte UI_DIRECTION_TORIGHT = 1;
    public static final byte UI_DIRECTION_TOLEFT = 2;
    public static final String SYSTEM_MENU_PROPERTY = "SystemMenuProperty";
    private boolean mClientGetReturned;
    private Object mClientGetReturnValue;
    protected boolean mLocked = false;
    private BorderPainter mBorderPainter = null;
    protected BorderPainter mRolloverEntryPainter = null;
    protected BorderPainter mRolloverPainter = null;
    protected BorderPainter mHighlightPainter = null;
    private boolean mPatternPending;
    private static Image mFrameIcon;
    private static boolean sFocusRequest;
    private boolean mServerFocusRequest = false;
    private boolean mDeferredFocusRequest = false;
    private BorderPainter mRequiredPainter = null;
    private boolean mGlass = false;

    public UICommon(MessageHandler messageHandler) {
        this.setHandler(messageHandler);
    }

    protected UICommon() {
    }

    public Component getComponent() {
        return this.mComponent;
    }

    protected MessageHandler getHandler() {
        return this.mHandler;
    }

    protected int getLWDirection(byte by) {
        int n = 0;
        if (by == 2) {
            n = 2;
        } else if (by == 1) {
            n = 1;
        }
        return by;
    }

    protected byte getDirection() {
        return (byte)this.mDirection;
    }

    public BorderPainter getRolloverPainter() {
        return this.mRolloverPainter;
    }

    public BorderPainter getHighlightPainter() {
        return this.mHighlightPainter;
    }

    public final boolean isToLeft() {
        boolean bl = this.mView == null ? this.getDirection() == 2 : (LanguageDirection)this.mView.getProperty(ID.LANGUAGE_DIRECTION) == LanguageDirection.RIGHT_TO_LEFT;
        return bl;
    }

    protected void setDirection(byte by) {
        this.mDirection = by;
        if (this.mView == null && this.mComponent instanceof LWComponent) {
            ((LWComponent)this.mComponent).setReadingDirection(this.getLWDirection(by));
        }
    }

    public static boolean setDefaultFocus(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible() || !component.isEnabled()) continue;
            if (component.isFocusable()) {
                component.requestFocus();
                return true;
            }
            if (!(component instanceof Container) || !UICommon.setDefaultFocus((Container)component)) continue;
            return true;
        }
        return false;
    }

    protected void setComponent(Component component) {
        this.mComponent = component;
        this.mComponent.setVisible(false);
    }

    private static final void deferRequestFocusForInactiveApplet(UICommon uICommon, Object object) {
        UICommon uICommon2 = uICommon;
        Objects.requireNonNull(uICommon2);
        DeferredItem deferredItem = uICommon2.new DeferredItem(uICommon, object);
        sFocusChangesInactiveApplet.add(deferredItem);
        if (uICommon.getDispatcher().isLoggingEnabled()) {
            uICommon.getDispatcher().getFocusLogger().sendMessage(uICommon, 8);
        }
    }

    public static final void doDeferredRequestFocusForInactiveApplet(Frame frame) {
        if (!frame.isActive()) {
            return;
        }
        while (!sFocusChangesInactiveApplet.isEmpty()) {
            DeferredItem deferredItem = (DeferredItem)sFocusChangesInactiveApplet.get(0);
            deferredItem.item.setDeferredFocusRequest(true);
            deferredItem.item.setFVP(ID.getInstance(174), deferredItem.value);
            deferredItem.item.setDeferredFocusRequest(false);
            sFocusChangesInactiveApplet.removeElementAt(0);
        }
    }

    public static final void deferRequestFocus(LWWindow lWWindow, UICommon uICommon) {
        Vector<UICommon> vector = (Vector<UICommon>)sFocusChanges.get(lWWindow);
        if (vector == null) {
            vector = new Vector<UICommon>(1, 1);
        }
        vector.add(uICommon);
        sFocusChanges.put(lWWindow, vector);
        if (uICommon != null && uICommon.getDispatcher().isLoggingEnabled()) {
            uICommon.getDispatcher().getFocusLogger().sendMessage(uICommon, 2);
        }
    }

    public static final void doDeferredRequestFocus(LWWindow lWWindow) {
        Vector vector = (Vector)sFocusChanges.remove(lWWindow);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Message message;
            UICommon uICommon = (UICommon)vector.get(i);
            if (uICommon == null || uICommon.getEventComponent() == null) continue;
            if (uICommon.getEventComponent().isVisible()) {
                uICommon.getEventComponent().requestFocus();
                if (!(uICommon instanceof FormCanvas) || !(uICommon.getEventComponent() instanceof FScrollBox) || uICommon.getDispatcher().getFocusOwner() == null) continue;
                message = Message.newMessage(uICommon.getDispatcher().getFocusOwner(), 174, Boolean.FALSE);
                uICommon.getDispatcher().onMessage(message, 1);
                uICommon.getDispatcher().setFocusOwner(null);
                continue;
            }
            message = Message.newMessage(uICommon, 521, Boolean.TRUE);
            uICommon.getDispatcher().onMessage(message, 1);
        }
    }

    public static final void removeDeferredRequestFocus(LWWindow lWWindow) {
        Vector vector = (Vector)sFocusChanges.remove(lWWindow);
    }

    public final void clearDeferredRequestFocus(LWWindow lWWindow) {
        Vector vector = (Vector)sFocusChanges.get(lWWindow);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                UICommon uICommon = (UICommon)vector.get(i);
                Message message = Message.newMessage(uICommon, 521, Boolean.TRUE);
                this.getDispatcher().onMessage(message, 1);
            }
        }
    }

    public LWWindow getParentWindow() {
        Component component;
        for (component = this.getComponent(); component != null && !(component instanceof LWWindow); component = component.getParent()) {
        }
        return (LWWindow)component;
    }

    public static final boolean isFocusHidden() {
        return sFocusHidden;
    }

    public static final Component getExpectedFocusIn() {
        return sExpectedFocusIn;
    }

    public static final Component getExpectedFocusOut() {
        return sExpectedFocusOut;
    }

    public static final void setExpectedFocusIn(Component component) {
        sExpectedFocusIn = component;
    }

    public static final void setExpectedFocusOut(Component component) {
        sExpectedFocusOut = component;
    }

    public static final void setFocusHidden(boolean bl) {
        sFocusHidden = bl;
    }

    protected Component getEventComponent() {
        return this.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFocus() {
        boolean bl = false;
        LWWindow lWWindow = this.getParentWindow();
        if (lWWindow != null) {
            Component component = lWWindow.getFocusOwner();
            if (!lWWindow.isActive() || lWWindow.isMinimized()) {
                UICommon.deferRequestFocus(lWWindow, this);
                bl = true;
            } else {
                Object object;
                Object object2;
                if (lWWindow instanceof ExtendedFrame && lWWindow.isModal()) {
                    object2 = ((ExtendedFrame)lWWindow).getHandler();
                    Object object3 = object = ((FormWindow)object2).activationLock();
                    synchronized (object3) {
                        if (!((FormWindow)object2).isActivated()) {
                            try {
                                long l = System.currentTimeMillis();
                                object.wait(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.getEventComponent() != component) {
                    this.clearDeferredItem();
                    if (!this.isDeferredFocusRequest()) {
                        while (!sFocusChangesInactiveApplet.isEmpty()) {
                            object2 = (DeferredItem)sFocusChangesInactiveApplet.get(0);
                            if (object2 != null) {
                                object = Message.newMessage(((DeferredItem)object2).item, 521, Boolean.TRUE);
                                this.getDispatcher().onMessage((Message)object, 1);
                            }
                            sFocusChangesInactiveApplet.removeElementAt(0);
                        }
                    }
                    object2 = this.getDispatcher().getFocusOwner();
                    if (!this.getEventComponent().requestFocusInWindow()) {
                        UICommon.deferRequestFocus(lWWindow, this);
                        bl = true;
                    } else if (this.getDispatcher().getFocusOwner() == null || this.getDispatcher().getFocusOwner() == object2) {
                        UICommon.deferRequestFocus(lWWindow, this);
                        bl = true;
                    }
                    if (LWComponent.getFocusedComponent() == this.getEventComponent() && this.getDispatcher().getFocusOwner() != this && this.getDispatcher().getFocusOwner() != null) {
                        object = Message.newMessage(this.getDispatcher().getFocusOwner(), 174, Boolean.FALSE);
                        this.getDispatcher().onMessage((Message)object, 1);
                        this.getDispatcher().setFocusOwner(null);
                    }
                }
            }
        }
        return bl;
    }

    public final void clearDeferredItem() {
        if (!sFocusChanges.isEmpty()) {
            Enumeration enumeration = sFocusChanges.keys();
            while (enumeration.hasMoreElements()) {
                LWWindow lWWindow = (LWWindow)enumeration.nextElement();
                Vector vector = (Vector)sFocusChanges.remove(lWWindow);
                if (vector == null) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    UICommon uICommon = (UICommon)vector.get(i);
                    if (uICommon == null) continue;
                    Message message = Message.newMessage(uICommon, 521, Boolean.TRUE);
                    this.getDispatcher().onMessage(message, 1);
                }
            }
        }
    }

    protected void setHandler(MessageHandler messageHandler) {
        this.mHandler = messageHandler;
        if (this.mHandler instanceof Component) {
            this.setComponent((Component)((Object)this.mHandler));
        }
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        this.mDispatcher = runform;
        this.mMainApplet = runform.getApplet();
        this.mHandlerId = message.getHandlerId();
        this.instantiate(message);
    }

    @Override
    public synchronized void onUpdate(Message message) {
        int n = message.size();
        for (int i = 0; i < n && this.mHandler != null; ++i) {
            int n2 = message.getPropertyAt(i);
            Object object = message.getValueAt(i);
            try {
                if (!this.onUpdate(n2, object)) continue;
            }
            catch (ClassCastException classCastException) {
                MessageGenerator messageGenerator = this.getApplet().getErrorMessageGenerator();
                System.out.println(messageGenerator.getMessage("FRM-92480", ID.getInstance(n2).toString(), classCastException.toString()));
                return;
            }
        }
    }

    @Override
    public synchronized void onRegister(int n) {
        this.mHandler.onRegister(n);
    }

    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = false;
        if (this.mComponent != null) {
            if (this.setFVP(n, object)) {
                return true;
            }
            bl = this.onComponentUpdate(n, object);
        }
        return bl;
    }

    protected synchronized boolean onComponentUpdate(int n, Object object) {
        boolean bl = false;
        Object var4_4 = null;
        if (this.mHandler == null) {
            return true;
        }
        switch (n) {
            case 134: {
                this.doAddParent((Integer)object);
                bl = true;
                break;
            }
            case 135: {
                if (this instanceof FormCanvas && ((FormCanvas)this).getSplitter() != null) {
                    ((FormCanvas)this).getSplitter().setLocation(((Point)object).x, ((Point)object).y);
                } else {
                    this.mComponent.setLocation(((Point)object).x, ((Point)object).y);
                }
                this.mPosition = (Point)object;
                bl = true;
                break;
            }
            case 136: {
                bl = true;
                break;
            }
            case 137: {
                this.setSize((Point)object);
                if (this instanceof FormCanvas && ((FormCanvas)this).getSplitter() != null) {
                    int n2 = 0;
                    FSplitter fSplitter = ((FormCanvas)this).getSplitter();
                    int n3 = fSplitter.getSplitterPosition();
                    if (this.getDirection() == 2 && !fSplitter.isHorizontal()) {
                        n2 = fSplitter.getSize().width;
                    }
                    fSplitter.setSize(((Point)object).x, ((Point)object).y);
                    if (this.getDirection() == 2 && !fSplitter.isHorizontal()) {
                        if (n3 == -1) {
                            n3 = fSplitter.getCachedPos();
                        }
                        fSplitter.setSplitterPosition(((Point)object).x - (n2 - n3));
                        fSplitter.setCachedPos(((Point)object).x - (n2 - n3));
                    } else {
                        fSplitter.setSplitterPosition(n3 + 1);
                        fSplitter.setSplitterPosition(n3);
                    }
                } else {
                    this.mComponent.setSize(((Point)object).x, ((Point)object).y);
                }
                if (this.mComponent.isVisible() && this.mComponent instanceof ScrollBox) {
                    this.mComponent.validate();
                }
                bl = true;
                break;
            }
            case 138: {
                bl = true;
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                bl = true;
                break;
            }
            case 144: {
                boolean bl2 = (Boolean)object;
                this.mComponent.setEnabled(bl2);
                bl = true;
                break;
            }
            case 146: {
                this.mFGColor = (Integer)object;
                this.mComponent.setForeground(this.mHandler.getDispatcher().getColorEntry(this.mFGColor));
                if (!(this instanceof ComponentItem) || ((ComponentItem)this).mGradientStart == 0) {
                    this.updatePattern(this.mComponent, false);
                }
                bl = true;
                break;
            }
            case 147: {
                this.mBGColor = (Integer)object;
                this.mComponent.setBackground(this.mHandler.getDispatcher().getColorEntry(this.mBGColor));
                if (!(this instanceof ComponentItem) || ((ComponentItem)this).mGradientStart == 0) {
                    this.updatePattern(this.mComponent, false);
                }
                bl = true;
                break;
            }
            case 148: {
                this.mBGPattern = (String)object;
                this.mGlass = "glass".equals(this.mBGPattern);
                if (!(this instanceof ComponentItem) || ((ComponentItem)this).mGradientStart == 0) {
                    this.updatePattern(this.mComponent, true);
                }
                bl = true;
                break;
            }
            case 149: {
                this.setFontIndex((Integer)object);
                bl = true;
                break;
            }
            case 150: {
                this.setBordered((Boolean)object);
                bl = true;
                break;
            }
            case 165: {
                this.setDirection((Byte)object);
                bl = true;
                break;
            }
            case 129: {
                this.mComponent.setName((String)object);
                this.mName = (String)object;
                bl = true;
                break;
            }
            case 173: {
                if (this.isPatternPending() && (!(this instanceof ComponentItem) || ((ComponentItem)this).mGradientStart == 0)) {
                    this.updatePattern(this.mComponent, false);
                }
                this.doShowComponent((Boolean)object);
                bl = true;
                break;
            }
            case 174: {
                UICommon.setFocusRequest(true);
                this.setServerFocusRequest(true);
                this.updateFocus();
                bl = true;
                break;
            }
            case 189: {
                try {
                    UICommon uICommon = (UICommon)this.getDispatcher().getHandler((Integer)object);
                    if (uICommon != null) {
                        UICommon.setExpectedFocusIn(this.getComponent());
                        UICommon.setExpectedFocusOut(uICommon.getComponent());
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                UICommon.setFocusRequest(true);
                this.setServerFocusRequest(true);
                this.updateFocus();
                UICommon.setExpectedFocusIn(null);
                UICommon.setExpectedFocusOut(null);
                bl = true;
                break;
            }
            case 177: {
                this.moveAbove((Integer)object);
                bl = true;
                break;
            }
            case 178: {
                Container container = this.mComponent.getParent();
                if (container != null) {
                    container.remove(this.mComponent);
                    container.add(this.mComponent, 0);
                }
                bl = true;
                break;
            }
            case 152: {
                this.setBorderBevel(((Byte)object).intValue());
                bl = true;
                break;
            }
            case 145: {
                this.setEventMode((Integer)object);
                bl = true;
                break;
            }
            case 509: {
                bl = true;
                break;
            }
            case 508: {
                bl = true;
                break;
            }
            case 139: 
            case 151: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: {
                bl = true;
            }
        }
        return bl;
    }

    public Object onGet(int n) {
        Object object = null;
        Object object2 = this.getFVP(n);
        if (this.getView() != null && object2 != null && object2 != Property.UNKNOWN) {
            if (n == 152 || n == 165) {
                object = ((Property)object2).toID();
            }
        } else if (this.mComponent != null && object2 == Property.UNKNOWN) {
            object = this.onComponentGet(n);
        }
        return object;
    }

    @Override
    public synchronized void onGet(Message message) {
        int n = message.size();
        Object var5_3 = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = message.getPropertyAt(n2);
            Object object = null;
            if (n3 == 402) {
                ID iD;
                Object object2;
                if (this.mView != null && (object2 = message.getValueAt(n2)) != null && ID.isRegistered((String)object2) && (object = this.mView.getProperty(iD = ID.registerProperty((String)object2))) instanceof Property) {
                    object = ((Property)object).toID();
                }
            } else {
                object = this.onGet(n3);
                if (object == null) {
                    // empty if block
                }
            }
            message.setValueAt(n2++, object);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.getDispatcher().getIdleThread() != null) {
            this.getDispatcher().getIdleThread().reset();
        }
        if (this.isMenuActive() || this.isMenuAccelerator(keyEvent)) {
            return;
        }
        sKeyEventTarget = this;
        this.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object;
        IView iView;
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.isMenuActive() || keyEvent.isConsumed()) {
            return;
        }
        if (sKeyEventTarget != this && (iView = this.getView()) != null && ((object = iView.getProperty(ID.MNEMONIC)) != null && Character.toUpperCase(keyEvent.getKeyChar()) == Character.toUpperCase(((Character)object).charValue()) || this instanceof ButtonItem && this.isDefaultButtonChar(keyEvent) && ((Boolean)iView.getProperty(ID.IS_DEFAULT)).booleanValue())) {
            this.retargetKeyEvent(this);
        }
        if (sKeyEventTarget != this) {
            keyEvent.consume();
            return;
        }
        this.keyTypedImpl(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.isMenuActive()) {
            return;
        }
        if (sKeyEventTarget != this) {
            if (!(this instanceof ButtonItem && this.isDefaultButtonChar(keyEvent) && ((Boolean)this.getView().getProperty(ID.IS_DEFAULT)).booleanValue())) {
                keyEvent.consume();
            }
            this.retargetKeyEvent(this);
            return;
        }
        this.keyReleasedImpl(keyEvent);
    }

    public void retargetKeyEvent(Object object) {
        sKeyEventTarget = object;
    }

    public Object getKeyEventTarget() {
        return sKeyEventTarget;
    }

    public static void setNeedScrollbarMouseReleasedEvent(MouseEvent mouseEvent) {
        sNeedScrollbarMouseReleasedEvent = mouseEvent;
    }

    public static MouseEvent getNeedScrollbarMouseReleasedEvent() {
        return sNeedScrollbarMouseReleasedEvent;
    }

    public void keyPressedImpl(KeyEvent keyEvent) {
    }

    public void keyTypedImpl(KeyEvent keyEvent) {
    }

    public void keyReleasedImpl(KeyEvent keyEvent) {
    }

    public void setEventMode(int n) {
        this.mEventMode = n;
    }

    public int getEventMode(int n) {
        return this.mEventMode;
    }

    public void setFontIndex(int n) {
        Component component = this.getComponent();
        this.mFontIndex = n;
        if (component instanceof VTextField) {
            ((VTextField)component).setStyle(this.getDispatcher().getStyle(n));
        }
        if (component instanceof VButton) {
            ((VButton)component).setStyle(this.getDispatcher().getStyle(n));
        }
        if (n == 0) {
            component.setFont(LWComponent.DEFAULT_FONT);
        } else {
            component.setFont(this.getDispatcher().getFontEntry(n));
        }
    }

    public int getFontIndex() {
        return this.mFontIndex;
    }

    public void setSize(Point point) {
        this.mSize = point;
    }

    public Point getSize() {
        return this.mSize;
    }

    private final Object onComponentGet(int n) {
        Object object = null;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        switch (n) {
            case 139: {
                object = new Point(0, 0);
                break;
            }
            case 135: {
                rectangle = this.mComponent.getBounds();
                object = new Point(rectangle.x, rectangle.y);
                break;
            }
            case 137: {
                rectangle2 = this.mComponent.getBounds();
                object = new Point(rectangle2.width, rectangle2.height);
                break;
            }
            case 136: {
                object = this.getInnerSize();
                break;
            }
            case 148: {
                object = this.mBGPattern;
                break;
            }
            case 147: {
                object = this.mBGColor;
                break;
            }
            case 146: {
                object = this.mFGColor;
                break;
            }
            case 165: {
                object = this.mDirection;
                break;
            }
            case 155: {
                rectangle2 = this.mComponent.getBounds();
                object = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
                break;
            }
            case 129: {
                object = this.mName;
            }
        }
        return object;
    }

    @Override
    public synchronized void onDestroy() {
        Container container;
        Component component = this.getEventComponent();
        if (component != null && component instanceof LWComponent) {
            ((LWComponent)component).removeAnyEventListener(this.getDispatcher());
        }
        if (this.getView() != null) {
            this.getView().destroy();
            this.mView = null;
        }
        if (this.mComponent != null && (container = this.mComponent.getParent()) != null) {
            if (this.mComponent instanceof LWComponent && ((LWComponent)this.mComponent).hasGlobalFocus()) {
                container.requestFocus();
            }
            if (container != null) {
                container.remove(this.mComponent);
            }
        }
        this.mHandler = null;
        this.mComponent = null;
        this.mPosition = null;
        this.mSize = null;
        this.mName = null;
        this.mBGPattern = null;
    }

    @Override
    public Message getFinalMessage() {
        return null;
    }

    @Override
    public int getHandlerId() {
        return this.mHandlerId;
    }

    @Override
    public int getHandlerClassId() {
        return this.mHandler.getHandlerClassId();
    }

    @Override
    public Runform getDispatcher() {
        return this.mDispatcher;
    }

    @Override
    public void onClientGetReturn(Message message) {
        int n = message.size();
        for (int i = 0; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            Object object = message.getValueAt(i);
            this.onClientGetReturn(n2, object);
        }
    }

    protected void onClientGetReturn(int n, Object object) {
        this.mClientGetReturned = true;
        this.mClientGetReturnValue = object;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private final void moveAbove(int n) {
        int n2 = -2;
        int n3 = -2;
        Object var8_4 = null;
        MessageHandler messageHandler = this.getDispatcher().getHandler(n);
        Component component = ((UICommon)messageHandler).getComponent();
        Component component2 = this.getComponent();
        if (component2.getParent() instanceof FSplitter) {
            if (component2.getParent() == component.getParent()) {
                return;
            }
            component2 = component2.getParent();
            if (component.getParent() instanceof FSplitter) {
                component = component.getParent();
            }
        } else if (component.getParent() instanceof FSplitter) {
            component = component.getParent();
        }
        Container container = component2.getParent();
        int n4 = container.getComponentCount();
        for (int i = 0; i < n4; ++i) {
            Component component3 = container.getComponent(i);
            if (component3 == component2) {
                n3 = i;
            }
            if (component3 == component) {
                n2 = i;
            }
            if (n3 != -2 && n2 != -2) break;
        }
        if (n3 != -2 && n2 != -2 && n3 + 1 != n2) {
            LWComponent lWComponent = LWComponent.getFocusedComponent();
            UICommon.setFocusHidden(true);
            container.setComponentZOrder(component2, n2);
            ((LWComponent)container).refreshComponentOrder(component2, n2);
            if (lWComponent != null) {
                Container container2;
                for (container2 = lWComponent.getParent(); container2 != null && container2 != component2; container2 = container2.getParent()) {
                }
                if (container2 != null) {
                    lWComponent.requestFocus();
                }
            }
            UICommon.setFocusHidden(false);
            if (this instanceof FormCanvas) {
                component2.repaint();
            }
        }
    }

    protected void setBordered(boolean bl) {
        this.mBordered = bl;
        if (!bl) {
            this.setBorderBevel(0);
        }
    }

    public boolean isBordered() {
        return this.mBordered;
    }

    protected void setBorderWidth(byte by) {
        this.mBorderWidth = by;
    }

    public byte getBorderWidth() {
        return this.mBorderWidth;
    }

    public static DisplayStringFilter getPasswordFilter() {
        if (sPasswordFilter == null) {
            sPasswordFilter = new CharEchoFilter('*');
        }
        return sPasswordFilter;
    }

    protected void setBorderBevel(int n) {
    }

    public void doAddParent(int n) {
        MessageHandler messageHandler = this.mHandler.getDispatcher().getHandler(n);
        Object var4_3 = null;
        if (messageHandler instanceof FormWindow) {
            return;
        }
        Container container = messageHandler instanceof FormCanvas ? ((FormCanvas)messageHandler).getPanel() : (messageHandler instanceof UICommon ? (Container)((UICommon)messageHandler).getComponent() : (Container)((Object)messageHandler));
        if (!(messageHandler instanceof TabControl)) {
            container.add(this.mComponent);
        }
    }

    protected void doShowComponent(boolean bl) {
        this.mComponent.setVisible(bl);
    }

    private final Object getInnerSize() {
        Point point = null;
        String string = this.mHandler.getClass().getName() + ".onComponentGet(): ";
        if (this.mComponent instanceof Container) {
            Rectangle rectangle = this.mComponent.getBounds();
            if (this.mInsets == null) {
                point = new Point(rectangle.width, rectangle.height);
            } else {
                int n = rectangle.width - this.mInsets.left - this.mInsets.right;
                int n2 = rectangle.height - this.mInsets.top - this.mInsets.bottom;
                point = new Point(n, n2);
            }
        } else {
            Rectangle rectangle = this.mComponent.getBounds();
            point = new Point(rectangle.width, rectangle.height);
        }
        return point;
    }

    public final void lockBackground(Color color) {
        PushButton pushButton;
        if (color != null) {
            this.mLocked = true;
            this.mView.setProperty(ID.BACKGROUND, color);
            if (this.mBGPattern != null) {
                this.mView.setProperty(ID.BGPATTERN, this.createPattern());
            }
        }
        if (this.mDispatcher.getRequiredBorderPainter() != null) {
            this.mRequiredPainter = this.mDispatcher.getRequiredBorderPainter();
            ((Component)((Object)this.getView())).repaint();
        }
        if (this instanceof TextComponentItem && (pushButton = ((TextComponentItem)this).getToggleButton()) != null) {
            pushButton.setBackground(color);
        }
    }

    public final void setBorderHighlightColor(boolean bl) {
        Color color;
        OracleBorderPainter oracleBorderPainter = null;
        Color color2 = color = bl ? this.getDispatcher().getBorderRolloverColor() : this.getDispatcher().getBorderHighlightColor();
        if (sPainters == null) {
            sPainters = new HashMap();
        }
        if ((oracleBorderPainter = sPainters.get(color)) == null) {
            oracleBorderPainter = new OracleBorderPainter(color);
            sPainters.put(color, oracleBorderPainter);
        }
        if (bl) {
            this.mRolloverPainter = oracleBorderPainter;
        } else {
            this.mHighlightPainter = oracleBorderPainter;
            ((Component)((Object)this.getView())).repaint();
        }
    }

    public final void setBorderRolloverColor() {
        OracleBorderPainter oracleBorderPainter = null;
        Color color = this.getDispatcher().getBorderRolloverColor();
        if (this.getView().getProperty(ID.PARTIAL_EDGE) == Boolean.FALSE) {
            this.setBorderHighlightColor(true);
            return;
        }
        if (sRolloverPainters == null) {
            sRolloverPainters = new HashMap();
        }
        if ((oracleBorderPainter = sRolloverPainters.get(color)) == null) {
            oracleBorderPainter = new OracleBorderPainter(3, color, this.getApplet().getDrawLeftBorder(), this.getApplet().getDrawRightBorder(), this.getApplet().getDrawTopBorder(), this.getApplet().getDrawBottomBorder());
            sRolloverPainters.put(color, oracleBorderPainter);
        }
        this.mRolloverPainter = oracleBorderPainter;
    }

    public final void unlockBackground() {
        PushButton pushButton;
        if (this.mLocked) {
            this.mLocked = false;
            this.mView.setProperty(ID.BACKGROUND, this.getDispatcher().getColorEntry(this.mBGColor));
            if (this.mBGPattern != null) {
                this.mView.setProperty(ID.BGPATTERN, this.createPattern());
            }
        }
        if (this.mRequiredPainter != null) {
            this.mRequiredPainter = null;
            ((Component)((Object)this.getView())).repaint();
        }
        if (this instanceof TextComponentItem && (pushButton = ((TextComponentItem)this).getToggleButton()) != null) {
            pushButton.setBackground(this.getDispatcher().getColorEntry(this.mBGColor));
        }
    }

    public final void clearBorderHighlightColor() {
        this.mHighlightPainter = null;
        ((Component)((Object)this.getView())).repaint();
        this.mBorderPainter = null;
    }

    public final void clearBorderRolloverColor() {
        this.mRolloverPainter = null;
    }

    public void addAnyEventListener(AnyEventListener anyEventListener) {
        Component component = this.getEventComponent();
        if (component instanceof LWComponent) {
            ((LWComponent)component).addAnyEventListener(anyEventListener);
        }
    }

    public synchronized Object getProperty(int n, Object object) {
        Runform runform = this.getDispatcher();
        Message message = Message.newMessage((byte)7, this.getHandlerClassId(), this.getHandlerId());
        message.add(n, object);
        this.mClientGetReturned = false;
        this.mClientGetReturnValue = Property.UNKNOWN;
        runform.onMessage(message, 0);
        return this.mClientGetReturnValue;
    }

    public synchronized Object getProperty(int n) {
        return this.getProperty(n, null);
    }

    public synchronized void setProperty(int n, Object object) {
        Runform runform = this.getDispatcher();
        Message message = Message.newMessage((byte)8, this.getHandlerClassId(), this.getHandlerId());
        message.add(n, object);
        runform.onMessage(message, 0);
    }

    public final IView getView() {
        return this.mView;
    }

    protected void init() {
    }

    protected Class getDefaultClass() {
        return null;
    }

    private void instantiate(Message message) {
        String string = null;
        Class clazz = null;
        int n = message.size();
        for (int i = 0; i < n; ++i) {
            if (message.size() <= 0 || message.getPropertyAt(i) != 397) continue;
            string = (String)message.getValueAt(i);
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break;
        }
        if (clazz == null) {
            clazz = this.getDefaultClass();
        }
        if (clazz != null) {
            try {
                Object t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (t instanceof IView) {
                    this.mView = (IView)t;
                } else {
                    clazz = this.getDefaultClass();
                    this.mView = (IView)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.mView.setProperty(ID.registerProperty("beanName"), string);
                }
                this.init();
                this.mView.init(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public final Object getFVP(ID iD) {
        return this.mView == null ? Property.UNKNOWN : this.mView.getProperty(iD);
    }

    public final Object getFVP(int n) {
        return this.getFVP(ID.getInstance(n));
    }

    public final boolean isFVP(ID iD) {
        return (Boolean)this.mView.getProperty(iD);
    }

    public final boolean isFVP(int n) {
        return this.isFVP(ID.getInstance(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFVP(ID iD, Object object) {
        boolean bl = false;
        if (this.mView == null) {
            return false;
        }
        int n = object instanceof Number ? ((Number)object).intValue() : 0;
        switch (iD.toID()) {
            case 148: {
                this.mBGPattern = (String)object;
                object = this.createPattern();
                if ("glass".equals(this.mBGPattern)) {
                    this.mGlass = true;
                    break;
                }
                this.mGlass = false;
                break;
            }
            case 146: {
                object = this.mHandler.getDispatcher().getColorEntry(n);
                if (this.mFGColor == n) break;
                this.mFGColor = n;
                if (this.mBGPattern == null) break;
                this.mView.setProperty(iD, object);
                this.mView.setProperty(ID.BGPATTERN, this.createPattern());
                break;
            }
            case 147: {
                object = this.mHandler.getDispatcher().getColorEntry(n);
                if (this.mBGColor != n) {
                    this.mBGColor = n;
                    if (this.mBGPattern != null) {
                        if (!this.mLocked) {
                            this.mView.setProperty(iD, object);
                        }
                        this.mView.setProperty(ID.BGPATTERN, this.createPattern());
                    }
                }
                if (!this.mLocked) break;
                return true;
            }
            case 173: {
                if (!this.isPatternPending()) break;
                this.mView.setProperty(ID.BGPATTERN, this.createPattern());
                break;
            }
            case 149: {
                object = this.mHandler.getDispatcher().getFontEntry(n);
                if (this.getComponent() instanceof VTextField) {
                    ((VTextField)this.getComponent()).setStyle(this.getDispatcher().getStyle(n));
                }
                if (!(this.getComponent() instanceof VButton)) break;
                ((VButton)this.getComponent()).setStyle(this.getDispatcher().getStyle(n));
                break;
            }
            case 165: {
                object = LanguageDirection.getInstance(n);
                break;
            }
            case 140: {
                object = Character.valueOf((char)((Byte)object).byteValue());
                break;
            }
            case 551: {
                object = Character.valueOf(((String)object).charAt(0));
                break;
            }
            case 152: {
                if (this.mRolloverEntryPainter != null) {
                    this.mRolloverEntryPainter = null;
                }
                if (n == 4) {
                    this.clearBorderRolloverColor();
                    this.setBorderHighlightColor(false);
                    return true;
                }
                this.clearBorderHighlightColor();
                object = BorderBevel.getInstance(n);
                break;
            }
            case 576: {
                bl = this.mView.setProperty(iD, object);
                if (this.mBorderPainter != null) {
                    this.setBorderHighlightColor(false);
                }
                return bl;
            }
            case 577: {
                bl = this.mView.setProperty(iD, object);
                if (this.mBorderPainter != null) {
                    this.setBorderHighlightColor(false);
                }
                if (this.mRolloverEntryPainter != null) {
                    this.mRolloverEntryPainter = null;
                }
                return bl;
            }
            case 208: {
                object = WrapStyle.getInstance(n);
                break;
            }
            case 387: {
                object = ImageScrollPolicy.getInstance(n);
                break;
            }
            case 199: {
                object = CaseRestriction.getInstance(n);
                break;
            }
            case 144: {
                ComponentItem componentItem = this.getDispatcher().getFocusOwner();
                boolean bl2 = (Boolean)object;
                Component component = this.getComponent();
                if (bl2 || this != componentItem && (!(component instanceof LWComponent) || !((LWComponent)component).hasWindowFocus())) break;
                LWWindow lWWindow = this.getParentWindow();
                if (lWWindow != null) {
                    lWWindow.requestFocus();
                } else {
                    DesktopContainer desktopContainer = this.getApplet().getDesktop();
                    if (desktopContainer != null) {
                        desktopContainer.requestFocus();
                    }
                }
                if (componentItem == null || componentItem == this) break;
                componentItem.getComponent().requestFocus();
                break;
            }
            case 174: {
                if (this instanceof ComponentItem && !this.getApplet().isParentWindowActive()) {
                    UICommon.deferRequestFocusForInactiveApplet(this, object);
                    return true;
                }
                ComponentItem componentItem = (ComponentItem)this;
                if (!this.getComponent().isDisplayable() || this instanceof RadioButtonItem && !this.getComponent().isVisible() || componentItem.isParentTabPanel() && this.getComponent().getParent() != null && !this.getComponent().getParent().isVisible() || this.isFocusRequestOnFocusOwner()) {
                    Message message = Message.newMessage(this, 521, Boolean.TRUE);
                    this.getDispatcher().onMessage(message, 1);
                    return true;
                }
                UICommon.setFocusRequest(true);
                this.setServerFocusRequest(true);
                if (!this.updateFocus()) break;
                object = Boolean.FALSE;
                break;
            }
            case 189: {
                try {
                    UICommon uICommon = (UICommon)this.getDispatcher().getHandler((Integer)object);
                    if (uICommon == null) break;
                    UICommon.setExpectedFocusIn(this.getComponent());
                    UICommon.setExpectedFocusOut(uICommon.getComponent());
                    break;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
                finally {
                    iD = ID.FOCUS;
                    object = Boolean.TRUE;
                    UICommon.setFocusRequest(true);
                    this.setServerFocusRequest(true);
                }
            }
            case 115: {
                object = Alignment.getInstance(n);
                break;
            }
            case 410: {
                int n2 = (Integer)object;
                object = ((PopupHelpItem)this.getDispatcher().getHandler(n2)).getComponent();
            }
        }
        return this.mView.setProperty(iD, object);
    }

    public boolean setFVP(int n, Object object) {
        return this.setFVP(ID.getInstance(n), object);
    }

    public boolean isGlassBackground() {
        return this.mGlass;
    }

    private Image createPattern() {
        return this.createPattern((Color)this.getView().getProperty(ID.FOREGROUND), (Color)this.getView().getProperty(ID.BACKGROUND));
    }

    protected Image createPattern(Color color, Color color2) {
        this.mPatternPending = false;
        if (this.mBGPattern == null || "transparent".equals(this.mBGPattern) || "glass".equals(this.mBGPattern)) {
            return null;
        }
        if (this.mPatternProducer == null) {
            this.mPatternProducer = PatternProducer.getProducer(this.getApplet());
        }
        if (color == null || color2 == null) {
            this.mPatternPending = true;
            return null;
        }
        Image image = this.mPatternProducer.getPattern(this.mBGPattern, color, color2);
        if (image != null) {
            return image;
        }
        return this.getApplet().getCustomImage(this.mBGPattern);
    }

    protected void updatePattern(Component component, boolean bl) {
        if (component instanceof LWComponent) {
            LWComponent lWComponent = (LWComponent)component;
            Image image = this.createPattern(component.getForeground(), component.getBackground());
            if (image != null) {
                lWComponent.setFill(new PainterTiler(new FixedImagePainter(image)));
                if (this instanceof TreeItem) {
                    ((LWComponent)((TreeItem)this).getAccessibleComponent()).setFill(new PainterTiler(new FixedImagePainter(image)));
                }
            } else if (bl) {
                Painter painter = this instanceof TreeItem && this.isGlassBackground() ? NullPainter.getPainter() : UIManager.getPainter(LookAndFeel.BACKGROUND_PAINTER);
                lWComponent.setFill(painter);
                if (this instanceof TreeItem) {
                    ((LWComponent)((TreeItem)this).getAccessibleComponent()).setFill(painter);
                }
            }
        }
    }

    protected final boolean isPatternPending() {
        return this.mPatternPending;
    }

    @Override
    public Main getApplet() {
        return this.mMainApplet;
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) throws FException {
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public void addProperty(ID iD) throws FException {
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public IObject findObject(Class clazz, String string) throws FException {
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public Object getProperty(ID iD) throws FException {
        Object object = this.getFVP(iD);
        if (object == Property.UNKNOWN) {
            object = this.getProperty(iD.toID());
        }
        if (object != Property.UNKNOWN) {
            return object;
        }
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) throws FException {
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public void removeProperty(ID iD) throws FException {
        throw new FException(0, "", "", 0, false);
    }

    @Override
    public void setProperty(ID iD, Object object) throws FException {
        this.setProperty(iD.toID(), object);
    }

    @Override
    public boolean isActive() {
        return this.getApplet().isActive();
    }

    @Override
    public URL getDocumentBase() {
        return this.getApplet().getDocumentBase();
    }

    @Override
    public URL getCodeBase() {
        return this.getApplet().getCodeBase();
    }

    @Override
    public String getParameter(String string) {
        return this.getApplet().getParameter(string);
    }

    @Override
    public AppletContext getAppletContext() {
        return this.getApplet().getAppletContext();
    }

    @Override
    public void appletResize(int n, int n2) {
    }

    private boolean isMenuActive() {
        boolean bl;
        Container container = this.getApplet().useSeparateFrame() ? this.getApplet().getFrame() : this.getApplet();
        Component[] componentArray = container.getComponents();
        for (bl = false; bl < componentArray.length; bl += 1) {
            if (!(componentArray[bl] instanceof LWPopupMenu)) continue;
            return true;
        }
        bl = FormMenu.isAnyPopupShowing();
        if (!bl) {
            DesktopContainer desktopContainer;
            LWWindow lWWindow;
            Runform runform = this.getDispatcher();
            LWWindow lWWindow2 = runform.getFrame();
            if (lWWindow2 == null) {
                return bl;
            }
            if (lWWindow2.isReshaping()) {
                return true;
            }
            LWMenuBar lWMenuBar = runform.isSDIMode() ? lWWindow2.getMenuBar() : (LWMenuBar)lWWindow2.getClientProperty("mdiMenuBar");
            if (lWMenuBar != null && lWMenuBar.getSelectedItem() != null) {
                bl = true;
            }
            if ((lWWindow = (desktopContainer = this.getApplet().getDesktop()).getWindow(0)) != null) {
                lWMenuBar = (LWMenuBar)lWWindow.getClientProperty(SYSTEM_MENU_PROPERTY);
                if (lWMenuBar == null) {
                    int n = lWWindow.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        Component component = lWWindow.getComponent(i);
                        if (!(component instanceof TitleBar)) continue;
                        lWMenuBar = ((TitleBar)component).getSystemMenuBar();
                        lWWindow.putClientProperty(SYSTEM_MENU_PROPERTY, lWMenuBar);
                        break;
                    }
                }
                if (lWMenuBar != null && lWMenuBar.getSelectedItem() != null) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean isMenuAccelerator(KeyEvent keyEvent) {
        FormMenu formMenu;
        boolean bl = false;
        KeyStroke keyStroke = new KeyStroke(keyEvent.getKeyCode(), InputEventUtils.getMods(keyEvent));
        try {
            formMenu = ((ExtendedFrame)this.getParentWindow()).getHandler().getMenu();
        }
        catch (NullPointerException nullPointerException) {
            return bl;
        }
        if (formMenu != null && formMenu.getMenuInfo() != null && formMenu.getMenuInfo().getAccelerators().containsKey(keyStroke)) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getDefaultFrameIcon() {
        if (mFrameIcon != null) return mFrameIcon;
        Class<UICommon> clazz = UICommon.class;
        synchronized (UICommon.class) {
            if (mFrameIcon != null) return mFrameIcon;
            mFrameIcon = this.getApplet().getDefaultImage("frame");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mFrameIcon;
        }
    }

    public static boolean isFocusRequest() {
        if (!Thread.currentThread().getName().endsWith("engine.Main")) {
            return false;
        }
        return sFocusRequest;
    }

    public static void setFocusRequest(boolean bl) {
        sFocusRequest = bl;
    }

    public boolean isServerFocusRequest() {
        return this.mServerFocusRequest;
    }

    public void setServerFocusRequest(boolean bl) {
        this.mServerFocusRequest = bl;
    }

    private boolean isDefaultButtonChar(KeyEvent keyEvent) {
        return keyEvent.getKeyChar() == '\r' || keyEvent.getKeyChar() == '\n';
    }

    private void doRemoveNotify(Component component, boolean bl) {
        if (component instanceof FScrollBox) {
            ((FScrollBox)component).doRemoveNotify(bl);
        } else if (component instanceof FormsTabPanel) {
            ((FormsTabPanel)component).doRemoveNotify(bl);
        }
    }

    private boolean isFocusRequestOnFocusOwner() {
        boolean bl = false;
        if (this instanceof JavaContainer) {
            IView iView = this.getParentView(this.getParentWindow().getFocusOwner());
            if (iView != null && iView == this.getComponent()) {
                bl = true;
            }
        } else if (this.getParentWindow() != null && this.getParentWindow().getFocusOwner() == this.getComponent()) {
            bl = true;
        }
        return bl;
    }

    public IView getParentView(Component component) {
        while (component != null && !(component instanceof IView)) {
            component = component.getParent();
        }
        return (IView)((Object)component);
    }

    private void setDeferredFocusRequest(boolean bl) {
        this.mDeferredFocusRequest = bl;
    }

    public BorderPainter getRequiredPainter() {
        return this.mRequiredPainter;
    }

    private boolean isDeferredFocusRequest() {
        return this.mDeferredFocusRequest;
    }

    public Integer normalizeCursorposForServer(Integer n, LWCommonText lWCommonText) {
        int n2 = n;
        n2 = this.normalizeSelectionForServer((Point)new Point((int)n2, (int)n2), (LWCommonText)lWCommonText).y;
        return n2;
    }

    public Integer normalizeCursorposFromServer(Integer n, LWCommonText lWCommonText) {
        int n2 = n;
        n2 = this.normalizeSelectionFromServer((Point)new Point((int)n2, (int)n2), (LWCommonText)lWCommonText).y;
        return n2;
    }

    public Point normalizeSelectionForServer(Point point, LWCommonText lWCommonText) {
        int n;
        if (point == null || lWCommonText == null) {
            return point;
        }
        int n2 = point.x;
        int n3 = point.y;
        if (n2 > n3) {
            n2 = n3;
        }
        point = new Point(0, 0);
        if (n3 > 0 && (n = lWCommonText.getTextLength()) > 0) {
            if (n3 > n) {
                if (n2 > n) {
                    n2 = n;
                }
                n3 = n;
            }
            if (this.getDispatcher().isSurrogatePairSupportEnabled()) {
                String string = lWCommonText.getText();
                if (n2 > 0) {
                    point.x = string.codePointCount(0, n2);
                }
                point.y = point.x;
                if (n3 > n2) {
                    point.y += string.codePointCount(n2, n3);
                }
            } else {
                point.x = n2;
                point.y = n3;
            }
        }
        return point;
    }

    public Point normalizeSelectionFromServer(Point point, LWCommonText lWCommonText) {
        int n;
        if (point == null || lWCommonText == null) {
            return point;
        }
        int n2 = point.x;
        int n3 = point.y;
        if (n2 > n3) {
            n2 = n3;
        }
        point = new Point(0, 0);
        if (n3 > 0 && (n = lWCommonText.getTextLength()) > 0) {
            if (this.getDispatcher().isSurrogatePairSupportEnabled()) {
                String string = lWCommonText.getText();
                try {
                    if (n2 > 0) {
                        point.x = string.offsetByCodePoints(0, n2);
                    }
                    point.y = point.x;
                    if (n3 > n2) {
                        point.y = string.offsetByCodePoints(point.x, n3 - n2);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n2 > 0 && point.x == 0) {
                        point.x = n;
                    }
                    point.y = n;
                }
            } else {
                if (n3 > n) {
                    if (n2 > n) {
                        n2 = n;
                    }
                    n3 = n;
                }
                point.x = n2;
                point.y = n3;
            }
        }
        return point;
    }

    static {
        sFocusHidden = false;
        sFocusChanges = new Hashtable();
        sFocusChangesInactiveApplet = new Vector(2, 2);
        sKeyEventTarget = null;
        sNeedScrollbarMouseReleasedEvent = null;
        sFocusRequest = false;
    }

    private class DeferredItem {
        private UICommon item;
        private Object value;

        private DeferredItem(UICommon uICommon2, Object object) {
            this.item = uICommon2;
            this.value = object;
        }
    }
}

