/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeActivateListener;
import oracle.ewt.dTree.DTreeButtonDecoration;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeDeferringRoot;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeLineDecoration;
import oracle.ewt.dTree.DTreeMultipleSelection;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSelectionListener;
import oracle.ewt.dTree.DTreeSingleSelection;
import oracle.ewt.dTree.DTreeStackingDecoration;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.ImmInsets;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.ui.GenericBorderPainter;
import oracle.forms.ui.OracleBorderPainter;
import oracle.forms.ui.TreeDataSource;
import oracle.forms.ui.TreeFactory;

public class TreeItem
extends ComponentItem
implements DTreeActivateListener,
DTreeExpansionListener,
DTreeSelectionListener {
    public static final int ROOT_NODE = 0;
    public static final int DUMMY_NODE = -1;
    public static final int SEND_ACTIVATED = 1;
    public static final int SEND_SELECTED = 2;
    public static final int LEAF_NODE = 0;
    public static final int EXPANDED_NODE = 1;
    public static final int COLLAPSED_NODE = -1;
    public static final int UNSET_SELECT_TYPE = 0;
    public static final int SELECT_ON = 1;
    public static final int SELECT_OFF = 2;
    public static final int SELECT_TOGGLE = 3;
    public static final int ICON_SIZE = 16;
    public static final int ICON_SIZE_MEDIUM = 32;
    public static final int ICON_SIZE_LARGE = 48;
    public static final int SET_LABEL = 1;
    public static final int SET_ICON = 2;
    public static final int SET_STATE = 4;
    public static final int NEW_NODE = 1;
    public static final int REQUESTED_NODE = 2;
    public static final int PROG_SELECTION = 3;
    private static final int INIT_HASH_SIZE = 100;
    private static final int INIT_NUM_ICONS = 20;
    private static int sHandlerClassId = 0;
    private DTree mTree = null;
    private ScrollBox mScroller = null;
    private int mParent;
    private boolean mEnabled = true;
    private boolean mMultiSelect = false;
    private boolean mShowLines = true;
    private boolean mShowSymbols = true;
    private boolean mSendActivated = false;
    private boolean mSendSelected = false;
    private Hashtable mIDtoParent;
    private Hashtable mIDtoData;
    private Hashtable mIDtoItem;
    private Hashtable mIcons;
    private int mProgrammaticEvent = 0;
    private DTreeItem[] moldSelection = null;
    private DTreeSelection mSelection = null;
    private Vector mDeSelectedList = null;
    private int mSelectedDummyNodes = 0;

    public TreeItem() {
        this.setHandler(this);
    }

    @Override
    protected Component getEventComponent() {
        return this.mTree;
    }

    @Override
    public void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        TreeDataSource treeDataSource = new TreeDataSource(this, 0);
        this.mTree = new DTree(new DTreeDeferringRoot(null, null, treeDataSource, TreeFactory.getInstance()));
        this.mTree.addFocusListener(this);
        this.mTree.addKeyListener(this);
        this.mTree.addActivateListener(this);
        this.mTree.addExpansionListener(this);
        this.mTree.addSelectionListener(this);
        this.mTree.addMouseListener(this);
        this.mScroller = new ScrollBox(this.mTree, 0, 0);
        this.setComponent(this.mScroller);
        this.mScroller.setBorderPainter(NullPainter.getPainter());
        this.mIDtoParent = new Hashtable(100);
        this.mIDtoData = new Hashtable(100);
        this.mIDtoItem = new Hashtable(100);
        this.mIcons = new Hashtable(20);
        this.mIDtoData.put(0, treeDataSource);
        this.onUpdate(message);
        this.setDecoration();
    }

    public void setProgrammaticEvent(boolean bl) {
        if (bl) {
            ++this.mProgrammaticEvent;
        } else if (this.mProgrammaticEvent > 0) {
            --this.mProgrammaticEvent;
        }
    }

    public boolean isProgrammaticEvent() {
        return this.mProgrammaticEvent > 0;
    }

    @Override
    public void dTreeItemActivate(DTreeItemEvent dTreeItemEvent) {
        if (this.getHandler() != null && this.mSendActivated && !this.isProgrammaticEvent()) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            Integer n = ((TreeDataSource)((DTreeDeferringParent)dTreeItem.getParent()).getDataSource()).getID(dTreeItem.getIndex());
            Message message = new Message(this.getHandler(), 491, n);
            this.getHandler().getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public void dTreeItemExpanding(DTreeItemEvent dTreeItemEvent) {
        if (this.getHandler() != null && !this.isProgrammaticEvent()) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            Integer n = ((TreeDataSource)((DTreeDeferringParent)dTreeItem.getParent()).getDataSource()).getID(dTreeItem.getIndex());
            Message message = new Message(this.getHandler(), 489, n);
            this.getHandler().getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public void dTreeItemExpanded(DTreeItemEvent dTreeItemEvent) {
    }

    @Override
    public void dTreeItemCollapsing(DTreeItemEvent dTreeItemEvent) {
    }

    @Override
    public void dTreeItemCollapsed(DTreeItemEvent dTreeItemEvent) {
        if (this.getHandler() != null && !this.isProgrammaticEvent()) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            Integer n = ((TreeDataSource)((DTreeDeferringParent)dTreeItem.getParent()).getDataSource()).getID(dTreeItem.getIndex());
            Message message = new Message(this.getHandler(), 490, n);
            this.getHandler().getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public void dTreeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent) {
    }

    @Override
    public void dTreeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent) {
        if (this.getHandler() != null && this.mSendSelected && !this.isProgrammaticEvent()) {
            Integer n;
            Object[] objectArray;
            int n2;
            int n3;
            int n4;
            DTreeItem dTreeItem;
            DTreeRange dTreeRange;
            int n5;
            int n6;
            DTreeRangeSet dTreeRangeSet = dTreeSelectionEvent.getOldSelectionRanges();
            DTreeRangeSet dTreeRangeSet2 = dTreeSelectionEvent.getNewSelectionRanges();
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            if (dTreeRangeSet != null) {
                n6 = dTreeRangeSet.getCount();
                for (n5 = 0; n5 < n6; ++n5) {
                    dTreeRange = dTreeRangeSet.getRange(n5);
                    dTreeItem = dTreeRange.getParent();
                    n4 = dTreeRange.getStartIndex();
                    n3 = n4 + dTreeRange.getCount() - 1;
                    for (n2 = n4; n2 <= n3; ++n2) {
                        objectArray = (Object[])((DTreeDeferringParent)dTreeItem).getChildData(n2);
                        vector.addElement(objectArray[0]);
                    }
                }
            }
            if (dTreeRangeSet2 != null) {
                n6 = dTreeRangeSet2.getCount();
                n5 = 0;
                this.clearOldSelection();
                for (n2 = 0; n2 < n6; ++n2) {
                    dTreeRange = dTreeRangeSet2.getRange(n2);
                    dTreeItem = dTreeRange.getParent();
                    n4 = dTreeRange.getStartIndex();
                    n3 = n4 + dTreeRange.getCount() - 1;
                    for (int i = n4; i <= n3; ++i) {
                        objectArray = (Object[])((DTreeDeferringParent)dTreeItem).getChildData(i);
                        if (objectArray[0] == null || objectArray[0] != null && (Integer)objectArray[0] == -1) {
                            ++this.mSelectedDummyNodes;
                            n5 = 1;
                        }
                        vector2.addElement(objectArray[0]);
                    }
                }
                if (n5 == 1) {
                    this.setOldSelection();
                    this.setDeselectedList(vector);
                    return;
                }
            }
            int n7 = vector.size();
            for (n5 = 0; n5 < n7; ++n5) {
                n = (Integer)vector.elementAt(n5);
                if (vector2.contains(n)) {
                    vector2.removeElement(n);
                    continue;
                }
                this.sendSelEvent(n, false);
            }
            vector = null;
            n7 = vector2.size();
            for (n5 = 0; n5 < n7; ++n5) {
                n = (Integer)vector2.elementAt(n5);
                this.sendSelEvent(n, true);
            }
        }
    }

    private void sendSelEvent(Integer n, boolean bl) {
        Object var3_3 = null;
        Message message = bl ? new Message(this.getHandler(), 488, n) : new Message(this.getHandler(), 492, n);
        this.getHandler().getDispatcher().onMessage(message, 0);
    }

    void sendShowOptionsEvent(MouseEvent mouseEvent, Integer n) {
        Message message = new Message(this.getHandler(), 481, mouseEvent.getPoint());
        message.add(535, n);
        this.getHandler().getDispatcher().onMessage(message, 0);
    }

    @Override
    public void setEventMask(Object object) {
        super.setEventMask(object);
        this.setMouseEventListeners();
    }

    @Override
    public void setMouseEventListeners() {
        if (this.isMouseMoveEnabled()) {
            this.mTree.addMouseMotionListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
        String string = this.getApplet().getOsName();
        boolean bl = false;
        if (string.startsWith("Windows")) {
            if ((mouseEvent.getModifiersEx() & 0x1000) == 4096) {
                bl = true;
            }
        } else {
            bl = mouseEvent.isPopupTrigger();
        }
        if (bl) {
            if (this.isPopupMenuEnabled()) {
                Integer n = 0;
                Point point = this.mScroller.getScrollPosition();
                mouseEvent.translatePoint(point.x, point.y);
                DTreeItem dTreeItem = ((DTree)this.getEventComponent()).getItemAt(mouseEvent.getX(), mouseEvent.getY());
                if (dTreeItem != null && !"".equals(dTreeItem)) {
                    n = ((TreeDataSource)((DTreeDeferringParent)dTreeItem.getParent()).getDataSource()).getID(dTreeItem.getIndex());
                    mouseEvent.translatePoint(-point.x, -point.y);
                }
                ImmInsets immInsets = this.mScroller.getBorderInsets();
                mouseEvent.translatePoint(immInsets.left, immInsets.top);
                this.sendShowOptionsEvent(mouseEvent, n);
                mouseEvent.translatePoint(-immInsets.left, -immInsets.top);
            }
            this.mPopupMenuView = mouseEvent.getComponent();
            mouseEvent.consume();
        } else {
            Point point = this.mScroller.getScrollPosition();
            mouseEvent.translatePoint(point.x, point.y);
            this.sendMouseEvent(mouseEvent, true);
            this.mTree.requestFocus();
            mouseEvent.translatePoint(-point.x, -point.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getHandler() != null) {
            if (mouseEvent.getComponent() == this.mPopupMenuView) {
                mouseEvent.consume();
            } else {
                Point point = this.mScroller.getScrollPosition();
                mouseEvent.translatePoint(point.x, point.y);
                this.sendMouseEvent(mouseEvent, false);
                mouseEvent.translatePoint(-point.x, -point.y);
            }
        }
        this.mPopupMenuView = null;
    }

    @Override
    public synchronized void onGet(Message message) {
        int n = message.size();
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            Cloneable cloneable;
            Object object2;
            int n3 = message.getPropertyAt(n2);
            if (n3 == 155) {
                Dimension dimension = this.mScroller.getViewPortSize();
                object2 = this.mScroller.getScrollPosition();
                cloneable = new Rectangle(((Point)object2).x, ((Point)object2).y, dimension.width, dimension.height);
                object = cloneable;
            } else {
                object = super.onGet(n3);
            }
            if (object == null) {
                switch (n3) {
                    case 486: {
                        int n4;
                        int n5 = 0;
                        object2 = this.mTree.getSelection().getSelectionRanges();
                        if (object2 != null) {
                            int n6 = ((DTreeRangeSet)object2).getCount();
                            for (n4 = 0; n4 < n6; ++n4) {
                                n5 += ((DTreeRangeSet)object2).getRange(n4).getCount();
                            }
                        }
                        object = n5;
                        break;
                    }
                    case 504: {
                        int n7 = 0;
                        object2 = this.mTree.getSelection();
                        cloneable = object2.getSelectionRanges();
                        Object object3 = message.getValueAt(n2);
                        int n8 = (Integer)object3;
                        if (!object2.getHasSelection()) {
                            object = 0;
                            break;
                        }
                        if (n8 < 1) {
                            object = -1;
                            break;
                        }
                        int n4 = ((DTreeRangeSet)cloneable).getCount();
                        for (int i = 0; i < n4; ++i) {
                            DTreeRange dTreeRange = ((DTreeRangeSet)cloneable).getRange(i);
                            int n9 = dTreeRange.getCount();
                            if (n8 <= n7 + n9) {
                                DTreeItem dTreeItem = dTreeRange.getParent();
                                int n10 = n8 - n7 - 1 + dTreeRange.getStartIndex();
                                TreeDataSource treeDataSource = (TreeDataSource)((DTreeDeferringParent)dTreeItem).getDataSource();
                                object = treeDataSource.getID(n10);
                                break;
                            }
                            n7 += n9;
                        }
                        if (object != null) break;
                        object = -1;
                        break;
                    }
                }
            }
            if (object == null) {
                // empty if block
            }
            message.setValueAt(n2++, object);
        }
    }

    @Override
    public void onDestroy() {
        this.mTree = null;
        this.mScroller = null;
        this.mIDtoParent = null;
        this.mIDtoData = null;
        this.mIDtoItem = null;
        this.mIcons = null;
        super.onDestroy();
    }

    @Override
    public Message getFinalMessage() {
        this.getDispatcher().clearObserver(false);
        return null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private void setDecoration() {
        if (this.mShowLines && this.mShowSymbols) {
            this.mTree.setDecoration(new DTreeStackingDecoration(new DTreeLineDecoration(), new DTreeButtonDecoration()));
        } else if (this.mShowLines) {
            this.mTree.setDecoration(new DTreeLineDecoration());
        } else if (this.mShowSymbols) {
            this.mTree.setDecoration(new DTreeButtonDecoration());
        } else {
            this.mTree.setDecoration(null);
        }
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 144: {
                this.mEnabled = (Boolean)object;
                this.mTree.setEnabled(this.mEnabled);
                this.mScroller.setEnabled(this.mEnabled);
                break;
            }
            case 146: {
                if (!super.onUpdate(n, object)) break;
                Color color = this.getHandler().getDispatcher().getColorEntry((Integer)object);
                this.mTree.setForeground(color);
                break;
            }
            case 147: {
                if (!super.onUpdate(n, object)) break;
                Color color = this.getHandler().getDispatcher().getColorEntry((Integer)object);
                this.mTree.setBackground(color);
                break;
            }
            case 497: {
                this.mShowLines = (Boolean)object;
                if (this.mTree == null) break;
                this.setDecoration();
                break;
            }
            case 498: {
                this.mShowSymbols = (Boolean)object;
                if (this.mTree == null) break;
                this.setDecoration();
                break;
            }
            case 496: {
                if (this.mMultiSelect == (Boolean)object) break;
                this.mMultiSelect = (Boolean)object;
                this.setProgrammaticEvent(true);
                if (this.mMultiSelect) {
                    this.mTree.setSelection(new DTreeMultipleSelection());
                } else {
                    this.mTree.setSelection(new DTreeSingleSelection());
                }
                this.setProgrammaticEvent(false);
                break;
            }
            case 494: {
                this.doAddNode(object, 1);
                break;
            }
            case 505: {
                this.doAddNode(object, 2);
                break;
            }
            case 488: {
                this.doAddNode(object, 3);
                break;
            }
            case 506: {
                this.doSetChildren(object, true);
                break;
            }
            case 507: {
                this.doResetChildren(object);
                break;
            }
            case 499: {
                this.doAlterNode(object);
                break;
            }
            case 495: {
                this.doDeleteNode(object, false);
                break;
            }
            case 520: {
                this.doDeleteNode(object, true);
                break;
            }
            case 501: {
                break;
            }
            case 493: {
                byte by = (Byte)object;
                this.mSendActivated = (by & 1) != 0;
                if ((by & 2) == 0) {
                    this.mSendSelected = false;
                    break;
                }
                this.mSendSelected = true;
                break;
            }
            case 487: {
                this.doSelectNode(object);
                break;
            }
            case 174: {
                if (!this.getComponent().isDisplayable() || !this.getApplet().isParentWindowActive()) {
                    Message message = Message.newMessage(this, 521, Boolean.TRUE);
                    this.getDispatcher().onMessage(message, 1);
                    break;
                }
                LWWindow lWWindow = this.getParentWindow();
                if (lWWindow != null) {
                    lWWindow.requestFocus();
                    bl = super.onUpdate(n, object);
                    break;
                }
                this.getEventComponent().requestFocus();
                break;
            }
            case 152: {
                if (((Byte)object).intValue() == 0) {
                    this.mScroller.setBorderPainter(NullPainter.getPainter());
                    break;
                }
                if (((Byte)object).intValue() == 1) {
                    if (this.getApplet().hasOracleLF()) {
                        this.mScroller.setBorderPainter(new OracleBorderPainter(1));
                        break;
                    }
                    this.mScroller.setBorderPainter(new GenericBorderPainter(1));
                    break;
                }
                if (((Byte)object).intValue() == 2) {
                    if (this.getApplet().hasOracleLF()) {
                        this.mScroller.setBorderPainter(new OracleBorderPainter(2));
                        break;
                    }
                    this.mScroller.setBorderPainter(new GenericBorderPainter(2));
                    break;
                }
                if (((Byte)object).intValue() != 3) break;
                if (this.getApplet().hasOracleLF()) {
                    this.mScroller.setBorderPainter(new OracleBorderPainter(3));
                    break;
                }
                this.mScroller.setBorderPainter(new GenericBorderPainter(3));
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    private Image doGetIcon(String string) {
        Image image = (Image)this.mIcons.get(string);
        if (image == null) {
            Main main2 = this.getApplet();
            Image image2 = this.getApplet().getDefaultImage(string);
            if (image2 != null && ImageUtils.loadImage(image2)) {
                int n = image2.getWidth(main2);
                int n2 = image2.getHeight(main2);
                Runform runform = this.getHandler().getDispatcher();
                int n3 = runform.getScreenRes();
                int n4 = 16;
                if (runform.getTreeIconHeight() == 2) {
                    n4 = 32;
                } else if (runform.getTreeIconHeight() == 3) {
                    n4 = 48;
                } else if (runform.getTreeIconHeight() == 4 && n3 != runform.getScreenResolution()) {
                    n4 = n4 * n3 / runform.getScreenResolution();
                }
                if (n == n4 && n2 == n4) {
                    image = image2;
                } else if (n < n4 || n2 < n4) {
                    image = runform.getTreeIconScaling() ? image2.getScaledInstance(n4, n4, 2) : image2;
                } else {
                    CropImageFilter cropImageFilter = new CropImageFilter(0, 0, n4, n4);
                    FilteredImageSource filteredImageSource = new FilteredImageSource(image2.getSource(), cropImageFilter);
                    image = main2.createImage(filteredImageSource);
                }
            }
            if (image != null) {
                this.mIcons.put(string, image);
            }
        }
        return image;
    }

    public void doAddNode(Object object, int n) {
        DTreeDeferringParent dTreeDeferringParent;
        int n2;
        int n3;
        Message message = (Message)object;
        Integer n4 = null;
        String string = null;
        Image image = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        int n8 = 0;
        Integer n9 = null;
        DTreeItem dTreeItem = null;
        Object var14_13 = null;
        DTreeItem[] dTreeItemArray = null;
        DTreeSelection dTreeSelection = null;
        int n10 = message.size();
        block9: for (n3 = 0; n3 < n10; ++n3) {
            n2 = message.getPropertyAt(n3);
            Object object2 = message.getValueAt(n3);
            switch (n2) {
                case 500: {
                    n4 = (Integer)object2;
                    continue block9;
                }
                case 116: {
                    string = (String)object2;
                    continue block9;
                }
                case 114: {
                    image = this.doGetIcon((String)object2);
                    continue block9;
                }
                case 484: {
                    n9 = (Integer)object2;
                    continue block9;
                }
                case 485: {
                    n7 = (Integer)object2;
                    continue block9;
                }
                case 502: {
                    n5 = (Integer)object2;
                    continue block9;
                }
                case 503: {
                    n6 = (Integer)object2;
                    n8 = n6;
                    continue block9;
                }
            }
        }
        if (n4 == null || string == null || n9 == null || n5 == null || n6 == null) {
            return;
        }
        TreeDataSource treeDataSource = this.getDataSource(n5);
        if (treeDataSource == null) {
            return;
        }
        if (n8 < 0 || n8 > treeDataSource.getItemCount()) {
            return;
        }
        if (n9 != 0) {
            TreeDataSource treeDataSource2 = n7 == null ? new TreeDataSource(this, n4) : new TreeDataSource(this, n4, n7);
            this.mIDtoData.put(n4, treeDataSource2);
        }
        this.mIDtoParent.put(n4, n5);
        dTreeItemArray = this.getOldSelection();
        treeDataSource.addChild(n8, n4, string, image, n9, n);
        dTreeSelection = this.mTree.getSelection();
        if (n == 3 && this.mIDtoItem.get(n4) == null && (dTreeDeferringParent = n5 == 0 ? (DTreeDeferringParent)((Object)this.mTree.getRoot()) : (DTreeDeferringParent)this.mIDtoItem.get(n5)) != null) {
            DTreeItem dTreeItem2 = dTreeDeferringParent.getItem(n8);
            this.mIDtoItem.put(n4, dTreeItem2);
        }
        if (this.mSelectedDummyNodes >= 0) {
            --this.mSelectedDummyNodes;
        }
        if (dTreeItemArray != null) {
            n3 = dTreeItemArray[0].getIndex() + 1;
            n10 = n3 + dTreeItemArray.length;
            for (n2 = n3; n2 <= n10; ++n2) {
                boolean bl;
                dTreeItem = treeDataSource.getTree().getCreatedItem(n2);
                if (dTreeItem == null || (bl = dTreeSelection.isSelected(dTreeItem))) continue;
                this.setProgrammaticEvent(true);
                dTreeSelection.extendSelection(dTreeItem);
                this.setProgrammaticEvent(false);
            }
        }
        if (this.mSelectedDummyNodes == 0 && dTreeItemArray != null) {
            this.sendDeferredNodeSelection();
        }
    }

    private void doAlterNode(Object object) {
        int n;
        TreeDataSource treeDataSource;
        Message message = (Message)object;
        Integer n2 = null;
        String string = null;
        Image image = null;
        boolean bl = false;
        Integer n3 = null;
        int n4 = 0;
        int n5 = message.size();
        block6: for (int i = 0; i < n5; ++i) {
            int n6 = message.getPropertyAt(i);
            Object object2 = message.getValueAt(i);
            switch (n6) {
                case 500: {
                    n2 = (Integer)object2;
                    continue block6;
                }
                case 116: {
                    string = (String)object2;
                    continue block6;
                }
                case 114: {
                    image = this.doGetIcon((String)object2);
                    bl = true;
                    continue block6;
                }
                case 484: {
                    n3 = (Integer)object2;
                    continue block6;
                }
            }
        }
        if (n2 == null) {
            return;
        }
        Object v = this.mIDtoParent.get(n2);
        if (v == null || (treeDataSource = this.getDataSource(v)) == null || (n = treeDataSource.getIndex(n2)) == -1) {
            return;
        }
        if (string != null) {
            n4 |= 1;
        }
        if (bl) {
            n4 |= 2;
        }
        if (n3 != null) {
            n4 |= 4;
            Object[] objectArray = (Object[])treeDataSource.getData(n);
            Integer n7 = (Integer)objectArray[3];
            if (n3 == 0 && n7 != 0) {
                this.mIDtoData.remove(n2);
            } else if (n3 != 0 && n7 == 0) {
                this.mIDtoData.put(n2, new TreeDataSource(this, n2));
            }
        }
        treeDataSource.modifyChild(n, n4, string, image, n3);
    }

    private void clearTree() {
        TreeDataSource treeDataSource = new TreeDataSource(this, 0);
        DTreeDeferringRoot dTreeDeferringRoot = new DTreeDeferringRoot(null, null, treeDataSource, TreeFactory.getInstance());
        this.setProgrammaticEvent(true);
        this.mTree.setRoot(dTreeDeferringRoot);
        this.setProgrammaticEvent(false);
        this.mIDtoParent = new Hashtable(100);
        this.mIDtoData = new Hashtable(100);
        this.mIDtoItem = new Hashtable(100);
        this.mIDtoData.put(0, treeDataSource);
    }

    private void doDeleteNode(Object object, boolean bl) {
        if (object instanceof Message) {
            Message message = (Message)object;
            Integer n = null;
            Integer n2 = null;
            int n3 = 0;
            TreeDataSource treeDataSource = null;
            int n4 = message.size();
            block4: for (int i = 0; i < n4; ++i) {
                int n5 = message.getPropertyAt(i);
                Object object2 = message.getValueAt(i);
                switch (n5) {
                    case 502: {
                        n = (Integer)object2;
                        continue block4;
                    }
                    case 503: {
                        n2 = (Integer)object2;
                        n3 = n2;
                        continue block4;
                    }
                }
            }
            if (n == null || n2 == null) {
                return;
            }
            treeDataSource = this.getDataSource(n);
            if (treeDataSource == null) {
                return;
            }
            if (n3 < 0 || n3 > treeDataSource.getItemCount()) {
                return;
            }
            treeDataSource.removeChild(n3);
        } else {
            Integer n = (Integer)object;
            if (n == 0) {
                this.clearTree();
            } else if (bl) {
                TreeDataSource treeDataSource = this.getDataSource(n);
                if (treeDataSource != null) {
                    this.removeChildren(n);
                    treeDataSource.removeChildren();
                }
            } else {
                TreeDataSource treeDataSource = null;
                int n6 = 0;
                Object v = this.mIDtoParent.get(n);
                if (v == null || (treeDataSource = this.getDataSource(v)) == null || (n6 = treeDataSource.getIndex(n)) == -1) {
                    return;
                }
                this.removeChildren(n);
                this.setProgrammaticEvent(true);
                this.mIDtoParent.remove(n);
                this.mIDtoData.remove(n);
                this.mIDtoItem.remove(n);
                treeDataSource.removeChild(n6);
                this.setProgrammaticEvent(false);
            }
        }
    }

    private void doSelectNode(Object object) {
        Object object2;
        Message message = (Message)object;
        Integer n = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = message.size();
        block4: for (int i = 0; i < n3; ++i) {
            int n4 = message.getPropertyAt(i);
            object2 = message.getValueAt(i);
            switch (n4) {
                case 500: {
                    n = (Integer)object2;
                    continue block4;
                }
                case 504: {
                    n2 = (Integer)object2;
                    continue block4;
                }
            }
        }
        if (n == null || n2 == 0) {
            return;
        }
        DTreeSelection dTreeSelection = this.mTree.getSelection();
        DTreeItem dTreeItem = (DTreeItem)this.mIDtoItem.get(n);
        if (dTreeItem == null && (n2 == 1 || n2 == 3)) {
            Stack<Integer> stack = new Stack<Integer>();
            Integer n5 = (Integer)this.mIDtoParent.get(n);
            stack.push(n);
            while (this.mIDtoItem.get(n5) == null && n5 != 0) {
                stack.push(n5);
                n5 = (Integer)this.mIDtoParent.get(n5);
            }
            while (!stack.empty()) {
                Integer n6 = (Integer)stack.pop();
                n5 = (Integer)this.mIDtoParent.get(n6);
                object2 = n5 == 0 ? (DTreeDeferringParent)((Object)this.mTree.getRoot()) : (DTreeDeferringParent)this.mIDtoItem.get(n5);
                dTreeItem = object2.getItem(((TreeDataSource)object2.getDataSource()).getIndex(n6));
                this.mIDtoItem.put(n6, dTreeItem);
            }
        }
        if (dTreeItem != null) {
            if (!(n2 != 1 && n2 != 3 || dTreeSelection.isSelected(dTreeItem))) {
                this.setProgrammaticEvent(true);
                for (DTreeItem dTreeItem2 = dTreeItem.getParent(); dTreeItem2 != this.mTree.getRoot(); dTreeItem2 = dTreeItem2.getParent()) {
                    if (dTreeItem2.isExpanded()) continue;
                    dTreeItem2.setExpanded(true);
                    bl = true;
                }
                this.setProgrammaticEvent(false);
            }
            if (n2 == 1 && !dTreeSelection.isSelected(dTreeItem) || n2 == 2 && dTreeSelection.isSelected(dTreeItem) || n2 == 3) {
                this.setProgrammaticEvent(true);
                dTreeSelection.toggleItem(dTreeItem);
                this.setProgrammaticEvent(false);
            }
            if (bl) {
                Message message2 = new Message(this.getHandler(), 504, n);
                this.getHandler().getDispatcher().onMessage(message2, 0);
            }
        }
    }

    public void doSetChildren(Object object, boolean bl) {
        Message message = (Message)object;
        Integer n = null;
        Integer n2 = null;
        int n3 = message.size();
        block4: for (int i = 0; i < n3; ++i) {
            int n4 = message.getPropertyAt(i);
            Object object2 = message.getValueAt(i);
            switch (n4) {
                case 500: {
                    n = (Integer)object2;
                    continue block4;
                }
                case 485: {
                    n2 = (Integer)object2;
                    continue block4;
                }
            }
        }
        if (n == null || n2 == null) {
            return;
        }
        TreeDataSource treeDataSource = this.getDataSource(n);
        if (treeDataSource == null) {
            return;
        }
        treeDataSource.setItemCount(n2, bl);
    }

    public void doResetChildren(Object object) {
        Message message = (Message)object;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        int n4 = message.size();
        block5: for (int i = 0; i < n4; ++i) {
            int n5 = message.getPropertyAt(i);
            Object object2 = message.getValueAt(i);
            switch (n5) {
                case 500: {
                    n = (Integer)object2;
                    continue block5;
                }
                case 503: {
                    n3 = (Integer)object2;
                    continue block5;
                }
                case 485: {
                    n2 = (Integer)object2;
                    continue block5;
                }
            }
        }
        if (n == null || n3 == null || n2 == null) {
            return;
        }
        TreeDataSource treeDataSource = this.getDataSource(n);
        if (treeDataSource == null) {
            return;
        }
        treeDataSource.resetChildren(n3, n2);
    }

    private void removeChildren(Integer n) {
        TreeDataSource treeDataSource = this.getDataSource(n);
        if (treeDataSource != null) {
            for (int i = 0; i < treeDataSource.getItemCount(); ++i) {
                Integer n2 = treeDataSource.getID(i);
                if (n2 == null) continue;
                this.removeChildren(n2);
                this.mIDtoParent.remove(n2);
                this.mIDtoData.remove(n2);
                this.mIDtoItem.remove(n2);
            }
        }
    }

    public TreeDataSource getDataSource(Object object) {
        return (TreeDataSource)this.mIDtoData.get(object);
    }

    public void setDataSource(Object object, TreeDataSource treeDataSource) {
        this.mIDtoData.put(object, treeDataSource);
    }

    public void getNode(Integer n, Integer n2) {
        Message message = new Message(this.getHandler());
        Message message2 = new Message(this.getHandler(), 505, message);
        message.add(500, n);
        message.add(503, n2);
        this.getHandler().getDispatcher().onMessage(message2, 0);
    }

    public void getNumChildren(Integer n) {
        Message message = new Message(this.getHandler(), 506, n);
        this.getHandler().getDispatcher().onMessage(message, 0);
    }

    public DTreeItem getCreatedItem(Object object) {
        return (DTreeItem)this.mIDtoItem.get(object);
    }

    public void setCreatedItem(Object object, Object object2) {
        this.mIDtoItem.put(object, object2);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public Component getAccessibleComponent() {
        return this.mTree;
    }

    protected String getMsgPropName(int n) {
        String string = null;
        return string;
    }

    private void setOldSelection() {
        this.mSelection = this.mTree.getSelection();
        this.moldSelection = this.mSelection.getSelectionRanges().getItems();
    }

    private void clearOldSelection() {
        this.mSelection = null;
        this.moldSelection = null;
        this.mSelectedDummyNodes = 0;
    }

    private DTreeItem[] getOldSelection() {
        return this.moldSelection;
    }

    private void setDeselectedList(Vector vector) {
        this.mDeSelectedList = vector;
    }

    private Vector getDeselectedList() {
        return this.mDeSelectedList;
    }

    private void sendDeferredNodeSelection() {
        Integer n;
        int n2;
        Vector vector = this.getDeselectedList();
        Vector<Object> vector2 = new Vector<Object>();
        int n3 = 0;
        DTreeRangeSet dTreeRangeSet = this.mTree.getSelection().getSelectionRanges();
        int n4 = dTreeRangeSet.getCount();
        for (n2 = 0; n2 < n4; ++n2) {
            DTreeRange dTreeRange = dTreeRangeSet.getRange(n2);
            DTreeItem dTreeItem = dTreeRange.getParent();
            int n5 = dTreeRange.getStartIndex();
            int n6 = n5 + dTreeRange.getCount() - 1;
            for (int i = n5; i <= n6; ++i) {
                Object[] objectArray = (Object[])((DTreeDeferringParent)dTreeItem).getChildData(i);
                vector2.addElement(objectArray[0]);
            }
        }
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            n = (Integer)vector.elementAt(n2);
            if (vector2.contains(n)) {
                vector2.removeElement(n);
                continue;
            }
            this.sendSelEvent(n, false);
        }
        vector = null;
        n3 = vector2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            n = (Integer)vector2.elementAt(n2);
            this.sendSelEvent(n, true);
        }
    }
}

