/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextListener;
import java.io.PrintStream;
import javax.accessibility.AccessibleContext;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.forms.common.Utils;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.properties.LanguageDirection;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.VTextField;

public class TextFieldItem
extends TextComponentItem {
    private static int sHandlerClassId = 0;
    private boolean mHasLovButton = false;
    private String mAccessibleDesc = null;
    private boolean mLOVButtonDisplayed = false;
    private boolean mLostFocus = false;
    private boolean mFieldShrunk = false;
    private static final int FUDGE_FACTOR = 2;
    private static final int MIN_FIELD_SIZE = 40;
    private boolean mReqdFlag = false;
    private boolean mSecure = false;
    private boolean mWantsToggleButton = false;

    public TextFieldItem() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.setComponent((Component)((Object)this.getView()));
        this.getView().addListener(FocusListener.class, this);
        this.getView().addListener(KeyListener.class, this);
        this.getView().addListener(MouseListener.class, this);
        this.getView().addListener(TextListener.class, this);
        this.getView().addListener(SelectionListener.class, this);
        this.getView().setProperty(ID.BORDER_BEVEL, BorderBevel.NONE);
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 203: {
                if (this.getDispatcher().useLovButtons()) {
                    if (this.hasLovButton() && !((Boolean)object).booleanValue()) {
                        this.setVisibleLOVButton(false);
                    }
                    this.mHasLovButton = (Boolean)object;
                    if (this.hasLovButton() && this.getDispatcher().getFocusOwner() == this) {
                        this.setVisibleLOVButton(true);
                    }
                }
                bl = super.onUpdate(n, object);
                break;
            }
            case 574: {
                this.mWantsToggleButton = (Boolean)object;
                if (((Boolean)object).booleanValue() && this.mSecure && this.mToggleButton == null) {
                    this.createToggleButton();
                }
                if (this.mToggleButton == null) break;
                this.mToggleButton.setVisible(this.mSecure && this.mWantsToggleButton);
                break;
            }
            case 579: {
                this.getView().setProperty(ID.PERSISTENT_PLACEHOLDER, (Boolean)object);
                break;
            }
            case 197: {
                this.mSecure = (Boolean)object;
                this.getView().setProperty(ID.SECURE, (Boolean)object);
                if (((Boolean)object).booleanValue() && this.mWantsToggleButton && this.mToggleButton == null) {
                    this.createToggleButton();
                }
                if (this.mToggleButton != null) {
                    this.mToggleButton.setVisible(this.mSecure && this.mWantsToggleButton);
                }
                if (!this.getDispatcher().mustObfuscateConcealedData() || this.getView().getClass() != VTextField.class) break;
                String string = (String)this.getView().getProperty(ID.VALUE);
                int n2 = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                char[] cArray = string.toCharArray();
                if (((Boolean)object).booleanValue()) {
                    Utils.obfuscateConcealedData(cArray);
                } else {
                    Utils.deobfuscateConcealedData(cArray);
                }
                String string2 = new String(cArray);
                this.getView().setProperty(ID.VALUE, string2);
                this.getView().setProperty(ID.CURSOR_POSITION, n2);
                break;
            }
            case 194: {
                bl = super.onUpdate(n, object);
                if (this.hasLovButton()) {
                    this.setVisibleLOVButton((Boolean)object);
                }
                this.appendAccessibilityDesc(this.mReqdFlag);
                break;
            }
            case 135: {
                Boolean bl2;
                bl = super.onUpdate(n, object);
                if (!this.hasLovButton() || this.getDispatcher().getFocusOwner() != this || !(bl2 = (Boolean)this.getView().getProperty(ID.EDITABLE)).booleanValue()) break;
                this.setVisibleLOVButton(false);
                this.setVisibleLOVButton(true);
                break;
            }
            case 137: {
                Boolean bl3;
                boolean bl4 = false;
                if (this.hasLovButton() && this.getDispatcher().getFocusOwner() == this && (bl3 = (Boolean)this.getView().getProperty(ID.EDITABLE)).booleanValue()) {
                    this.setVisibleLOVButton(false);
                    bl4 = true;
                }
                bl = super.onUpdate(n, object);
                if (!bl4) break;
                this.setVisibleLOVButton(true);
                break;
            }
            case 514: {
                bl = super.onUpdate(n, object);
                this.mAccessibleDesc = (String)object;
                this.appendAccessibilityDesc(false);
                this.mReqdFlag = false;
                break;
            }
            case 513: {
                this.mReqdFlag = (Boolean)object;
                this.appendAccessibilityDesc(this.mReqdFlag);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(FocusListener.class, this);
            this.getView().removeListener(KeyListener.class, this);
            this.getView().removeListener(MouseListener.class, this);
            this.getView().removeListener(TextListener.class, this);
            this.getView().removeListener(SelectionListener.class, this);
            if (this.isMouseMoveEnabled()) {
                this.getView().removeListener(MouseMotionListener.class, this);
            }
        }
        super.onDestroy();
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    public final boolean hasLovButton() {
        return this.mHasLovButton;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getHandler() == null) {
            return;
        }
        super.focusGained(focusEvent);
        this.mLostFocus = false;
        Boolean bl = (Boolean)this.getView().getProperty(ID.EDITABLE);
        if (this.hasLovButton() && bl.booleanValue()) {
            this.setVisibleLOVButton(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.getHandler() == null) {
            return;
        }
        this.mLostFocus = true;
        Boolean bl = (Boolean)this.getView().getProperty(ID.EDITABLE);
        if (this.hasLovButton() && bl.booleanValue()) {
            this.setVisibleLOVButton(false);
        }
        super.focusLost(focusEvent);
    }

    @Override
    public void keyTypedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t') {
            keyEvent.consume();
        }
        if (keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\r') {
            super.keyTypedImpl(keyEvent);
        }
    }

    public void setVisibleLOVButton(boolean bl) {
        ExtendedFrame extendedFrame = (ExtendedFrame)this.getParentWindow();
        LWTextField lWTextField = extendedFrame.getLovButtonParent();
        Container container = (Container)this.getView().getProperty(ID.UI_PARENT);
        Rectangle rectangle = (Rectangle)this.getView().getProperty(ID.BOUNDS);
        int n = lWTextField.getSize().width;
        Object object = this.getView().getProperty(ID.LANGUAGE_DIRECTION);
        if (bl && this == this.getDispatcher().getFocusOwner() && !this.mLOVButtonDisplayed && !this.mLostFocus) {
            Rectangle rectangle2 = lWTextField.getBounds();
            Rectangle rectangle3 = extendedFrame.getLovButton().getBounds();
            boolean bl2 = true;
            rectangle2.height = rectangle.height - 1;
            rectangle2.y = rectangle.y + 1;
            extendedFrame.getLovButton().setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle2.height);
            if (rectangle.width >= 40) {
                Point point;
                this.mFieldShrunk = true;
                if (object != LanguageDirection.RIGHT_TO_LEFT) {
                    rectangle.width -= n - 2;
                    if (this.mToggleButton != null) {
                        point = this.mToggleButton.getLocation();
                        point.x -= n - 2;
                        this.mToggleButton.setLocation(point.x, point.y);
                    }
                }
                point = new Point(rectangle.width, rectangle.height);
                this.getView().setProperty(ID.SIZE, point);
                if (object != LanguageDirection.RIGHT_TO_LEFT) {
                    rectangle2.x = rectangle.x + rectangle.width - 2;
                } else {
                    rectangle2.x = rectangle.x;
                    Point point2 = new Point(rectangle.x, rectangle.y);
                    this.getView().setProperty(ID.LOCATION, point2);
                    if (this.mToggleButton != null) {
                        Point point3 = this.mToggleButton.getLocation();
                        point3.x += n - 2;
                        this.mToggleButton.setLocation(point3.x, point3.y);
                    }
                }
            } else {
                Dimension dimension = container.getSize();
                rectangle2.x = object != LanguageDirection.RIGHT_TO_LEFT ? rectangle.x + rectangle.width - 2 : rectangle.x - n + 2;
                Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, n, rectangle2.height);
                if (rectangle2.x + n + 2 > dimension.width || rectangle2.x < 0 || this.isObscurred(rectangle4)) {
                    bl2 = false;
                }
            }
            if (bl2) {
                container.add((Component)lWTextField, 0);
                lWTextField.setBounds(rectangle2);
                lWTextField.setVisible(true);
                this.mLOVButtonDisplayed = true;
            }
        } else if (this.mLOVButtonDisplayed && !bl) {
            this.mLOVButtonDisplayed = false;
            lWTextField.setVisible(false);
            if (this.mFieldShrunk) {
                Point point;
                this.mFieldShrunk = false;
                if (object != LanguageDirection.RIGHT_TO_LEFT) {
                    rectangle.width += n - 2;
                    if (this.mToggleButton != null) {
                        point = this.mToggleButton.getLocation();
                        point.x += n - 2;
                        this.mToggleButton.setLocation(point.x, point.y);
                    }
                }
                point = new Point(rectangle.width, rectangle.height);
                this.getView().setProperty(ID.SIZE, point);
                if (object == LanguageDirection.RIGHT_TO_LEFT) {
                    Point point4 = new Point(rectangle.x, rectangle.y);
                    this.getView().setProperty(ID.LOCATION, point4);
                    if (this.mToggleButton != null) {
                        Point point5 = this.mToggleButton.getLocation();
                        point5.x -= n - 2;
                        this.mToggleButton.setLocation(point5.x, point5.y);
                    }
                }
            }
            container.remove(lWTextField);
        }
    }

    @Override
    protected Class getDefaultClass() {
        return VTextField.class;
    }

    private boolean isObscurred(Rectangle rectangle) {
        DrawnPanel drawnPanel = this.getContentView();
        Component component = (Component)this.getView().getProperty(ID.UI_PARENT);
        Container container = this.getParentContainer(component, drawnPanel);
        Component[] componentArray = drawnPanel.getComponents();
        boolean bl = false;
        for (int i = 0; i < componentArray.length && componentArray[i] != container; ++i) {
            Rectangle rectangle2;
            if (!componentArray[i].isVisible() || !(rectangle2 = componentArray[i].getBounds()).intersects(rectangle)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Container getParentContainer(Component component, Container container) {
        Container container2;
        if (container == null || !(component instanceof Container)) {
            return null;
        }
        for (container2 = (Container)component; container2 != null && container2.getParent() != container; container2 = container2.getParent()) {
        }
        return container2;
    }

    private void appendAccessibilityDesc(boolean bl) {
        String string = this.mAccessibleDesc;
        Component component = this.getComponent();
        MessageGenerator messageGenerator = this.getApplet().getTranslatedPhraseGenerator();
        if (bl) {
            string = string + messageGenerator.getText("REQD");
        }
        Boolean bl2 = (Boolean)this.getView().getProperty(ID.EDITABLE);
        if (this.getDispatcher().useLovButtons() && this.hasLovButton() && bl2.booleanValue()) {
            string = string + messageGenerator.getText("LOV");
        }
        if (component instanceof LWComponent) {
            AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
            accessibleContext.setAccessibleDescription(string);
            accessibleContext.setAccessibleName(string);
        }
    }

    public boolean isFieldShrunk() {
        return this.mFieldShrunk;
    }

    public boolean isLOVButtonDisplayed() {
        return this.mLOVButtonDisplayed;
    }
}

