/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import javax.accessibility.AccessibleContext;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.SelectionEvent;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.forms.common.Utils;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.properties.Alignment;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.CaseRestriction;
import oracle.forms.properties.ID;
import oracle.forms.properties.LanguageDirection;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.IView;
import oracle.forms.ui.OracleCenteredPainter;
import oracle.forms.ui.StatusBarInterface;
import oracle.forms.ui.VTextArea;
import oracle.forms.ui.VTextField;

public abstract class TextComponentItem
extends ComponentItem
implements TextListener,
SelectionListener,
ActionListener {
    private boolean mDirty = false;
    private boolean mLock = false;
    private boolean mRowLockRequired = true;
    private boolean mTextInSync = true;
    private boolean mHandleTextValueChangedEvent = true;
    private String mLastValue = "";
    private Point mLastSelection = null;
    private boolean mSelectionEmpty = true;
    private Integer mLastCursorpos = null;
    private static final Point BOGUS_KEY_STROKE = new Point(97, 0);
    private boolean mAutoSkip = false;
    private boolean mSkipping = false;
    private static final int NO_AUTOSKIP_DEFAULT_STATE = 0;
    private static final int NO_AUTOSKIP_INITIAL_STATE = 1;
    private static final int NO_AUTOSKIP_CONFIRM_STATE = 2;
    private int mNoAutoSkip = 0;
    private boolean mAlwaysHome = true;
    private boolean mMaxLengthIsBytes = false;
    private int mMaxLength = Integer.MAX_VALUE;
    private static final DataOutputStream sConvertStream = new DataOutputStream(new ByteArrayOutputStream());
    private String mPreviousValue = "";
    private boolean isScrollKeyReleased = false;
    private String mPlaceholderText = null;
    protected PushButton mToggleButton = null;
    private int mToggleButtonSize = 17;
    private static Image sToggleIcon = null;
    private PushButton mInternalLOVButton = null;
    private boolean mHasLOV = false;
    private boolean mShowLOVButton = false;
    private boolean mHasCharCounter = false;
    private Color mLabelColor = null;
    private boolean mCharCountDisplayed = false;
    private boolean mFocusWasLost = false;

    public TextComponentItem() {
    }

    public TextComponentItem(MessageHandler messageHandler) {
        super(messageHandler);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 203: {
                this.mHasLOV = (Boolean)object;
                if (this.mShowLOVButton && this.mHasLOV && this.mInternalLOVButton == null) {
                    this.CreateInteriorLOVButton();
                }
                if (this.mInternalLOVButton == null) break;
                this.mInternalLOVButton.setVisible(this.mHasLOV && this.mShowLOVButton && this.getDispatcher().getFocusOwner() == this);
                break;
            }
            case 575: {
                this.mShowLOVButton = (Boolean)object;
                if (this.mShowLOVButton && this.mHasLOV && this.mInternalLOVButton == null) {
                    this.CreateInteriorLOVButton();
                }
                if (this.mInternalLOVButton == null) break;
                this.mInternalLOVButton.setVisible(this.mHasLOV && this.mShowLOVButton && this.getDispatcher().getFocusOwner() == this);
                break;
            }
            case 137: {
                int n2;
                int n3;
                if (this.mInternalLOVButton != null) {
                    n3 = ((Point)object).x;
                    n2 = 0;
                    if (this instanceof TextAreaItem) {
                        if (this.getView().getProperty(ID.BORDER_BEVEL) != BorderBevel.NONE) {
                            n2 = -2;
                            n3 -= 2;
                        }
                        if (((VTextArea)this.getView()).getVDisplayPolicy() != 2) {
                            n3 -= 16;
                        }
                    }
                    if (this.getView().getProperty(ID.LANGUAGE_DIRECTION) == LanguageDirection.RIGHT_TO_LEFT) {
                        this.mInternalLOVButton.setLocation(this instanceof TextAreaItem ? -2 : 0, n2);
                    } else {
                        this.mInternalLOVButton.setLocation(n3 - 8, n2);
                    }
                }
                if (this.mToggleButton != null) {
                    n3 = ((Point)object).x;
                    n2 = 0;
                    if (((Point)object).y > this.mToggleButtonSize) {
                        n2 = (((Point)object).y - this.mToggleButtonSize) / 2;
                    }
                    if (this instanceof TextAreaItem) {
                        if (this.getView().getProperty(ID.BORDER_BEVEL) != BorderBevel.NONE) {
                            n2 = -2;
                            n3 -= 2;
                        }
                        if (((VTextArea)this.getView()).getVDisplayPolicy() != 2) {
                            n3 -= 17;
                        }
                    }
                    if (this.getView().getProperty(ID.LANGUAGE_DIRECTION) == LanguageDirection.RIGHT_TO_LEFT) {
                        this.mToggleButton.setLocation(this instanceof TextAreaItem ? 0 : 4, n2);
                    } else {
                        this.mToggleButton.setLocation(n3 - this.mToggleButtonSize - 4, n2);
                    }
                }
                n3 = 0;
                if (this.mHasCharCounter && this.getDispatcher().getFocusOwner() == this) {
                    this.setVisibleCharCounter(false);
                    n3 = 1;
                }
                bl = super.onUpdate(n, object);
                if (n3 == 0) break;
                this.setVisibleCharCounter(true);
                break;
            }
            case 131: {
                this.getDispatcher().setBIDIText();
                this.setTextValue((String)object);
                ComponentItem componentItem = this.getDispatcher().getFocusOwner();
                StatusBarInterface statusBarInterface = this.getDispatcher().getCurrentStatusBar();
                if (componentItem == this && statusBarInterface != null) {
                    Component component = this.getAccessibleComponent();
                    AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
                    String string = accessibleContext.getAccessibleDescription() + (String)object;
                    statusBarInterface.setStatusBarProperty(11, string);
                    ComponentItem.scheduleAccessibilityTask(this);
                }
                if (!this.mHasCharCounter || componentItem != this) break;
                this.updateCharCountLabel();
                break;
            }
            case 596: {
                if (this.mHasCharCounter && !((Boolean)object).booleanValue()) {
                    this.setVisibleCharCounter(false);
                }
                this.mHasCharCounter = (Boolean)object;
                if (!this.mHasCharCounter || this.getDispatcher().getFocusOwner() != this) break;
                this.setVisibleCharCounter(true);
                break;
            }
            case 135: {
                bl = super.onUpdate(n, object);
                if (!this.mHasCharCounter || this.getDispatcher().getFocusOwner() != this) break;
                this.setVisibleCharCounter(false);
                this.setVisibleCharCounter(true);
                break;
            }
            case 193: {
                this.mLastCursorpos = this.normalizeCursorposFromServer((Integer)object, this.getLWCommonText());
                this.getView().setProperty(ID.CURSOR_POSITION, this.mLastCursorpos);
                break;
            }
            case 202: {
                this.getView().setProperty(ID.CAN_TAKE_FOCUS, (Boolean)object);
                break;
            }
            case 194: {
                this.getView().setProperty(ID.EDITABLE, (Boolean)object);
                break;
            }
            case 528: {
                this.mMaxLengthIsBytes = (Boolean)object;
                break;
            }
            case 117: {
                this.mMaxLength = (Integer)object;
                if (this.getDispatcher().isSurrogatePairSupportEnabled()) {
                    object = Integer.MAX_VALUE;
                }
                this.getView().setProperty(ID.MAX_LENGTH, (Integer)object);
                break;
            }
            case 195: {
                this.mLastSelection = this.normalizeSelectionFromServer((Point)object, this.getLWCommonText());
                this.getView().setProperty(ID.SELECTION, this.mLastSelection);
                break;
            }
            case 532: {
                if (this.mLastSelection == null) {
                    this.mLastSelection = new Point();
                }
                this.mLastSelection.x = (Integer)object;
                break;
            }
            case 533: {
                if (this.mLastSelection == null) {
                    this.mLastSelection = new Point();
                }
                this.mLastSelection.y = (Integer)object;
                this.mLastSelection = this.normalizeSelectionFromServer(this.mLastSelection, this.getLWCommonText());
                this.getView().setProperty(ID.SELECTION, this.mLastSelection);
                break;
            }
            case 196: {
                this.setTextAlwaysHome((Boolean)object);
                break;
            }
            case 198: {
                this.setTextAutoSkip((Boolean)object);
                break;
            }
            case 206: {
                this.setDirty(false);
                break;
            }
            case 192: 
            case 200: 
            case 201: 
            case 205: {
                break;
            }
            case 204: {
                if (!this.getDispatcher().useRequiredFieldVA()) break;
                if (((Boolean)object).booleanValue()) {
                    this.getDispatcher().addElementToVAList(this.getHandlerId());
                    break;
                }
                this.getDispatcher().removeElementFromVAList(this.getHandlerId());
                break;
            }
            case 573: {
                this.mPlaceholderText = (String)object;
                if (this.getComponent() == null) break;
                this.getComponent().repaint();
                break;
            }
            case 537: {
                this.setRowLockRequired(object);
                break;
            }
            case 147: {
                if (this.mToggleButton != null && !this.mLocked) {
                    this.mToggleButton.setBackground(this.getDispatcher().getColorEntry((Integer)object));
                }
                bl = super.onUpdate(n, object);
                break;
            }
            case 146: {
                bl = super.onUpdate(n, object);
                if (this.mInternalLOVButton == null) break;
                this.mInternalLOVButton.setBackground(this.getLWCommonText().getForeground());
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized Object onGet(int n) {
        switch (n) {
            case 131: {
                if (this.obfuscationRequired()) {
                    char[] cArray = ((String)this.getView().getProperty(ID.VALUE)).toCharArray();
                    Utils.deobfuscateConcealedData(cArray);
                    return cArray;
                }
                return this.getView().getProperty(ID.VALUE);
            }
            case 199: {
                CaseRestriction caseRestriction = (CaseRestriction)this.getView().getProperty(ID.CASE_FOLD);
                return (byte)caseRestriction.toID();
            }
            case 115: {
                Alignment alignment = (Alignment)this.getView().getProperty(ID.ALIGNMENT);
                return (byte)alignment.toID();
            }
            case 193: {
                return this.normalizeCursorposForServer((Integer)this.getView().getProperty(ID.CURSOR_POSITION), this.getLWCommonText());
            }
            case 528: {
                return this.mMaxLengthIsBytes;
            }
            case 117: {
                return this.mMaxLength;
            }
            case 196: {
                return this.getTextAlwaysHome() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 198: {
                return this.getTextAutoSkip() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 195: {
                return this.normalizeSelectionForServer((Point)this.getView().getProperty(ID.SELECTION), this.getLWCommonText());
            }
        }
        return super.onGet(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mInternalLOVButton) {
            this.sendLOVButtonPressedMessage();
        }
    }

    private void CreateInteriorLOVButton() {
        if (this.mInternalLOVButton == null) {
            int n = 8;
            int n2 = 7;
            this.mInternalLOVButton = new PushButton("");
            if (this.getDispatcher().getScreenRes() != this.getDispatcher().getScreenResolution()) {
                n = n * this.getDispatcher().getScreenRes() / this.getDispatcher().getScreenResolution();
                n2 = n2 * this.getDispatcher().getScreenRes() / this.getDispatcher().getScreenResolution();
            }
            Dimension dimension = new Dimension(n, n2);
            this.mInternalLOVButton.setSize(dimension);
            this.mInternalLOVButton.setCursor(Cursor.getPredefinedCursor(12));
            this.mInternalLOVButton.setBackground(this.getLWCommonText().getForeground());
            this.mInternalLOVButton.addActionListener(this);
            this.mInternalLOVButton.addMouseListener(this);
            this.mInternalLOVButton.setFocusable(false);
            this.getLWCommonText().add((Component)this.mInternalLOVButton, -1);
            Rectangle rectangle = (Rectangle)this.getView().getProperty(ID.BOUNDS);
            int n3 = 0;
            if (this instanceof TextAreaItem) {
                if (this.getView().getProperty(ID.BORDER_BEVEL) != BorderBevel.NONE) {
                    n3 = -2;
                    rectangle.width -= 2;
                }
                if (((VTextArea)this.getView()).getVDisplayPolicy() != 2) {
                    rectangle.width -= 16;
                }
            }
            if (this.getView().getProperty(ID.LANGUAGE_DIRECTION) == LanguageDirection.RIGHT_TO_LEFT) {
                this.mInternalLOVButton.setLocation(this instanceof TextAreaItem ? -2 : 0, n3);
            } else {
                this.mInternalLOVButton.setLocation(rectangle.width - n, n3);
            }
        }
    }

    protected void createToggleButton() {
        if (this.mToggleButton == null) {
            this.mToggleButton = new PushButton("");
            if (this.getDispatcher().getScreenRes() != this.getDispatcher().getScreenResolution()) {
                this.mToggleButtonSize = this.mToggleButtonSize * this.getDispatcher().getScreenRes() / this.getDispatcher().getScreenResolution();
            }
            Rectangle rectangle = (Rectangle)this.getView().getProperty(ID.BOUNDS);
            if (this.mToggleButtonSize > rectangle.height - 2) {
                this.mToggleButtonSize = rectangle.height - 2;
            }
            Dimension dimension = new Dimension(this.mToggleButtonSize, this.mToggleButtonSize);
            this.mToggleButton.setSize(dimension);
            this.mToggleButton.setCursor(Cursor.getPredefinedCursor(12));
            if (this.getView() instanceof LWComponent) {
                this.mToggleButton.setBackground(((LWComponent)((Object)this.getView())).getBackground());
            }
            if (sToggleIcon == null) {
                sToggleIcon = this.getDispatcher().getApplet().getDefaultImage("unlock");
            }
            Image image = sToggleIcon;
            if (this.mToggleButtonSize != 17 && sToggleIcon != null) {
                image = sToggleIcon.getScaledInstance(11 * this.mToggleButtonSize / 17, 11 * this.mToggleButtonSize / 17, 2);
            }
            this.mToggleButton.setImage(image);
            this.mToggleButton.setPainter(OracleCenteredPainter.getInstance());
            this.mToggleButton.addMouseListener(this);
            this.mToggleButton.setFocusable(false);
            this.mToggleButton.setEnabled(true);
            this.getLWCommonText().add((Component)this.mToggleButton, -1);
            int n = 0;
            if (rectangle.height > this.mToggleButtonSize) {
                n = (rectangle.height - this.mToggleButtonSize) / 2;
            }
            if (this instanceof TextAreaItem) {
                if (this.getView().getProperty(ID.BORDER_BEVEL) != BorderBevel.NONE) {
                    n = -2;
                    rectangle.width -= 2;
                }
                if (((VTextArea)this.getView()).getVDisplayPolicy() != 2) {
                    rectangle.width -= this.mToggleButtonSize;
                }
            }
            Alignment alignment = (Alignment)this.getView().getProperty(ID.ALIGNMENT);
            if (this.getView().getProperty(ID.LANGUAGE_DIRECTION) == LanguageDirection.RIGHT_TO_LEFT && (alignment == Alignment.START || alignment == Alignment.CENTER) || this.getView().getProperty(ID.LANGUAGE_DIRECTION) != LanguageDirection.RIGHT_TO_LEFT && alignment == Alignment.END || alignment == Alignment.RIGHT) {
                this.mToggleButton.setLocation(this instanceof TextAreaItem ? 0 : 4, n);
            } else {
                this.mToggleButton.setLocation(rectangle.width - this.mToggleButtonSize - 4, n);
            }
        }
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
    }

    public final boolean hasCharCounter() {
        return this.mHasCharCounter;
    }

    public final void setLabelColor(Color color) {
        if (this.mLabelColor != color) {
            this.mLabelColor = color;
            if (this.mHasCharCounter && this.getDispatcher().getFocusOwner() == this) {
                this.setVisibleCharCounter(false);
                this.setVisibleCharCounter(true);
            }
        }
    }

    @Override
    public void setEventMask(Object object) {
        super.setEventMask(object);
        if (this.isMouseMoveEnabled()) {
            this.getView().addListener(MouseMotionListener.class, this);
        }
    }

    public void setDirty(boolean bl) {
        Object var2_2 = null;
        Boolean bl2 = (Boolean)this.getView().getProperty(ID.EDITABLE);
        boolean bl3 = this.mDirty;
        this.mDirty = bl;
        if (this.getView() != null && bl && !bl3 && this.isRowLockRequired() && !this.getDispatcher().getSendKeyEventFlag() && bl2.booleanValue()) {
            this.getDispatcher().setObserver(this.getHandler());
            this.getDispatcher().setSendKeyEventFlag(true);
            this.mLock = true;
            this.sendKeyEvent();
            this.mLock = false;
        }
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public boolean isRowLockRequired() {
        return this.mRowLockRequired;
    }

    public void setRowLockRequired(Object object) {
        this.mRowLockRequired = (Boolean)object;
    }

    public boolean isLocked() {
        return this.mLock;
    }

    public void setTextValue(String string) {
        this.mHandleTextValueChangedEvent = false;
        this.getView().setProperty(ID.VALUE, string);
        this.setDirty(false);
        this.mHandleTextValueChangedEvent = true;
        this.mLastValue = (String)this.getView().getProperty(ID.VALUE);
        if (this.getDispatcher().getFocusOwner() == this) {
            this.mPreviousValue = this.mLastValue;
        }
    }

    public void setTextAutoSkip(boolean bl) {
        this.mAutoSkip = bl;
    }

    public boolean getTextAutoSkip() {
        return this.mAutoSkip;
    }

    public void setTextAlwaysHome(boolean bl) {
        this.mAlwaysHome = bl;
    }

    public boolean getTextAlwaysHome() {
        return this.mAlwaysHome;
    }

    protected void sendKeyEvent() {
        Message message = new Message(this, 175, BOGUS_KEY_STROKE);
        this.getDispatcher().onMessage(message, 0);
    }

    @Override
    public Message getFinalMessage() {
        if (this.getView() == null) {
            return null;
        }
        String string = (String)this.getView().getProperty(ID.VALUE);
        Object var3_2 = null;
        Point point = (Point)this.getView().getProperty(ID.SELECTION);
        Integer n = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
        LWCommonText lWCommonText = this.getLWCommonText();
        boolean bl = this.getDispatcher().getApplet().isSendTextChanged();
        char[] cArray = null;
        if (this.obfuscationRequired()) {
            cArray = string.toCharArray();
            Utils.obfuscateConcealedData(cArray);
        }
        int n2 = this.getDispatcher().compareStringAgainstMaxLength(string, this.mMaxLength, this.mMaxLengthIsBytes, cArray != null, cArray);
        if (this.isLocked() || TextComponentItem.hasTextChanged(this.mLastValue, string) && n2 <= 0 || bl && this.isDirty() || this.mSkipping) {
            Message message;
            this.mSkipping = false;
            if (this.mNoAutoSkip == 1) {
                this.mNoAutoSkip = 2;
            }
            if (this.obfuscationRequired()) {
                cArray = string.toCharArray();
                Utils.deobfuscateConcealedData(cArray);
                message = new Message(this, 131, cArray);
            } else {
                message = new Message(this, 131, string);
            }
            message.add(195, this.normalizeSelectionForServer(point, lWCommonText));
            this.mLastSelection = point;
            message.add(193, this.normalizeCursorposForServer(n, lWCommonText));
            this.mLastCursorpos = n;
            ComponentItem componentItem = this.getDispatcher().getNextFocusOwner();
            if (componentItem != null && componentItem != this) {
                message.add(198, false);
            }
            this.mLastValue = string;
            this.setDirty(false);
            return message;
        }
        if (TextComponentItem.hasSelectionChanged(this.mLastSelection, point)) {
            Message message = new Message(this, 195, this.normalizeSelectionForServer(point, lWCommonText));
            this.mLastSelection = point;
            if (TextComponentItem.hasCursorposChanged(this.mLastCursorpos, n)) {
                message.add(193, this.normalizeCursorposForServer(n, lWCommonText));
                this.mLastCursorpos = n;
            }
            return message;
        }
        if (TextComponentItem.hasCursorposChanged(this.mLastCursorpos, n)) {
            Message message = new Message(this, 193, this.normalizeCursorposForServer(n, lWCommonText));
            this.mLastCursorpos = n;
            return message;
        }
        return null;
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        int n;
        if (keyEvent.isShiftDown() && (keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 35)) {
            return;
        }
        if (keyEvent.isControlDown() && (keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 86 || keyEvent.getKeyCode() == 88)) {
            return;
        }
        if (this.getDispatcher().getScrollControl() && ((n = keyEvent.getKeyCode()) == 40 || n == 38)) {
            if (!this.isScrollKeyReleased) {
                if (this.getApplet().getToolkit().getSystemEventQueue().peekEvent(402) != null) {
                    this.isScrollKeyReleased = true;
                    return;
                }
            } else {
                return;
            }
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyReleasedImpl(KeyEvent keyEvent) {
        super.keyReleasedImpl(keyEvent);
        this.isScrollKeyReleased = false;
    }

    @Override
    public void keyTypedImpl(KeyEvent keyEvent) {
        if (!(!keyEvent.isControlDown() && !keyEvent.isAltDown() && !keyEvent.isMetaDown() || keyEvent.isControlDown() && keyEvent.isAltDown())) {
            keyEvent.consume();
        }
        Boolean bl = (Boolean)this.getView().getProperty(ID.EDITABLE);
        if (keyEvent.getKeyChar() != '\t' && !keyEvent.isControlDown() && !bl.booleanValue()) {
            this.sendKeyEvent();
        }
        super.keyTypedImpl(keyEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mToggleButton) {
            if (this.getDispatcher().mustObfuscateConcealedData()) {
                String string = (String)this.getView().getProperty(ID.VALUE);
                int n = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                char[] cArray = string.toCharArray();
                Utils.deobfuscateConcealedData(cArray);
                String string2 = new String(cArray);
                this.getView().setProperty(ID.VALUE, string2);
                this.getView().setProperty(ID.CURSOR_POSITION, n);
            }
            this.getView().setProperty(ID.SECURE, Boolean.FALSE);
            return;
        }
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
        if (this.isMouseClickEnabled() || this.isPopupMenuEnabled()) {
            super.mousePressed(mouseEvent);
            return;
        }
        this.retargetKeyEvent(this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mToggleButton) {
            this.getView().setProperty(ID.SECURE, Boolean.TRUE);
            if (this.getDispatcher().mustObfuscateConcealedData()) {
                String string = (String)this.getView().getProperty(ID.VALUE);
                int n = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                char[] cArray = string.toCharArray();
                Utils.obfuscateConcealedData(cArray);
                String string2 = new String(cArray);
                this.getView().setProperty(ID.VALUE, string2);
                this.getView().setProperty(ID.CURSOR_POSITION, n);
            }
            return;
        }
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
        if (this.isMouseClickEnabled() || this.isPopupMenuEnabled()) {
            super.mouseReleased(mouseEvent);
            return;
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        if (this.mHandleTextValueChangedEvent) {
            int n;
            String string = (String)this.getView().getProperty(ID.VALUE);
            char[] cArray = null;
            if (this.obfuscationRequired()) {
                n = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                cArray = string.toCharArray();
                Utils.obfuscateConcealedData(cArray);
                String string2 = new String(cArray);
                this.getView().setProperty(ID.VALUE, string2);
                this.getView().setProperty(ID.CURSOR_POSITION, n);
            }
            if ((n = this.getDispatcher().compareStringAgainstMaxLength(string, this.mMaxLength, this.mMaxLengthIsBytes, cArray != null, cArray)) > 0) {
                int n2 = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                if ((n2 -= string.length() - this.mPreviousValue.length()) < 0) {
                    n2 = 0;
                }
                this.getView().setProperty(ID.VALUE, this.mPreviousValue);
                this.getView().setProperty(ID.CURSOR_POSITION, n2);
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.mPreviousValue = string;
            }
            this.mNoAutoSkip = 1;
            if (n <= 0) {
                this.setDirty(true);
            }
            if (this.getTextAutoSkip() && n == 0 && this.mNoAutoSkip != 2) {
                this.setDirty(false);
                this.mSkipping = true;
                this.sendFinalMessage(true);
                this.mSkipping = false;
            }
            this.mNoAutoSkip = 0;
        }
        if (this.mHasCharCounter && this.getDispatcher().getFocusOwner() == this) {
            this.updateCharCountLabel();
        }
    }

    private static boolean hasSelectionChanged(Point point, Point point2) {
        boolean bl = false;
        if (point == null) {
            if (point2 != null) {
                bl = point2.x != 0 || point2.y != 0;
            }
        } else {
            bl = !point.equals(point2);
        }
        return bl;
    }

    private static boolean hasCursorposChanged(Integer n, Integer n2) {
        boolean bl = false;
        bl = n == null ? n2 != null : !n.equals(n2);
        return bl;
    }

    private static boolean hasTextChanged(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        String string = Thread.currentThread().getName();
        if (!string.startsWith("AWT-EventQueue")) {
            try {
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                eventQueue.postEvent(selectionEvent);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (selectionEvent.isSelectionEmpty() != this.mSelectionEmpty) {
            boolean bl = this.mSelectionEmpty = !this.mSelectionEmpty;
            if (this.getDispatcher().getFocusOwner() == this) {
                FormMenu formMenu;
                FormMenu formMenu2 = formMenu = this.getDispatcher().getFrame() != null ? ((ExtendedFrame)this.getDispatcher().getFrame()).getHandler().getMenu() : ((ExtendedFrame)this.getParentWindow()).getHandler().getMenu();
                if (formMenu != null && formMenu.getMenuInfo() != null && this.getView() instanceof LWComponent) {
                    LWCommonText lWCommonText = null;
                    lWCommonText = this instanceof TextAreaItem ? (LWTextArea)((VTextArea)this.getView()).getContent() : (LWTextField)((Object)this.getView());
                    formMenu.getMenuInfo().doEnableCopy(!this.mSelectionEmpty, lWCommonText.isEditable());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.setBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mRolloverEntryPainter != null || this.mRolloverPainter != null) {
            this.clearBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.getDispatcher().setBIDIText();
        this.mPreviousValue = (String)this.getView().getProperty(ID.VALUE);
        this.mLastSelection = null;
        this.mLastCursorpos = null;
        if (this.mInternalLOVButton != null && this.mHasLOV && this.mShowLOVButton) {
            this.mInternalLOVButton.setVisible(true);
        }
        this.mFocusWasLost = false;
        if (this.mHasCharCounter) {
            this.setVisibleCharCounter(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.mInternalLOVButton != null) {
            this.mInternalLOVButton.setVisible(false);
        }
        this.mFocusWasLost = true;
        if (this.mHasCharCounter) {
            this.setVisibleCharCounter(false);
        }
        super.focusLost(focusEvent);
    }

    public void setVisibleCharCounter(boolean bl) {
        ExtendedFrame extendedFrame = (ExtendedFrame)this.getParentWindow();
        Rectangle rectangle = (Rectangle)this.getView().getProperty(ID.BOUNDS);
        Container container = (Container)this.getView().getProperty(ID.UI_PARENT);
        LWLabel lWLabel = extendedFrame.getCharCountLabel();
        Object object = this.getView().getProperty(ID.LANGUAGE_DIRECTION);
        if (bl && this == this.getDispatcher().getFocusOwner() && !this.mCharCountDisplayed && !this.mFocusWasLost) {
            Font font = this.getComponent().getFont();
            int n = this.getDispatcher().getCharCounterFontsize();
            int n2 = this.getDispatcher().getScreenRes();
            if (n2 != this.getDispatcher().getScreenResolution()) {
                n = n * n2 / this.getDispatcher().getScreenResolution();
            }
            lWLabel.setFont(new Font(font.getName(), 0, n));
            n = lWLabel.getFont().getSize();
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, (int)((double)n * 1.2));
            lWLabel.setBounds(rectangle2);
            lWLabel.setVisible(true);
            if (object != LanguageDirection.RIGHT_TO_LEFT) {
                lWLabel.setAlignment(2);
            } else {
                lWLabel.setAlignment(1);
            }
            if (this.mLabelColor != null) {
                lWLabel.setForeground(this.mLabelColor);
            } else {
                lWLabel.setForeground(Color.BLACK);
            }
            this.updateCharCountLabel();
            this.mCharCountDisplayed = true;
            container.add((Component)lWLabel, 0);
        } else if (this.mCharCountDisplayed && !bl) {
            this.mCharCountDisplayed = false;
            lWLabel.setVisible(false);
            container.remove(lWLabel);
        }
    }

    private void updateCharCountLabel() {
        ExtendedFrame extendedFrame = (ExtendedFrame)this.getParentWindow();
        LWLabel lWLabel = extendedFrame.getCharCountLabel();
        String string = (String)this.getView().getProperty(ID.VALUE);
        Integer n = (Integer)this.getView().getProperty(ID.MAX_LENGTH);
        int n2 = string != null ? string.length() : 0;
        lWLabel.setText(n2 + " / " + n);
    }

    public LWCommonText getLWCommonText() {
        Object object = this.getView();
        if (object instanceof ScrollBox) {
            object = ((ScrollBox)object).getContent();
        }
        if (object instanceof LWCommonText) {
            return (LWCommonText)object;
        }
        return null;
    }

    private boolean obfuscationRequired() {
        IView iView;
        if (this.getDispatcher().mustObfuscateConcealedData() && (iView = this.getView()).getClass() == VTextField.class) {
            return ((VTextField)iView).isTextSecure();
        }
        return false;
    }

    public String getPlaceholderText() {
        return this.mPlaceholderText;
    }

    public PushButton getToggleButton() {
        return this.mToggleButton;
    }
}

