/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextListener;
import java.io.PrintStream;
import javax.accessibility.AccessibleContext;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.VTextArea;

public class TextAreaItem
extends TextComponentItem {
    private static int sHandlerClassId = 0;
    private static boolean sTabRedispatched = false;
    private String mAccessibleDesc = null;

    public TextAreaItem() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        int n;
        super.onCreate(runform, message);
        this.setComponent((Component)((Object)this.getView()));
        this.getView().addListener(FocusListener.class, this);
        this.getView().addListener(KeyListener.class, this);
        this.getView().addListener(MouseListener.class, this);
        this.getView().addListener(TextListener.class, this);
        this.getView().addListener(SelectionListener.class, this);
        this.getView().setProperty(ID.BORDER_BEVEL, BorderBevel.NONE);
        if (this.getView() instanceof VTextArea && (n = this.getDispatcher().getApplet().getTabStop()) != -1) {
            ((VTextArea)this.getView()).setTabStop(n);
        }
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 209: {
                this.getView().setProperty(ID.VSBARPOLICY, (Boolean)object);
                break;
            }
            case 514: {
                bl = super.onUpdate(n, object);
                this.mAccessibleDesc = (String)object;
                this.appendAccessibilityDesc();
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(FocusListener.class, this);
            this.getView().removeListener(KeyListener.class, this);
            this.getView().removeListener(MouseListener.class, this);
            this.getView().removeListener(TextListener.class, this);
            this.getView().removeListener(SelectionListener.class, this);
            if (this.isMouseMoveEnabled()) {
                this.getView().removeListener(MouseMotionListener.class, this);
            }
        }
        super.onDestroy();
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getHandler() == null) {
            return;
        }
        if (this.getTextAlwaysHome()) {
            this.getView().setProperty(ID.CURSOR_POSITION, 0);
        }
        super.focusGained(focusEvent);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 9 && keyEvent.isControlDown()) {
            if (keyEvent.getKeyCode() == 9 && keyEvent.getSource() instanceof LWComponent) {
                KeyEvent keyEvent2 = new KeyEvent((Component)keyEvent.getSource(), 401, keyEvent.getWhen(), 0, keyEvent.getKeyCode(), keyEvent.getKeyChar());
                KeyEvent keyEvent3 = new KeyEvent((Component)keyEvent.getSource(), 400, keyEvent.getWhen(), 0, 0, '\t');
                sTabRedispatched = true;
                keyEvent.consume();
                ((LWComponent)keyEvent.getSource()).redispatchEvent(keyEvent2);
                ((LWComponent)keyEvent.getSource()).redispatchEvent(keyEvent3);
            }
            return;
        }
        if (keyEvent.isActionKey() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39)) {
            return;
        }
        if (keyEvent.getKeyCode() == 9 && sTabRedispatched) {
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyTypedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t' && sTabRedispatched) {
            sTabRedispatched = false;
            return;
        }
        super.keyTypedImpl(keyEvent);
    }

    @Override
    public Component getAccessibleComponent() {
        Component component = null;
        component = this.getComponent() instanceof VTextArea ? ((VTextArea)this.getComponent()).getContent() : super.getAccessibleComponent();
        return component;
    }

    @Override
    protected Class getDefaultClass() {
        return VTextArea.class;
    }

    private void appendAccessibilityDesc() {
        Object object;
        String string = this.mAccessibleDesc;
        Component component = this.getAccessibleComponent();
        Boolean bl = (Boolean)this.getView().getProperty(ID.EDITABLE);
        if (bl.booleanValue()) {
            object = this.getApplet().getTranslatedPhraseGenerator();
            string = string + ((MessageGenerator)object).getText("MULTILINE");
        }
        if (component instanceof LWComponent) {
            object = ((LWComponent)component).getAccessibleContext();
            ((AccessibleContext)object).setAccessibleDescription(string);
            ((AccessibleContext)object).setAccessibleName(string);
        }
    }
}

