/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.PopListItem;
import oracle.forms.properties.ID;
import oracle.forms.ui.IView;
import oracle.forms.ui.StatusBarInterface;
import oracle.forms.ui.VTList;

public class TListItem
extends PopListItem
implements ActionListener {
    private static int sHandlerClassId = 0;
    private int mOldIndex = -1;

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.getView().addListener(ActionListener.class, this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(ActionListener.class, this);
        }
        super.onDestroy();
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.setBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mRolloverEntryPainter != null || this.mRolloverPainter != null) {
            this.clearBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
        IView iView = this.getView();
        Integer n = (Integer)iView.getProperty(ID.SELECTEDINDEX);
        Message message = new Message(this, 341, n);
        this.mOldIndex = n;
        this.getDispatcher().onMessage(message, 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        IView iView = this.getView();
        Integer n = (Integer)iView.getProperty(ID.SELECTEDINDEX);
        if (n != this.mOldIndex) {
            this.mOldIndex = n;
            Message message = new Message(this, 131, n);
            this.getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    protected void doListValue(Integer n) {
        IView iView = this.getView();
        if (n == -1) {
            Integer n2 = (Integer)iView.getProperty(ID.SELECTEDINDEX);
            if (n2 != -1) {
                iView.setProperty(ID.DESELECT, n2);
                this.mOldIndex = -1;
            }
        } else {
            iView.setProperty(ID.SELECT, n);
            iView.setProperty(ID.MAKEVISIBLE, n);
            this.mOldIndex = n;
            if (iView instanceof VTList) {
                String string = ((VTList)iView).getSelectedItem();
                StatusBarInterface statusBarInterface = this.getDispatcher().getCurrentStatusBar();
                if (statusBarInterface != null) {
                    statusBarInterface.setStatusBarProperty(11, string);
                    ComponentItem.scheduleAccessibilityTask(this);
                }
            }
        }
    }

    @Override
    protected void updateIndex(int n) {
        if (n == -1 || n == this.mOldIndex) {
            this.mOldIndex = -1;
        } else if (n < this.mOldIndex) {
            --this.mOldIndex;
        }
    }

    @Override
    protected Class getDefaultClass() {
        return VTList.class;
    }
}

