/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.PromptItem;
import oracle.graphics.vgs.ui.Device;

public class PromptListItem
extends ComponentItem {
    private FormCanvas mFormCanvas;
    private Vector mPrompts;
    private int mNumPrompts;
    private Hashtable mHashTable;
    private static int sHandlerClassId = 0;
    private boolean mForceRepaint = false;
    private PromptItem mLocalPrompt = null;

    public PromptListItem() {
        this.setHandler(this);
        this.mNumPrompts = 0;
        this.mHashTable = new Hashtable();
        this.mHashTable.clear();
        this.mPrompts = new Vector();
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.onUpdate(message);
        this.mFormCanvas.addPromptListItem(this);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 416: {
                this.mFormCanvas = (FormCanvas)this.getDispatcher().getHandler((Integer)object);
                break;
            }
            case 417: {
                this.mLocalPrompt = new PromptItem();
                this.mLocalPrompt.setPromptProperty(-1, object);
                this.addPromptToList(this.mLocalPrompt);
                ++this.mNumPrompts;
                break;
            }
            case 419: {
                this.mLocalPrompt = (PromptItem)this.mHashTable.get(object);
                this.mLocalPrompt.setDirty(true);
                break;
            }
            case 418: {
                this.onRemove((PromptItem)this.mHashTable.get(object));
                break;
            }
            case 420: {
                if (!this.mLocalPrompt.isDirty()) break;
                this.mLocalPrompt.damagePrompt(this.mFormCanvas);
                break;
            }
            default: {
                bl = this.mLocalPrompt.setPromptProperty(n, object);
            }
        }
        return bl;
    }

    public void dirtyAllPrompts() {
        for (int i = 0; i < this.mPrompts.size(); ++i) {
            ((PromptItem)this.mPrompts.elementAt(i)).setDirty(true);
        }
    }

    public void addPromptToList(PromptItem promptItem) {
        this.mPrompts.addElement(promptItem);
        Integer n = promptItem.getItemInfo().getItemIndex();
        this.mHashTable.put(n, promptItem);
    }

    public void onRemove(PromptItem promptItem) {
        int n = promptItem.getItemInfo().getItemIndex();
        this.mPrompts.removeElement(promptItem);
        --this.mNumPrompts;
        this.mHashTable.remove(n);
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
        for (int i = 0; i < this.mNumPrompts; ++i) {
            ((PromptItem)this.mPrompts.elementAt(i)).doDestroy();
        }
        this.mPrompts = null;
        this.mHashTable = null;
        this.mFormCanvas = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public void onDraw(Graphics graphics, Device device) {
        Rectangle rectangle = graphics.getClipBounds();
        for (int i = 0; i < this.mNumPrompts; ++i) {
            PromptItem promptItem = (PromptItem)this.mPrompts.elementAt(i);
            if (!promptItem.isDisplayed() || !promptItem.redrawNeeded(rectangle)) continue;
            promptItem.drawPrompt(graphics, device, this.mFormCanvas);
        }
    }
}

