/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterTiler;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.PatternProducer;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.ItemInfo;
import oracle.forms.handler.TextComponentItem;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Text;

class PromptItem {
    private byte mEnumVal;
    private int mEdgeOffset;
    private int mAlignOffset;
    private byte mReadingDirection;
    private Vector mTextVal;
    private int mColorNum;
    private Color mBgColor;
    private int mFontNum;
    private Color mColor;
    private Font mFont;
    private String mImageName;
    private Painter mPainter;
    private ItemInfo mItemInfo;
    private PatternProducer mProducer;
    private FontMetrics mFontMetrics;
    private int mWidth = 0;
    private int mHeight = 0;
    private Rectangle mBoundingBox;
    private boolean mDirty;
    private boolean mFirst;
    public static final int PROMPT_ITEMINDEX = -1;
    public static final byte PROMPT_DSP_SHIFT = 7;
    public static final byte PROMPT_DSP_MASK = 1;
    public static final byte PROMPT_EDG_SHIFT = 5;
    public static final byte PROMPT_EDG_MASK = 3;
    public static final byte PROMPT_EDG_TOP = 0;
    public static final byte PROMPT_EDG_BOT = 1;
    public static final byte PROMPT_EDG_START = 2;
    public static final byte PROMPT_EDG_END = 3;
    public static final byte PROMPT_TAL_SHIFT = 2;
    public static final byte PROMPT_TAL_MASK = 7;
    public static final byte PROMPT_TAL_START = 0;
    public static final byte PROMPT_TAL_END = 1;
    public static final byte PROMPT_TAL_LEFT = 2;
    public static final byte PROMPT_TAL_CENTER = 3;
    public static final byte PROMPT_TAL_RIGHT = 4;
    public static final byte PROMPT_EAL_SHIFT = 0;
    public static final byte PROMPT_EAL_MASK = 3;
    public static final byte PROMPT_EAL_START = 0;
    public static final byte PROMPT_EAL_CENTER = 1;
    public static final byte PROMPT_EAL_END = 2;
    public static final byte PROMPT_READINGDIRECTION_DEFAULT = 0;
    public static final byte PROMPT_READINGDIRECTION_TOLEFT = 1;
    public static final byte PROMPT_READINGDIRECTION_TORIGHT = 2;

    public PromptItem() {
        this.setDirty(true);
        this.mFirst = true;
        this.mFontNum = 1;
        this.mColorNum = 1;
        this.mReadingDirection = 0;
        this.mItemInfo = new ItemInfo();
        this.mBoundingBox = new Rectangle();
    }

    public boolean setPromptProperty(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 421: {
                this.setEnum((Byte)object);
                break;
            }
            case 165: {
                this.mReadingDirection = (Byte)object;
                break;
            }
            case 422: {
                this.setEOF((Integer)object);
                break;
            }
            case 423: {
                this.setAOF((Integer)object);
                break;
            }
            case 131: {
                this.setTextVal((String[])object);
                break;
            }
            case 425: {
                this.setColorNum((Integer)object);
                break;
            }
            case 426: {
                this.setFontNum((Integer)object);
                break;
            }
            case 427: {
                this.mItemInfo.setItemPosition((Point)object);
                break;
            }
            case 428: {
                this.mItemInfo.setItemSize((Point)object);
                break;
            }
            case -1: {
                this.mItemInfo.setItemIndex((Integer)object);
                break;
            }
            case 429: {
                this.setImage((String)object);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void setEnum(byte by) {
        this.mEnumVal = by;
    }

    public void setEOF(int n) {
        this.mEdgeOffset = n;
    }

    public void setAOF(int n) {
        this.mAlignOffset = n;
    }

    public void setTextVal(String[] stringArray) {
        Object var2_2 = null;
        this.mTextVal = null;
        this.mTextVal = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mTextVal.addElement(stringArray[i]);
        }
    }

    public void setColorNum(int n) {
        if (n != this.mColorNum) {
            this.mPainter = null;
        }
        this.mColorNum = n;
    }

    public void setBgColor(Color color) {
        if (color != this.mBgColor) {
            this.mPainter = null;
        }
        this.mBgColor = color;
    }

    public void setFontNum(int n) {
        this.mFontNum = n;
    }

    public void setDirty(boolean bl) {
        this.mDirty = bl;
    }

    public void setImage(String string) {
        if (string == null && string != this.mImageName || string != null && !string.equals(this.mImageName)) {
            this.mPainter = null;
        }
        this.mImageName = string;
    }

    public byte getEnum() {
        return this.mEnumVal;
    }

    public int getEOF() {
        return this.mEdgeOffset;
    }

    public int getAOF() {
        return this.mAlignOffset;
    }

    public int getColorNum() {
        return this.mColorNum;
    }

    public Color getBgColor() {
        return this.mBgColor;
    }

    public int getFontNum() {
        return this.mFontNum;
    }

    public Painter getPainter(Runform runform) {
        if (this.mPainter == null && this.mImageName != null) {
            Image image;
            if (this.mProducer == null) {
                this.mProducer = PatternProducer.getProducer(runform.getApplet());
            }
            this.mPainter = (image = this.mProducer.getPattern(this.mImageName, runform.getColorEntry(this.getColorNum()), this.getBgColor())) == null ? null : new PainterTiler(new FixedImagePainter(image));
        }
        return this.mPainter;
    }

    public ItemInfo getItemInfo() {
        return this.mItemInfo;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public boolean isDisplayed() {
        boolean bl = false;
        byte by = (byte)(this.mEnumVal >> 7 & 1);
        bl = by == 1;
        return bl;
    }

    public void computeWidth(byte by) {
        int n = 0;
        int n2 = this.mReadingDirection == 2 || this.mReadingDirection == 0 && by == 1 ? 1 : 2;
        this.mWidth = 0;
        for (int i = 0; i < this.mTextVal.size(); ++i) {
            String string = StringUtils.getDisplayString((String)this.mTextVal.elementAt(i), Locale.getDefault(), n2);
            n = this.mFontMetrics.stringWidth(string);
            if (n <= this.mWidth) continue;
            this.mWidth = n;
        }
    }

    public void computeHeight() {
        int n = 0;
        for (int i = 0; i < this.mTextVal.size(); ++i) {
            n += this.mFontMetrics.getHeight();
        }
        this.mHeight = n;
    }

    public void computeBoundingBox(FormCanvas formCanvas) {
        Point point = new Point(0, 0);
        int n = this.mEnumVal >> 5 & 3;
        int n2 = this.mEnumVal >> 0 & 3;
        int n3 = this.mItemInfo.getItemX();
        int n4 = this.mItemInfo.getItemY();
        int n5 = this.mItemInfo.getItemWidth();
        int n6 = this.mItemInfo.getItemHeight();
        int n7 = this.getAOF();
        this.mFont = formCanvas.getFontEntry(this.getFontNum());
        this.mFontMetrics = formCanvas.getComponent().getFontMetrics(this.mFont);
        this.computeWidth(formCanvas.getDeviceDirection());
        this.computeHeight();
        if (formCanvas.getDeviceDirection() == 2) {
            Dimension dimension = formCanvas.getPanel().getSize();
            n3 = dimension.width - (n3 + n5);
            if (n == 0 || n == 1) {
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 2;
                        break;
                    }
                }
            } else {
                n = n == 2 ? 3 : 2;
            }
        }
        if (n2 == 2) {
            n7 *= -1;
        }
        switch (n) {
            case 0: {
                point.x = n3;
                point.y = n4 - this.mEdgeOffset - this.mHeight;
                switch (n2) {
                    case 1: {
                        point.x += (n5 - this.mWidth) / 2;
                        break;
                    }
                    case 2: {
                        point.x += n5 - this.mWidth;
                        break;
                    }
                }
                point.x += n7;
                break;
            }
            case 1: {
                point.x = n3;
                point.y = n4 + this.mEdgeOffset + n6;
                switch (n2) {
                    case 1: {
                        point.x += (n5 - this.mWidth) / 2;
                        break;
                    }
                    case 2: {
                        point.x += n5 - this.mWidth;
                        break;
                    }
                }
                point.x += n7;
                break;
            }
            case 3: {
                point.x = n3 + n5 + this.mEdgeOffset;
                point.y = n4;
                switch (n2) {
                    case 1: {
                        point.y += (n6 - this.mHeight) / 2;
                        break;
                    }
                    case 2: {
                        point.y += n6 - this.mHeight;
                        break;
                    }
                }
                point.y += n7;
                break;
            }
            default: {
                point.x = n3 - this.mWidth - this.mEdgeOffset;
                point.y = n4;
                switch (n2) {
                    case 1: {
                        point.y += (n6 - this.mHeight) / 2;
                        break;
                    }
                    case 2: {
                        point.y += n6 - this.mHeight;
                        break;
                    }
                }
                point.y += n7;
            }
        }
        this.mBoundingBox.x = point.x;
        this.mBoundingBox.y = point.y;
        this.mBoundingBox.width = this.mWidth;
        this.mBoundingBox.height = this.mHeight;
        this.setDirty(false);
    }

    public void damagePrompt(FormCanvas formCanvas) {
        if (this.mBoundingBox.width != 0 && this.mBoundingBox.height != 0) {
            formCanvas.getPanel().repaint(0L, this.mBoundingBox.x, this.mBoundingBox.y, this.mBoundingBox.width, this.mBoundingBox.height);
        }
        this.computeBoundingBox(formCanvas);
        if (this.mBoundingBox.width != 0 && this.mBoundingBox.height != 0) {
            formCanvas.getPanel().repaint(0L, this.mBoundingBox.x, this.mBoundingBox.y, this.mBoundingBox.width, this.mBoundingBox.height);
        }
    }

    public boolean redrawNeeded(Rectangle rectangle) {
        boolean bl;
        if (this.mFirst) {
            this.mFirst = false;
            bl = true;
        } else {
            bl = rectangle.intersects(this.mBoundingBox);
        }
        return bl;
    }

    public void drawPrompt(Graphics graphics, Device device, FormCanvas formCanvas) {
        int n;
        Point point = new Point();
        int n2 = this.mEnumVal >> 2 & 7;
        if (this.mReadingDirection == 1 || this.mReadingDirection == 0 && formCanvas.getDeviceDirection() == 2) {
            if (n2 == 0) {
                n2 = 4;
            } else if (n2 == 1) {
                n2 = 2;
            }
            n = 2;
        } else {
            n = 1;
        }
        if (this.isDirty()) {
            this.computeBoundingBox(formCanvas);
        }
        point.x = this.mBoundingBox.x;
        point.y = this.mBoundingBox.y;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        this.mColor = this.getColorNum() == 255 ? (formCanvas.getDispatcher().getApplet().hasDarkLook() ? device.getColorEntry(0) : UIManager.getLookAndFeel().getDefaults(formCanvas.getPanel().getPaintContext()).getColor(LookAndFeel.TEXT_TEXT)) : device.getColorEntry(this.getColorNum());
        ComponentItem componentItem = (ComponentItem)formCanvas.getDispatcher().getHandler(this.mItemInfo.getItemIndex());
        if (componentItem instanceof TextComponentItem && ((TextComponentItem)componentItem).hasCharCounter()) {
            ((TextComponentItem)componentItem).setLabelColor(this.mColor);
        }
        graphics.setColor(this.mColor);
        graphics.setFont(this.mFont);
        for (int i = 0; i < this.mTextVal.size(); ++i) {
            String string = StringUtils.getDisplayString((String)this.mTextVal.elementAt(i), LocaleUtils.getDefaultableLocale(device.getComponent()), n);
            int n3 = this.mFontMetrics.stringWidth(string);
            point.y += this.mFontMetrics.getHeight();
            switch (n2) {
                case 1: 
                case 4: {
                    point.x = this.mBoundingBox.x + this.mWidth - n3;
                    break;
                }
                case 3: {
                    point.x = this.mBoundingBox.x + (this.mWidth - n3) / 2;
                    break;
                }
            }
            point.y -= this.mFontMetrics.getDescent();
            GraphicUtils.drawString(graphics, string, point.x, point.y);
            Text.drawUnderlineOverstrike(graphics, string, point.x, point.y, device.getStyle(this.getFontNum()));
            point.y += this.mFontMetrics.getDescent();
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public void doDestroy() {
        this.mItemInfo = null;
        this.mBoundingBox = null;
        this.mTextVal = null;
    }
}

