/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import javax.accessibility.AccessibleContext;
import oracle.ewt.lwAWT.LWComponent;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.TListItem;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.DropDownEvent;
import oracle.forms.ui.DropDownListener;
import oracle.forms.ui.IView;
import oracle.forms.ui.VPopList;

public class PopListItem
extends ComponentItem
implements DropDownListener {
    private static int sHandlerClassId = 0;
    private int isDropDownShowing = 0;
    private boolean mItemEventOccured = false;
    private String mAccessibleDesc = null;
    private boolean mReqdFlag = false;
    protected int mOldIndex = -1;
    protected int mSavedIndex = -2;
    protected static final int INVALID_INDEX = -2;
    protected int mUserLength = -1;

    public PopListItem() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.setComponent((Component)((Object)this.getView()));
        this.getView().addListener(FocusListener.class, this);
        this.getView().addListener(ItemListener.class, this);
        this.getView().addListener(KeyListener.class, this);
        this.getView().addListener(MouseListener.class, this);
        this.getView().addListener(MouseMotionListener.class, this);
        if (!(this instanceof TListItem)) {
            this.getView().addListener(DropDownListener.class, this);
        }
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 131: {
                this.doListValue((Integer)object);
                this.mUserLength = -1;
                break;
            }
            case 329: {
                this.doAddListItem(object);
                break;
            }
            case 330: {
                this.updateIndex((Integer)object);
                this.getView().remove(object);
                break;
            }
            case 331: {
                this.updateIndex(-1);
                this.getView().removeAll();
                break;
            }
            case 204: {
                if (!this.getDispatcher().useRequiredFieldVA()) break;
                if (((Boolean)object).booleanValue()) {
                    this.getDispatcher().addElementToVAList(this.getHandlerId());
                    break;
                }
                this.getDispatcher().removeElementFromVAList(this.getHandlerId());
                break;
            }
            case 514: {
                bl = super.onUpdate(n, object);
                this.mAccessibleDesc = (String)object;
                this.appendAccessibilityDesc(false);
                this.mReqdFlag = false;
                break;
            }
            case 513: {
                this.mReqdFlag = (Boolean)object;
                this.appendAccessibilityDesc(this.mReqdFlag);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    private void appendAccessibilityDesc(boolean bl) {
        String string = this.mAccessibleDesc;
        Component component = this.getComponent();
        MessageGenerator messageGenerator = this.getApplet().getTranslatedPhraseGenerator();
        if (bl) {
            string = string + messageGenerator.getText("REQD");
        }
        if (component instanceof LWComponent) {
            AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
            accessibleContext.setAccessibleDescription(string);
            accessibleContext.setAccessibleName(string);
        }
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(FocusListener.class, this);
            this.getView().removeListener(ItemListener.class, this);
            this.getView().removeListener(KeyListener.class, this);
            this.getView().removeListener(MouseListener.class, this);
            this.getView().removeListener(MouseMotionListener.class, this);
            if (!(this instanceof TListItem)) {
                this.getView().removeListener(DropDownListener.class, this);
            }
        }
        super.onDestroy();
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.setBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mRolloverEntryPainter != null || this.mRolloverPainter != null) {
            this.clearBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Message message;
        IView iView = this.getView();
        this.mItemEventOccured = true;
        if (this.getDispatcher() == null) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        Integer n = (Integer)iView.getProperty(ID.SELECTEDINDEX);
        int n2 = n;
        if (n2 == -1) {
            this.mOldIndex = n2;
            return;
        }
        if (n2 != (this.mSavedIndex == -2 ? this.mOldIndex : this.mSavedIndex)) {
            message = new Message(this, 131, n);
            this.mOldIndex = n2;
        } else if (n2 == this.mSavedIndex && this.mOldIndex != n2) {
            message = new Message(this, 131, n);
            this.mOldIndex = n2;
        } else {
            message = new Message(this, 332, null);
        }
        this.setUserItemFromSelection();
        this.mSavedIndex = -2;
        this.mUserLength = -1;
        this.getDispatcher().onMessage(message, 0);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.isDropDownShowing()) {
            return;
        }
        if (keyEvent.isActionKey() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39)) {
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void dropDownShown(DropDownEvent dropDownEvent) {
        ++this.isDropDownShowing;
    }

    @Override
    public void dropDownHidden(DropDownEvent dropDownEvent) {
        --this.isDropDownShowing;
        if (!this.mItemEventOccured) {
            Message message = new Message(this, 332, null);
            this.getDispatcher().onMessage(message, 0);
        } else {
            this.mItemEventOccured = false;
        }
    }

    private boolean isDropDownShowing() {
        return this.isDropDownShowing != 0;
    }

    protected void doListValue(Integer n) {
        IView iView = this.getView();
        Integer n2 = (Integer)iView.getProperty(ID.COUNT);
        if (n < n2) {
            this.selectValue(n);
            Integer n3 = (Integer)iView.getProperty(ID.SELECTEDINDEX);
            this.mOldIndex = n3;
        }
    }

    protected void updateIndex(int n) {
    }

    @Override
    protected Class getDefaultClass() {
        return VPopList.class;
    }

    protected void setUserItemFromSelection() {
    }

    protected void selectValue(Integer n) {
        this.getView().setProperty(ID.SELECT, n);
    }

    private void doAddListItem(Object object) {
        Object var2_2 = null;
        Message message = (Message)object;
        int n = message.size();
        for (int i = 0; i < n; i += 2) {
            Object object2 = message.getValueAt(i);
            Object object3 = message.getValueAt(i + 1);
            if (!(object2 instanceof String)) {
                object2 = message.getValueAt(i + 1);
                object3 = message.getValueAt(i);
            }
            this.getView().add(object2, (Integer)object3);
        }
        this.getComponent().invalidate();
    }
}

