/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.PrintStream;
import java.util.Vector;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarTextItem;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;

public class MenuParametersDialog
extends CommonDialog
implements ActionListener,
TextListener {
    private static final int PARAM_MARGIN = 10;
    private static final byte CASE_UPPER = 1;
    private static final byte CASE_LOWER = 2;
    private static final byte CASE_ANY = 3;
    private static final byte NO_TARGET = -1;
    private static int sHandlerClassId = 0;
    private int mNumRows = 0;
    private boolean[] mRequired;
    private boolean[] mMustFill;
    private byte[] mCaseFold;
    private int[] mMaxlen;
    private LWLabel[] mLabels;
    private LWTextField[] mValues;
    private boolean[] mSecure;
    private Vector mTabList;
    private PushButton mOKButton = null;
    private PushButton mCancelButton = null;
    private LWContainer mPanel = null;
    private ScrollBox mScroller = null;
    private StatusBarTextItem mErrorField = null;
    private String mErrorRequired = null;
    private String mErrorMustFill = null;
    public static final String DEFAULT_MNU_PARAM_NAME = "Forms_Menu_Parameter_Dialog";

    public MenuParametersDialog() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonBar buttonBar = new ButtonBar();
        LWContainer lWContainer = new LWContainer();
        StatusBar statusBar = new StatusBar();
        super.onCreate(runform, message);
        this.mDialog = this.createDialog(runform.getFrame(), true);
        this.mDialog.setTitle("Enter Parameter Value(s)");
        this.getContent().setLayout(gridBagLayout);
        this.setResizable(true);
        this.setAutoSize(false);
        this.setAutoCenter(false);
        this.setComponent(this.mDialog);
        this.mPanel = new LWContainer();
        this.mPanel.setLayout(new GridBagLayout());
        this.mScroller = new ScrollBox(this.mPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.mScroller, gridBagConstraints);
        this.mOKButton = new PushButton("OK");
        this.mOKButton.addActionListener(this);
        this.mOKButton.addKeyListener(this);
        this.mCancelButton = new PushButton("Cancel");
        this.mCancelButton.addActionListener(this);
        this.mCancelButton.addKeyListener(this);
        buttonBar.add(this.mOKButton);
        buttonBar.add(this.mCancelButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(buttonBar, gridBagConstraints);
        lWContainer.setLayout(new GridLayout(1, 1, 16, 0));
        statusBar.setEnabled(false);
        lWContainer.add(statusBar);
        statusBar.addItem(new StatusBarTextItem("", -1, true));
        this.mErrorField = (StatusBarTextItem)statusBar.getItem(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(lWContainer, gridBagConstraints);
        this.onUpdate(message);
        this.getContent().add(this.mScroller);
        this.getContent().add(buttonBar);
        this.getContent().add(lWContainer);
        this.mOKButton.setDefault(true);
        this.setCancelButton(this.mCancelButton);
        for (n = 0; n < this.mValues.length; ++n) {
            this.mValues[n].addKeyListener(this);
            this.mValues[n].addTextListener(this);
        }
        for (n = 0; n < this.mNumRows; ++n) {
            this.setNextTab(this.mValues[n]);
        }
        this.setNextTab(this.mOKButton);
        this.setNextTab(this.mCancelButton);
        this.show();
        if (this.mNumRows == 0) {
            this.mCancelButton.requestFocus();
        }
    }

    private void setNextTab(Component component) {
        if (this.mTabList == null) {
            this.mTabList = new Vector();
        }
        this.mTabList.addElement(component);
    }

    private void moveFocus(Component component) {
        Rectangle rectangle = component.getBounds();
        Dimension dimension = this.mScroller.getViewPortSize();
        Point point = this.mScroller.getScrollPosition();
        Rectangle rectangle2 = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        if (this.getDispatcher() == null) {
            return;
        }
        if (component instanceof LWTextField && rectangle2.intersection(rectangle).isEmpty()) {
            Dimension dimension2 = this.mScroller.getContentSize();
            int n = rectangle.x;
            int n2 = rectangle.y;
            if (n > dimension2.width - dimension.width && (n = dimension2.width - dimension.width) < 0) {
                n = 0;
            }
            if (n2 > dimension2.height - dimension.height && (n2 = dimension2.height - dimension.height) < 0) {
                n2 = 0;
            }
            this.mScroller.setScrollPosition(n, n2);
        }
        component.requestFocus();
    }

    private void nextTab(Component component) {
        int n = this.mTabList.indexOf(component);
        if (++n == this.mTabList.size()) {
            n = 0;
        }
        Component component2 = (Component)this.mTabList.elementAt(n);
        this.moveFocus(component2);
    }

    private void previousTab(Component component) {
        int n = this.mTabList.indexOf(component);
        if (--n < 0) {
            n = this.mTabList.size() - 1;
        }
        Component component2 = (Component)this.mTabList.elementAt(n);
        this.moveFocus(component2);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && !(keyEvent.getSource() instanceof PushButton)) {
            this.retargetKeyEvent(this.mOKButton);
        } else if (keyEvent.getKeyCode() == 9) {
            if (keyEvent.isShiftDown()) {
                this.previousTab(keyEvent.getComponent());
            } else {
                this.nextTab(keyEvent.getComponent());
            }
            keyEvent.consume();
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        int n;
        int n2 = -1;
        int n3 = 0;
        int n4 = 3;
        boolean bl = false;
        this.mErrorField.setText("");
        for (n = 0; n < this.mNumRows; ++n) {
            if (textEvent.getSource() != this.mValues[n]) continue;
            n2 = n;
            n3 = this.mMaxlen[n2];
            n4 = this.mCaseFold[n2];
            break;
        }
        if (n2 == -1) {
            return;
        }
        String string = this.mValues[n2].getText();
        if (n4 == 1) {
            if (!(string = string.toUpperCase()).equals(this.mValues[n2].getText())) {
                bl = true;
            }
        } else if (n4 == 2 && !(string = string.toLowerCase()).equals(this.mValues[n2].getText())) {
            bl = true;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
            bl = true;
            Toolkit.getDefaultToolkit().beep();
        }
        if (bl) {
            n = this.mValues[n2].getCaretPosition();
            if (n > string.length()) {
                n = string.length();
            }
            this.mValues[n2].setText(string);
            this.mValues[n2].setCaretPosition(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            if (this.getDispatcher() == null) {
                return;
            }
            if (actionEvent.getSource() == this.mCancelButton) {
                this.disposeDialog();
                Message message = new Message(this, 105, null);
                this.getHandler().getDispatcher().onMessage(message, 0);
                return;
            }
            if (actionEvent.getSource() == this.mOKButton) {
                String[] stringArray = new String[this.mNumRows];
                for (int i = 0; i < this.mNumRows; ++i) {
                    stringArray[i] = new String(this.mValues[i].getText());
                    if (this.mRequired[i] && stringArray[i].length() == 0) {
                        if (this.mErrorRequired != null) {
                            this.mErrorField.setText(this.mErrorRequired);
                        }
                        this.moveFocus(this.mValues[i]);
                    } else {
                        if (!this.mMustFill[i] || this.mMaxlen[i] == stringArray[i].length()) continue;
                        if (this.mErrorMustFill != null) {
                            this.mErrorField.setText(this.mErrorMustFill);
                        }
                        this.moveFocus(this.mValues[i]);
                    }
                    break block8;
                }
                this.disposeDialog();
                Message message = new Message(this.getHandler(), 171, stringArray);
                this.getHandler().getDispatcher().onMessage(message, 0);
            }
        }
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 473: {
                int n2 = (Integer)object;
                this.mRequired = new boolean[n2];
                this.mMustFill = new boolean[n2];
                this.mCaseFold = new byte[n2];
                this.mMaxlen = new int[n2];
                this.mLabels = new LWLabel[n2];
                this.mValues = new LWTextField[n2];
                this.mSecure = new boolean[n2];
                for (int i = 0; i < n2; ++i) {
                    this.mCaseFold[i] = 3;
                }
                break;
            }
            case 119: {
                String string = this.processLabel((String)object, this.mOKButton);
                this.mOKButton.setLabel(string);
                break;
            }
            case 106: {
                String string = this.processLabel((String)object, this.mCancelButton);
                this.mCancelButton.setLabel(string);
                break;
            }
            case 474: {
                this.mErrorRequired = (String)object;
                break;
            }
            case 475: {
                this.mErrorMustFill = (String)object;
                break;
            }
            case 197: {
                this.mSecure[this.mNumRows] = (Boolean)object;
                break;
            }
            case 472: {
                this.mRequired[this.mNumRows] = (Boolean)object;
                break;
            }
            case 471: {
                this.mMustFill[this.mNumRows] = (Boolean)object;
                break;
            }
            case 117: {
                this.mMaxlen[this.mNumRows] = (Integer)object;
                break;
            }
            case 199: {
                this.mCaseFold[this.mNumRows] = (Byte)object;
                break;
            }
            case 122: {
                String[] stringArray = (String[])object;
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                GridBagLayout gridBagLayout = (GridBagLayout)this.mPanel.getLayout();
                this.mLabels[this.mNumRows] = new LWLabel(stringArray[0]);
                this.mValues[this.mNumRows] = new LWTextField(stringArray[1], this.mMaxlen[this.mNumRows]);
                if (this.mSecure[this.mNumRows]) {
                    DisplayStringFilter displayStringFilter = MenuParametersDialog.getPasswordFilter();
                    this.mValues[this.mNumRows].setDisplayStringFilter(displayStringFilter);
                }
                gridBagConstraints.insets.top = 10;
                gridBagConstraints.insets.bottom = 10;
                gridBagConstraints.insets.left = 10;
                gridBagConstraints.insets.right = 10;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.mLabels[this.mNumRows], gridBagConstraints);
                gridBagConstraints.insets.left = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(this.mValues[this.mNumRows], gridBagConstraints);
                this.mPanel.add(this.mLabels[this.mNumRows]);
                this.mPanel.add(this.mValues[this.mNumRows]);
                ++this.mNumRows;
                break;
            }
            case 129: {
                this.mDialog.setTitle((String)object);
                if (!this.getDispatcher().getRecordNames()) break;
                super.onUpdate(539, DEFAULT_MNU_PARAM_NAME);
                break;
            }
            default: {
                if (super.onUpdate(n, object)) break;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
        this.mScroller = null;
        this.mPanel = null;
        this.mCancelButton = null;
        this.mOKButton = null;
        this.mErrorRequired = null;
        this.mErrorMustFill = null;
        this.mRequired = null;
        this.mMustFill = null;
        this.mSecure = null;
        this.mCaseFold = null;
        this.mMaxlen = null;
        this.mLabels = null;
        this.mValues = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }
}

