/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.util.ClipboardProxy;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComboBoxItem;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.EndSubmenu;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.FormWindow;
import oracle.forms.handler.MenuItemInfo;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.handler.TextFieldItem;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.SmartBar;
import oracle.forms.ui.VTextArea;

public class MenuInfo
extends ComponentItem {
    private Vector mItemList;
    private Vector mHBarItemList;
    private Vector mVBarItemList;
    private Vector mUIMenus;
    private Hashtable mIDs;
    private Hashtable mNewIDs;
    private Hashtable mDupIDs;
    private Hashtable mAccelerators;
    private MenuItemInfo mLastMenuItem;
    private int mNextID;
    private static int sHandlerClassId = 0;
    private Point mPopupXY = new Point(0, 0);
    private boolean mHasHBar = false;
    private boolean mHasVBar = false;
    private boolean mNoSmartBar = false;
    private static Hashtable mIcons = new Hashtable(50);
    private static Hashtable mSBIcons = new Hashtable(50);
    public static final int MNID_HELP = 32769;
    public static final int MNID_ABOUT = 32770;
    public static final int MNID_CUT = 32771;
    public static final int MNID_COPY = 32772;
    public static final int MNID_PASTE = 32773;
    public static final int MNID_CLEAR = 32774;
    public static final int MNID_QUIT = 32779;
    public static final int MNID_SETUP = 32781;
    public static final int MNID_UNDO = 32784;
    public static final int FIRST_TK_MNID = 32769;
    public static final int LAST_TK_MNID = 32786;
    protected static final int LASTCRITERIA = 76;
    private static final int NEW_ID_BASE = 500;

    protected static Hashtable getIcons() {
        return mIcons;
    }

    public static Hashtable getSBIcons() {
        return mSBIcons;
    }

    public MenuInfo() {
        this.setHandler(this);
        this.mItemList = new Vector();
        this.mUIMenus = new Vector();
        this.mIDs = new Hashtable();
        this.mNewIDs = new Hashtable();
        this.mDupIDs = new Hashtable();
        this.mAccelerators = new Hashtable();
        this.mNextID = 500;
    }

    public void putHashItem(Integer n, MenuItemInfo menuItemInfo) {
        if (n != null && n != 0) {
            this.mIDs.put(n, menuItemInfo);
        }
    }

    public MenuItemInfo getHashItem(int n) {
        MenuItemInfo menuItemInfo = null;
        Integer n2 = n;
        menuItemInfo = (MenuItemInfo)this.mIDs.get(n2);
        return menuItemInfo;
    }

    public int getOrigMenuID(int n) {
        Integer n2 = n;
        Integer n3 = (Integer)this.mNewIDs.get(n2);
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    public int getDupMenuID(int n) {
        Integer n2 = n;
        Integer n3 = (Integer)this.mDupIDs.get(n2);
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    public Vector getItemList() {
        return this.mItemList;
    }

    public Vector getHBarItemList() {
        return this.mHBarItemList;
    }

    public Vector getVBarItemList() {
        return this.mVBarItemList;
    }

    public boolean hasHBar() {
        if (this.mNoSmartBar) {
            return false;
        }
        return this.mHasHBar;
    }

    public boolean hasVBar() {
        return this.mHasVBar;
    }

    public Hashtable getAccelerators() {
        return this.mAccelerators;
    }

    public FormMenu createUIMenu(MessageHandler messageHandler, LWMenuBar lWMenuBar) {
        return this.createUIMenu(messageHandler, lWMenuBar, true);
    }

    public FormMenu createUIMenu(MessageHandler messageHandler, LWMenuBar lWMenuBar, boolean bl) {
        FormMenu formMenu = new FormMenu(this, messageHandler, this.getDispatcher(), lWMenuBar);
        if (formMenu == null) {
            if (messageHandler instanceof FormWindow) {
                throw new Error("Unable to create a menu for " + messageHandler.toString() + ".");
            }
            throw new Error("Unable to create a popup menu.");
        }
        if (messageHandler != null) {
            this.initClipboardMenuItems();
        }
        if (bl) {
            this.addUIMenu(formMenu);
        }
        return formMenu;
    }

    public SmartBar createSmartBar(MessageHandler messageHandler, ToolBar toolBar, boolean bl) {
        if (bl && !this.hasHBar() || !bl && !this.hasVBar()) {
            throw new Error("Attempting to build SmartBar with no contents.");
        }
        SmartBar smartBar = new SmartBar(this, bl, messageHandler, this.getDispatcher(), toolBar);
        if (smartBar == null) {
            throw new Error("Unable to create a SmartBar for " + messageHandler.toString() + ".");
        }
        this.initClipboardMenuItems();
        this.addUIMenu(smartBar);
        return smartBar;
    }

    private void addUIMenu(Object object) {
        if (!this.mUIMenus.contains(object)) {
            this.mUIMenus.addElement(object);
        }
    }

    public void removeFormMenu(FormMenu formMenu) {
        if (this.mUIMenus != null) {
            this.mUIMenus.removeElement(formMenu);
        }
    }

    public void removeSmartBar(SmartBar smartBar) {
        if (this.mUIMenus != null) {
            this.mUIMenus.removeElement(smartBar);
        }
    }

    private void initClipboardMenuItems() {
        ComponentItem componentItem = this.getDispatcher().getFocusOwner();
        LWCommonText lWCommonText = null;
        if (componentItem != null && componentItem.getView() instanceof LWComponent) {
            if (componentItem instanceof TextFieldItem) {
                lWCommonText = (LWTextField)((Object)componentItem.getView());
            } else if (componentItem instanceof TextAreaItem) {
                lWCommonText = (LWTextArea)((VTextArea)componentItem.getView()).getContent();
            } else if (componentItem instanceof ComboBoxItem) {
                lWCommonText = ((ComboBox)((Object)componentItem.getView())).getLWTextField();
            }
        }
        if (lWCommonText != null) {
            Clipboard clipboard = ClipboardProxy.getSystemClipboard();
            try {
                boolean bl = this.getApplet().isClipboardValidationDisabled();
                if (!bl) {
                    Transferable transferable = clipboard.getContents(lWCommonText);
                    if (transferable != null && ((LWTextComponent)lWCommonText).isOKToPaste(transferable) && lWCommonText.isEditable()) {
                        this.doEnablePaste(true);
                    }
                } else if (lWCommonText.isEditable()) {
                    this.doEnablePaste(true);
                }
            }
            catch (IllegalStateException illegalStateException) {
                Main main2 = this.getApplet();
                ClipboardErrorUtils.displayMessage(main2.getErrorMessageGenerator(), main2.getTranslatedPhraseGenerator(), lWCommonText.getParent(), main2.isAlertDialogAllowed());
            }
            if (lWCommonText.getSelectionStart() != lWCommonText.getSelectionEnd()) {
                this.doEnableCopy(true, lWCommonText.isEditable());
            }
        }
    }

    public void setState(int n, boolean bl) {
        this.setState((Integer)n, bl);
    }

    public void setState(Integer n, boolean bl) {
        MenuItemInfo menuItemInfo = (MenuItemInfo)this.mIDs.get(n);
        menuItemInfo.setState(bl);
        if (menuItemInfo.getType() != 2 || bl) {
            for (int i = 0; i < this.mUIMenus.size(); ++i) {
                Object e = this.mUIMenus.elementAt(i);
                if (e instanceof FormMenu) {
                    ((FormMenu)e).setState(n, bl);
                    continue;
                }
                ((SmartBar)e).setState(n, bl);
            }
        }
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.onUpdate(message);
        if (this.hasHBar()) {
            this.buildBarVector(true);
        }
        if (this.hasVBar()) {
            this.buildBarVector(false);
        }
    }

    @Override
    public synchronized void onUpdate(Message message) {
        int n = message.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = message.getPropertyAt(i);
            if (!this.onUpdate(n2, object = message.getValueAt(i))) continue;
        }
    }

    @Override
    public synchronized void onDestroy() {
        int n;
        if (this.mItemList != null) {
            this.mItemList.removeAllElements();
        }
        if (this.mUIMenus != null && this.mUIMenus.size() != 0) {
            n = this.mUIMenus.size();
            for (int i = n - 1; i >= 0; --i) {
                Object e = this.mUIMenus.elementAt(i);
                if (e instanceof FormMenu) {
                    ((FormMenu)e).destroy();
                    continue;
                }
                if (!(e instanceof SmartBar)) continue;
                ((SmartBar)e).destroy();
            }
        }
        if (this.mIDs != null && this.mIDs.size() != 0) {
            n = this.mIDs.size();
            for (int i = 0; i < n; ++i) {
                MenuItemInfo menuItemInfo = this.getHashItem(i);
                if (menuItemInfo == null) continue;
                menuItemInfo.setParent(null);
            }
        }
        super.onDestroy();
        this.mItemList = null;
        this.mUIMenus = null;
        this.mIDs = null;
        this.mNewIDs = null;
        this.mDupIDs = null;
        this.mAccelerators = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = false;
        Object var4_4 = null;
        switch (n) {
            case 354: {
                Integer n2;
                Integer n3 = (Integer)object;
                int n4 = n3;
                if (this.getHashItem(n4) != null) {
                    if (n4 >= 32769 && n4 <= 32786) {
                        throw new Error("MenuInfo.onUpdate(): MENUITEM Illegal duplicate menu ID: " + object);
                    }
                    n4 = this.mNextID++;
                    n2 = n4;
                    this.mNewIDs.put(n2, n3);
                    if (this.getDupMenuID(n3) == 0) {
                        this.mDupIDs.put(n3, n2);
                    }
                } else {
                    n2 = n3;
                }
                this.mLastMenuItem = n4 == 32771 || n4 == 32772 || n4 == 32774 || n4 == 32773 ? new MenuItemInfo(true, this.getDispatcher()) : new MenuItemInfo(false, this.getDispatcher());
                this.mItemList.addElement(this.mLastMenuItem);
                this.mLastMenuItem.setID(n4);
                this.putHashItem(n2, this.mLastMenuItem);
                bl = true;
                break;
            }
            case 366: {
                this.mItemList.addElement(new EndSubmenu());
                bl = true;
                break;
            }
            case 144: {
                int n5 = this.mLastMenuItem.getID();
                if (n5 != 32771 && n5 != 32772 && n5 != 32774 && n5 != 32773) {
                    this.mLastMenuItem.setEnabled((Boolean)object);
                }
                bl = true;
                break;
            }
            case 149: {
                this.mLastMenuItem.setFont((Integer)object);
                bl = true;
                break;
            }
            case 358: {
                if (this.getDispatcher().getRecordNames()) {
                    String string = new String(((String)object).substring(0, ((String)object).indexOf(32)));
                    this.mLastMenuItem.setName(string);
                    string = ((String)object).substring(((String)object).indexOf(32) + 1);
                    this.mLastMenuItem.setHelpText(string);
                } else {
                    this.mLastMenuItem.setHelpText((String)object);
                }
                bl = true;
                break;
            }
            case 359: {
                this.mLastMenuItem.setHidden((Boolean)object);
                bl = true;
                break;
            }
            case 360: {
                Image image = null;
                Image image2 = (Image)MenuInfo.getIcons().get((String)object);
                if (image2 != null) {
                    image = (Image)MenuInfo.getSBIcons().get((String)object);
                } else {
                    image2 = this.getApplet().getDefaultImage((String)object);
                    MenuInfo.getIcons().put(object, image2);
                }
                this.mLastMenuItem.setImage(image2);
                this.mLastMenuItem.setIcon((String)object);
                if (image != null) {
                    this.mLastMenuItem.setSBImage(image);
                }
                bl = true;
                break;
            }
            case 361: {
                Integer n6;
                Integer n7 = (Integer)object;
                int n8 = n7;
                if (this.getHashItem(n8) != null) {
                    n8 = this.mNextID++;
                    n6 = n8;
                    this.mNewIDs.put(n6, n7);
                    if (this.getDupMenuID(n7) == 0) {
                        this.mDupIDs.put(n7, n6);
                    }
                } else {
                    n6 = n7;
                }
                this.mLastMenuItem.setID(n8);
                this.putHashItem(n6, this.mLastMenuItem);
                bl = true;
                break;
            }
            case 116: {
                this.mLastMenuItem.setLabel((String)object);
                bl = true;
                break;
            }
            case 356: {
                KeyStroke keyStroke = this.readAccelerator(object);
                this.mLastMenuItem.setAccelerator(keyStroke);
                if (keyStroke != null) {
                    this.mAccelerators.put(keyStroke, this.mLastMenuItem.getID());
                }
                bl = true;
                break;
            }
            case 140: {
                this.mLastMenuItem.setMnemonic((Byte)object);
                bl = true;
                break;
            }
            case 551: {
                this.mLastMenuItem.setMnemonic(((String)object).charAt(0));
                bl = true;
                break;
            }
            case 362: {
                this.mLastMenuItem.setStartGroup((Boolean)object);
                bl = true;
                break;
            }
            case 363: {
                this.mLastMenuItem.setState((Boolean)object);
                bl = true;
                break;
            }
            case 364: {
                this.mLastMenuItem.setSubmenu((Boolean)object);
                bl = true;
                break;
            }
            case 365: {
                this.mLastMenuItem.setTearoff((Boolean)object);
                bl = true;
                break;
            }
            case 130: {
                this.mLastMenuItem.setType((short)((Integer)object).intValue());
                bl = true;
                break;
            }
            case 371: {
                this.mLastMenuItem.setFlags((Byte)object);
                if (!this.mHasHBar && this.mLastMenuItem.isOnHBar()) {
                    this.mHasHBar = true;
                }
                if (!this.mHasVBar && this.mLastMenuItem.isOnVBar()) {
                    this.mHasVBar = true;
                }
                bl = true;
                break;
            }
            case 367: {
                MenuInfo menuInfo = (MenuInfo)this.getDispatcher().getHandler((Integer)object);
                MenuItemInfo menuItemInfo = (MenuItemInfo)menuInfo.mItemList.firstElement();
                int n9 = menuItemInfo.getID();
                MenuItemInfo menuItemInfo2 = this.getHashItem(n9);
                if (menuItemInfo2 == null) break;
                this.modifyItem(menuItemInfo2, menuItemInfo);
                int n10 = this.getDupMenuID(n9);
                if (n10 != 0 && (menuItemInfo2 = this.getHashItem(n10)) != null) {
                    this.modifyItem(menuItemInfo2, menuItemInfo);
                }
                bl = true;
                break;
            }
            case 369: {
                this.mPopupXY = (Point)object;
                bl = true;
                break;
            }
            case 368: {
                this.showPopup((Integer)object);
                this.mPopupXY = new Point(0, 0);
                bl = true;
                break;
            }
            case 370: {
                this.createUIMenu(null, null, true);
                bl = true;
                break;
            }
            case 372: {
                this.mNoSmartBar = true;
                bl = true;
            }
        }
        return bl;
    }

    private KeyStroke readAccelerator(Object object) {
        Message message = (Message)object;
        Integer n = null;
        Integer n2 = null;
        KeyStroke keyStroke = null;
        Object var6_6 = null;
        int n3 = message.size();
        block4: for (int i = 0; i < n3; ++i) {
            int n4 = message.getPropertyAt(i);
            Object object2 = message.getValueAt(i);
            switch (n4) {
                case 355: {
                    n = (Integer)object2;
                    continue block4;
                }
                case 357: {
                    n2 = (Integer)object2;
                }
            }
        }
        if (n != null) {
            keyStroke = n2 == null ? new KeyStroke(n, 0) : new KeyStroke(n, (int)n2);
        }
        return keyStroke;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyItem(MenuItemInfo menuItemInfo, MenuItemInfo menuItemInfo2) {
        Object e;
        boolean bl = false;
        Image image = null;
        short s = menuItemInfo2.getMask();
        if ((s & 4) != 0) {
            if (menuItemInfo.isHidden() != menuItemInfo2.isHidden()) {
                menuItemInfo.setHidden(menuItemInfo2.isHidden());
                bl = true;
            } else {
                s = (short)(s & 0xFFFFFFFB);
            }
        } else if ((s & 0x10) != 0) {
            menuItemInfo.setImage(menuItemInfo2.getImage());
            menuItemInfo.setIcon(menuItemInfo2.getIcon());
            image = menuItemInfo2.getSBImage();
            if (image != null) {
                menuItemInfo.setSBImage(image);
            }
            bl = true;
        } else if ((s & 1) != 0) {
            menuItemInfo.setLabel(menuItemInfo2.getLabel());
            menuItemInfo.setMnemonic(menuItemInfo2.getMnemonic());
            bl = true;
        } else if ((s & 8) != 0) {
            menuItemInfo.setState(menuItemInfo2.getState());
            if (menuItemInfo.getState() || menuItemInfo.getType() != 2) {
                bl = true;
            }
        } else if ((s & 2) != 0) {
            menuItemInfo.setEnabled(menuItemInfo2.isEnabled());
            bl = true;
        }
        if (!bl) return;
        Integer n = menuItemInfo.getID();
        int n2 = this.mUIMenus.size();
        FormMenu formMenu = null;
        SmartBar smartBar = null;
        boolean bl2 = false;
        if ((s & 4) != 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                e = this.mUIMenus.elementAt(i);
                if (!(e instanceof FormMenu)) continue;
                formMenu = (FormMenu)e;
                MessageHandler messageHandler = formMenu.getRecipient();
                Object object = formMenu.getTopMenu();
                if (!(object instanceof LWMenuBar)) {
                    object = null;
                }
                FormMenu formMenu2 = this.createUIMenu(messageHandler, (LWMenuBar)object);
                if (messageHandler instanceof FormWindow) {
                    ((FormWindow)messageHandler).setMenu(formMenu2);
                    continue;
                }
                this.mUIMenus.removeElementAt(i);
            }
            bl2 = true;
        }
        if (bl2 && !this.hasHBar() && !this.hasVBar()) return;
        for (int i = 0; i < n2; ++i) {
            boolean bl3;
            e = this.mUIMenus.elementAt(i);
            if (e instanceof FormMenu) {
                if (bl2) continue;
                formMenu = (FormMenu)e;
                bl3 = true;
            } else {
                smartBar = (SmartBar)e;
                bl3 = false;
            }
            if ((s & 2) != 0) {
                if (bl3) {
                    formMenu.setEnabled(n, menuItemInfo.isEnabled());
                } else {
                    smartBar.setEnabled(n, menuItemInfo.isEnabled());
                }
            }
            if ((s & 4) != 0 && !bl3) {
                smartBar.setHidden(n, menuItemInfo.isHidden());
            }
            if ((s & 0x10) != 0) {
                if (bl3) {
                    if (menuItemInfo.isIconUsedInMenu()) {
                        formMenu.setImage(n, menuItemInfo.getImage());
                    }
                } else if (image != null) {
                    smartBar.setIcon(n, image);
                } else {
                    smartBar.setIcon(n, menuItemInfo);
                    image = menuItemInfo.getSBImage();
                }
            }
            if ((s & 1) != 0 && bl3) {
                formMenu.setLabel(n, menuItemInfo.getLabel());
                formMenu.setMnemonic(n, menuItemInfo.getMnemonic());
            }
            if ((s & 8) == 0) continue;
            if (bl3) {
                formMenu.setState(n, menuItemInfo.getState());
                continue;
            }
            smartBar.setState(n, menuItemInfo.getState());
        }
    }

    private void doEnableSpecial(int n, boolean bl) {
        MenuItemInfo menuItemInfo = this.getHashItem(n);
        if (menuItemInfo != null) {
            MenuItemInfo menuItemInfo2 = new MenuItemInfo(true, this.getDispatcher());
            menuItemInfo2.setID(n);
            menuItemInfo2.setEnabled(bl);
            this.modifyItem(menuItemInfo, menuItemInfo2);
        }
    }

    public void doEnablePaste(boolean bl) {
        this.doEnableSpecial(32773, bl);
    }

    public void doEnableCopy(boolean bl, boolean bl2) {
        this.doEnableSpecial(32772, bl);
        if (bl) {
            this.doEnableSpecial(32771, bl2);
            this.doEnableSpecial(32774, bl2);
        } else {
            this.doEnableSpecial(32771, bl);
            this.doEnableSpecial(32774, bl);
        }
    }

    private void showPopup(int n) {
        MessageHandler messageHandler = this.getHandler().getDispatcher().getHandler(n);
        if (messageHandler instanceof ComponentItem) {
            for (int i = 0; i < this.mUIMenus.size(); ++i) {
                Object e = this.mUIMenus.elementAt(i);
                if (!(e instanceof FormMenu) || !(((FormMenu)e).getTopMenu() instanceof LWPopupMenu)) continue;
                ComponentItem componentItem = this.getDispatcher().getFocusOwner();
                if ((componentItem instanceof TextComponentItem || componentItem instanceof ComboBoxItem) && componentItem.getView() instanceof LWComponent) {
                    LWCommonText lWCommonText = null;
                    lWCommonText = componentItem instanceof TextAreaItem ? (LWTextArea)((VTextArea)componentItem.getView()).getContent() : (componentItem instanceof TextFieldItem ? (LWTextField)((Object)componentItem.getView()) : ((ComboBox)((Object)componentItem.getView())).getLWTextField());
                    if (lWCommonText != null) {
                        Clipboard clipboard = ClipboardProxy.getSystemClipboard();
                        boolean bl = this.getApplet().isClipboardValidationDisabled();
                        if (!bl) {
                            Transferable transferable = clipboard.getContents(lWCommonText);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            if (transferable != null && ((LWTextComponent)lWCommonText).isOKToPaste(transferable) && lWCommonText.isEditable()) {
                                bl2 = true;
                            }
                            if (lWCommonText.getSelectionStart() != lWCommonText.getSelectionEnd()) {
                                bl3 = true;
                            }
                            this.doEnablePaste(bl2);
                            this.doEnableCopy(bl3, lWCommonText.isEditable());
                        } else {
                            boolean bl4 = false;
                            boolean bl5 = false;
                            if (lWCommonText.isEditable()) {
                                bl4 = true;
                            }
                            if (lWCommonText.getSelectionStart() != lWCommonText.getSelectionEnd()) {
                                bl5 = true;
                            }
                            this.doEnablePaste(bl4);
                            this.doEnableCopy(bl5, lWCommonText.isEditable());
                        }
                    }
                }
                ((FormMenu)e).show(messageHandler, this.mPopupXY.x, this.mPopupXY.y);
                break;
            }
        }
    }

    private void buildBarVector(boolean bl) {
        Vector vector;
        if (bl) {
            this.mHBarItemList = new Vector();
            vector = this.mHBarItemList;
        } else {
            this.mVBarItemList = new Vector();
            vector = this.mVBarItemList;
        }
        int n = this.mItemList.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.mItemList.elementAt(i);
            if (e instanceof EndSubmenu) {
                vector.addElement(e);
                continue;
            }
            MenuItemInfo menuItemInfo = (MenuItemInfo)e;
            short s = menuItemInfo.getType();
            if (s == 0 && menuItemInfo.hasSubmenu()) {
                vector.addElement(e);
                continue;
            }
            if (s == 2) {
                int n2;
                boolean bl2 = false;
                if (bl && menuItemInfo.isOnHBar() || !bl && menuItemInfo.isOnVBar()) {
                    bl2 = true;
                }
                for (n2 = i + 1; n2 < n && !((e = this.mItemList.elementAt(n2)) instanceof EndSubmenu) && (menuItemInfo = (MenuItemInfo)e).getType() == 2 && !menuItemInfo.isStartGroup(); ++n2) {
                    if ((!bl || !menuItemInfo.isOnHBar()) && (bl || !menuItemInfo.isOnVBar())) continue;
                    bl2 = true;
                }
                if (bl2) {
                    while (i < n2) {
                        vector.addElement(this.mItemList.elementAt(i));
                        ++i;
                    }
                }
                i = n2 - 1;
                continue;
            }
            if ((!bl || !menuItemInfo.isOnHBar()) && (bl || !menuItemInfo.isOnVBar())) continue;
            vector.addElement(e);
        }
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public void listInfo(PrintStream printStream, String string, FormMenu formMenu) {
    }
}

