/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.accessibility.AccessibleContext;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.ListValuesData;
import oracle.forms.handler.LongLabel;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.IView;
import oracle.forms.ui.ListView;

public class ListValuesDialog
extends CommonDialog
implements ActionListener,
ComponentListener,
TextListener {
    private static final int UNDEFINED = -1;
    private static int sHandlerClassId = 0;
    private GridBagLayout mDialogLayout = new GridBagLayout();
    private LWContainer mLongListPanel;
    private LongLabel mLongLabel;
    private String mLongListLabelString;
    private LWLabel mFindLabel;
    private LWTextField mFindField;
    private ListView mTable;
    private ScrollBox mTableScroller;
    private PushButton mFindButton;
    private PushButton mOKButton;
    private PushButton mCancelButton;
    private boolean mAutosizeCols = false;
    private boolean mLongList = false;
    private int mUpdateRowStart;
    private int mUpdateRowNumRows = 0;
    private int mWaitonInteger = 0;
    private FontMetrics mFontMetrics = null;
    private ListValuesData mListData;
    private boolean mAutoPosition = true;
    private boolean mSelectionSent;
    private boolean mFocusSet;
    private boolean mFindButtonPressed = false;
    private boolean mCancelLllMode = false;
    private String mFindButtonString;
    private String mStopQueryString;
    public static final String DEFAULT_LOV_DLG_NAME = "Forms_LOV_Dialog";

    public ListValuesDialog() {
        this.setHandler(this);
        this.mListData = new ListValuesData(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
        if (actionEvent.getSource() == this.mFindButton) {
            if (this.mFindButton.isEnabled()) {
                if (this.isCancelLllMode()) {
                    this.mListData.setQueryCanceled(true);
                    this.setCancelLllMode(false);
                    Message message = new Message(this, 105, null);
                    this.getDispatcher().onMessage(message, 0);
                    return;
                }
                if (!this.mFindButtonPressed) {
                    this.mFindButtonPressed = true;
                    this.appendAccessibilityDesc(this.mFindField);
                }
                this.doLOVFind();
            }
        } else if (actionEvent.getSource() == this.mCancelButton) {
            if (this.isCancelLllMode()) {
                this.mListData.setQueryCanceled(true);
                this.mOKButton.setEnabled(true);
                this.setCancelLllMode(false);
                Message message = new Message(this, 105, null);
                this.getDispatcher().onMessage(message, 0);
                return;
            }
            this.mListData.stopFetching(true);
            this.disposeDialog();
            this.sendCancelDialogEvent();
        } else if (actionEvent.getSource() == this.mOKButton && !this.isLongList()) {
            this.doLOVSelect();
        }
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        Object object = keyEvent.getSource();
        if (n == 10) {
            if (this.mDialog.isReshaping()) {
                super.keyPressedImpl(keyEvent);
                return;
            }
            if (object == this.mFindField) {
                if (this.isLongList() && !this.mFindButtonPressed) {
                    this.mFindButtonPressed = true;
                    this.appendAccessibilityDesc(this.mFindField);
                }
                if (this.mFindButton.isEnabled()) {
                    this.doLOVFind();
                }
                keyEvent.consume();
            } else if (!(object instanceof PushButton)) {
                this.retargetKeyEvent(this.mOKButton);
            }
        } else if (object == this.getTable()) {
            if (!(this.isLongList() || n != 8 && n != 127)) {
                String string = this.mDialog.getTitle();
                this.mDialog.setTitle(string + " (" + this.getDispatcher().getWorkingMsg() + ")");
                Message message = new Message(this, 453, null);
                this.getDispatcher().onMessage(message, 0);
                this.mDialog.setTitle(string);
            } else if (keyEvent.getKeyChar() != '\t' && keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\r' && !keyEvent.isAltDown() && n != 37 && n != 39 && n != 38 && n != 40 && n != 36 && n != 35 && n != 34 && n != 33 && !this.isDeadKey(n)) {
                keyEvent.consume();
            }
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyTypedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() != '\t' && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\r' && !this.isLongList() && keyEvent.getSource() == this.getTable()) {
            Object object;
            String string = this.mDialog.getTitle();
            this.mDialog.setTitle(string + " (" + this.getDispatcher().getWorkingMsg() + ")");
            int n = 0;
            String string2 = this.getDispatcher().getServerCharset();
            if (string2 != null) {
                try {
                    object = Character.valueOf(keyEvent.getKeyChar()).toString().getBytes(string2);
                    for (int i = 0; i < ((byte[])object).length; ++i) {
                        n = object[i] < 0 ? (n << 8) + (256 + object[i]) : (n << 8) + object[i];
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            object = new Message(this, 452, new Point(n != 0 ? n : keyEvent.getKeyChar(), InputEventUtils.getMods(keyEvent)));
            this.getDispatcher().onMessage((Message)object, 0);
            if (this.mDialog == null) {
                return;
            }
            this.mDialog.setTitle(string);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
        if (mouseEvent.getSource() == this.getTable() && mouseEvent.getClickCount() > 1 && !this.isLongList()) {
            this.doLOVSelect();
        }
        super.mouseClicked(mouseEvent);
    }

    protected void doLOVSelect() {
        int n = this.getTable().getSelectedRow();
        if (n >= 0 && n < this.mListData.getRowCount()) {
            this.mListData.stopFetching(true);
            this.disposeDialog();
            this.sendLOVSelectionEvent(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void doLOVFind() {
        String string = this.mDialog.getTitle();
        this.mListData.clearCache();
        this.mListData.setQueryCanceled(false);
        this.mDialog.setTitle(string + " (" + this.getDispatcher().getWorkingMsg() + ")");
        if (!this.mFocusSet) {
            this.initFocus();
        }
        this.mFocusSet = false;
        Message message = new Message(this, 454, this.mFindField.getText());
        this.getHandler().getDispatcher().onMessage(message, 0);
        if (this.mDialog != null) {
            this.mDialog.setTitle(string);
        }
        if (!this.isCancelLllMode()) {
            this.mFindButton.setEnabled(false);
        }
    }

    protected void sendLOVSelectionEvent(int n) {
        if (!this.mSelectionSent) {
            this.mSelectionSent = true;
            Message message = new Message(this, 450, (Object)(n + 1));
            this.getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        int n = message.size();
        LWContainer lWContainer = new LWContainer();
        ButtonBar buttonBar = new ButtonBar();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Object var10_8 = null;
        super.onCreate(runform, message);
        this.mDialog = this.createDialog(runform.getFrame(), true);
        this.mDialog.addComponentListener(this);
        this.getContent().setLayout(this.mDialogLayout);
        this.setResizable(true);
        this.setAutoSize(false);
        this.setAutoCenter(false);
        this.setComponent(this.mDialog);
        this.mLongListPanel = new LWContainer();
        this.mTable = new ListView(this.mListData, this.mListData, runform);
        this.mTable.addKeyListener(this);
        this.mTable.addMouseListener(this);
        this.mTable.setNullText(".....");
        this.mTableScroller = new ScrollBox(this.mTable, 0, 0);
        this.mTable.setSelectedRow(0);
        this.mTable.setFocusedRow(0);
        this.mFindLabel = new LWLabel();
        this.mFindField = new LWTextField();
        this.mFindField.addKeyListener(this);
        this.mFindField.addTextListener(this);
        this.mFindButton = new PushButton("x");
        this.mFindButton.addActionListener(this);
        this.mFindButton.addKeyListener(this);
        this.mOKButton = new PushButton("x");
        this.mOKButton.addActionListener(this);
        this.mOKButton.addKeyListener(this);
        this.mCancelButton = new PushButton("x");
        this.mCancelButton.addActionListener(this);
        this.mCancelButton.addKeyListener(this);
        block12: for (int i = 0; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            Object object = message.getValueAt(i);
            switch (n2) {
                case 129: {
                    this.mDialog.setTitle((String)object);
                    if (!this.getDispatcher().getRecordNames()) continue block12;
                    this.mDialog.setName(DEFAULT_LOV_DLG_NAME);
                    continue block12;
                }
                case 112: {
                    String string = this.processLabel((String)object, this.mFindButton);
                    this.mFindLabel.setText(string);
                    this.mFindButton.setLabel(string);
                    this.mFindButtonString = string;
                    continue block12;
                }
                case 534: {
                    String string;
                    this.mStopQueryString = string = (String)object;
                    char c = Character.toUpperCase(this.mCancelButton.getMnemonicChar());
                    char c2 = Character.toUpperCase(this.mFindButton.getMnemonicChar());
                    char c3 = Character.toUpperCase(this.mOKButton.getMnemonicChar());
                    for (int j = 0; j < string.length(); ++j) {
                        char c4 = Character.toUpperCase(string.charAt(j));
                        if (c4 == c || c4 == c2 || c4 == c3) continue;
                        this.mStopQueryString = string.substring(0, j) + "&" + string.substring(j);
                        continue block12;
                    }
                    continue block12;
                }
                case 119: {
                    String string = this.processLabel((String)object, this.mOKButton);
                    this.mOKButton.setLabel(string);
                    continue block12;
                }
                case 106: {
                    String string = this.processLabel((String)object, this.mCancelButton);
                    this.mCancelButton.setLabel(string);
                    continue block12;
                }
                case 447: {
                    this.mAutosizeCols = (Boolean)object;
                    this.mFontMetrics = this.mDialog.getFontMetrics(this.mDialog.getFont());
                    continue block12;
                }
                case 448: {
                    this.defineColumn((Message)object);
                    continue block12;
                }
                case 455: {
                    this.setLongListLabel((String)object);
                    this.setLongList(true);
                    this.setAccessibilityDesc((String)object, this.mFindField);
                    continue block12;
                }
                case 146: {
                    Color color = this.getDispatcher().getColorEntry((Integer)object);
                    this.mFindField.setForeground(color);
                    this.mTable.setForeground(color);
                    this.mTable.setSelectBackground(color);
                    this.onUpdate(n2, object);
                    continue block12;
                }
                case 147: {
                    Color color = this.getDispatcher().getColorEntry((Integer)object);
                    this.mFindField.setBackground(color);
                    this.mTable.setBackground(color);
                    this.mTable.setSelectForeground(color);
                    this.onUpdate(n2, object);
                    continue block12;
                }
                default: {
                    if (this.onUpdate(n2, object)) continue block12;
                }
            }
        }
        this.appendAccessibilityDesc(this.mFindField);
        lWContainer.setLayout(gridBagLayout);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.mFindLabel, gridBagConstraints);
        ButtonBar buttonBar2 = new ButtonBar();
        ButtonBar buttonBar3 = new ButtonBar();
        buttonBar2.add(this.mOKButton);
        buttonBar2.add(this.mCancelButton);
        buttonBar3.add(this.mFindButton);
        buttonBar.add(buttonBar3);
        buttonBar.add(buttonBar2);
        if (this.getDirection() == 2) {
            this.mTable.setReadingDirection(2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.mFindField, gridBagConstraints);
            lWContainer.add(this.mFindField);
            lWContainer.add(this.mFindLabel);
        } else {
            this.mTable.setReadingDirection(1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.mFindField, gridBagConstraints);
            lWContainer.add(this.mFindLabel);
            lWContainer.add(this.mFindField);
        }
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.mDialogLayout.setConstraints(lWContainer, gridBagConstraints);
        this.mDialogLayout.setConstraints(this.mLongListPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.mDialogLayout.setConstraints(this.mTableScroller, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.mDialogLayout.setConstraints(buttonBar, gridBagConstraints);
        this.getContent().add(this.mLongListPanel);
        this.getContent().add(lWContainer);
        this.getContent().add(this.mTableScroller);
        this.getContent().add(buttonBar);
        this.mDialog.validate();
        this.mOKButton.setDefault(true);
        this.setCancelButton(this.mCancelButton);
    }

    public void setNonBlockingUI(boolean bl) {
        if (bl) {
            String string = this.processLabel(this.mStopQueryString, this.mFindButton);
            this.mFindButton.setLabel(string);
            this.mFindButton.setEnabled(true);
            this.mCancelButton.setEnabled(false);
            this.mOKButton.setEnabled(false);
            this.mDialog.validate();
            this.getDispatcher().setNonBlockingWaitCursors(true);
        } else {
            String string = this.processLabel(this.mFindButtonString, this.mFindButton);
            this.mFindButton.setLabel(string);
            this.mFindButton.setEnabled(false);
            this.mCancelButton.setEnabled(true);
            this.mOKButton.setEnabled(true);
            this.mDialog.validate();
            this.initFocus();
            this.getDispatcher().setNonBlockingWaitCursors(false);
        }
    }

    private boolean isFindCharValid(char c) {
        return c != '\uffff' && c != ' ' && c != '_';
    }

    private boolean isFindCriteriaValid() {
        String string = this.mFindField.getText();
        for (int i = 0; i < string.length(); ++i) {
            char c = Character.toUpperCase(string.charAt(i));
            if (!this.isFindCharValid(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.mFindField) {
            this.mFindButton.setEnabled(this.isFindCriteriaValid());
        }
    }

    private void initFocus() {
        if (this.isLongList()) {
            this.mFindField.requestFocus();
        } else {
            this.getTable().requestFocus();
        }
    }

    private final boolean lovUnobscured(Point point, Dimension dimension, Point point2, Dimension dimension2) {
        return 0 <= point.x + point2.x && 0 <= point.y + point2.y && point.x + point2.x + dimension.width <= dimension2.width && point.y + point2.y + dimension.height <= dimension2.height;
    }

    private Point getAutoPosition() {
        Point point = new Point(0, 0);
        ComponentItem componentItem = this.getDispatcher().getFocusOwner();
        if (componentItem == null || componentItem.getView() == null) {
            return point;
        }
        IView iView = componentItem.getView();
        Point point2 = (Point)iView.getProperty(ID.LOCATION);
        if (point2 == null) {
            return point;
        }
        Dimension dimension = (Dimension)iView.getProperty(ID.SIZE);
        Container container = this.getComponent().getParent();
        Dimension dimension2 = this.getComponent().getSize();
        Point point3 = container.getLocation();
        Dimension dimension3 = container.getParent().getSize();
        for (Container container2 = (Container)iView.getProperty(ID.UI_PARENT); container2 != container && container2 != null; container2 = container2.getParent()) {
            Point point4 = container2.getLocation();
            point2.x += point4.x;
            point2.y += point4.y;
        }
        point.x = point2.x;
        point.y = point2.y + dimension.height;
        if (this.lovUnobscured(point, dimension2, point3, dimension3)) {
            return point;
        }
        point.x = point2.x;
        point.y = point2.y - dimension2.height;
        if (this.lovUnobscured(point, dimension2, point3, dimension3)) {
            return point;
        }
        point.x = point2.x + dimension.width;
        point.y = point2.y;
        if (this.lovUnobscured(point, dimension2, point3, dimension3)) {
            return point;
        }
        point.x = point2.x - dimension2.width;
        point.y = point2.y;
        if (this.lovUnobscured(point, dimension2, point3, dimension3)) {
            return point;
        }
        point.x = -point3.x;
        point.y = -point3.y;
        return point;
    }

    @Override
    public void doShowComponent(boolean bl) {
        if (this.mAutoPosition) {
            Point point = this.getAutoPosition();
            this.getComponent().setLocation(point.x, point.y);
        }
        super.doShowComponent(bl);
        if (bl) {
            this.mListData.start();
            this.mSelectionSent = false;
        }
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        if (n == 135) {
            this.mAutoPosition = false;
        }
        if (super.onUpdate(n, object)) {
            return true;
        }
        switch (n) {
            case 446: {
                int n2 = this.mListData.getRowCount();
                this.mListData.setRowCount((Integer)object);
                if (this.mListData.getRowCount() != 0) {
                    this.getTable().setSelectedRow(0);
                    this.getTable().setFocusedRow(0);
                    this.getTable().setFirstRowOnScreen(0);
                    if (this.isLongList()) {
                        this.setLongList(false);
                    }
                }
                return true;
            }
            case 451: {
                if (this.mWaitonInteger == 1) {
                    this.mWaitonInteger = 0;
                    this.mUpdateRowNumRows = (Integer)object;
                } else if (object instanceof Integer) {
                    this.mWaitonInteger = 1;
                    this.mUpdateRowStart = (Integer)object - 1;
                } else {
                    this.mUpdateRowStart = ((Point)object).x - 1;
                    this.mUpdateRowNumRows = ((Point)object).y;
                }
                return true;
            }
            case 122: {
                this.getDispatcher().setBIDIText();
                this.mListData.setRowData(this.mUpdateRowStart, (String[])object);
                ++this.mUpdateRowStart;
                --this.mUpdateRowNumRows;
                if (!this.mFocusSet) {
                    this.initFocus();
                    this.mFocusSet = true;
                }
                return true;
            }
            case 454: {
                this.mFindField.setText((String)object);
                if (this.isLongList()) {
                    if (((String)object).equals("%")) {
                        this.mFindField.setText("");
                    }
                    this.mFindButton.setEnabled(this.isFindCriteriaValid());
                }
                return true;
            }
            case 456: {
                if (this.isLongList()) {
                    this.setLongList(false);
                }
                return true;
            }
            case 450: {
                this.mListData.stopFetching(true);
                this.disposeDialog();
                this.sendLOVSelectionEvent((Integer)object - 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void onGet(Message message) {
    }

    @Override
    public synchronized void onDestroy() {
        if (this.mListData.isAlive()) {
            this.mListData.stopFetching(false);
            this.disposeDialog();
        }
        if (this.mDialog != null) {
            this.mDialog.removeComponentListener(this);
            this.mListData.removeDataSourceListener(this.mTable);
            this.mListData.removeDataSourceListener(this.mTable);
            this.mTable.removeKeyListener(this);
            this.mTable.removeMouseListener(this);
            this.mFindField.removeKeyListener(this);
            this.mFindField.removeTextListener(this);
            this.mFindButton.removeActionListener(this);
            this.mFindButton.removeKeyListener(this);
            this.mOKButton.removeActionListener(this);
            this.mOKButton.removeKeyListener(this);
            this.mCancelButton.removeActionListener(this);
            this.mCancelButton.removeKeyListener(this);
            this.mTableScroller.setContent(null);
        }
        super.onDestroy();
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    protected ListView getTable() {
        return this.mTable;
    }

    private void defineColumn(Message message) {
        int n;
        String string = null;
        boolean bl = false;
        int n2 = -1;
        Object var10_5 = null;
        int n3 = message.size();
        block5: for (n = 0; n < n3; ++n) {
            int n4 = message.getPropertyAt(n);
            Object object = message.getValueAt(n);
            switch (n4) {
                case 108: {
                    string = (String)object;
                    continue block5;
                }
                case 109: {
                    n2 = (Integer)object;
                    continue block5;
                }
                case 449: {
                    bl = (Boolean)object;
                    continue block5;
                }
            }
        }
        if (string == null) {
            string = "";
        }
        if (n2 == -1) {
            n2 = 20;
        }
        if (this.mAutosizeCols && n2 != 0) {
            ImmInsets immInsets = this.getTable().getColumnInsets();
            n = this.mFontMetrics.stringWidth(string) + immInsets.left + immInsets.right;
            if (n > n2) {
                n2 = n;
            }
        }
        int n5 = this.mListData.getItemCount();
        this.mListData.addColumn(string);
        this.getTable().setColumnWidth(n5, n2);
        int n6 = bl ? 2 : 0;
        this.getTable().setColumnAlignment(n5, n6);
    }

    public synchronized void defineRow(String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.mListData.setData(i, n, stringArray[i]);
        }
    }

    private final boolean isLongList() {
        return this.mLongList;
    }

    private final void setLongListLabel(String string) {
        this.mLongListLabelString = string;
    }

    private final void setLongList(boolean bl) {
        this.mLongList = bl;
        if (this.mLongList) {
            MessageGenerator messageGenerator = this.getApplet().getErrorMessageGenerator();
            String string = messageGenerator.getMessage("FRM-92700");
            this.mLongLabel = new LongLabel(WordWrapper.getTextWrapper(), this.mLongListLabelString + "\n\n" + string);
            this.mLongLabel.setPreferredAspectRatio(0.0f);
            this.mLongLabel.setWrappingLocked(true);
            Dimension dimension = this.mDialog.getSize();
            this.mLongLabel.setWrapWidth(dimension.width);
            this.mLongListPanel.add(this.mLongLabel);
            this.mOKButton.setEnabled(false);
        } else {
            if (this.mLongLabel != null) {
                this.mLongListPanel.remove(this.mLongLabel);
                this.mLongLabel = null;
            }
            this.mOKButton.setEnabled(true);
            this.mDialog.validate();
        }
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.mLongLabel != null) {
            Dimension dimension = this.mLongLabel.getParent().getSize();
            this.mLongLabel.setWrapWidth(dimension.width);
            this.mDialog.validate();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public PushButton getFindButton() {
        return this.mFindButton;
    }

    public PushButton getOKButton() {
        return this.mOKButton;
    }

    public boolean isCancelLllMode() {
        return this.mCancelLllMode;
    }

    public void setCancelLllMode(boolean bl) {
        if (this.mCancelLllMode != bl) {
            this.setNonBlockingUI(bl);
        }
        this.mCancelLllMode = bl;
    }

    private void appendAccessibilityDesc(Component component) {
        String string = null;
        AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
        MessageGenerator messageGenerator = this.getApplet().getTranslatedPhraseGenerator();
        MessageGenerator messageGenerator2 = this.getApplet().getErrorMessageGenerator();
        string = accessibleContext.getAccessibleDescription();
        if (string != null && !this.mFindButtonPressed) {
            string = string + messageGenerator2.getMessage("FRM-92700");
            string = string + messageGenerator.getText("FIND");
        } else {
            string = messageGenerator.getText("FIND");
        }
        accessibleContext.setAccessibleDescription(string);
        accessibleContext.setAccessibleName(string);
    }

    private void setAccessibilityDesc(String string, Component component) {
        AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
        accessibleContext.setAccessibleDescription(string);
        accessibleContext.setAccessibleName(string);
    }

    private boolean isDeadKey(int n) {
        return n == 129 || n == 128 || n == 130 || n == 131 || n == 132 || n == 133 || n == 134 || n == 135 || n == 136 || n == 137 || n == 138 || n == 139 || n == 140 || n == 141 || n == 142 || n == 143;
    }
}

