/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.event.ListenerManager;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ListValuesDialog;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.test.Test;

class ListValuesData
extends Thread
implements Test,
TwoDDataSource,
OneDDataSource {
    private ListValuesDialog mLOV;
    private int mNumRows = 0;
    private Vector mHeadingData = new Vector();
    private ListenerManager mDataListener = new ListenerManager();
    private ListenerManager mHeadingListener = new ListenerManager();
    private Vector mCacheRegion = new Vector();
    private Vector mCacheData = new Vector();
    private Vector mExposeRegion = new Vector();
    private Vector mRequestRegion = new Vector();
    private boolean mIsRunning = true;
    private boolean mQueryCanceled = false;

    public ListValuesData(ListValuesDialog listValuesDialog) {
        super("List of Values Data Fetching");
        this.mLOV = listValuesDialog;
        this.clearCache();
    }

    @Override
    public void addDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        this.mDataListener.addListener(twoDDataSourceListener);
    }

    public void addColumn(String string) {
        int n = this.getItemCount();
        this.mHeadingData.addElement(string);
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, 1);
        Enumeration enumeration = this.mHeadingListener.getListeners();
        while (enumeration.hasMoreElements()) {
            ((OneDDataSourceListener)enumeration.nextElement()).itemsAdded(oneDDataSourceEvent);
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2001, n, 1);
        enumeration = this.mDataListener.getListeners();
        while (enumeration.hasMoreElements()) {
            ((TwoDDataSourceListener)enumeration.nextElement()).columnsAdded(twoDDataSourceEvent);
        }
    }

    @Override
    public int getColumnCount() {
        return this.mHeadingData.size();
    }

    public void setRowCount(int n) {
        Enumeration enumeration;
        TwoDDataSourceEvent twoDDataSourceEvent;
        int n2 = this.mNumRows;
        if (this.mQueryCanceled) {
            this.clearCache();
            return;
        }
        if (n < 0) {
            n = Math.abs(n);
            this.mLOV.setCancelLllMode(true);
        } else if (this.mLOV.isCancelLllMode() && n > 0) {
            this.mLOV.setCancelLllMode(false);
        } else {
            this.clearCache();
        }
        if (this.mNumRows != 0) {
            this.mNumRows = 0;
            twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2005, 0, n2);
            enumeration = this.mDataListener.getListeners();
            while (enumeration.hasMoreElements()) {
                ((TwoDDataSourceListener)enumeration.nextElement()).rowsRemoved(twoDDataSourceEvent);
            }
            TwoDDataSourceEvent twoDDataSourceEvent2 = new TwoDDataSourceEvent(this, 2006, 0, n2);
            enumeration = this.mDataListener.getListeners();
            while (enumeration.hasMoreElements()) {
                ((TwoDDataSourceListener)enumeration.nextElement()).invalidateRows(twoDDataSourceEvent2);
            }
        }
        this.mNumRows = n;
        if (this.mNumRows != 0) {
            twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2004, 0, n);
            enumeration = this.mDataListener.getListeners();
            while (enumeration.hasMoreElements()) {
                ((TwoDDataSourceListener)enumeration.nextElement()).rowsAdded(twoDDataSourceEvent);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.mNumRows;
    }

    @Override
    public Object getData(int n, int n2) {
        String[] stringArray = this.getCacheRow(n2);
        if (stringArray == null) {
            this.addExposeRegion(n2, 1);
            return null;
        }
        return stringArray[n];
    }

    @Override
    public void removeDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        this.mDataListener.removeListener(twoDDataSourceListener);
    }

    @Override
    public void setData(int n, int n2, Object object) {
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2006, n2, 1);
        Enumeration enumeration = this.mDataListener.getListeners();
        while (enumeration.hasMoreElements()) {
            ((TwoDDataSourceListener)enumeration.nextElement()).invalidateRows(twoDDataSourceEvent);
        }
    }

    @Override
    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        this.mHeadingListener.addListener(oneDDataSourceListener);
    }

    @Override
    public int getItemCount() {
        return this.getColumnCount();
    }

    @Override
    public Object getData(int n) {
        return this.mHeadingData.elementAt(n);
    }

    @Override
    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        this.mHeadingListener.removeListener(oneDDataSourceListener);
    }

    @Override
    public void setData(int n, Object object) {
        throw new NoSuchMethodError("This should never be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isRunning()) {
                Object object = this;
                synchronized (object) {
                    if (this.mExposeRegion.size() == 0) {
                        this.wait();
                    }
                    if (!this.isRunning()) {
                        break;
                    }
                }
                while (this.mExposeRegion.size() > 0) {
                    Vector vector;
                    object = this.mExposeRegion;
                    synchronized (object) {
                        vector = this.mExposeRegion;
                        this.mExposeRegion = new Vector();
                    }
                    object = this.mLOV.getTable().getExposedCells();
                    int n = ((Rectangle)object).y;
                    int n2 = ((Rectangle)object).height;
                    for (int i = vector.size() - 1; i >= 0; --i) {
                        Point point = (Point)vector.elementAt(i);
                        for (int j = 0; j < point.y; ++j) {
                            int n3 = point.x + j;
                            if (this.isRowCached(n3) && this.isRowInRange(n3, n, n2)) {
                                this.mLOV.defineRow(this.getCacheRow(n3), n3);
                                continue;
                            }
                            if (!this.isRowCacheCandidate(n3)) continue;
                            this.addRequestEntry(n3);
                        }
                    }
                    this.sendRequestEntry();
                    if (!this.isRunning()) continue;
                    this.pruneCache();
                }
            }
        }
        catch (Exception exception) {
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFetching(boolean bl) {
        ListValuesData listValuesData = this;
        synchronized (listValuesData) {
            this.mIsRunning = false;
            this.notify();
        }
        if (bl && Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                MessageGenerator messageGenerator = this.mLOV.getApplet().getErrorMessageGenerator();
                System.out.println(messageGenerator.getMessage("FRM-92460", Thread.currentThread().getName()));
            }
        }
    }

    public void setQueryCanceled(boolean bl) {
        this.mQueryCanceled = bl;
    }

    private final boolean isRunning() {
        return this.mIsRunning;
    }

    private void addRequestEntry(int n) {
        this.fold(new Point(n, 1), this.mRequestRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestEntry() {
        Vector vector;
        if (this.mRequestRegion.size() == 0) {
            return;
        }
        Runform runform = this.mLOV.getDispatcher();
        Object object = this.mRequestRegion;
        synchronized (object) {
            vector = this.mRequestRegion;
            this.mRequestRegion = new Vector();
        }
        int n = vector.size();
        object = runform.getOnMessageLock();
        synchronized (object) {
            if (!this.isRunning()) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                Message message;
                Point point = new Point((Point)vector.elementAt(i));
                ++point.x;
                if (point.x > Short.MAX_VALUE || point.y > Short.MAX_VALUE) {
                    message = new Message(this.mLOV, 451, (Object)point.x);
                    message.add(451, point.y);
                    runform.onMessage(message, i == n - 1 ? 0 : 1);
                    continue;
                }
                ++((Point)vector.elementAt((int)i)).x;
                message = new Message(this.mLOV, 451, (Point)vector.elementAt(i));
                runform.onMessage(message, i == n - 1 ? 0 : 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addExposeRegion(int n, int n2) {
        this.fold(new Point(n, n2), this.mExposeRegion);
        ListValuesData listValuesData = this;
        synchronized (listValuesData) {
            this.notify();
        }
    }

    private void fold(Point point, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Point point2 = (Point)vector.elementAt(i);
            if (this.isAdjoining(point, point2)) {
                Point point3;
                int n = point2.x;
                point2.x = Math.min(point.x, point2.x);
                point2.y = Math.max(point.x + point.y - 1, n + point2.y - 1) - point2.x + 1;
                for (int j = i + 1; j < vector.size() && this.isAdjoining(point2, point3 = (Point)vector.elementAt(j)); ++j) {
                    n = point3.x;
                    point2.x = Math.min(point2.x, point3.x);
                    point2.y = Math.max(point2.x + point2.y - 1, n + point3.y - 1) - point2.x + 1;
                    vector.removeElementAt(j);
                }
                bl = true;
                break;
            }
            if (point.x >= point2.x) continue;
            vector.insertElementAt(point, i);
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(point);
        }
    }

    public synchronized void setRowData(int n, String[] stringArray) {
        if (this.isRowCacheCandidate(n)) {
            this.addCacheRow(n, stringArray);
        }
        if (this.mLOV.getTable().isRowExposed(n)) {
            this.mLOV.defineRow(stringArray, n);
        }
    }

    private boolean isRowInRange(int n, int n2, int n3) {
        return n >= n2 && n < n2 + n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        Vector vector = this.mCacheRegion;
        synchronized (vector) {
            this.mCacheRegion = new Vector();
            this.mCacheData = new Vector();
        }
    }

    private synchronized void addCacheRow(int n, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < this.mCacheRegion.size(); ++i) {
            Point point = (Point)this.mCacheRegion.elementAt(i);
            if (n < point.x - 1) {
                this.mCacheRegion.insertElementAt(new Point(n, 1), i);
                Vector<String[]> vector = new Vector<String[]>();
                this.mCacheData.insertElementAt(vector, i);
                vector.addElement(stringArray);
                bl = true;
                break;
            }
            if (n == point.x - 1) {
                --point.x;
                ++point.y;
                ((Vector)this.mCacheData.elementAt(i)).insertElementAt(stringArray, 0);
                bl = true;
                break;
            }
            if (n != point.x + point.y) continue;
            ++point.y;
            ((Vector)this.mCacheData.elementAt(i)).addElement(stringArray);
            if (i != this.mCacheRegion.size() - 1) {
                Point point2 = (Point)this.mCacheRegion.elementAt(i + 1);
                if (point.x + point.y == point2.x) {
                    point.y += point2.y;
                    for (int j = 0; j < point2.y; ++j) {
                        ((Vector)this.mCacheData.elementAt(i)).addElement(((Vector)this.mCacheData.elementAt(i + 1)).elementAt(j));
                    }
                    this.mCacheRegion.removeElementAt(i + 1);
                    this.mCacheData.removeElementAt(i + 1);
                }
            }
            bl = true;
            break;
        }
        if (!bl) {
            this.mCacheRegion.addElement(new Point(n, 1));
            Vector<String[]> vector = new Vector<String[]>();
            this.mCacheData.addElement(vector);
            vector.addElement(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getCacheRow(int n) {
        String[] stringArray = null;
        Vector vector = this.mCacheRegion;
        synchronized (vector) {
            for (int i = this.mCacheRegion.size() - 1; i >= 0; --i) {
                Point point = (Point)this.mCacheRegion.elementAt(i);
                if (!this.isRowInRange(n, point.x, point.y)) continue;
                Vector vector2 = (Vector)this.mCacheData.elementAt(i);
                stringArray = (String[])vector2.elementAt(n - point.x);
                break;
            }
        }
        return stringArray;
    }

    private boolean isRowCacheCandidate(int n) {
        return this.mLOV.getTable().isRowExposed(n) && n < this.getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowCached(int n) {
        boolean bl = false;
        Vector vector = this.mCacheRegion;
        synchronized (vector) {
            for (int i = this.mCacheRegion.size() - 1; i >= 0; --i) {
                Point point = (Point)this.mCacheRegion.elementAt(i);
                if (!this.isRowInRange(n, point.x, point.y)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private synchronized void pruneCache() {
    }

    private boolean isAdjoining(Point point, Point point2) {
        if (Math.max(point.x, point2.x) == point.x) {
            return Math.min(point2.x + point2.y - point.x, point.y) >= 0;
        }
        return Math.min(point.x + point.y - point2.x, point2.y) >= 0;
    }

    protected void listCache(PrintStream printStream, String string) {
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }
}

