/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ewt.graphics.ImageUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.ui.VImage;

public class ImageItem
extends ComponentItem {
    public static final byte DEFAULT_BORDER_WIDTH = 2;
    private static int sHandlerClassId = 0;
    private static Toolkit mToolkit = null;
    private Rectangle mSelRect = new Rectangle();

    public ImageItem() {
        this.setHandler(this);
    }

    @Override
    public void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.setComponent((Component)((Object)this.getView()));
        this.getView().addListener(FocusListener.class, this);
        this.getView().addListener(KeyListener.class, this);
        this.getView().addListener(MouseListener.class, this);
        this.getView().setProperty(ID.BORDER_BEVEL, BorderBevel.NONE);
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 384: {
                this.setValue(object);
                break;
            }
            case 385: {
                this.setValue(object);
                break;
            }
            case 388: {
                this.mSelRect = (Rectangle)object;
                break;
            }
            case 391: {
                ImgSelection imgSelection = new ImgSelection((Image)this.getView().getProperty(ID.VALUE));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSelection, null);
                break;
            }
            case 139: {
                this.getView().setProperty(ID.CANVASORIGIN, (Point)object);
                break;
            }
            case 386: {
                this.getView().setProperty(ID.SCALE, (Integer)object);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onGet(Message message) {
        int n = message.size();
        Object object = null;
        int n2 = 0;
        while (n2 < n) {
            Cloneable cloneable;
            int n3 = message.getPropertyAt(n2);
            switch (n3) {
                case 155: {
                    cloneable = (Point)this.getView().getProperty(ID.SCROLL_POSITION);
                    Dimension dimension = (Dimension)this.getView().getProperty(ID.VIEWPORT_SIZE);
                    object = new Rectangle(cloneable.x, cloneable.y, dimension.width, dimension.height);
                    break;
                }
                case 386: {
                    object = this.getView().getProperty(ID.SCALE);
                    break;
                }
                default: {
                    object = super.onGet(n3);
                }
            }
            if (object == null) {
                switch (n3) {
                    case 388: {
                        cloneable = new Rectangle(this.mSelRect.x, this.mSelRect.y, this.mSelRect.width, this.mSelRect.height);
                        object = cloneable;
                        break;
                    }
                }
            }
            if (object == null) {
                // empty if block
            }
            message.setValueAt(n2++, object);
        }
    }

    @Override
    public void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(FocusListener.class, this);
            this.getView().removeListener(KeyListener.class, this);
            this.getView().removeListener(MouseListener.class, this);
            if (this.isMouseMoveEnabled()) {
                this.getView().removeListener(MouseMotionListener.class, this);
            }
        }
        super.onDestroy();
    }

    @Override
    public Message getFinalMessage() {
        this.getDispatcher().clearObserver(false);
        return null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void setEventMask(Object object) {
        super.setEventMask(object);
        this.setMouseEventListeners();
    }

    @Override
    public void setMouseEventListeners() {
        if (this.isMouseMoveEnabled()) {
            this.getView().addListener(MouseMotionListener.class, this);
        }
    }

    @Override
    public Component getAccessibleComponent() {
        Component component = null;
        component = this.getComponent() instanceof VImage ? ((VImage)this.getComponent()).getContent() : super.getAccessibleComponent();
        return component;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.setBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mRolloverEntryPainter != null || this.mRolloverPainter != null) {
            this.clearBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private void createBorder() {
    }

    private void setValue(Object object) {
        Object object2;
        boolean bl = false;
        Image image = null;
        String string = "";
        if (object instanceof String) {
            string = (String)object;
            image = this.getApplet().getCustomImage(string);
        } else {
            object2 = (byte[])object;
            if (((byte[])object2).length == 0) {
                image = null;
                bl = true;
            } else {
                if (mToolkit == null) {
                    mToolkit = this.getApplet().getToolkit();
                }
                image = mToolkit.createImage((byte[])object2);
            }
        }
        if (image != null && !ImageUtils.loadImage(image)) {
            image = null;
        }
        if (image == null && !bl) {
            image = this.getApplet().getDefaultImage("badimage");
            object2 = this.getApplet().getErrorMessageGenerator();
            System.out.println(object2.getMessage("FRM-92470", string));
        }
        this.getView().setProperty(ID.VALUE, image);
    }

    @Override
    protected Class getDefaultClass() {
        return VImage.class;
    }

    private class ImgSelection
    implements Transferable {
        private Image image;

        public ImgSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }
}

