/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.EventObject;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;
import oracle.forms.ui.ListView;

public class HelpDialog
extends CommonDialog
implements ActionListener {
    private static final int HELP_MARGIN = 10;
    private static int sHandlerClassId = 0;
    private PushButton mOKButton = null;
    private ListView mTable = null;
    private ArrayOneDDataSource mColumnSource = null;
    private ArrayTwoDDataSource mDataSource = null;
    private int mNumCols = 0;
    private int mNumRows = 0;
    private ScrollBox mScrollBox;
    public static final String DEFAULT_HELP_DLG_NAME = "Forms_Help_Dialog";

    public HelpDialog() {
        this.setHandler(this);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && !this.mDialog.isReshaping()) {
            keyEvent.consume();
            this.doCancelDialog();
        } else {
            super.keyPressedImpl(keyEvent);
        }
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        int n = message.size();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonBar buttonBar = new ButtonBar();
        super.onCreate(runform, message);
        this.mDialog = this.createDialog(runform.getFrame(), true);
        this.mDialog.setTitle("Help");
        this.getContent().setLayout(gridBagLayout);
        this.setResizable(true);
        this.setAutoSize(false);
        this.setAutoCenter(true);
        this.setComponent(this.mDialog);
        this.mColumnSource = new ArrayOneDDataSource(null);
        this.mDataSource = new ArrayTwoDDataSource(0, 0);
        this.mTable = new ListView(this.mColumnSource, this.mDataSource, runform);
        this.mTable.setReadOnly(true);
        int n2 = 12;
        int n3 = this.getDispatcher().getScreenRes();
        if (n3 != this.getDispatcher().getScreenResolution()) {
            n2 = n2 * n3 / this.getDispatcher().getScreenResolution();
        }
        this.mTable.setFont(new Font("SansSerif", 0, n2));
        this.mScrollBox = new ScrollBox(this.mTable, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.mScrollBox, gridBagConstraints);
        this.mOKButton = new PushButton("OK");
        this.mOKButton.addActionListener(this);
        this.mOKButton.addKeyListener(this);
        buttonBar.add(this.mOKButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(buttonBar, gridBagConstraints);
        this.mTable.addKeyListener(this);
        this.onUpdate(message);
        this.getContent().add(this.mScrollBox);
        this.getContent().add(buttonBar);
        this.mOKButton.setDefault(true);
        this.setCancelButton(this.mOKButton);
        this.show();
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        String string = null;
        Object var6_5 = null;
        switch (n) {
            case 129: {
                this.mDialog.setTitle((String)object);
                if (!this.getDispatcher().getRecordNames()) break;
                super.onUpdate(539, DEFAULT_HELP_DLG_NAME);
                break;
            }
            case 119: {
                String string2 = this.processLabel((String)object, this.mOKButton);
                this.mOKButton.setLabel(string2);
                break;
            }
            case 108: {
                string = (String)object;
                if (string == null) {
                    this.mTable.setHeaderVisible(false);
                    break;
                }
                Object[] objectArray = new String[]{string};
                this.mColumnSource.addItems(this.mNumCols, objectArray);
                break;
            }
            case 109: {
                this.mDataSource.addColumns(this.mNumCols, 1);
                this.mTable.setColumnWidth(this.mNumCols, (Integer)object);
                ++this.mNumCols;
                break;
            }
            case 122: {
                String[] stringArray = (String[])object;
                this.mDataSource.addRows(this.mNumRows, 1);
                for (int i = 0; i < this.mNumCols; ++i) {
                    this.mDataSource.setData(i, this.mNumRows, stringArray[i]);
                }
                ++this.mNumRows;
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
        this.mTable = null;
        this.mOKButton = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.sendConfirmation(actionEvent);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.sendConfirmation(windowEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private void sendConfirmation(EventObject eventObject) {
        if (this.getDispatcher() == null) {
            return;
        }
        if (eventObject.getSource() == this.mOKButton || eventObject.getSource() == this.mDialog) {
            this.disposeDialog();
            Message message = new Message(this.getHandler(), 171, null);
            this.getHandler().getDispatcher().onMessage(message, 0);
        }
    }
}

