/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.forms.ui.BeanManager;

public class HeavyBeanManager
implements ComponentListener,
ContainerListener {
    private Component mBean;
    private BeanManager mManager;
    private Panel mPanel;
    private Container[] mParents;
    private Container mContainer;
    private Dimension mDimension = null;

    public HeavyBeanManager(Component component, BeanManager beanManager) {
        this.mBean = component;
        this.mContainer = this.getBean().getParent();
        this.mPanel = new Panel(null);
        this.mManager = beanManager;
        this.getContainer().setLayout(null);
        this.getContainer().removeAll();
        this.getContainer().add(this.getPanel());
        this.getContainer().addComponentListener(this);
        this.getPanel().setVisible(false);
        this.getPanel().add(this.getBean());
        this.updateAll();
    }

    public final Component getBean() {
        return this.mBean;
    }

    public final Container getContainer() {
        return this.mContainer;
    }

    public final Container getPanel() {
        return this.mPanel;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getPanel().getSize();
        if (this.mDimension == null) {
            this.updateLocation();
            this.mDimension = dimension;
        } else if (dimension.height != this.mDimension.height || dimension.width != this.mDimension.width) {
            this.updateLocation();
            this.mDimension = dimension;
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.updateLocation();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.updateVisibility();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.updateVisibility();
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.updateLocation();
        containerEvent.getChild().addComponentListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.updateLocation();
        containerEvent.getChild().removeComponentListener(this);
    }

    private void updateAll() {
        this.updateParents();
        this.updateVisibility();
        this.updateLocation();
    }

    private void updateParents() {
        int n;
        if (this.mParents != null) {
            for (n = 0; n < this.mParents.length; ++n) {
                if (this.mParents[n] instanceof DesktopContainer) {
                    this.mParents[n].removeContainerListener(this);
                }
                this.mParents[n].removeComponentListener(this);
            }
        }
        Vector<Container> vector = new Vector<Container>();
        for (Container container = this.getContainer().getParent(); container != null; container = container.getParent()) {
            vector.addElement(container);
        }
        this.mParents = new Container[vector.size()];
        vector.copyInto(this.mParents);
        for (n = 0; n < this.mParents.length; ++n) {
            if (this.mParents[n] instanceof DesktopContainer) {
                this.mParents[n].addContainerListener(this);
            }
            this.mParents[n].addComponentListener(this);
        }
    }

    private void updateLocation() {
        boolean bl = this.getPanel().isVisible();
        if (bl) {
            this.getPanel().setVisible(false);
        }
        this.getPanel().setLocation(1, 0);
        this.getPanel().setLocation(0, 0);
        this.updateClipping();
        if (bl) {
            this.getPanel().setVisible(true);
        }
    }

    private void updateVisibility() {
        boolean bl = true;
        for (int i = 0; i < this.mParents.length; ++i) {
            if (this.mParents[i].isVisible()) continue;
            bl = false;
            break;
        }
        this.getPanel().setVisible(bl);
    }

    private void updateClipping() {
        if (this.getPanel().isDisplayable() && (this.getPanel().isLightweight() || this.getPanel().getColorModel() != null)) {
            Rectangle rectangle = this.getContainer().getBounds();
            int n = -rectangle.x;
            int n2 = -rectangle.y;
            int n3 = 0;
            int n4 = 0;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            for (int i = 0; i < this.mParents.length; ++i) {
                Container container;
                Rectangle rectangle2 = this.mParents[i].getBounds();
                if (n > n3) {
                    n3 = n;
                }
                if (n2 > n4) {
                    n4 = n2;
                }
                if (n5 > n + rectangle2.width) {
                    n5 = n + rectangle2.width;
                }
                if (n6 > n2 + rectangle2.height) {
                    n6 = n2 + rectangle2.height;
                }
                if (this.mParents[i] instanceof LWWindow && (container = this.mParents[i].getParent()) != null) {
                    Component[] componentArray = container.getComponents();
                    int n7 = 0;
                    while (componentArray[n7] != this.mParents[i]) {
                        if (componentArray[n7].isVisible()) {
                            Rectangle rectangle3 = componentArray[n7].getBounds();
                            rectangle3.x += n - rectangle2.x;
                            rectangle3.y += n2 - rectangle2.y;
                            if (n3 < rectangle3.x + rectangle3.width && rectangle3.x <= n5 && n4 < rectangle3.y + rectangle3.height && rectangle3.y <= n6) {
                                int n8;
                                int n9 = n3;
                                int n10 = n5;
                                int n11 = n4;
                                int n12 = n6;
                                if (n5 > rectangle3.x + rectangle3.width) {
                                    n3 = rectangle3.x + rectangle3.width;
                                } else if (n3 < rectangle3.x) {
                                    n5 = rectangle3.x;
                                } else if (n6 > rectangle3.y + rectangle3.height) {
                                    n4 = rectangle3.y + rectangle3.height;
                                } else if (n4 < rectangle3.y) {
                                    n6 = rectangle3.y;
                                } else {
                                    n3 = n5;
                                }
                                if (n12 > rectangle3.y + rectangle3.height) {
                                    n11 = rectangle3.y + rectangle3.height;
                                } else if (n11 < rectangle3.y) {
                                    n12 = rectangle3.y;
                                } else if (n10 > rectangle3.x + rectangle3.width) {
                                    n9 = rectangle3.x + rectangle3.width;
                                } else if (n9 < rectangle3.x) {
                                    n10 = rectangle3.x;
                                } else {
                                    n11 = n12;
                                }
                                int n13 = n3 >= n5 || n4 >= n6 ? 0 : (n5 - n3) * (n6 - n4);
                                int n14 = n8 = n9 >= n10 || n11 >= n12 ? 0 : (n10 - n9) * (n12 - n11);
                                if (n8 > n13) {
                                    n3 = n9;
                                    n5 = n10;
                                    n4 = n11;
                                    n6 = n12;
                                }
                                if (n3 >= n5 || n4 >= n6) break;
                            }
                        }
                        ++n7;
                    }
                }
                if (n3 >= n5 || n4 >= n6) break;
                n -= rectangle2.x;
                n2 -= rectangle2.y;
            }
            this.getPanel().setBounds(n3, n4, n5 - n3, n6 - n4);
            this.getBean().setBounds(-n3, -n4, rectangle.width, rectangle.height);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

