/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintStream;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JFrame;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.lwAWT.lwWindow.DesktopModalStyle;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.toolBar.ToolBar;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.AppsModalStyle;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.DialogThread;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.FormStatusBar;
import oracle.forms.handler.ImageItem;
import oracle.forms.handler.MenuInfo;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.handler.UICommon;
import oracle.forms.test.Test;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.SmartBar;
import oracle.forms.ui.mdi.MDIContainer;

public class FormWindow
extends UICommon
implements ComponentListener,
PropertyChangeListener,
VetoableChangeListener,
WindowStateListener {
    public static final int HANDLER_TREE = 274;
    private static final int TYPE_ROOT = 1;
    private static int sHandlerClassId = 0;
    private ExtendedFrame mWindow = null;
    private int mMenuId = 0;
    private FormMenu mMenu = null;
    private boolean mMenuDirty = false;
    private boolean mWindowClosing = false;
    private boolean mContentSet = false;
    protected FormCanvas mContent = null;
    protected SmartBar mHSmartBar = null;
    protected SmartBar mVSmartBar = null;
    private static Component sExpectedComponentShown = null;
    private static Component sExpectedWindowActivated = null;
    private static Component sExpectedWindowDeactivated = null;
    private boolean mInitialHiddenReceived = false;
    private boolean mAllowClose = false;
    private Frame mRoot;
    private Integer mType;
    private int mResizeCount = 0;
    private Object mActivationLock = new Object();
    private boolean mIsActivated = false;
    private boolean mDialogThreadSync = false;

    public FormWindow() {
        this.setHandler(this);
    }

    protected void createComponent() {
        this.mWindow = new ExtendedFrame(this, this.getApplet().isWindowModeTitleLess());
        this.setComponent(this.mWindow);
        this.getApplet().getDesktop().addWindow(this.mWindow, false);
        this.mWindow.addComponentListener(this);
        this.mWindow.addKeyListener(this);
        this.mWindow.addPropertyChangeListener(this);
        this.mWindow.addVetoableChangeListener(this);
        this.mWindow.pack();
    }

    protected final ExtendedFrame getWindow() {
        return (ExtendedFrame)this.getComponent();
    }

    protected FormCanvas getContent() {
        return this.mContent;
    }

    public void createMenu() {
        if (this.mMenuDirty) {
            String string = null;
            this.mMenuDirty = false;
            MenuInfo menuInfo = (MenuInfo)this.getDispatcher().getHandler(this.mMenuId);
            if (menuInfo != null) {
                SmartBar smartBar;
                FormMenu formMenu;
                Object object;
                if (this.mMenu == null || !((object = this.mMenu.getTopMenu()) instanceof LWMenuBar)) {
                    object = null;
                }
                if ((formMenu = menuInfo.createUIMenu(this, (LWMenuBar)object)) != null) {
                    this.setMenu(formMenu);
                }
                SmartBar smartBar2 = null;
                if (menuInfo.hasHBar() && (smartBar2 = menuInfo.createSmartBar(this, (ToolBar)(object = (smartBar = this.getHBar()) == null ? null : smartBar.getToolBar()), true)) == null) {
                    String string2 = "WINDOW_MENU:Unable to create Hor smartbar for: ";
                    throw new Error(string + string2 + this);
                }
                this.setHBar(smartBar2);
                smartBar2 = null;
                if (menuInfo.hasVBar() && (smartBar2 = menuInfo.createSmartBar(this, (ToolBar)(object = (smartBar = this.getVBar()) == null ? null : smartBar.getToolBar()), false)) == null) {
                    String string3 = "WINDOW_MENU:Unable to create Ver smartbar for: ";
                    throw new Error(string + string3 + this);
                }
                this.setVBar(smartBar2);
            }
        }
    }

    protected void setLWMenuBar(LWMenuBar lWMenuBar) {
        this.getWindow().setLWMenuBar(lWMenuBar);
    }

    final void setMenu(FormMenu formMenu) {
        if (this.mMenu != null && this.mMenu.getMenuInfo() != null) {
            this.mMenu.destroy();
        }
        this.mMenu = formMenu;
        if (formMenu.getTopMenu() instanceof LWMenuBar) {
            LWMenuBar lWMenuBar = (LWMenuBar)formMenu.getTopMenu();
            this.setLWMenuBar(lWMenuBar);
            this.setAsMyDirection(lWMenuBar);
        }
    }

    public FormMenu getMenu() {
        return this.mMenu;
    }

    protected void setHBar(SmartBar smartBar) {
        ToolBar toolBar = null;
        SmartBar smartBar2 = this.getHBar();
        if (smartBar2 != null && smartBar2.getMenuInfo() != null) {
            smartBar2.destroy();
        }
        this.mHSmartBar = smartBar;
        if (smartBar != null) {
            toolBar = smartBar.getToolBar();
        }
        this.setAsMyDirection(toolBar);
        this.getWindow().setHorizontalSmartBar(toolBar);
    }

    public SmartBar getHBar() {
        return this.mHSmartBar;
    }

    protected void setVBar(SmartBar smartBar) {
        ToolBar toolBar = null;
        SmartBar smartBar2 = this.getVBar();
        if (smartBar2 != null && smartBar2.getMenuInfo() != null) {
            smartBar2.destroy();
        }
        this.mVSmartBar = smartBar;
        if (smartBar != null) {
            toolBar = smartBar.getToolBar();
        }
        this.getWindow().setVerticalSmartBar(toolBar);
    }

    public SmartBar getVBar() {
        return this.mVSmartBar;
    }

    protected void setContent(FormCanvas formCanvas) {
        this.mContent = formCanvas;
        this.mContentSet = true;
        this.getWindow().addToContent(formCanvas);
        this.setAsMyDirection(this.mContent);
    }

    protected void setVerticalToolbar(FormCanvas formCanvas) {
        DrawnPanel drawnPanel = formCanvas != null ? formCanvas.getPanel() : null;
        this.getWindow().setVerticalToolbar(drawnPanel);
    }

    protected void setHorizontalToolbar(FormCanvas formCanvas) {
        DrawnPanel drawnPanel = formCanvas != null ? formCanvas.getPanel() : null;
        this.getWindow().setHorizontalToolbar(drawnPanel);
    }

    protected void setStatusBar(FormCanvas formCanvas) {
        DrawnPanel drawnPanel = formCanvas != null ? formCanvas.getPanel() : null;
        this.getWindow().setStatusBar(drawnPanel);
        this.setAsMyDirection(formCanvas);
    }

    protected void sendActivatedEvent(boolean bl) {
        Message message = Message.newMessage(this, 247, bl ? Boolean.TRUE : Boolean.FALSE);
        int n = bl ? 0 : 4;
        this.getDispatcher().onMessage(message, n);
    }

    @Override
    protected void setDirection(byte by) {
        super.setDirection(by);
        if (this.mContent != null) {
            this.mContent.setDirection(this.getDirection());
        }
        if (this.mMenu != null && this.mMenu.getTopMenu() instanceof LWMenuBar) {
            ((LWMenuBar)this.mMenu.getTopMenu()).setReadingDirection(this.getLWDirection(by));
        }
        if (this.mHSmartBar != null) {
            this.setAsMyDirection(this.mHSmartBar.getToolBar());
        }
    }

    protected void setAsMyDirection(Object object) {
        if (object instanceof UICommon) {
            ((UICommon)object).setDirection(this.getDirection());
        } else if (object instanceof LWComponent) {
            ((LWComponent)object).setReadingDirection(this.getLWDirection(this.getDirection()));
        }
    }

    private void handleWindowActivated(EventObject eventObject) {
        EventListener eventListener;
        Object object;
        Object object2;
        if (this.getHandler() == null) {
            return;
        }
        Component component = this.getComponent();
        boolean bl = this.getDispatcher().isSDIMode();
        if (!bl && (object2 = ((MDIContainer)(object = this.getApplet().getMDIContainer())).getDefaultStatusBar()) == null && (eventListener = (FormStatusBar)this.getDispatcher().getCurrentStatusBar()) != null) {
            ((MDIContainer)object).setDefaultStatusBar(((UICommon)eventListener).getComponent());
            ((MDIContainer)object).updateWindowProperties(this.getWindow());
        }
        if (component == FormWindow.getExpectedWindowActivated()) {
            FormWindow.setExpectedWindowActivated(null);
        } else {
            this.sendActivatedEvent(true);
        }
        this.getDispatcher().setFrame(this.getWindow());
        if (component instanceof ExtendedFrame) {
            object = ((ExtendedFrame)component).getAlertDismissMsg();
            if (object != null) {
                this.getDispatcher().onMessage((Message)object, 0);
                ((ExtendedFrame)component).setDialogResult(null);
            }
            if ((object2 = this.getDispatcher().getFocusOwner()) != null && ((UICommon)object2).getParentWindow() == this.getWindow() && ((UICommon)object2).getComponent() != null) {
                FormWindow.setFocusHidden(true);
                if ((object2 instanceof TextAreaItem || object2 instanceof ImageItem || ((UICommon)object2).getHandlerClassId() == 274) && ((UICommon)object2).getComponent() instanceof ScrollBox) {
                    eventListener = (ScrollBox)((UICommon)object2).getComponent();
                    ((ScrollBox)eventListener).getContent().requestFocus();
                } else if (((UICommon)object2).getComponent().isEnabled()) {
                    ((UICommon)object2).getComponent().requestFocus();
                }
                FormWindow.setFocusHidden(false);
            } else if (this.getWindow() != null) {
                FormWindow.setFocusHidden(true);
                this.getWindow().requestFocus();
                FormWindow.setFocusHidden(false);
            }
        }
        if (this.mMenuDirty) {
            this.createMenu();
        }
        FormWindow.doDeferredRequestFocus((LWWindow)eventObject.getSource());
    }

    public void handleWindowDeactivated(EventObject eventObject) {
        if (this.getHandler() == null) {
            return;
        }
        Component component = this.getComponent();
        LWWindow lWWindow = (LWWindow)eventObject.getSource();
        if (lWWindow.isMinimized()) {
            this.clearDeferredRequestFocus(lWWindow);
        }
        if (component == FormWindow.getExpectedWindowDeactivated()) {
            FormWindow.setExpectedWindowDeactivated(null);
        } else {
            this.sendActivatedEvent(false);
        }
        if (!this.mWindowClosing && component instanceof ExtendedFrame && ((ExtendedFrame)component).getDesktop() != LWComponent.getFocusedComponent()) {
            FormWindow.setFocusHidden(true);
            ((ExtendedFrame)component).loseFocus();
            FormWindow.setFocusHidden(false);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension;
        ExtendedFrame extendedFrame = this.getWindow();
        if (this.getHandler() == null || this.getComponent() == null || extendedFrame.isMinimized()) {
            return;
        }
        if (this.mRoot == null) {
            ++this.mResizeCount;
            dimension = this.getContentViewSize();
            if (!(this.mContentSet || dimension.width != 0 && dimension.height != 0)) {
                return;
            }
            if (this.mContentSet && (dimension.width != this.mSize.x || dimension.height != this.mSize.y)) {
                this.mSize = new Point(dimension.width, dimension.height);
            }
            this.sendResizedEvent();
        } else if (componentEvent == null || componentEvent.getSource() != this.mRoot) {
            dimension = this.mRoot.getSize();
            if (dimension.width != this.mSize.x || dimension.height != this.mSize.y) {
                this.mSize = new Point(dimension.width, dimension.height);
                this.sendResizedEvent();
            }
        }
        if (this == this.getDispatcher().getRootWindow()) {
            dimension = this.getApplet().getDesktop().getParent().getParent().getSize();
            if (dimension.width != 0 && dimension.height != 0) {
                Vector vector = this.getApplet().getWindowsToCenter();
                for (int i = 0; i < vector.size(); ++i) {
                    ExtendedFrame extendedFrame2 = (ExtendedFrame)vector.elementAt(i);
                    Dimension dimension2 = extendedFrame2.getSize();
                    int n = Math.max(0, dimension.width - dimension2.width) / 2;
                    int n2 = Math.max(0, dimension.height - dimension2.height) / 2;
                    extendedFrame2.setLocation(n, n2);
                }
                vector.removeAllElements();
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.getHandler() == null || this.getComponent() == null) {
            return;
        }
        if (this.mRoot == null || componentEvent == null || componentEvent.getSource() == this.mRoot) {
            Point point = null;
            point = this.mRoot != null ? this.mRoot.getLocation() : this.getWindow().getLogicalLocation();
            Message message = Message.newMessage(this.getHandler(), 135, point);
            this.getDispatcher().onMessage(message, 1);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.getHandler() == null || this.mRoot != null) {
            return;
        }
        if (this.getComponent() == FormWindow.getExpectedComponentShown()) {
            FormWindow.setExpectedComponentShown(null);
        } else {
            Message message = Message.newMessage(this.getHandler(), 173, Boolean.TRUE);
            this.getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (this.getHandler() == null || this.mRoot != null) {
            return;
        }
        if (!this.mInitialHiddenReceived) {
            this.mInitialHiddenReceived = true;
        } else {
            Message message = Message.newMessage(this.getHandler(), 173, Boolean.FALSE);
            this.getDispatcher().onMessage(message, 0);
        }
    }

    @Override
    public void windowStateChanged(WindowEvent windowEvent) {
        int n;
        if (this.mRoot == null) {
            return;
        }
        int n2 = windowEvent.getOldState();
        if ((n2 & 6) != ((n = windowEvent.getNewState()) & 6)) {
            Message message = Message.newMessage(this, 242, (n & 6) > 0);
            this.getDispatcher().onMessage(message, 1);
        } else if ((n2 & 1) != (n & 1)) {
            Message message = Message.newMessage(this, 243, (n & 1) > 0);
            this.getDispatcher().onMessage(message, 1);
        }
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    public Dimension getContentViewSize() {
        return ((ExtendedFrame)this.getComponent()).getTKInnerSize();
    }

    public Component getContentView(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof Panel)) continue;
            for (int j = 0; j < ((Container)component).getComponentCount(); ++j) {
                Component component2 = ((Container)component).getComponent(j);
                if (!(component2 instanceof DrawnPanel) || ((DrawnPanel)component2).getUsage() != 1) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.createComponent();
        this.onUpdate(message);
        if (this.isToLeft()) {
            this.getWindow().setLogicalLocation(this.mPosition.x, this.mPosition.y, false);
        }
    }

    @Override
    public Object onGet(int n) {
        if (this.mRoot != null) {
            switch (n) {
                case 130: {
                    return this.mType;
                }
                case 129: {
                    return this.mRoot.getTitle();
                }
            }
            return null;
        }
        return super.onGet(n);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        if (this.mRoot != null) {
            return this.onUpdateRoot(n, object);
        }
        switch (n) {
            case 539: {
                if (this.getWindow() == null) break;
                this.getWindow().setName((String)object);
                break;
            }
            case 129: {
                if (this.getWindow() == null) break;
                this.getWindow().setTitle((String)object);
                break;
            }
            case 173: {
                Test test;
                int n2 = ((Number)object).intValue();
                if (n2 > 0) {
                    test = (FormWindow)this.getDispatcher().getHandler(n2);
                    FormWindow.setExpectedWindowDeactivated(test.getComponent());
                    FormWindow.setExpectedWindowActivated(this.getComponent());
                    FormWindow.setExpectedComponentShown(this.getComponent());
                }
                if (n2 != 0 && this.getContent() != null) {
                    test = Message.newMessage(this.getContent(), 173, Boolean.TRUE);
                    this.getContent().onUpdate((Message)test);
                }
                bl = super.onUpdate(n, n2 != 0 ? Boolean.TRUE : Boolean.FALSE);
                if (n2 <= 0) break;
                FormWindow.setExpectedWindowActivated(null);
                FormWindow.setExpectedWindowDeactivated(null);
                break;
            }
            case 216: {
                break;
            }
            case 239: {
                FormMenu formMenu = this.mMenu;
                int n3 = ((Number)object).intValue();
                if (n3 == this.mMenuId && this.mMenu != null) break;
                this.mMenuId = n3;
                this.mMenuDirty = true;
                if (!((ExtendedFrame)this.getComponent()).isVisible()) break;
                this.createMenu();
                break;
            }
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                break;
            }
            case 130: {
                this.mType = (Integer)object;
                if (this.mType == 1) {
                    this.mRoot = this.getApplet().getFrame();
                    this.getDispatcher().setRootWindow(this);
                    this.mRoot.addComponentListener(this);
                    this.mRoot.addWindowStateListener(this);
                    Container container = this.getApplet().getDesktop().getParent();
                    container.addComponentListener(this);
                    this.mWindow.removeComponentListener(this);
                    this.mWindow.removeKeyListener(this);
                    this.mWindow.removePropertyChangeListener(this);
                    this.mWindow.removeVetoableChangeListener(this);
                    this.componentMoved(null);
                    this.componentResized(null);
                    break;
                }
                this.mWindow.setType(WindowType.DIALOG);
                break;
            }
            case 222: {
                if ((Integer)object == 3) {
                    MDIContainer mDIContainer = this.getApplet().getMDIContainer();
                    this.mWindow.setModal(true);
                    this.mWindow.setModalStyle(AppsModalStyle.getAppsModalStyle(mDIContainer.getMDIScrollBox()));
                    break;
                }
                if ((Integer)object != 2) break;
                this.mWindow.setModal(true);
                this.mWindow.setModalStyle(DesktopModalStyle.getDesktopModalStyle());
                break;
            }
            case 227: {
                this.getWindow().setResizable((Boolean)object);
                break;
            }
            case 236: {
                if (this.getWindow() == null) break;
                Cursor cursor = Cursor.getPredefinedCursor(((Number)object).byteValue());
                this.setCursor(cursor, cursor);
                break;
            }
            case 228: {
                this.getWindow().setClosable((Boolean)object);
                break;
            }
            case 230: {
                this.getWindow().setMinimizable((Boolean)object);
                break;
            }
            case 231: {
                this.getWindow().setMaximizable((Boolean)object);
                break;
            }
            case 242: {
                this.getWindow().setMaximized((Boolean)object);
                break;
            }
            case 243: {
                this.getWindow().setMinimized((Boolean)object);
                break;
            }
            case 229: {
                this.getWindow().setMovable((Boolean)object);
                break;
            }
            case 233: {
                String string = (String)object;
                Image image = null;
                if (string.equalsIgnoreCase("<none>")) {
                    image = new BufferedImage(1, 1, 2);
                } else if (!string.equalsIgnoreCase("default")) {
                    image = this.getApplet().getDefaultImage(string);
                }
                this.getWindow().setIcon(image);
                break;
            }
            case 232: {
                if (!((Boolean)object).booleanValue()) {
                    this.getWindow().removeTitleBar();
                    break;
                }
                TitleBar titleBar = this.getWindow().getTitleBar();
                if (titleBar == null) break;
                titleBar.setVisible(true);
                Dimension dimension = titleBar.getPreferredSize();
                Dimension dimension2 = this.getWindow().getSize();
                this.getWindow().setSize(dimension2.width, dimension2.height + dimension.height);
                break;
            }
            case 240: {
                if (!((Boolean)object).booleanValue()) break;
                this.getWindow().setLogicalLocation(0, 0, true);
                break;
            }
            case 234: 
            case 235: 
            case 237: 
            case 238: 
            case 241: 
            case 244: {
                break;
            }
            case 246: {
                ExtendedFrame extendedFrame = this.getWindow();
                int n4 = ((Number)object).intValue();
                if (n4 != 0) {
                    FormWindow formWindow = (FormWindow)this.getDispatcher().getHandler(n4);
                    FormWindow.setExpectedWindowDeactivated(formWindow.getComponent());
                    FormWindow.setExpectedWindowActivated(this.getComponent());
                }
                if (extendedFrame != this.getDispatcher().getFrame()) {
                    if (extendedFrame.isMinimized()) {
                        extendedFrame.setMinimized(false);
                    }
                    extendedFrame.moveToFront();
                    extendedFrame.setActive(true);
                }
                if (n4 == 0) break;
                FormWindow.setExpectedWindowActivated(null);
                FormWindow.setExpectedWindowDeactivated(null);
                break;
            }
            case 245: {
                this.doWindowPrint();
                break;
            }
            case 135: {
                this.mPosition = (Point)object;
                this.getWindow().setLogicalLocation(this.mPosition.x, this.mPosition.y, false);
                break;
            }
            case 248: {
                FormCanvas formCanvas = (FormCanvas)this.getDispatcher().getHandler((Integer)object);
                this.getWindow().setMDIVerticalToolbar(formCanvas.getPanel());
                formCanvas.setIsMDIVToolbar(true);
                break;
            }
            case 249: {
                FormCanvas formCanvas = (FormCanvas)this.getDispatcher().getHandler((Integer)object);
                this.getWindow().setMDIHorizontalToolbar(formCanvas.getPanel());
                formCanvas.setIsMDIHToolbar(true);
                break;
            }
            case 137: {
                this.setSize((Point)object);
                this.getWindow().setTKInnerSize(((Point)object).x, ((Point)object).y);
                if (!this.isToLeft()) break;
                this.getWindow().setLogicalLocation(this.mPosition.x, this.mPosition.y, false);
                break;
            }
            case 102: {
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    private boolean onUpdateRoot(int n, Object object) {
        Object var3_3 = null;
        switch (n) {
            case 129: {
                this.mRoot.setTitle((String)object);
                break;
            }
            case 242: {
                int n2;
                int n3 = n2 = this.mRoot.getExtendedState();
                n2 = object == Boolean.TRUE ? (n2 |= 6) : (n2 &= 0xFFFFFFF9);
                if (n2 != n3) {
                    this.mRoot.setExtendedState(n2);
                }
                this.mRoot.validate();
                this.getApplet().correctSize();
                break;
            }
            case 243: {
                if (object == Boolean.TRUE && this.mRoot != null && !this.getApplet().useSeparateFrame()) {
                    Message message = Message.newMessage(this, 243, false);
                    this.getDispatcher().onMessage(message, 1);
                } else {
                    int n4;
                    int n5 = n4 = this.mRoot.getExtendedState();
                    n4 = object == Boolean.TRUE ? (n4 |= 1) : (n4 &= 0xFFFFFFFE);
                    if (n4 != n5) {
                        this.mRoot.setExtendedState(n4);
                    }
                }
                this.mRoot.validate();
                this.getApplet().correctSize();
                break;
            }
            case 233: {
                String string = (String)object;
                Image image = null;
                if (string.equalsIgnoreCase("<none>")) {
                    image = new BufferedImage(1, 1, 2);
                } else if (!string.equalsIgnoreCase("default")) {
                    image = this.getApplet().getDefaultImage(string);
                }
                this.mRoot.setIconImage(image);
                break;
            }
            case 135: {
                this.mPosition = (Point)object;
                this.mRoot.setLocation(this.mPosition);
                break;
            }
            case 137: {
                if (!this.getApplet().useSeparateFrame()) break;
                Point point = (Point)object;
                if (this.mRoot instanceof JFrame && this.getApplet().isWebstartRequest()) {
                    Dimension dimension = this.getApplet().getToolkit().getScreenSize();
                    if (point.x > dimension.width) {
                        point.x = dimension.width;
                    }
                    if (point.y > dimension.height) {
                        point.y = dimension.height;
                    }
                }
                this.mRoot.setSize(point.x, point.y);
                this.mRoot.validate();
                this.getApplet().correctSize();
                this.getApplet().correctMDISize();
                break;
            }
            case 581: {
                this.mRoot.setAlwaysOnTop((Boolean)object);
                break;
            }
            case 240: {
                if (!this.getApplet().useSeparateFrame() || object != Boolean.TRUE) break;
                this.getApplet().centerMDI();
            }
        }
        return true;
    }

    @Override
    public void doShowComponent(boolean bl) {
        DesktopContainer desktopContainer;
        ComponentItem componentItem;
        if (!bl && (componentItem = this.getDispatcher().getFocusOwner()) != null && componentItem.getParentWindow() == this.getWindow() && (desktopContainer = (DesktopContainer)this.getWindow().getDesktop()) != null) {
            FormWindow.setFocusHidden(true);
            desktopContainer.requestFocus();
            FormWindow.setFocusHidden(false);
        }
        if (bl && this.mMenuDirty) {
            this.createMenu();
        }
        if (bl && this.mWindow.isModal()) {
            if (!this.mWindow.isVisible()) {
                DialogThread.showDialog(this.mWindow);
                this.mWindow.setTitle(this.mWindow.getTitle());
            }
        } else {
            this.mWindow.setVisible(bl);
        }
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getWindow() != null) {
            if (this.getWindow().getType() == WindowType.DIALOG) {
                this.getWindow().setVisible(false);
            } else {
                FormWindow.removeDeferredRequestFocus(this.getWindow());
                this.getWindow().removeKeyListener(this);
            }
            this.getWindow().removeComponentListener(this);
            this.getWindow().removePropertyChangeListener(this);
            this.getWindow().removeVetoableChangeListener(this);
            if (this.getDispatcher().getFrame() == this.getWindow()) {
                this.getDispatcher().setFrame(null);
            }
            if (this.mRoot != null) {
                Container container = this.getApplet().getDesktop().getParent();
                container.removeComponentListener(this);
                this.mRoot.removeComponentListener(this);
            }
            if (this.getDispatcher().getFrame() == this.mWindow) {
                this.getDispatcher().setFrame(null);
            }
            this.mAllowClose = true;
            this.getWindow().removeAll();
            this.getWindow().setLWMenuBar(null);
            this.getWindow().dispose();
            this.getWindow().destroy();
        }
        super.onDestroy();
        if (this.mMenu != null) {
            this.mMenu.destroy();
        }
        if (this.mHSmartBar != null) {
            this.mHSmartBar.destroy();
        }
        if (this.mVSmartBar != null) {
            this.mVSmartBar.destroy();
        }
        this.mWindow = null;
        this.mContent = null;
        this.mMenu = null;
        this.mHSmartBar = null;
        this.mVSmartBar = null;
    }

    protected void doWindowPrint() {
        DialogThread.print(this.getDispatcher(), this.getWindow(), this.getWindow().getTitle());
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    protected synchronized void setCursor(Cursor cursor, Cursor cursor2) {
        if (this.getWindow() != null) {
            if (cursor != null) {
                this.getWindow().setCursor(cursor);
            }
            if (this.getWindow().getComponentCount() > 0 && cursor2 != null) {
                this.getWindow().getComponent(0).setCursor(cursor2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2 = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getPropertyName() == "active") {
            this.mIsActivated = false;
            this.mDialogThreadSync = true;
            if (object2 == Boolean.TRUE) {
                object = this.mActivationLock;
                synchronized (object) {
                    this.handleWindowActivated(propertyChangeEvent);
                    this.mIsActivated = true;
                    this.mDialogThreadSync = false;
                    this.mActivationLock.notifyAll();
                }
            } else {
                this.handleWindowDeactivated(propertyChangeEvent);
            }
        }
        if (propertyChangeEvent.getPropertyName() == "maximized") {
            if (object2 == Boolean.TRUE) {
                this.getWindow().setMovable(false);
            } else {
                this.getWindow().setMovable(true);
            }
            object = Message.newMessage(this, 242, (Boolean)object2);
            this.getDispatcher().onMessage((Message)object, 1);
        } else if (propertyChangeEvent.getPropertyName() == "minimized") {
            Object object3;
            object = this.getDispatcher().getFocusOwner();
            if (object != null && ((UICommon)object).getParentWindow() == this.getWindow() && ((UICommon)object).getComponent() != null) {
                FormWindow.setFocusHidden(true);
                if ((object instanceof TextAreaItem || object instanceof ImageItem || ((UICommon)object).getHandlerClassId() == 274) && ((UICommon)object).getComponent() instanceof ScrollBox) {
                    object3 = (ScrollBox)((UICommon)object).getComponent();
                    ((ScrollBox)object3).getContent().requestFocus();
                } else {
                    ((UICommon)object).getComponent().requestFocus();
                }
                FormWindow.setFocusHidden(false);
            }
            object3 = Message.newMessage(this, 243, (Boolean)object2);
            this.getDispatcher().onMessage((Message)object3, 1);
            if (object2 == Boolean.FALSE) {
                FormWindow.doDeferredRequestFocus((LWWindow)propertyChangeEvent.getSource());
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getPropertyName() == "closed") {
            this.mWindowClosing = true;
            if (this.getWindow() != null) {
                if (this.getHandler() == null) {
                    return;
                }
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl.booleanValue()) {
                    Message message = Message.newMessage(this, 216, Boolean.TRUE);
                    this.getDispatcher().onMessage(message, 0);
                }
            }
            if (!this.mAllowClose) {
                throw new PropertyVetoException("Cannot close", propertyChangeEvent);
            }
        }
    }

    private void sendResizedEvent() {
        if (this.getDispatcher() == null || !this.getDispatcher().isRunning() || this.getHandler() == null) {
            return;
        }
        if (this.mRoot == null && this.mResizeCount <= 2) {
            return;
        }
        Message message = Message.newMessage(this.getHandler(), 137, this.mSize);
        this.getDispatcher().onMessage(message, 0);
    }

    private static final Component getExpectedComponentShown() {
        return sExpectedComponentShown;
    }

    private static final Component getExpectedWindowActivated() {
        return sExpectedWindowActivated;
    }

    private static final Component getExpectedWindowDeactivated() {
        return sExpectedWindowDeactivated;
    }

    private static final void setExpectedComponentShown(Component component) {
        sExpectedComponentShown = component;
    }

    private static final void setExpectedWindowActivated(Component component) {
        sExpectedWindowActivated = component;
    }

    private static final void setExpectedWindowDeactivated(Component component) {
        sExpectedWindowDeactivated = component;
    }

    public Object activationLock() {
        return this.mActivationLock;
    }

    public boolean isActivated() {
        return this.mIsActivated;
    }

    public boolean isDialogThreadSync() {
        return this.mDialogThreadSync;
    }
}

