/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.PrintStream;
import oracle.ewt.EwtContainer;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.SeparatorBorderPainter;
import oracle.ewt.plaf.StatusBarUI;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarTextItem;
import oracle.forms.engine.Main;
import oracle.forms.engine.MainRT;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.UICommon;
import oracle.forms.test.Test;
import oracle.forms.ui.FormStatusArea;
import oracle.forms.ui.StatsIndicator;
import oracle.forms.ui.StatusBarInterface;

public class FormStatusBar
extends UICommon
implements Test,
StatusBarInterface {
    private static int sHandlerClassId = 0;
    private EwtContainer mStatusArea;
    private StatusBar mMessageBar;
    private StatusBar mLampBar;
    private StatsIndicator mBusyBar;
    private String mRoundTrips;
    private String mBytesTotal;
    private String mMessage;
    private String mHint;
    private static int mCount = 0;
    private static final String mSBarName = "StatusBar_";
    private StatusBarTextItem mAccessibilityText;
    private String mAccessibilityTextVal;
    private int mCurrentLamp = 0;
    private static final int STATUS_DELAY = 30;

    public FormStatusBar() {
        super.setHandler(this);
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        Color color;
        Font font;
        super.onCreate(runform, message);
        this.mStatusArea = new FormStatusArea(this.getApplet().hasOracleLF());
        this.mStatusArea.setEnabled(false);
        String string = this.getParameter("consoleUseRegistryFont");
        if (string == null || !string.equalsIgnoreCase("true")) {
            int n = 12;
            int n2 = this.getDispatcher().getScreenRes();
            if (n2 != this.getDispatcher().getScreenResolution()) {
                n = n * n2 / this.getDispatcher().getScreenResolution();
            }
            font = new Font("SansSerif", 0, n);
        } else {
            font = this.getDispatcher().getDefaultFont();
        }
        this.mStatusArea.setFont(font);
        this.mStatusArea.setLayout(new GridLayout(2, 1));
        this.mMessageBar = new StatusBar();
        this.mLampBar = new StatusBar();
        if (this.getDispatcher().getRecordNames()) {
            this.mMessageBar.setName(mSBarName + Integer.toString(mCount++));
            this.mLampBar.setName(mSBarName + Integer.toString(mCount++));
        }
        this.mStatusArea.setBackground(this.mMessageBar.getBackground());
        if (this.getDispatcher().getApplet().hasDarkLook() && this.getDispatcher().getApplet().hasCustomColorScheme() && ColorUtils.getApproximateLuminance(color = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.DESKTOP)) <= this.getDispatcher().getDarkLuminance()) {
            this.mStatusArea.setForeground(Color.white);
            this.mMessageBar.setForeground(Color.white);
            this.mLampBar.setForeground(Color.white);
        }
        this.mStatusArea.add(this.mMessageBar);
        StatusBarTextItem statusBarTextItem = new StatusBarTextItem("", -1, true);
        this.mAccessibilityText = new StatusBarTextItem("");
        this.mMessageBar.addItem(statusBarTextItem);
        this.mMessageBar.addItem(this.mAccessibilityText);
        this.mAccessibilityText.setVisible(false);
        LWContainer lWContainer = new LWContainer();
        lWContainer.setBorderPainter(new SeparatorBorderPainter(1, true, 0));
        this.mBusyBar = new StatsIndicator(runform, 30, " ");
        StatusBarUI statusBarUI = (StatusBarUI)this.mMessageBar.getUI();
        this.mBusyBar.setBorderPainter(statusBarUI.getItemBorderPainter(this.mMessageBar));
        this.mBusyBar.setBackground(this.mMessageBar.getBackground());
        this.mStatusArea.setBorderPainter(this.mLampBar.getBorderPainter());
        this.mLampBar.setBorderPainter(null);
        this.mMessageBar.setBorderPainter(null);
        this.arrangeStatusItems(lWContainer, this.getDirection(), false);
        this.mStatusArea.add(lWContainer);
        this.setComponent(this.mStatusArea);
        this.onUpdate(message);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        if (super.onUpdate(n, object)) {
            return true;
        }
        switch (n) {
            case 347: {
                this.mLampBar.addItem(new StatusBarTextItem("", (String)object, false));
                return true;
            }
            case 348: {
                this.mMessage = (String)object;
                this.updateMessage();
                return true;
            }
            case 349: {
                this.mCurrentLamp = (Integer)object;
                return true;
            }
            case 350: {
                if (this.mCurrentLamp < this.mLampBar.getItemCount()) {
                    ((StatusBarTextItem)this.mLampBar.getItem(this.mCurrentLamp)).setText((String)object);
                }
                return true;
            }
            case 351: {
                this.mMessage = this.getDispatcher().getWorkingMsg();
                this.updateMessage();
                return true;
            }
            case 352: {
                this.mMessage = null;
                this.updateMessage();
                return true;
            }
            case 522: {
                if (this.mLampBar != null) {
                    this.mLampBar.removeAll();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void onDestroy() {
        Runform runform = this.getDispatcher();
        if (runform != null && runform.getCurrentStatusBar() == this) {
            runform.setCurrentStatusBar(null);
        }
        super.onDestroy();
        if (this.mStatusArea != null) {
            this.mStatusArea.removeAll();
        }
        if (this.mMessageBar != null) {
            this.mMessageBar.removeAll();
        }
        if (this.mLampBar != null) {
            this.mLampBar.removeAll();
        }
        if (this.mBusyBar != null) {
            this.mBusyBar.kill();
        }
        this.mAccessibilityText = null;
        this.mMessageBar = null;
        this.mLampBar = null;
        this.mBusyBar = null;
        this.mStatusArea = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void doAddParent(int n) {
        MessageHandler messageHandler = this.getDispatcher().getHandler(n);
        ((FormCanvas)messageHandler).getPanel().add(this.mStatusArea);
        this.setDirection(((FormCanvas)messageHandler).getDirection());
    }

    @Override
    protected void setDirection(byte by) {
        super.setDirection(by);
        int n = this.getLWDirection(by);
        this.mMessageBar.setReadingDirection(n);
        this.mLampBar.setReadingDirection(n);
        this.arrangeStatusItems(this.mLampBar.getParent(), by, true);
    }

    private void arrangeStatusItems(Container container, byte by, boolean bl) {
        if (bl) {
            container.remove(this.mLampBar);
            container.remove(this.mBusyBar);
        }
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        if (by == 1) {
            gridBagConstraints.weightx = 8.0;
            container.add((Component)this.mLampBar, gridBagConstraints);
            gridBagConstraints.weightx = 2.0;
            container.add((Component)this.mBusyBar, gridBagConstraints);
        } else {
            gridBagConstraints.weightx = 2.0;
            container.add((Component)this.mBusyBar, gridBagConstraints);
            gridBagConstraints.weightx = 8.0;
            container.add((Component)this.mLampBar, gridBagConstraints);
        }
    }

    @Override
    public void setStatusBarProperty(int n, Object object) {
        switch (n) {
            case 6: {
                this.mBytesTotal = ((Integer)object).toString();
                this.mBusyBar.setBusyText(this.mBytesTotal + " : " + this.mRoundTrips);
                break;
            }
            case 7: {
                this.mRoundTrips = ((Integer)object).toString();
                this.mBusyBar.setBusyText(this.mBytesTotal + " : " + this.mRoundTrips);
                break;
            }
            case 8: {
                Main main2 = this.getApplet();
                if ((Boolean)object == Boolean.TRUE) {
                    String string = this.getParameter("hideActivityBar");
                    if (string != null && string.equalsIgnoreCase("true") || main2 instanceof MainRT) break;
                    this.mBusyBar.start();
                    break;
                }
                String string = this.getParameter("hideActivityBar");
                if (string != null && string.equalsIgnoreCase("true") || main2 instanceof MainRT) break;
                this.mBusyBar.stop();
                break;
            }
            case 10: {
                this.mHint = object == null ? null : object.toString();
                this.updateMessage();
                break;
            }
            case 9: {
                this.mMessage = object == null ? null : object.toString();
                this.updateMessage();
                break;
            }
            case 11: {
                this.mAccessibilityTextVal = (String)object;
                if (this.mAccessibilityTextVal != null) break;
                this.updateMessage();
                break;
            }
            case 12: {
                this.mBusyBar.setBusyText((String)object);
                break;
            }
        }
    }

    @Override
    public Object getStatusBarProperty(int n) {
        return null;
    }

    public void updateMessage() {
        if (this.mMessageBar != null) {
            StatusBarTextItem statusBarTextItem = (StatusBarTextItem)this.mMessageBar.getItem(0);
            if (statusBarTextItem != null) {
                if (this.mHint != null) {
                    statusBarTextItem.setText(this.mHint);
                } else if (this.mMessage != null) {
                    statusBarTextItem.setText(this.mMessage);
                } else {
                    statusBarTextItem.setText(null);
                }
            }
            if (this.mAccessibilityTextVal == null) {
                this.mAccessibilityText.setText("");
            } else {
                this.mAccessibilityText.setText(this.mAccessibilityTextVal);
            }
            this.mAccessibilityTextVal = null;
        }
    }
}

