/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import oracle.ewt.util.FocusUtils;

public class FormPrintableImpl
implements Printable {
    private Image mPrintImage;
    private double mImageWidth;
    private double mImageHeight;
    private String mPrintJobName;
    private boolean mIsJPSPrint = true;
    private boolean mRotateLandScapeImage = false;
    private static PrinterJob sPrintJob = null;
    private static PrintRequestAttributeSet sAttributes = null;

    public void setImage(Image image, int n, int n2) {
        this.mPrintImage = image;
        this.mImageWidth = n;
        this.mImageHeight = n2;
    }

    public void setJobName(String string) {
        this.mPrintJobName = string;
    }

    public boolean isJPSPrint() {
        return this.mIsJPSPrint;
    }

    public void setJPSPrint(boolean bl) {
        this.mIsJPSPrint = bl;
    }

    public static PrintRequestAttributeSet getAttributes() {
        return sAttributes;
    }

    public static void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        sAttributes = printRequestAttributeSet;
    }

    public static PrinterJob getPrintJob() {
        return sPrintJob;
    }

    public static void setPrintJob(PrinterJob printerJob) {
        sPrintJob = printerJob;
    }

    public boolean isRotateLandscapeImage() {
        return this.mRotateLandScapeImage;
    }

    public void setRotateLandscapeImage(boolean bl) {
        this.mRotateLandScapeImage = bl;
    }

    public void doPrint() {
        block19: {
            PrinterJob printerJob;
            if (sPrintJob == null) {
                sPrintJob = PrinterJob.getPrinterJob();
            }
            if ((printerJob = sPrintJob) != null) {
                if (this.mPrintJobName != null) {
                    printerJob.setJobName(this.mPrintJobName);
                }
                if (FocusUtils.areNewFocusAPIsAvailable() && this.isJPSPrint()) {
                    try {
                        if (sAttributes == null) {
                            sAttributes = new HashPrintRequestAttributeSet();
                        }
                        PrintRequestAttributeSet printRequestAttributeSet = sAttributes;
                        PageFormat pageFormat = new PageFormat();
                        printerJob.setPrintable(this, pageFormat);
                        Boolean bl = printerJob.printDialog(printRequestAttributeSet);
                        if (!bl.booleanValue()) break block19;
                        try {
                            if (this.isRotateLandscapeImage()) {
                                OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
                                if (orientationRequested != null && orientationRequested.getValue() == OrientationRequested.LANDSCAPE.getValue()) {
                                    DocAttribute docAttribute;
                                    printRequestAttributeSet.remove(orientationRequested);
                                    Paper paper = pageFormat.getPaper();
                                    double d = paper.getImageableWidth();
                                    double d2 = paper.getImageableHeight();
                                    MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
                                    if (mediaPrintableArea != null) {
                                        docAttribute = new MediaPrintableArea(mediaPrintableArea.getX(1), mediaPrintableArea.getY(1), mediaPrintableArea.getHeight(1), mediaPrintableArea.getWidth(1), 1);
                                        printRequestAttributeSet.remove(mediaPrintableArea);
                                        printRequestAttributeSet.add(docAttribute);
                                    }
                                    if ((docAttribute = (Media)printRequestAttributeSet.get(Media.class)) != null) {
                                        printRequestAttributeSet.remove(docAttribute);
                                    }
                                    Attribute[] attributeArray = printRequestAttributeSet.toArray();
                                    HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                                    for (int i = 0; i < attributeArray.length; ++i) {
                                        hashPrintRequestAttributeSet.add(attributeArray[i]);
                                    }
                                    pageFormat.setOrientation(1);
                                    paper.setSize(d2, d);
                                    pageFormat.setPaper(paper);
                                    printerJob.setPrintable(this, pageFormat);
                                    printerJob.print(hashPrintRequestAttributeSet);
                                }
                            } else {
                                printerJob.print(printRequestAttributeSet);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                } else {
                    printerJob.setPrintable(this);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.mImageWidth > pageFormat.getImageableWidth()) {
            d = pageFormat.getImageableWidth() / this.mImageWidth;
        }
        if (this.mImageHeight > pageFormat.getImageableHeight()) {
            d2 = pageFormat.getImageableHeight() / this.mImageHeight;
        }
        if ((d3 = Math.min(d, d2)) < 1.0) {
            this.mImageWidth *= d3;
            this.mImageHeight *= d3;
        }
        if (this.mPrintImage != null) {
            graphics2D.drawImage(this.mPrintImage, 0, 0, Math.round((float)this.mImageWidth), Math.round((float)this.mImageHeight), null);
        }
        return 0;
    }
}

