/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWCheckboxMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuListener;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.util.ClipboardProxy;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComboBoxItem;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.EndSubmenu;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.FormPrintableImpl;
import oracle.forms.handler.FormWindow;
import oracle.forms.handler.MenuInfo;
import oracle.forms.handler.MenuItemInfo;
import oracle.forms.handler.RadioMenuGroup;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.handler.TextFieldItem;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.RadioMenuItem;
import oracle.forms.ui.StatusBarInterface;
import oracle.forms.ui.VTextArea;
import oracle.forms.ui.mdi.MDIWindowMenu;

public class FormMenu
implements ActionListener,
PropertyChangeListener,
LWPopupMenuListener {
    private Component mTopMenu;
    private MenuInfo mNonVisMenu;
    private MessageHandler mRecipient;
    private Hashtable mIDs;
    private Hashtable mItems;
    private Runform mDispatcher;
    private LWMenuBar mlwMenuBar;
    private LWMenu mlwWindowMenu = null;
    private static int sIsAnyPopupShowing = 0;

    private FormMenu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormMenu(MenuInfo menuInfo, MessageHandler messageHandler, Runform runform, LWMenuBar lWMenuBar) {
        Object object;
        RadioMenuGroup radioMenuGroup = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Stack<Component> stack = new Stack<Component>();
        this.mIDs = new Hashtable();
        this.mItems = new Hashtable();
        this.mDispatcher = runform;
        this.mRecipient = messageHandler;
        this.mNonVisMenu = menuInfo;
        Vector vector = menuInfo.getItemList();
        int n = vector.size();
        if (messageHandler instanceof FormWindow) {
            this.mTopMenu = new LWMenuBar();
            this.mlwMenuBar = (LWMenuBar)this.mTopMenu;
            LWMenuBar.setMnemonicHandled(true);
            if (!this.mDispatcher.isSDIMode()) {
                bl2 = true;
            }
        } else {
            this.mTopMenu = new LWPopupMenu();
        }
        this.setColors(this.mTopMenu);
        if (n != 0) {
            stack.push(this.mTopMenu);
        }
        for (int i = 0; i < n; ++i) {
            Object object2;
            int n2;
            Object e = vector.elementAt(i);
            LWComponent lWComponent = (LWComponent)stack.peek();
            if (e instanceof EndSubmenu) {
                if (bl3) {
                    object = this.mDispatcher.getApplet();
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    synchronized (toolkit) {
                        lWComponent.add(new LWMenuSeparator());
                        lWComponent.add(((Main)object).getCascadeMenuItem());
                        lWComponent.add(((Main)object).getTileHMenuItem());
                        lWComponent.add(((Main)object).getTileVMenuItem());
                        lWComponent.add(new LWMenuSeparator());
                        lWComponent.add(new MDIWindowMenu(((Main)object).getDesktop(), (LWPopupMenu)lWComponent, this.mDispatcher));
                    }
                    bl = true;
                    bl3 = false;
                }
                stack.pop();
                continue;
            }
            MenuItemInfo menuItemInfo = (MenuItemInfo)e;
            int n3 = menuItemInfo.getID();
            short s = menuItemInfo.getType();
            if (s != 3) {
                if (s == 0) {
                    radioMenuGroup = null;
                    if (menuItemInfo.hasSubmenu()) {
                        LWPopupMenu lWPopupMenu = new LWPopupMenu();
                        object = new LWMenu(menuItemInfo.getLabel(), lWPopupMenu);
                        this.setColors((Component)object);
                        stack.push(lWPopupMenu);
                        if (n3 == 32783 && bl2) {
                            bl3 = true;
                        }
                        if (menuItemInfo.isHidden() || !menuItemInfo.isInMenu()) {
                            continue;
                        }
                    } else if (n3 == 32783 && bl2) {
                        object = this.mDispatcher.getApplet().getWindowMenu();
                        bl = true;
                        if (menuItemInfo.isHidden() || !menuItemInfo.isInMenu()) {
                            continue;
                        }
                    } else {
                        if (menuItemInfo.isHidden() || !menuItemInfo.isInMenu()) continue;
                        object = new LWMenuItem(menuItemInfo.getLabel());
                    }
                } else if (s == 1) {
                    radioMenuGroup = null;
                    if (menuItemInfo.isHidden() || !menuItemInfo.isInMenu()) continue;
                    object = new LWCheckboxMenuItem(menuItemInfo.getLabel(), menuItemInfo.isChecked());
                } else {
                    boolean bl4 = menuItemInfo.isChecked();
                    if (menuItemInfo.isStartGroup() || radioMenuGroup == null) {
                        radioMenuGroup = new RadioMenuGroup();
                        if (!bl4) {
                            for (n2 = i + 1; n2 < n; ++n2) {
                                e = vector.elementAt(n2);
                                if (e instanceof EndSubmenu) {
                                    bl4 = true;
                                    break;
                                }
                                MenuItemInfo menuItemInfo2 = (MenuItemInfo)e;
                                if (menuItemInfo2.getType() != 2 || menuItemInfo2.isStartGroup()) {
                                    bl4 = true;
                                    break;
                                }
                                if (menuItemInfo2.isChecked()) break;
                            }
                        }
                    }
                    object = new RadioMenuItem(radioMenuGroup, menuItemInfo.getLabel(), bl4);
                }
                if (!menuItemInfo.isHidden() && menuItemInfo.isInMenu()) {
                    if (menuItemInfo.getFont() == 0) {
                        ((LWComponent)object).setFont(LWComponent.DEFAULT_FONT);
                    } else {
                        ((LWComponent)object).setFont(runform.getFontEntry(menuItemInfo.getFont()));
                    }
                    ((LWComponent)object).setMnemonicChar(menuItemInfo.getMnemonic());
                    ((LWMenuItem)object).setAccelerator(menuItemInfo.getAccelerator());
                    ((LWComponent)object).setEnabled(menuItemInfo.isEnabled());
                    ((LWMenuItem)object).setHelpText(menuItemInfo.getHelpText());
                    if (menuItemInfo.isIconUsedInMenu()) {
                        ((LWMenuItem)object).setImage(menuItemInfo.getImage());
                    }
                    if (this.mDispatcher.getApplet().hasDarkLook() && this.mDispatcher.getApplet().hasCustomColorScheme()) {
                        Color color = lWComponent.getBackground();
                        if (color == null) {
                            color = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.DESKTOP);
                        }
                        if (ColorUtils.getApproximateLuminance(color) <= this.mDispatcher.getDarkLuminance()) {
                            ((LWComponent)object).setForeground(Color.white);
                        }
                    }
                    ((LWMenuItem)object).addPropertyChangeListener(this);
                    if (s != 2) {
                        ((LWMenuItem)object).addActionListener(this);
                    }
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    synchronized (toolkit) {
                        lWComponent.add((Component)object);
                    }
                }
                object2 = object;
                ((Component)object).setName(menuItemInfo.getName());
            } else {
                radioMenuGroup = null;
                if (menuItemInfo.isHidden() || !menuItemInfo.isInMenu() || lWComponent instanceof LWMenuBar) continue;
                boolean bl5 = true;
                if (lWComponent.getComponentCount() == 0) {
                    bl5 = false;
                }
                for (n2 = i + 1; n2 < n; ++n2) {
                    int n4;
                    e = vector.elementAt(n2);
                    if (e instanceof EndSubmenu) {
                        bl5 = false;
                        break;
                    }
                    if (((MenuItemInfo)e).getType() == 3) continue;
                    object = (MenuItemInfo)e;
                    if (!((MenuItemInfo)object).isHidden() && ((MenuItemInfo)object).isInMenu()) break;
                    if (!((MenuItemInfo)object).hasSubmenu()) continue;
                    int n5 = 1;
                    for (n4 = n2 + 1; n4 < n; ++n4) {
                        if (vector.elementAt(n4) instanceof EndSubmenu) {
                            --n5;
                        } else if (((MenuItemInfo)vector.elementAt(n4)).hasSubmenu()) {
                            ++n5;
                        }
                        if (n5 == 0) break;
                    }
                    n2 = n4;
                }
                i = n2 - 1;
                if (!bl5) continue;
                object = new LWMenuSeparator();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                synchronized (toolkit) {
                    lWComponent.add((Component)object);
                }
                object2 = object;
            }
            this.hashItem(n3, object2);
        }
        if (bl2 && !bl) {
            object = Toolkit.getDefaultToolkit();
            synchronized (object) {
                this.mlwWindowMenu = this.mDispatcher.getApplet().getWindowMenu();
                this.mlwMenuBar.add(this.mlwWindowMenu);
            }
        }
    }

    private void hashItem(int n, Object object) {
        if (n != 0) {
            Integer n2 = n;
            this.mIDs.put(n2, object);
            this.mItems.put(object, n2);
        }
    }

    public void changeState(LWMenuItem lWMenuItem, boolean bl) {
        RadioMenuItem radioMenuItem;
        Integer n = (Integer)this.mItems.get(lWMenuItem);
        if (n == null || n == 0) {
            throw new Error("FormMenu.changeState(): Unable to identify menu item " + lWMenuItem);
        }
        if (lWMenuItem instanceof RadioMenuItem && (radioMenuItem = ((RadioMenuItem)lWMenuItem).getRadioMenuGroup().getCurrent()) != null && radioMenuItem != lWMenuItem) {
            Integer n2 = (Integer)this.mItems.get(radioMenuItem);
            this.mNonVisMenu.setState(n2, false);
        }
        this.mNonVisMenu.setState(n, bl);
    }

    public void setState(Integer n, boolean bl) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            LWMenuItem lWMenuItem = (LWMenuItem)v;
            if (lWMenuItem instanceof LWCheckboxMenuItem) {
                ((LWCheckboxMenuItem)lWMenuItem).setState(bl);
            } else if (lWMenuItem instanceof RadioMenuItem) {
                ((RadioMenuItem)lWMenuItem).setState(bl);
            }
        }
    }

    public void setImage(Integer n, Image image) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            ((LWMenuItem)v).setImage(image);
        }
    }

    public void setLabel(Integer n, String string) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            ((LWMenuItem)v).setLabel(string);
        }
    }

    public void setMnemonic(Integer n, char c) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            ((LWMenuItem)v).setMnemonicChar(c);
        }
    }

    public void setEnabled(Integer n, boolean bl) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            ((LWMenuItem)v).setEnabled(bl);
        }
    }

    public void setHidden(Integer n, boolean bl) {
        Object v = this.mIDs.get(n);
        if (v != null && v instanceof LWMenuItem) {
            ((LWMenuItem)v).setVisible(bl);
        }
    }

    public Object getTopMenu() {
        return this.mTopMenu;
    }

    public MessageHandler getRecipient() {
        return this.mRecipient;
    }

    public MenuInfo getMenuInfo() {
        return this.mNonVisMenu;
    }

    public void show(MessageHandler messageHandler, int n, int n2) {
        this.mRecipient = messageHandler;
        LWComponent lWComponent = messageHandler instanceof FormCanvas ? ((FormCanvas)messageHandler).getPanel() : (LWComponent)((ComponentItem)messageHandler).getComponent();
        if (lWComponent instanceof VTextArea) {
            VTextArea vTextArea = (VTextArea)lWComponent;
            lWComponent = (LWComponent)vTextArea.getContent();
        }
        ((LWPopupMenu)this.mTopMenu).addPopupMenuListener(this);
        ((LWPopupMenu)this.mTopMenu).setReadingDirection(lWComponent.getActualReadingDirection());
        ((LWPopupMenu)this.mTopMenu).popup((Component)lWComponent, n, n2);
    }

    public boolean handleEvent(EventObject eventObject) {
        boolean bl = false;
        int n = 0;
        Integer n2 = (Integer)this.mItems.get(eventObject.getSource());
        if (this.mItems != null && n2 != null) {
            n = n2;
        }
        if (n != 0) {
            block34: {
                int n3 = this.mNonVisMenu.getOrigMenuID(n);
                if (n3 == 0) {
                    n3 = n;
                }
                if (n3 == 32771 || n3 == 32772 || n3 == 32774 || n3 == 32773) {
                    ComponentItem componentItem = this.mNonVisMenu.getDispatcher().getFocusOwner();
                    LWTextComponent lWTextComponent = null;
                    boolean bl2 = false;
                    if (componentItem != null && componentItem.getView() instanceof LWComponent) {
                        if (componentItem instanceof TextAreaItem) {
                            lWTextComponent = (LWTextArea)((VTextArea)componentItem.getView()).getContent();
                        } else if (componentItem instanceof TextFieldItem) {
                            lWTextComponent = (LWTextField)((Object)componentItem.getView());
                        } else if (componentItem instanceof ComboBoxItem) {
                            lWTextComponent = ((ComboBox)((Object)componentItem.getView())).getLWTextField();
                        }
                    }
                    if (lWTextComponent != null) {
                        if (n3 == 32771) {
                            lWTextComponent.cut();
                            bl2 = true;
                        } else if (n3 == 32772) {
                            lWTextComponent.copy();
                            bl2 = true;
                        } else if (n3 == 32774) {
                            lWTextComponent.clear();
                        } else if (n3 == 32773) {
                            lWTextComponent.paste();
                        }
                        if (bl2) {
                            Clipboard clipboard = ClipboardProxy.getSystemClipboard();
                            try {
                                boolean bl3 = this.mNonVisMenu.getApplet().isClipboardValidationDisabled();
                                if (!bl3) {
                                    Transferable transferable = clipboard.getContents(lWTextComponent);
                                    if (transferable != null && lWTextComponent.isOKToPaste(transferable)) {
                                        this.mNonVisMenu.doEnablePaste(true);
                                    }
                                    break block34;
                                }
                                this.mNonVisMenu.doEnablePaste(true);
                            }
                            catch (IllegalStateException illegalStateException) {
                                Main main2 = this.mNonVisMenu.getApplet();
                                ClipboardErrorUtils.displayMessage(main2.getErrorMessageGenerator(), main2.getTranslatedPhraseGenerator(), lWTextComponent.getParent(), main2.isAlertDialogAllowed());
                            }
                        }
                    }
                } else if (n3 == 32781) {
                    if (FormPrintableImpl.getPrintJob() == null) {
                        FormPrintableImpl.setPrintJob(PrinterJob.getPrinterJob());
                    }
                    if (FormPrintableImpl.getAttributes() == null) {
                        FormPrintableImpl.setAttributes(new HashPrintRequestAttributeSet());
                    }
                    PrinterJob printerJob = FormPrintableImpl.getPrintJob();
                    PrintRequestAttributeSet printRequestAttributeSet = FormPrintableImpl.getAttributes();
                    PageFormat pageFormat = null;
                    boolean bl4 = true;
                    pageFormat = printerJob.pageDialog(printRequestAttributeSet);
                } else {
                    int n4;
                    if (n3 == 32779 || n3 == 32784 || n3 == 32770) {
                        n4 = 478;
                    } else {
                        if (eventObject.getSource() instanceof LWCheckboxMenuItem) {
                            this.changeState((LWMenuItem)eventObject.getSource(), ((LWCheckboxMenuItem)eventObject.getSource()).getState());
                        } else if (eventObject.getSource() instanceof RadioMenuItem) {
                            this.changeState((LWMenuItem)eventObject.getSource(), ((RadioMenuItem)eventObject.getSource()).getState());
                        }
                        n4 = 477;
                    }
                    Message message = Message.newMessage(this.mRecipient, n4, (Object)n3);
                    this.mDispatcher.onMessage(message, 0);
                }
            }
            bl = true;
            if (this.mTopMenu instanceof LWPopupMenu) {
                // empty if block
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mDispatcher == null) {
            return;
        }
        if (actionEvent.getSource() instanceof LWMenuItem) {
            this.handleEvent(actionEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.mDispatcher == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == "selected") {
            String string2 = Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) ? ((LWMenuItem)propertyChangeEvent.getSource()).getHelpText() : null;
            StatusBarInterface statusBarInterface = this.mDispatcher.getCurrentStatusBar();
            if (statusBarInterface != null) {
                statusBarInterface.setStatusBarProperty(10, string2);
            }
        } else if (string == RadioMenuItem.PROPERTY_STATE && propertyChangeEvent.getSource() instanceof RadioMenuItem && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            this.handleEvent(propertyChangeEvent);
        }
    }

    public LWMenuItem getMenuItem(int n) {
        return null;
    }

    public static boolean isAnyPopupShowing() {
        return sIsAnyPopupShowing != 0;
    }

    public void destroy() {
        if (this.mlwWindowMenu != null) {
            this.mDispatcher.getApplet().cleanupWindowMenu(this.mlwWindowMenu);
            this.mlwWindowMenu = null;
        }
        if (this.mIDs != null) {
            this.mIDs.clear();
        }
        if (this.mItems != null) {
            this.mItems.clear();
        }
        if (this.mNonVisMenu != null) {
            this.mNonVisMenu.removeFormMenu(this);
        }
        this.mRecipient = null;
        this.mNonVisMenu = null;
        this.mIDs = null;
        this.mItems = null;
        this.mlwMenuBar = null;
        this.mTopMenu = null;
        this.mDispatcher = null;
    }

    private void setColors(Component component) {
        if (!this.mDispatcher.getApplet().hasOracleLF()) {
            component.setForeground(SystemColor.menuText);
            component.setBackground(SystemColor.menu);
        }
    }

    @Override
    public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
        --sIsAnyPopupShowing;
        ((LWPopupMenu)lWPopupMenuEvent.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void menuPoppedUp(LWPopupMenuEvent lWPopupMenuEvent) {
        ++sIsAnyPopupShowing;
    }

    @Override
    public void menuPoppingUp(LWPopupMenuEvent lWPopupMenuEvent) {
    }
}

