/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import java.util.Vector;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.DisplayList;
import oracle.forms.handler.FormWindow;
import oracle.forms.handler.Painter;
import oracle.forms.handler.PromptListItem;
import oracle.forms.handler.TabControl;
import oracle.forms.handler.UICommon;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.FScrollBox;
import oracle.forms.ui.FSplitter;
import oracle.forms.ui.FormsTabPanel;
import oracle.forms.ui.GenericBorderPainter;
import oracle.forms.ui.IView;
import oracle.forms.ui.OracleBorderPainter;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.VGImage;

public class FormCanvas
extends ComponentItem
implements AdjustmentListener,
Painter,
Device {
    private static int sHandlerClassId = 0;
    private DisplayList mBoilerplate = null;
    private DrawnPanel mPanel = null;
    private ScrollBox mScrollBox = null;
    private int mHDisplayPolicy = 2;
    private int mVDisplayPolicy = 2;
    private UICommon mParent = null;
    private boolean mIsTabPageInScrollBox = false;
    private PromptListItem mPromptListItem;
    private Vector mImage = new Vector();
    private static Toolkit mToolkit = null;
    private VGImage mBackgroundVGImage = null;
    private int mBackgroundIndex = -1;
    private boolean mBackgroundImageFixedSize = false;
    private Point mImageSizeWhenSet = null;
    private double mSmoothScalingMaxZoom = 0.0;
    private boolean mSizeInitialized = false;
    private boolean mDarkBackground = false;
    private Color mBackground = IView.DEFAULT_COLOR;
    private static BorderPainter[] sBorder = null;
    protected FSplitter mSplitter = null;
    private int mAnimationDelay = 0;
    static TaskScheduler sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    private transient Animator mAnimator;
    private transient Animator2 mToolbarAnimator;
    private boolean mMDIVToolbar = false;
    private boolean mMDIHToolbar = false;

    public FormCanvas() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.mPanel = new DrawnPanel();
        this.mDarkBackground = this.getApplet().hasDarkLook();
        this.mPanel.setFill(UIManager.getPainter(LookAndFeel.BACKGROUND_PAINTER));
        this.mPanel.setLayout(null);
        this.mPanel.setPainter(this);
        int n = message.size();
        for (int i = 0; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            if (n2 != 213) continue;
            byte by = (Byte)message.getValueAt(i);
            if (by != 3 && by != 2 && by != 4) {
                FontMetrics fontMetrics;
                this.mScrollBox = new FScrollBox(this.mPanel, 2, 2);
                this.mScrollBox.setBorderPainter(NullPainter.getPainter());
                this.mScrollBox.setHLineIncrement(8);
                this.mScrollBox.setVLineIncrement(8);
                this.mScrollBox.setHPageIncrement(64);
                this.mScrollBox.setVPageIncrement(64);
                Font font = this.mPanel.getFont();
                if (font != null && (fontMetrics = this.mPanel.getFontMetrics(font)) != null) {
                    this.mScrollBox.setHLineIncrement(fontMetrics.getMaxAdvance());
                    this.mScrollBox.setVLineIncrement(fontMetrics.getHeight());
                }
                this.mScrollBox.setWheelScrollingEnabled(false);
                this.setComponent(this.mScrollBox);
                break;
            }
            this.setComponent(this.mPanel);
            this.mPanel.setBorderPainter(NullPainter.getPainter());
            break;
        }
        this.onUpdate(message);
        if (!this.mSizeInitialized) {
            Point point = super.getSize();
            this.mPanel.setSize(point.x, point.y);
        }
        this.mSmoothScalingMaxZoom = this.getApplet().getSmoothScalingMaxZoom();
    }

    @Override
    public void setEventMask(Object object) {
        super.setEventMask(object);
        this.setMouseEventListeners();
    }

    @Override
    public void setMouseEventListeners() {
        if (this.isMouseClickEnabled() || this.isMouseCrossEnabled() || this.isPopupMenuEnabled()) {
            this.mPanel.addMouseListener(this);
            if (this.mScrollBox != null) {
                this.mScrollBox.addMouseListener(this);
            }
            if (this.mPanel.getParent() != null && this.mPanel.getParent().getParent() != null && this.mPanel.getParent().getParent() instanceof ScrollBox) {
                this.mPanel.getParent().addMouseListener(this);
            }
        }
        if (this.isMouseMoveEnabled()) {
            this.mPanel.addMouseMotionListener(this);
            if (this.mScrollBox != null) {
                this.mScrollBox.addMouseMotionListener(this);
            }
        }
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        int n2 = 0;
        MessageHandler messageHandler = null;
        Point point = null;
        switch (n) {
            case 213: {
                this.getPanel().setUsage((Byte)object);
                break;
            }
            case 130: {
                this.getPanel().setCanvasType((Byte)object);
                break;
            }
            case 139: {
                this.getDispatcher().setBIDIText();
                this.getPanel().setOrigin(this.mScrollBox, (Point)object);
                break;
            }
            case 594: {
                this.mAnimationDelay = (Integer)object;
                break;
            }
            case 597: {
                if (this.mSplitter == null) break;
                this.mSplitter.setEnabled((Boolean)object);
                break;
            }
            case 588: {
                if (this.mSplitter == null) break;
                if (this.mAnimationDelay == 0) {
                    this.mSplitter.setSplitterPosition((Integer)object);
                    break;
                }
                if (this.mAnimator == null) {
                    this.mAnimator = new Animator();
                }
                this.mAnimator.cancel();
                this.mAnimator.initValues((Integer)object, this.mAnimationDelay);
                this.mAnimationDelay = 0;
                this.mAnimator.start();
                break;
            }
            case 126: {
                if ((this.mPanel.getUsage() == 2 || this.mPanel.getUsage() == 3 || this.mPanel.getMDIFlag()) && this.mToolbarAnimator != null) {
                    if (this.mToolbarAnimator.getShow()) {
                        this.mToolbarAnimator.cancel();
                    }
                    this.mToolbarAnimator.setOrigSize((Point)object);
                }
                this.mPanel.setRealSize((Point)object);
                this.mPanel.setSize(((Point)object).x, ((Point)object).y);
                this.mSizeInitialized = true;
                break;
            }
            case 137: {
                if ((this.mPanel.getUsage() == 2 || this.mPanel.getUsage() == 3 || this.mPanel.getMDIFlag()) && this.mToolbarAnimator != null) {
                    if (this.mToolbarAnimator.getShow()) {
                        this.mToolbarAnimator.cancel();
                    }
                    this.mToolbarAnimator.setOrigSize((Point)object);
                }
                super.onUpdate(n, object);
                if (this.mScrollBox == null) break;
                this.updatePageIncrement();
                break;
            }
            case 165: {
                byte by = this.getDirection();
                this.setDirection((Byte)object);
                if (this.getDirection() == by) break;
                if (this.mPromptListItem != null) {
                    this.mPromptListItem.dirtyAllPrompts();
                }
                this.mPanel.repaint();
                break;
            }
            case 385: {
                this.doAddImageEntry(object, false);
                break;
            }
            case 569: {
                this.doAddImageEntry(object, true);
                this.mImageSizeWhenSet = this.mPanel.getRealSize();
                break;
            }
            case 570: {
                this.mBackgroundImageFixedSize = (Boolean)object;
                break;
            }
            case 146: {
                int n3 = (Integer)object;
                Color color = this.getHandler().getDispatcher().getColorEntry(n3);
                if (!(this.mScrollBox == null || this.getPanel().getUsage() == 5 && this.getPanel().getMDIFlag())) {
                    Container container = this.getPanel().getParent();
                    container.setForeground(color);
                    if (this.mGradientStart == 0) {
                        this.updatePattern(container, false);
                    }
                }
                this.getPanel().setForeground(color);
                super.onUpdate(n, object);
                if (this.mGradientStart != 0) break;
                this.updatePattern(this.getPanel(), false);
                break;
            }
            case 147: {
                int n4 = (Integer)object;
                this.mBackground = this.getHandler().getDispatcher().getColorEntry(n4);
                if (n4 != 255) {
                    this.setGradientColorSet(true);
                } else {
                    this.setGradientColorSet(false);
                }
                this.applyGradient(this.getPanel(), null, this.mBackground);
                super.onUpdate(n, object);
                if (!(this.mScrollBox == null || this.getPanel().getUsage() == 5 && this.getPanel().getMDIFlag())) {
                    Container container = this.getPanel().getParent();
                    container.setBackground(this.mBackground);
                    if (this.mGradientStart == 0) {
                        this.updatePattern(container, false);
                    }
                }
                this.getPanel().setBackground(this.mBackground);
                if (this.mGradientStart != 0) break;
                this.updatePattern(this.getPanel(), false);
                break;
            }
            case 568: {
                this.mGradientStart = (Byte)object;
                this.applyGradient(this.getPanel(), null, this.mBackground);
                break;
            }
            case 586: 
            case 587: {
                Point point2;
                int n5 = (Integer)object;
                boolean bl2 = false;
                if (n5 < 0) {
                    bl2 = true;
                    n5 *= -1;
                }
                FormCanvas formCanvas = (FormCanvas)this.getDispatcher().getHandler(n5);
                Component component = formCanvas.getComponent();
                Container container = this.mScrollBox.getParent();
                this.mSplitter = bl2 ? new FSplitter(this.mScrollBox, component, n == 587) : new FSplitter(component, this.mScrollBox, n == 587);
                container.add((Component)this.mSplitter, 0);
                Dimension dimension = new Dimension(0, 0);
                this.mScrollBox.setMinimumSize(dimension);
                component.setMinimumSize(dimension);
                formCanvas.setSplitter(this.mSplitter);
                if (bl2) {
                    this.mSplitter.setSize(component.getWidth(), component.getHeight());
                    point2 = component.getLocation();
                } else {
                    this.mSplitter.setSize(this.mScrollBox.getWidth(), this.mScrollBox.getHeight());
                    point2 = this.mScrollBox.getLocation();
                }
                this.mSplitter.setLocation(point2.x, point2.y);
                break;
            }
            case 148: {
                super.onUpdate(n, object);
                if (!(this.mScrollBox == null || this.getPanel().getUsage() == 5 && this.getPanel().getMDIFlag() || this.mGradientStart != 0)) {
                    this.updatePattern(this.getPanel().getParent(), true);
                }
                if (this.mGradientStart != 0) break;
                this.updatePattern(this.getPanel(), true);
                break;
            }
            case 257: {
                n2 = (Integer)object;
                messageHandler = this.getDispatcher().getHandler(n2);
                break;
            }
            case 258: {
                if (object instanceof Byte) {
                    this.mHDisplayPolicy = 0;
                    this.mScrollBox.setHDisplayPolicy(this.mHDisplayPolicy);
                    this.mScrollBox.addHAdjustmentListener(this);
                    this.mScrollBox.setWheelScrollingEnabled(true);
                    break;
                }
                if (((Boolean)object).booleanValue()) {
                    this.mHDisplayPolicy = 1;
                    this.mScrollBox.setHDisplayPolicy(this.mHDisplayPolicy);
                    this.mScrollBox.addHAdjustmentListener(this);
                    this.mScrollBox.setWheelScrollingEnabled(true);
                    break;
                }
                this.mHDisplayPolicy = 2;
                this.mScrollBox.setHDisplayPolicy(this.mHDisplayPolicy);
                this.mScrollBox.removeHAdjustmentListener(this);
                this.mScrollBox.setWheelScrollingEnabled(false);
                break;
            }
            case 259: {
                if (object instanceof Byte) {
                    this.mVDisplayPolicy = 0;
                    this.mScrollBox.setVDisplayPolicy(this.mVDisplayPolicy);
                    this.mScrollBox.addVAdjustmentListener(this);
                    this.mScrollBox.setWheelScrollingEnabled(true);
                    break;
                }
                if (((Boolean)object).booleanValue()) {
                    this.mVDisplayPolicy = 1;
                    this.mScrollBox.setVDisplayPolicy(this.mVDisplayPolicy);
                    this.mScrollBox.addVAdjustmentListener(this);
                    this.mScrollBox.setWheelScrollingEnabled(true);
                    break;
                }
                this.mVDisplayPolicy = 2;
                this.mScrollBox.setVDisplayPolicy(this.mVDisplayPolicy);
                this.mScrollBox.removeVAdjustmentListener(this);
                this.mScrollBox.setWheelScrollingEnabled(false);
                break;
            }
            case 260: {
                point = (Point)object;
                break;
            }
            case 215: {
                this.getPanel().setMDIFlag((Boolean)object);
                break;
            }
            case 174: {
                Object object2;
                if (this.getEventComponent() instanceof FScrollBox && this.getDispatcher().getFocusOwner() != null && this.getDispatcher().getFocusOwner().getParentWindow() == this.getParentWindow()) {
                    object2 = Message.newMessage(this.getDispatcher().getFocusOwner(), 174, Boolean.FALSE);
                    this.getDispatcher().onMessage((Message)object2, 1);
                    this.getDispatcher().setFocusOwner(null);
                }
                if ((object2 = this.getParentWindow()) == null || !((LWWindow)object2).isActive() || ((LWWindow)object2).isMinimized()) break;
                bl = super.onUpdate(n, object);
                break;
            }
            case 173: {
                boolean bl3 = (Boolean)object;
                if (!bl3 && this.mPanel.getUsage() == 5 && this.mPanel.getParent() instanceof DrawnPanel && this.getApplet().getHidingToolbar() != null && (((DrawnPanel)this.mPanel.getParent()).getUsage() == 2 || ((DrawnPanel)this.mPanel.getParent()).getUsage() == 3)) {
                    this.getApplet().getHidingToolbar().getToolbarAnimator().setHidingChildView(this);
                    this.getApplet().setHidingToolbar(null);
                    break;
                }
                if (this.mAnimationDelay != 0 && (this.mPanel.getUsage() == 2 || this.mPanel.getUsage() == 3 || this.mPanel.getMDIFlag()) && !bl3) {
                    if (this.mPanel.getUsage() == 2 || this.mPanel.getUsage() == 3) {
                        this.getApplet().setHidingToolbar(this);
                    }
                    if (this.mToolbarAnimator == null) {
                        this.mToolbarAnimator = new Animator2();
                        this.mToolbarAnimator.initValues(this.mPanel.getRealSize(), this.mAnimationDelay, bl3, this.mPanel.getUsage() == 2 || this.mMDIVToolbar);
                    } else {
                        this.mToolbarAnimator.cancel();
                        this.mToolbarAnimator.setShow(bl3);
                        this.mToolbarAnimator.setDelay(this.mAnimationDelay);
                    }
                    this.mAnimationDelay = 0;
                    this.mToolbarAnimator.start();
                    break;
                }
                if ((this.mAnimationDelay != 0 || this.mToolbarAnimator != null) && (this.mPanel.getUsage() == 2 || this.mPanel.getUsage() == 3 || this.mPanel.getMDIFlag()) && bl3) {
                    Point point3 = this.mToolbarAnimator != null ? this.mToolbarAnimator.getOrigSize() : this.mPanel.getRealSize();
                    boolean bl4 = this.mPanel.getUsage() == 2 || this.mMDIVToolbar;
                    int n6 = point3.x;
                    int n7 = point3.y;
                    if (this.mAnimationDelay != 0) {
                        if (this.mToolbarAnimator == null) {
                            this.mToolbarAnimator = new Animator2();
                            this.mToolbarAnimator.initValues(point3, this.mAnimationDelay, bl3, bl4);
                        } else {
                            this.mToolbarAnimator.cancel();
                            this.mToolbarAnimator.setShow(bl3);
                            this.mToolbarAnimator.setDelay(this.mAnimationDelay);
                        }
                    } else if (this.mToolbarAnimator != null) {
                        this.mToolbarAnimator.cancel();
                    }
                    if (bl4) {
                        point3.x = 1;
                    } else {
                        point3.y = 1;
                    }
                    this.mPanel.setRealSize(point3);
                    this.mPanel.setSize(point3.x, point3.y);
                    if (!this.mPanel.getMDIFlag()) {
                        this.getParentWindow().validate();
                    }
                    bl = super.onUpdate(n, object);
                    point3.x = n6;
                    point3.y = n7;
                    boolean bl5 = this.mAnimationDelay != 0;
                    this.mAnimationDelay = 0;
                    if (bl5) {
                        this.mToolbarAnimator.start();
                        break;
                    }
                    this.mPanel.setRealSize(point3);
                    this.mPanel.setSize(point3.x, point3.y);
                    break;
                }
                bl = super.onUpdate(n, object);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
                if (this.mScrollBox == null || n != 136 && n != 137) break;
                this.updatePageIncrement();
            }
        }
        return bl;
    }

    @Override
    public synchronized Object onGet(int n) {
        Object object = null;
        switch (n) {
            case 139: {
                object = this.mPanel.getLocation();
                break;
            }
            case 588: {
                if (this.mSplitter != null) {
                    object = this.mSplitter.getSplitterPosition();
                    break;
                }
                object = 0;
                break;
            }
            case 126: {
                if (!this.mSizeInitialized && this.mPanel.getUsage() == 1) {
                    this.mPanel.doLayout();
                    Point point = new Point(this.mPanel.getSize().width, this.mPanel.getSize().height);
                    this.mPanel.setRealSize(point);
                    this.mSizeInitialized = true;
                }
                object = this.getSize();
                break;
            }
            default: {
                object = super.onGet(n);
            }
        }
        return object;
    }

    @Override
    protected void setDirection(byte by) {
        super.setDirection(by);
        this.mPanel.setReadingDirection(this.getLWDirection(by));
        this.mPanel.repaint();
    }

    private void doAddImageEntry(Object object, boolean bl) {
        Image image;
        boolean bl2 = false;
        if (object instanceof String) {
            image = this.getApplet().getCustomImage((String)object);
        } else {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                image = null;
                bl2 = true;
            } else {
                if (mToolkit == null) {
                    mToolkit = this.getApplet().getToolkit();
                }
                image = mToolkit.createImage(byArray);
            }
        }
        if (image == null && !bl2) {
            image = this.getApplet().getDefaultImage("badimage");
        }
        if (this.mBackgroundVGImage == null) {
            if (bl) {
                this.mBackgroundIndex = this.mImage.size();
                this.mBackgroundVGImage = new VGImage();
                this.mBackgroundVGImage.setImageID(this.mBackgroundIndex);
                if (this.mBoilerplate != null) {
                    this.mBoilerplate.addBackgroundImage(this.mBackgroundVGImage);
                }
            }
            this.mImage.add(image);
        } else {
            if (!bl) {
                throw new IllegalStateException("non-background image encountered after background image");
            }
            this.mImage.set(this.mBackgroundIndex, image);
        }
        if (bl) {
            this.mBackgroundVGImage.setDirty(true);
            if (this.mBoilerplate != null) {
                this.getComponent().repaint();
            }
        }
    }

    @Override
    public Component getComponent() {
        return super.getComponent();
    }

    public DrawnPanel getPanel() {
        return this.mPanel;
    }

    @Override
    public void doAddParent(int n) {
        MessageHandler messageHandler = this.getDispatcher().getHandler(n);
        if (messageHandler instanceof FormCanvas) {
            this.mParent = (UICommon)messageHandler;
            DrawnPanel drawnPanel = ((FormCanvas)messageHandler).getPanel();
            byte by = drawnPanel.getUsage();
            if (by == 2 || by == 3) {
                if (this.getApplet().hasOracleLF()) {
                    UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
                    Color color = uIDefaults.getColor(LookAndFeel.LIGHT_INTENSITY);
                    this.getPanel().setBackground(color);
                } else {
                    this.getPanel().setForeground(SystemColor.menuText);
                    this.getPanel().setBackground(SystemColor.menu);
                }
                this.getPanel().setBorderPainter(NullPainter.getPainter());
            }
            if (by == 2 || by == 3 || by == 4) {
                drawnPanel.add((Component)this.getPanel(), 0);
            } else if (!(this.getComponent().getParent() instanceof FSplitter)) {
                drawnPanel.add(this.getComponent(), 0);
            }
        } else if (messageHandler instanceof TabControl) {
            this.mIsTabPageInScrollBox = this.mScrollBox != null;
        } else if (messageHandler instanceof FormWindow) {
            this.mParent = (UICommon)messageHandler;
            switch (this.getPanel().getUsage()) {
                case 1: {
                    ((FormWindow)messageHandler).setContent(this);
                    break;
                }
                case 2: {
                    ((FormWindow)messageHandler).setVerticalToolbar(this);
                    break;
                }
                case 3: {
                    ((FormWindow)messageHandler).setHorizontalToolbar(this);
                    break;
                }
                case 4: {
                    ((FormWindow)messageHandler).setStatusBar(this);
                    break;
                }
                case 5: {
                    if (this.getPanel().getMDIFlag()) {
                        Container container = this.getPanel().getParent();
                        if (container != null) {
                            container.remove(this.getPanel());
                        }
                        this.setComponent(this.getPanel());
                        break;
                    }
                    this.getPanel().addFocusListener(this);
                    this.getPanel().addKeyListener(this);
                    break;
                }
            }
        }
        if (this.isPatternPending() && this.mGradientStart == 0) {
            this.updatePattern(this.getPanel(), false);
        }
        this.applyGradient(this.getPanel(), null, this.mBackground);
    }

    @Override
    public void doShowComponent(boolean bl) {
        boolean bl2 = FormCanvas.isFocusHidden();
        FormCanvas.setFocusHidden(true);
        if (!bl) {
            this.loseFocusIfNecessary();
        }
        if (this.mScrollBox != null) {
            this.mScrollBox.setVisible(bl);
            this.updatePageIncrement();
            if (this.mSplitter != null) {
                boolean bl3;
                boolean bl4 = this.mSplitter.getComponent(0) != null && this.mSplitter.getComponent(0).isVisible();
                boolean bl5 = bl3 = this.mSplitter.getComponent(1) != null && this.mSplitter.getComponent(1).isVisible();
                if (bl4 || bl3) {
                    this.mSplitter.setVisible(true);
                } else {
                    this.mSplitter.setVisible(false);
                }
            }
        }
        this.setBackground();
        if (this.isPatternPending() && this.mGradientStart == 0) {
            this.updatePattern(this.getPanel(), false);
        }
        this.mPanel.setVisible(bl);
        FormCanvas.setFocusHidden(bl2);
    }

    @Override
    public Point getSize() {
        return this.getPanel().getRealSize();
    }

    public Point getOrigin() {
        return this.getPanel().getOrigin();
    }

    private void stopListening() {
        if (this.mPanel != null) {
            if (this.isMouseClickEnabled() || this.isMouseCrossEnabled() || this.isPopupMenuEnabled()) {
                this.mPanel.removeMouseListener(this);
            }
            if (this.isMouseMoveEnabled()) {
                this.mPanel.removeMouseMotionListener(this);
            }
            if (this.mPanel.getUsage() == 5) {
                this.mPanel.removeFocusListener(this);
                this.mPanel.removeKeyListener(this);
            }
            if (this.mPanel.getParent() != null && this.mPanel.getParent().getParent() != null && this.mPanel.getParent().getParent() instanceof ScrollBox) {
                this.mPanel.getParent().removeMouseListener(this);
            }
        }
        if (this.mScrollBox != null) {
            if (this.isMouseClickEnabled() || this.isMouseCrossEnabled() || this.isPopupMenuEnabled()) {
                this.mScrollBox.removeMouseListener(this);
            }
            if (this.isMouseMoveEnabled()) {
                this.mScrollBox.removeMouseMotionListener(this);
            }
            if (this.mHDisplayPolicy == 1) {
                this.mScrollBox.removeHAdjustmentListener(this);
            }
            if (this.mVDisplayPolicy == 1) {
                this.mScrollBox.removeVAdjustmentListener(this);
            }
        }
    }

    @Override
    public synchronized void onDestroy() {
        if (this.mParent != null && this.mParent instanceof FormWindow) {
            switch (this.getPanel().getUsage()) {
                case 2: {
                    ((FormWindow)this.mParent).setVerticalToolbar(null);
                    break;
                }
                case 3: {
                    ((FormWindow)this.mParent).setHorizontalToolbar(null);
                    break;
                }
                case 4: {
                    ((FormWindow)this.mParent).setStatusBar(null);
                    break;
                }
            }
        }
        this.stopListening();
        if (this.mPanel != null) {
            this.mPanel.removeAll();
            this.mPanel.destroy();
        }
        if (this.mScrollBox != null) {
            this.mScrollBox.removeAll();
            if (this.mSplitter != null) {
                this.mSplitter.remove(this.mScrollBox);
            }
        }
        if (this.mImage != null) {
            this.mImage.removeAllElements();
        }
        super.onDestroy();
        this.mPanel = null;
        this.mScrollBox = null;
        this.mBoilerplate = null;
        this.mPromptListItem = null;
        this.mImage = null;
        this.mSplitter = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.getDispatcher().setScrollObserver(this.getHandler());
        this.getPanel().setUserScrolled(true);
    }

    @Override
    public Message getFinalMessage() {
        Point point = this.mPanel.getLocation();
        Message message = Message.newMessage(this.getHandler(), 139, point);
        this.getDispatcher().clearScrollObserver(false);
        return message;
    }

    public void addGraphic(DisplayList displayList) {
        this.mBoilerplate = displayList;
        if (this.mBackgroundVGImage != null) {
            this.mBoilerplate.addBackgroundImage(this.mBackgroundVGImage);
        }
        this.getComponent().repaint();
    }

    public void addPromptListItem(PromptListItem promptListItem) {
        this.mPromptListItem = promptListItem;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void paint(Graphics graphics, Dimension dimension, Rectangle rectangle) {
        if (this.mBoilerplate != null) {
            if (this.mBackgroundVGImage != null) {
                Point point;
                if (this.mBackgroundImageFixedSize) {
                    point = this.mImageSizeWhenSet;
                } else if (!this.mIsTabPageInScrollBox) {
                    point = this.mPanel.getRealSize();
                } else {
                    Dimension dimension2 = this.mScrollBox.getInnerSize();
                    point = new Point(dimension2.width, dimension2.height);
                }
                if (point.x != this.mBackgroundVGImage.getWidth() || point.y != this.mBackgroundVGImage.getHeight()) {
                    this.mBackgroundVGImage.setWidth(point.x);
                    this.mBackgroundVGImage.setHeight(point.y);
                    this.mBackgroundVGImage.setClipRect(new Rectangle(0, 0, point.x, point.y));
                    this.mBackgroundVGImage.setDirty(true);
                }
            }
            this.mBoilerplate.drawGraphic(graphics, this);
        }
        if (this.mPromptListItem != null) {
            this.mPromptListItem.onDraw(graphics, this);
        }
    }

    @Override
    public Color getColorEntry(int n) {
        Color color;
        int n2;
        Color color2 = this.getDispatcher().getColorEntry(n);
        if (this.mDarkBackground && Color.black.equals(color2) && (n2 = ColorUtils.getApproximateLuminance(color = this.getPanel().getBackground())) <= this.getDispatcher().getDarkLuminance()) {
            color2 = Color.white;
        }
        return color2;
    }

    @Override
    public Font getFontEntry(int n) {
        return this.getDispatcher().getFontEntry(n);
    }

    @Override
    public byte getStyle(int n) {
        return this.getDispatcher().getStyle(n);
    }

    @Override
    public Image getImageEntry(int n) {
        Image image;
        if (n < 0 || n >= this.mImage.size()) {
            image = null;
        } else {
            image = (Image)this.mImage.elementAt(n);
            if (image != null && !ImageUtils.loadImage(image)) {
                image = null;
            }
        }
        if (n == this.mBackgroundIndex && image != null) {
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            int n4 = this.mBackgroundVGImage.getWidth();
            int n5 = this.mBackgroundVGImage.getHeight();
            if (n2 > 0 && n3 > 0 && (double)n4 / (double)n2 <= this.mSmoothScalingMaxZoom && (double)n5 / (double)n3 <= this.mSmoothScalingMaxZoom) {
                image = image.getScaledInstance(n4, n5, 4);
                ImageUtils.loadImage(image);
            }
        }
        return image;
    }

    public char[] getSymbolEntry(int n) {
        return null;
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return this.getComponent().createImage(imageProducer);
    }

    @Override
    public Image createImage(int n, int n2) {
        return this.getComponent().createImage(n, n2);
    }

    @Override
    public byte getDeviceDirection() {
        return this.getDirection();
    }

    @Override
    public Point getDeviceSize() {
        return this.getSize();
    }

    @Override
    protected void setBorderBevel(int n) {
        DrawnPanel drawnPanel;
        if (sBorder == null) {
            sBorder = new BorderPainter[3];
            FormCanvas.sBorder[0] = NullPainter.getPainter();
            if (this.getApplet().hasOracleLF()) {
                FormCanvas.sBorder[1] = new OracleBorderPainter(1);
                FormCanvas.sBorder[2] = new OracleBorderPainter(2);
            } else {
                FormCanvas.sBorder[1] = new GenericBorderPainter(1);
                FormCanvas.sBorder[2] = new GenericBorderPainter(2);
            }
        }
        this.mScrollBox.setBorderPainter(sBorder[n]);
        if (this.mParent != null && this.mParent instanceof FormCanvas && ((drawnPanel = ((FormCanvas)this.mParent).getPanel()).getUsage() == 2 || drawnPanel.getUsage() == 3)) {
            drawnPanel.setBorderPainter(sBorder[n]);
        }
    }

    private void updatePageIncrement() {
        if (this.mScrollBox != null && this.mScrollBox.isVisible()) {
            if (!this.mScrollBox.isValid()) {
                this.mScrollBox.validate();
            }
            Dimension dimension = this.mScrollBox.getViewPortSize();
            if (dimension.width != 0) {
                this.mScrollBox.setHPageIncrement(dimension.width);
            }
            if (dimension.height != 0) {
                this.mScrollBox.setVPageIncrement(dimension.height);
            }
        }
    }

    public void setBackground() {
        Container container;
        if (this.mBackground == LWComponent.DEFAULT_COLOR && this.mDarkBackground && this.getPanel().getCanvasType() != 0 && (container = this.getComponent().getParent()) != null) {
            Component[] componentArray = container.getComponents();
            Point point = this.getComponent().getLocation();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof TabPanel)) continue;
                Rectangle rectangle = componentArray[i].getBounds();
                if (rectangle.x > point.x || point.x >= rectangle.x + rectangle.width || rectangle.y > point.y || point.y >= rectangle.y + rectangle.height) continue;
                if (this.mScrollBox != null) {
                    this.getPanel().getParent().setBackground(UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.CONTROL));
                }
                this.getPanel().setBackground(UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.CONTROL));
                break;
            }
        }
    }

    private void loseFocusIfNecessary() {
        ComponentItem componentItem = this.getDispatcher().getFocusOwner();
        if (componentItem != null) {
            LWWindow lWWindow;
            DrawnPanel drawnPanel;
            boolean bl;
            DrawnPanel drawnPanel2 = componentItem.getContentView();
            Container container = componentItem.getComponent().getParent();
            boolean bl2 = bl = container == (drawnPanel = this.getPanel());
            while (!bl && container != drawnPanel2 && container != null) {
                if ((container = container.getParent()) != drawnPanel) continue;
                bl = true;
            }
            if (bl && (lWWindow = componentItem.getParentWindow()) != null && lWWindow instanceof ExtendedFrame) {
                ((ExtendedFrame)lWWindow).loseFocus();
            }
        }
    }

    public boolean isTabCanvas() {
        boolean bl = false;
        for (Container container = this.getPanel(); container != null && !(container instanceof LWWindow) && !bl; container = container.getParent()) {
            if (!(container instanceof FormsTabPanel)) continue;
            bl = true;
        }
        return bl;
    }

    public void setSplitter(FSplitter fSplitter) {
        this.mSplitter = fSplitter;
    }

    public FSplitter getSplitter() {
        return this.mSplitter;
    }

    public void setIsMDIVToolbar(boolean bl) {
        this.mMDIVToolbar = bl;
    }

    public void setIsMDIHToolbar(boolean bl) {
        this.mMDIHToolbar = bl;
    }

    public Animator2 getToolbarAnimator() {
        return this.mToolbarAnimator;
    }

    private class Animator
    implements Task {
        public int mDelay = 1;
        public int mTarget = 0;

        private Animator() {
        }

        public void initValues(int n, int n2) {
            this.mTarget = n;
            this.mDelay = n2;
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            int n = FormCanvas.this.mSplitter.getSplitterPosition();
            int n2 = this.mTarget - n;
            if (n == -1) {
                return;
            }
            if (n2 == 0) {
                return;
            }
            if (n2 > 2) {
                n2 = 2;
            } else if (n2 < -2) {
                n2 = -2;
            }
            FormCanvas.this.mSplitter.setSplitterPosition(n + n2);
            if (Integer.valueOf(FormCanvas.this.mSplitter.getSplitterPosition()) == n) {
                return;
            }
            sTaskScheduler.schedule(this, this.mDelay);
        }

        public void start() {
            sTaskScheduler.schedule(this, 1);
        }

        public void cancel() {
            sTaskScheduler.cancel(this);
        }
    }

    private class Animator2
    implements Task {
        private int mDelay = 1;
        private Point mOrigSize;
        private boolean mShow = true;
        private boolean mVert = true;
        private FormCanvas mHidingChildView = null;

        private Animator2() {
        }

        public void initValues(Point point, int n, boolean bl, boolean bl2) {
            this.mOrigSize = new Point(point.x, point.y);
            this.mDelay = n;
            this.mShow = bl;
            this.mVert = bl2;
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            Point point = FormCanvas.this.mPanel.getRealSize();
            boolean bl = false;
            if (!this.mShow) {
                if (this.mVert) {
                    if (point.x < 4) {
                        bl = true;
                        FormCanvas.this.mPanel.setRealSize(new Point(1, point.y));
                        FormCanvas.this.mPanel.setSize(1, point.y);
                    } else {
                        FormCanvas.this.mPanel.setRealSize(new Point(point.x - 2, point.y));
                        FormCanvas.this.mPanel.setSize(point.x - 2, point.y);
                        if (!FormCanvas.this.mPanel.getMDIFlag()) {
                            FormCanvas.this.getParentWindow().validate();
                        }
                    }
                } else if (point.y < 4) {
                    bl = true;
                    FormCanvas.this.mPanel.setRealSize(new Point(point.x, 1));
                    FormCanvas.this.mPanel.setSize(point.x, 1);
                } else {
                    FormCanvas.this.mPanel.setRealSize(new Point(point.x, point.y - 2));
                    FormCanvas.this.mPanel.setSize(point.x, point.y - 2);
                    if (!FormCanvas.this.mPanel.getMDIFlag()) {
                        FormCanvas.this.getParentWindow().validate();
                    }
                }
            } else if (this.mVert) {
                if (point.x >= this.mOrigSize.x - 2) {
                    FormCanvas.this.mPanel.setRealSize(this.mOrigSize);
                    FormCanvas.this.mPanel.setSize(this.mOrigSize.x, this.mOrigSize.y);
                    if (!FormCanvas.this.mPanel.getMDIFlag()) {
                        FormCanvas.this.getParentWindow().validate();
                    }
                    return;
                }
                FormCanvas.this.mPanel.setRealSize(new Point(point.x + 2, point.y));
                FormCanvas.this.mPanel.setSize(point.x + 2, point.y);
                if (!FormCanvas.this.mPanel.getMDIFlag()) {
                    FormCanvas.this.getParentWindow().validate();
                }
            } else {
                if (point.y >= this.mOrigSize.y - 2) {
                    FormCanvas.this.mPanel.setRealSize(this.mOrigSize);
                    FormCanvas.this.mPanel.setSize(this.mOrigSize.x, this.mOrigSize.y);
                    if (!FormCanvas.this.mPanel.getMDIFlag()) {
                        FormCanvas.this.getParentWindow().validate();
                    }
                    return;
                }
                FormCanvas.this.mPanel.setRealSize(new Point(point.x, point.y + 2));
                FormCanvas.this.mPanel.setSize(point.x, point.y + 2);
                if (!FormCanvas.this.mPanel.getMDIFlag()) {
                    FormCanvas.this.getParentWindow().validate();
                }
            }
            if (bl) {
                boolean bl2 = FormCanvas.super.onUpdate(173, false);
                FormCanvas.this.mPanel.setRealSize(this.mOrigSize);
                FormCanvas.this.mPanel.setSize(this.mOrigSize.x, this.mOrigSize.y);
                if (this.mHidingChildView != null) {
                    this.mHidingChildView.onUpdate(173, false);
                }
                this.mHidingChildView = null;
                if (!FormCanvas.this.mPanel.getMDIFlag()) {
                    FormCanvas.this.getParentWindow().validate();
                }
                return;
            }
            sTaskScheduler.schedule(this, this.mDelay);
        }

        public void start() {
            sTaskScheduler.schedule(this, 1);
        }

        public void setShow(boolean bl) {
            this.mShow = bl;
        }

        public boolean getShow() {
            return this.mShow;
        }

        public void setDelay(int n) {
            this.mDelay = n;
        }

        public void setOrigSize(Point point) {
            this.mOrigSize = point;
        }

        public Point getOrigSize() {
            return this.mOrigSize;
        }

        public void setHidingChildView(FormCanvas formCanvas) {
            this.mHidingChildView = formCanvas;
        }

        public void cancel() {
            if (this.mHidingChildView != null) {
                this.mHidingChildView.onUpdate(173, false);
            }
            this.mHidingChildView = null;
            sTaskScheduler.cancel(this);
        }
    }
}

