/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.PrintStream;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;
import oracle.forms.ui.GenericBorderPainter;
import oracle.forms.ui.OracleBorderPainter;
import oracle.forms.ui.VTextField;

public class FieldDialog
extends CommonDialog
implements ActionListener,
FocusListener,
TextListener,
MouseListener {
    private static int sHandlerClassId = 0;
    private LWLabel mLabel1;
    private VTextField mField1;
    private PushButton mOKButton;
    private PushButton mCancelButton;
    private boolean mForceFieldFocus = true;
    private static final int FIELD_MARGIN = 10;
    private static final int FIELD_SPACING = 6;
    public static final String DEFAULT_FIELD_DLG_NAME = "Forms_Field_Dialog";

    public FieldDialog() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonBar buttonBar = new ButtonBar();
        super.onCreate(runform, message);
        this.mDialog = this.createDialog(runform.getFrame(), true);
        this.setComponent(this.mDialog);
        this.getContent().setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.mLabel1 = new LWLabel();
        this.mField1 = new VTextField(runform);
        this.mField1.setText("");
        this.mField1.addKeyListener(this);
        this.mLabel1.setLabelFor(this.mField1);
        AbstractBorderPainter abstractBorderPainter = this.getApplet().hasOracleLF() ? new OracleBorderPainter() : new GenericBorderPainter();
        this.mField1.setBorderPainter(abstractBorderPainter);
        this.mOKButton = new PushButton("OK");
        this.mOKButton.addActionListener(this);
        this.mOKButton.addKeyListener(this);
        this.mCancelButton = new PushButton("Cancel");
        this.mCancelButton.addActionListener(this);
        this.mCancelButton.addKeyListener(this);
        this.onUpdate(message);
        byte by = this.getDirection();
        if (by == 2) {
            gridBagConstraints.insets = new Insets(10, 10, 6, 6);
            gridBagConstraints.ipady = 7;
            gridBagLayout.setConstraints(this.mField1, gridBagConstraints);
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.bottom = 6;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.mLabel1, gridBagConstraints);
            int n = 2;
            this.mLabel1.setReadingDirection(n);
            this.mOKButton.setReadingDirection(n);
            this.mCancelButton.setReadingDirection(n);
        } else {
            gridBagConstraints.insets = new Insets(10, 10, 6, 6);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.mLabel1, gridBagConstraints);
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.bottom = 6;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.ipady = 7;
            gridBagLayout.setConstraints(this.mField1, gridBagConstraints);
            gridBagConstraints.ipady = 0;
        }
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(buttonBar, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        if (by == 2) {
            buttonBar.add(this.mCancelButton);
            buttonBar.add(this.mOKButton);
            this.getContent().add(this.mField1);
            this.getContent().add(this.mLabel1);
            this.getContent().add(buttonBar);
        } else {
            buttonBar.add(this.mOKButton);
            buttonBar.add(this.mCancelButton);
            this.getContent().add(this.mLabel1);
            this.getContent().add(this.mField1);
            this.getContent().add(buttonBar);
        }
        this.mField1.setAlignment(this.mLabel1.getAlignment());
        this.mOKButton.setDefault(true);
        this.setCancelButton(this.mCancelButton);
        this.setResizable(false);
        this.mDialog.addFocusListener(this);
        this.mField1.addFocusListener(this);
        this.mCancelButton.addFocusListener(this);
        this.mOKButton.addFocusListener(this);
        this.show();
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 129: {
                this.mDialog.setTitle((String)object);
                if (!this.getDispatcher().getRecordNames()) break;
                super.onUpdate(539, DEFAULT_FIELD_DLG_NAME);
                break;
            }
            case 117: {
                int n2 = (Integer)object;
                this.mField1.setColumns(n2 * 9 / 8 + 1);
                this.mField1.setMaximumChars(n2);
                break;
            }
            case 131: {
                this.mField1.setText((String)object);
                break;
            }
            case 116: {
                this.mLabel1.setText((String)object);
                break;
            }
            case 119: {
                String string = this.processLabel((String)object, this.mOKButton);
                this.mOKButton.setLabel(string);
                break;
            }
            case 106: {
                String string = this.processLabel((String)object, this.mCancelButton);
                this.mCancelButton.setLabel(string);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mForceFieldFocus = false;
        if (this.getDispatcher() == null) {
            return;
        }
        if (actionEvent.getSource() == this.mOKButton) {
            this.disposeDialog();
            Message message = new Message(this.getHandler(), 131, this.mField1.getText());
            this.getHandler().getDispatcher().onMessage(message, 0);
        } else if (actionEvent.getSource() == this.mCancelButton) {
            this.disposeDialog();
            this.sendCancelDialogEvent();
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        this.mForceFieldFocus = false;
        if (keyEvent.getKeyCode() == 10 && !(keyEvent.getSource() instanceof PushButton)) {
            this.retargetKeyEvent(this.mOKButton);
        } else if (keyEvent.getKeyCode() == 27) {
            this.disposeDialog();
            this.sendCancelDialogEvent();
        }
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
        this.mDialog = null;
        this.mLabel1 = null;
        this.mField1 = null;
        this.mOKButton = null;
        this.mCancelButton = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mForceFieldFocus) {
            if (focusEvent.getComponent() != this.mField1) {
                this.mField1.requestFocus();
            } else {
                this.mForceFieldFocus = false;
            }
        } else {
            this.mDialog.removeFocusListener(this);
            this.mField1.removeFocusListener(this);
            this.mOKButton.removeFocusListener(this);
            this.mCancelButton.removeFocusListener(this);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.mForceFieldFocus) {
            if (focusEvent.getComponent() == this.mField1) {
                this.mField1.requestFocus();
                this.mForceFieldFocus = false;
            }
        } else {
            this.mDialog.removeFocusListener(this);
            this.mField1.removeFocusListener(this);
            this.mOKButton.removeFocusListener(this);
            this.mCancelButton.removeFocusListener(this);
        }
    }
}

