/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Locale;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.CharacterWrapper;
import oracle.ewt.textWrapper.NoWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;
import oracle.forms.handler.DialogThread;
import oracle.forms.ui.FWindow;

public class EditorDialog
extends CommonDialog
implements ActionListener,
TextListener {
    private static final byte CASE_UPPER = 1;
    private static final byte CASE_LOWER = 2;
    private static final byte CASE_MIXED = 3;
    private static final int EDIT_MARGIN = 10;
    private static final int EDIT_FIELD_SPACING = 4;
    private static final byte NO_WRAP = 1;
    private static final byte CHAR_WRAP = 2;
    private static final byte WORD_WRAP = 3;
    private static final byte FOUND = 1;
    private static final byte NOT_FOUND = 2;
    private static final byte END_REACHED = 3;
    private static final byte REPLACED = 4;
    private static final byte RESULT_TOOBIG = 5;
    private static int sHandlerClassId = 0;
    private LWLabel mEditBottomTitle;
    private String mEditTitle;
    LWCommonText mEditField;
    private LWCommonText mOldEditField;
    private PushButton mSearchButton;
    private PushButton mOKButton;
    private PushButton mCancelButton;
    private ButtonBar mButtonPanel;
    private ScrollBox mScrollBox;
    private LWContainer mLabelContainer;
    private LWLabel mCharCounter = null;
    int mMaxLen = -1;
    private boolean mSurrogatePairSupportEnabled = false;
    String sdSearchReplaceTitle;
    String sdSearchForLabel;
    String sdSearchButtonName;
    String sdOKButtonName;
    String sdCancelButtonName;
    String sdReplaceWithLabel;
    String sdReplaceButtonName;
    String sdReplaceAllButtonName;
    String sdContinueSearchMsg;
    String sdContinueButtonName;
    String sdSearchEndMsg;
    String sdNoMatchMsg;
    private String searchText = null;
    private String oldSearchText = null;
    private boolean searchInputDone = false;
    private Runform dispatcher;
    String searchableField;
    private boolean alertDialogStatus = false;
    int startString = 0;
    int endString = 0;
    FWindow mSearchDialog = null;
    private boolean mIsTextArea = true;
    private byte mCaseFold = (byte)3;
    private static String sSearchFieldText = "";

    public EditorDialog() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        Serializable serializable;
        super.onCreate(runform, message);
        this.mSurrogatePairSupportEnabled = runform.isSurrogatePairSupportEnabled();
        this.mDialog = this.createDialog(runform.getFrame(), true);
        this.dispatcher = runform;
        this.mDialog.setTitle("Editor");
        this.getContent().setLayout(new BorderLayout());
        this.setComponent(this.mDialog);
        this.mEditField = new LWTextArea("");
        this.mEditField.addKeyListener(this);
        this.mEditField.addTextListener(this);
        this.mEditBottomTitle = new LWLabel(null, 3);
        this.mScrollBox = new ScrollBox(this.mEditField, 2, 2);
        this.mOldEditField = new LWTextArea("");
        this.mSearchButton = new PushButton("Search");
        this.mSearchButton.addActionListener(this);
        this.mSearchButton.addKeyListener(this);
        this.mOKButton = new PushButton("OK");
        this.mOKButton.addActionListener(this);
        this.mOKButton.addKeyListener(this);
        this.mCancelButton = new PushButton("Cancel");
        this.mCancelButton.addActionListener(this);
        this.mCancelButton.addKeyListener(this);
        this.mButtonPanel = new ButtonBar();
        this.mLabelContainer = new LWContainer();
        this.mLabelContainer.setLayout(new BorderLayout());
        this.mLabelContainer.add("Center", this.mScrollBox);
        this.getContent().add("Center", this.mLabelContainer);
        this.onUpdate(message);
        if (this.mCharCounter != null) {
            this.mLabelContainer.add("South", this.mCharCounter);
        }
        this.mOldEditField.setText(this.mEditField.getText());
        ButtonBar buttonBar = new ButtonBar();
        ButtonBar buttonBar2 = new ButtonBar();
        buttonBar.add(this.mOKButton);
        buttonBar.add(this.mCancelButton);
        buttonBar2.add(this.mSearchButton);
        this.mButtonPanel.add(buttonBar);
        this.mButtonPanel.add(buttonBar2);
        this.mOKButton.setDefault(true);
        this.setCancelButton(this.mCancelButton);
        LWContainer lWContainer = new LWContainer(new BorderLayout(3, 3));
        lWContainer.setBorderPainter(new FixedBorderPainter(3, 3, 3, 3));
        lWContainer.add("South", this.mButtonPanel);
        this.getContent().add("South", lWContainer);
        this.setResizable(true);
        this.setAutoSize(false);
        this.setAutoCenter(false);
        if (this.mEditBottomTitle != null && this.mEditBottomTitle.getText() != null) {
            serializable = this.mDialog.getSize();
            String string = this.mEditBottomTitle.getText();
            FontMetrics fontMetrics = this.mDialog.getFontMetrics(this.mDialog.getFont());
            int n = fontMetrics.stringWidth(string);
            if (n > ((Dimension)serializable).width / 2) {
                int n2 = n / (((Dimension)serializable).width / 2);
                int n3 = string.length() / n2;
                int n4 = (string.length() - n3) / 2;
                String string2 = string.substring(n4, n4 + n3);
                this.mEditBottomTitle.setText(string2);
            }
            lWContainer.add("North", this.mEditBottomTitle);
        }
        if (this.mCharCounter != null) {
            serializable = this.mDialog.getFont();
            int n = this.getDispatcher().getCharCounterFontsize();
            int n5 = this.getDispatcher().getScreenRes();
            if (n5 != this.getDispatcher().getScreenResolution()) {
                n = n * n5 / this.getDispatcher().getScreenResolution();
            }
            this.mCharCounter.setFont(new Font(((Font)serializable).getName(), 0, n));
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object var2_2 = null;
        if (this.getDispatcher() == null) {
            return;
        }
        if (actionEvent.getSource() == this.mOKButton) {
            Message message = new Message(this.getHandler(), 131, this.mEditField.getText());
            this.mOldEditField.setText(this.mEditField.getText());
            this.getHandler().getDispatcher().onMessage(message, 0);
        } else if (actionEvent.getSource() == this.mCancelButton) {
            this.mEditField.setText(this.mOldEditField.getText());
            this.sendCancelDialogEvent();
        } else if (actionEvent.getSource() == this.mSearchButton) {
            if (this.getDispatcher().getIdleThread() != null) {
                this.getDispatcher().getIdleThread().reset();
            }
            SearchDialog searchDialog = new SearchDialog();
            searchDialog.showSearchDialog();
        }
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mEditField && keyEvent.getKeyCode() == 10) {
            if (!this.mIsTextArea) {
                this.retargetKeyEvent(this.mOKButton);
            }
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyReleasedImpl(KeyEvent keyEvent) {
        super.keyReleasedImpl(keyEvent);
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        int n;
        String string;
        if (textEvent.getSource() == this.mEditField) {
            string = this.mEditField.getText();
            if (this.mCaseFold == 1) {
                string = this.mEditField.getText().toUpperCase();
            } else if (this.mCaseFold == 2) {
                string = this.mEditField.getText().toLowerCase();
            }
        }
        int n2 = n = (string = this.mEditField.getText()) != null ? string.length() : 0;
        if (this.mCharCounter != null) {
            this.mCharCounter.setText(n + " / " + this.mEditField.getMaximumChars());
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.getDispatcher() == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "closed" && propertyChangeEvent.getSource() == this.mDialog && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.mEditField.setText(this.mOldEditField.getText());
        }
        super.vetoableChange(propertyChangeEvent);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        String string = null;
        if (n == 129) {
            this.mDialog.setTitle((String)object);
            super.onUpdate(n, object);
            return bl;
        }
        if (n == 146) {
            Color color = this.getDispatcher().getColorEntry((Integer)object);
            this.mEditField.setForeground(color);
            if (this.mCharCounter != null) {
                this.mCharCounter.setForeground(color);
            }
            if (this.mEditBottomTitle != null) {
                this.mEditBottomTitle.setForeground(color);
            }
            super.onUpdate(n, object);
            return bl;
        }
        if (n == 147) {
            Color color = this.getDispatcher().getColorEntry((Integer)object);
            this.mEditField.setBackground(color);
            super.onUpdate(n, object);
            return bl;
        }
        block0 : switch (n) {
            case 129: {
                this.mEditTitle = (String)object;
                this.mDialog.setTitle(this.mEditTitle);
                break;
            }
            case 596: {
                if (!((Boolean)object).booleanValue()) break;
                this.mCharCounter = new LWLabel();
                this.mCharCounter.setAlignment(2);
                Locale locale = this.dispatcher.getApplet().getLocale();
                if (locale == null || LocaleUtils.getReadingDirectionForLocale(locale) != 2) break;
                this.mCharCounter.setAlignment(1);
                break;
            }
            case 457: {
                this.mEditBottomTitle.setText((String)object);
                break;
            }
            case 131: {
                this.mEditField.setText((String)object);
                if (this.mCharCounter == null) break;
                int n2 = object != null ? ((String)object).length() : 0;
                this.mCharCounter.setText(n2 + " / " + this.mEditField.getMaximumChars());
                break;
            }
            case 124: {
                string = this.sdSearchButtonName = this.processLabel((String)object, this.mSearchButton);
                this.mSearchButton.setLabel(string);
                break;
            }
            case 119: {
                this.sdOKButtonName = this.processLabel((String)object, this.mOKButton);
                this.mOKButton.setLabel(this.sdOKButtonName);
                break;
            }
            case 106: {
                string = this.sdCancelButtonName = this.processLabel((String)object, this.mCancelButton);
                this.mCancelButton.setLabel(string);
                break;
            }
            case 460: {
                if (!((Boolean)object).booleanValue()) break;
                this.mScrollBox.setVDisplayPolicy(1);
                break;
            }
            case 462: {
                this.sdSearchReplaceTitle = (String)object;
                break;
            }
            case 463: {
                this.sdSearchForLabel = (String)object;
                break;
            }
            case 464: {
                this.sdReplaceWithLabel = (String)object;
                break;
            }
            case 465: {
                this.sdReplaceButtonName = (String)object;
                break;
            }
            case 466: {
                this.sdReplaceAllButtonName = (String)object;
                break;
            }
            case 467: {
                this.sdContinueSearchMsg = (String)object;
                break;
            }
            case 468: {
                this.sdContinueButtonName = (String)object;
                break;
            }
            case 469: {
                this.sdSearchEndMsg = (String)object;
                break;
            }
            case 470: {
                this.sdNoMatchMsg = (String)object;
                break;
            }
            case 461: {
                if (object != Boolean.FALSE) break;
                this.addEditField();
                break;
            }
            case 458: 
            case 459: {
                break;
            }
            case 199: {
                if (!((Boolean)object).booleanValue()) break;
                this.mCaseFold = 1;
                break;
            }
            case 194: {
                this.mEditField.setEditable((Boolean)object);
                break;
            }
            case 117: {
                int n3 = this.mMaxLen = ((Integer)object).intValue();
                if (this.mSurrogatePairSupportEnabled) {
                    n3 *= 2;
                }
                this.mEditField.setMaximumChars(n3);
                if (this.mCharCounter == null) break;
                String string2 = this.mEditField.getText();
                int n4 = string2 != null ? string2.length() : 0;
                this.mCharCounter.setText(n4 + " / " + this.mEditField.getMaximumChars());
                break;
            }
            case 208: {
                if (!(this.mEditField instanceof LWTextArea)) break;
                LWTextArea lWTextArea = (LWTextArea)this.mEditField;
                switch ((Byte)object) {
                    case 1: {
                        lWTextArea.setTextWrapper(NoWrapper.getTextWrapper());
                        break block0;
                    }
                    case 2: {
                        lWTextArea.setTextWrapper(CharacterWrapper.getTextWrapper());
                        break block0;
                    }
                }
                lWTextArea.setTextWrapper(WordWrapper.getTextWrapper());
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.disposeDialog();
        }
        super.onDestroy();
        this.mEditTitle = null;
        this.mEditBottomTitle = null;
        this.mEditField = null;
        this.mCancelButton = null;
        this.mSearchButton = null;
        this.mOKButton = null;
        this.mScrollBox = null;
        this.mLabelContainer = null;
        this.mCharCounter = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private static boolean hasTextChanged(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    private void addEditField() {
        LWCommonText lWCommonText = this.mEditField;
        this.mEditField.removeKeyListener(this);
        this.mEditField.removeTextListener(this);
        boolean bl = this.mEditField.isEditable();
        this.mEditField = new LWTextField(this.mEditField.getText());
        this.mEditField.addKeyListener(this);
        this.mEditField.addTextListener(this);
        this.mEditField.setEditable(bl);
        this.mLabelContainer.remove(this.mScrollBox);
        this.mLabelContainer.add("Center", this.mEditField);
        this.mOldEditField = new LWTextField();
        this.mEditField.setForeground(lWCommonText.getForeground());
        this.mEditField.setBackground(lWCommonText.getBackground());
        this.mEditField.setFont(lWCommonText.getFont());
        this.mIsTextArea = false;
    }

    SearchResult doSearchNReplace(String string, String string2, String string3, int n, boolean bl, int n2) {
        int n3;
        int n4 = 2;
        int n5 = -1;
        int n6 = -1;
        String string4 = null;
        if (string == null || string2 == null) {
            return new SearchResult(n4, n5, n6, string4);
        }
        int n7 = this.codePointCount(string);
        int n8 = this.codePointCount(string2);
        int n9 = 0;
        if (string3 != null) {
            n9 = this.codePointCount(string3);
        }
        if ((n3 = string.indexOf(string2, n)) != -1) {
            n4 = 1;
            n5 = n3;
            n6 = n3 + string2.length();
            if (bl) {
                if (n2 == -1 || n2 != -1 && n7 + n9 - n8 <= n2) {
                    string4 = string.substring(0, n5);
                    string4 = string4 + string3 + string.substring(n6);
                    n4 = 4;
                } else {
                    n4 = 5;
                }
            }
        } else {
            n4 = n != 0 ? 3 : 2;
        }
        return new SearchResult(n4, n5, n6, string4);
    }

    SearchResult doReplaceAll(String string, String string2, String string3, int n) {
        String string4 = "";
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        if (string2 == null || string == null || (n5 = string2.length()) == 0 || (n6 = this.codePointCount(string)) == 0) {
            return new SearchResult(n2, -1, -1, null);
        }
        if (string3 != null) {
            n7 = this.codePointCount(string3);
            if (this.mMaxLen != -1 && n6 - this.codePointCount(string2) + n7 > this.mMaxLen) {
                return new SearchResult(5, -1, -1, null);
            }
        }
        while (true) {
            if ((n4 = string.indexOf(string2, n3)) == -1) {
                if (!bl) break;
                string4 = string4.concat(string.substring(n3));
                break;
            }
            bl = true;
            if (n != -1 && this.codePointCount(string4) + n7 > n) break;
            string4 = string4.concat(string.substring(n3, n4));
            string4 = string4.concat(string3);
            n3 = n4 + n5;
        }
        n2 = bl ? 1 : 2;
        return new SearchResult(n2, -1, -1, string4);
    }

    private int codePointCount(String string) {
        int n = string.length();
        if (this.mSurrogatePairSupportEnabled) {
            n = string.codePointCount(0, n);
        }
        return n;
    }

    class SearchDialog
    implements ActionListener,
    KeyListener {
        private LWTextField mSearchField;
        private LWTextField mReplaceField;
        private LWLabel mEditBottomTitle;
        private LWLabel mSearchLabel;
        private LWLabel mReplaceLabel;
        private PushButton mSrchButton;
        private PushButton mReplButton;
        private PushButton mReplAllButton;
        private PushButton mCnclButton;
        private EwtContainer mSearchContent;
        public static final String DEFAULT_SEARCH_REPLACE_DLG_NAME = "Forms_Search_Replace_Dialog";

        private void init() {
            String string = null;
            if (this.mSearchContent == null) {
                return;
            }
            this.mSrchButton = new PushButton("Search");
            string = EditorDialog.this.processLabel(EditorDialog.this.sdSearchButtonName, this.mSrchButton);
            this.mSrchButton.setLabel(string);
            this.mReplButton = new PushButton("Replace");
            string = EditorDialog.this.processLabel(EditorDialog.this.sdReplaceButtonName, this.mReplButton);
            this.mReplButton.setLabel(string);
            this.mReplAllButton = new PushButton("ReplaceAll");
            string = EditorDialog.this.processLabel(EditorDialog.this.sdReplaceAllButtonName, this.mReplAllButton);
            this.mReplAllButton.setLabel(string);
            this.mCnclButton = new PushButton("Cancel");
            string = EditorDialog.this.processLabel(EditorDialog.this.sdCancelButtonName, this.mCnclButton);
            this.mCnclButton.setLabel(string);
            this.mSearchLabel = new LWLabel(EditorDialog.this.sdSearchForLabel);
            this.mReplaceLabel = new LWLabel(EditorDialog.this.sdReplaceWithLabel);
            this.mEditBottomTitle = new LWLabel();
            this.mSearchField = new LWTextField(sSearchFieldText);
            this.mReplaceField = new LWTextField();
            this.mSrchButton.addActionListener(this);
            this.mReplButton.addActionListener(this);
            this.mReplAllButton.addActionListener(this);
            this.mCnclButton.addActionListener(this);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mSearchContent.setLayout(gridBagLayout);
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.mSearchLabel, gridBagConstraints);
            this.mSearchContent.add(this.mSearchLabel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.mSearchField, gridBagConstraints);
            this.mSearchContent.add(this.mSearchField);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.mReplaceLabel, gridBagConstraints);
            this.mSearchContent.add(this.mReplaceLabel);
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.mReplaceField, gridBagConstraints);
            this.mSearchContent.add(this.mReplaceField);
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagLayout.setConstraints(this.mEditBottomTitle, gridBagConstraints);
            if (this.mEditBottomTitle != null && this.mEditBottomTitle.getText() != null) {
                this.mSearchContent.add(this.mEditBottomTitle);
            }
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 14;
            ButtonBar buttonBar = new ButtonBar();
            gridBagLayout.setConstraints(buttonBar, gridBagConstraints);
            ButtonBar buttonBar2 = new ButtonBar();
            ButtonBar buttonBar3 = new ButtonBar();
            buttonBar2.add(this.mCnclButton);
            buttonBar3.add(this.mSrchButton);
            buttonBar3.add(this.mReplButton);
            buttonBar3.add(this.mReplAllButton);
            buttonBar.add(buttonBar2);
            buttonBar.add(buttonBar3);
            this.mSrchButton.setDefault(true);
            this.mSearchContent.add(buttonBar);
            this.mReplButton.setEnabled(EditorDialog.this.mEditField.isEditable());
            this.mReplAllButton.setEnabled(EditorDialog.this.mEditField.isEditable());
            this.mSearchField.addKeyListener(this);
            this.mReplaceField.addKeyListener(this);
            this.mSrchButton.addKeyListener(this);
            this.mReplButton.addKeyListener(this);
            this.mReplAllButton.addKeyListener(this);
            this.mCnclButton.addKeyListener(this);
        }

        public void showSearchDialog() {
            EditorDialog.this.mSearchDialog = new FWindow(WindowType.DIALOG, EditorDialog.this.mDialog, true);
            this.mSearchContent = new EwtContainer();
            EditorDialog.this.mSearchDialog.setContent(this.mSearchContent);
            EditorDialog.this.mSearchDialog.setTitle(EditorDialog.this.sdSearchReplaceTitle);
            if (EditorDialog.this.getDispatcher().getRecordNames()) {
                EditorDialog.this.mSearchDialog.setName(DEFAULT_SEARCH_REPLACE_DLG_NAME);
            }
            FocusUtils.setDefaultFocusTraversalKeys(EditorDialog.this.mSearchDialog);
            EditorDialog.this.getApplet().getDesktop().addWindow(EditorDialog.this.mSearchDialog, false);
            EditorDialog.this.setIcon(null);
            this.init();
            EditorDialog.this.mSearchDialog.pack();
            DialogThread.showDialog(EditorDialog.this.mSearchDialog);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            sSearchFieldText = this.mSearchField.getText();
            if (EditorDialog.this.getDispatcher().getIdleThread() != null) {
                EditorDialog.this.getDispatcher().getIdleThread().reset();
            }
            if (actionEvent.getSource() == this.mSrchButton) {
                SearchResult searchResult = this.searchNReplace(EditorDialog.this.mEditField.getText(), this.mSearchField.getText(), this.mReplaceField.getText(), EditorDialog.this.mEditField.getCaretPosition(), false, EditorDialog.this.mMaxLen);
                if (searchResult.mSearchStatus == 3) {
                    EditorDialog.this.mEditField.select(0, 0);
                }
            } else if (actionEvent.getSource() == this.mReplButton) {
                SearchResult searchResult = this.searchNReplace(EditorDialog.this.mEditField.getText(), this.mSearchField.getText(), this.mReplaceField.getText(), EditorDialog.this.mEditField.getCaretPosition(), true, EditorDialog.this.mMaxLen);
                if (searchResult.mSearchStatus == 3) {
                    EditorDialog.this.mEditField.select(0, 0);
                }
            } else if (actionEvent.getSource() == this.mReplAllButton) {
                SearchResult searchResult = EditorDialog.this.doReplaceAll(EditorDialog.this.mEditField.getText(), this.mSearchField.getText(), this.mReplaceField.getText(), -1);
                if (searchResult.mSearchStatus == 1) {
                    EditorDialog.this.mEditField.setText(searchResult.mReplacedString);
                } else if (searchResult.mSearchStatus == 2) {
                    DialogThread.showAlert(EditorDialog.this.mSearchDialog, EditorDialog.this.getDispatcher(), EditorDialog.this.sdNoMatchMsg, null);
                }
            } else if (actionEvent.getSource() == this.mCnclButton) {
                this.dispose();
            }
        }

        private SearchResult searchNReplace(String string, String string2, String string3, int n, boolean bl, int n2) {
            SearchResult searchResult = EditorDialog.this.doSearchNReplace(string, string2, string3, n, bl, n2);
            if (searchResult.mSearchStatus == 1 || searchResult.mSearchStatus == 4) {
                EditorDialog.this.mEditField.requestFocus();
                EditorDialog.this.mEditField.select(searchResult.mStartSelection, searchResult.mEndSelection);
                if (bl) {
                    EditorDialog.this.mEditField.setText(searchResult.mReplacedString);
                    EditorDialog.this.mEditField.setCaretPosition(searchResult.mStartSelection + string3.length());
                    this.mReplButton.requestFocus();
                } else {
                    this.mSrchButton.requestFocus();
                }
            } else if (searchResult.mSearchStatus == 2) {
                DialogThread.showAlert(EditorDialog.this.mSearchDialog, EditorDialog.this.getDispatcher(), EditorDialog.this.sdNoMatchMsg, null);
            } else if (searchResult.mSearchStatus == 3) {
                DialogThread.showAlert(EditorDialog.this.mSearchDialog, EditorDialog.this.getDispatcher(), EditorDialog.this.sdSearchEndMsg + " " + EditorDialog.this.sdContinueSearchMsg, null);
            } else if (searchResult.mSearchStatus == 5) {
                // empty if block
            }
            return searchResult;
        }

        public void dispose() {
            EditorDialog.this.mSearchDialog.setVisible(false);
            EditorDialog.this.mSearchDialog = null;
            EditorDialog.this.mDialog.moveToFront();
            EditorDialog.this.mDialog.setActive(true);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (EditorDialog.this.getDispatcher().getIdleThread() != null) {
                EditorDialog.this.getDispatcher().getIdleThread().reset();
            }
            if (keyEvent.getKeyCode() == 27) {
                sSearchFieldText = this.mSearchField.getText();
                keyEvent.consume();
                this.dispose();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class SearchResult {
        public int mSearchStatus;
        public int mStartSelection;
        public int mEndSelection;
        public String mReplacedString;

        public SearchResult(int n, int n2, int n3, String string) {
            this.mSearchStatus = n;
            this.mStartSelection = n2;
            this.mEndSelection = n3;
            this.mReplacedString = string;
        }
    }
}

