/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import oracle.ewt.alert.AlertPane;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.AlertDialog;
import oracle.forms.handler.AppsModalStyle;
import oracle.forms.handler.FormPrintableImpl;
import oracle.forms.handler.FormWindow;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.FWindow;
import oracle.forms.ui.mdi.MDIContainer;

public class DialogThread
implements Runnable,
ActionListener,
VetoableChangeListener {
    private static final int USAGE_DIALOG = 0;
    private static final int USAGE_PRINT = 1;
    private static final int USAGE_ALERT = 2;
    private static final int USAGE_USER_ALERT = 3;
    private static int mPrintThreadCount = 1;
    private static int mDialogThreadCount = 1;
    private int mUsage = -1;
    private LWWindow mOwner;
    private LWWindow mDialog;
    private AlertPane mAlert;
    private int mButtons = -1;
    private int mResult = 4;
    private boolean mUserAlert = false;
    private boolean mDismissed = false;
    private String mMsgLine;
    private String mDetails;
    private MessageHandler mHandler;
    private Runform mDispatcher;
    private Frame mPrintFrame;
    private LWComponent mPrintComponent;
    private String mPrintTitle;
    private static int PRINT_MARGIN = 25;
    private static int TITLE_OFFSET = 15;

    private DialogThread(LWWindow lWWindow) {
        this.mUsage = 0;
        this.mDialog = lWWindow;
    }

    private DialogThread(LWWindow lWWindow, AlertPane alertPane, int n, MessageHandler messageHandler, Runform runform) {
        this.mDialog = lWWindow;
        this.mAlert = alertPane;
        this.mButtons = n;
        this.mHandler = messageHandler;
        this.mDispatcher = runform;
        this.mUsage = 3;
    }

    private DialogThread(LWWindow lWWindow, Runform runform, String string, String string2) {
        this.mUsage = 2;
        this.mOwner = lWWindow;
        this.mMsgLine = string;
        this.mDetails = string2;
        this.mDispatcher = runform;
        this.mButtons = 4 | (this.mDetails == null ? 0 : 2);
        this.mAlert = new AlertPane(this.mMsgLine, 0, this.mButtons);
        Image[] imageArray = runform.getNewAlertImages();
        if (imageArray[0] != null) {
            this.mAlert.setIcon(imageArray[0]);
        }
        this.mDialog = DialogThread.createAlertDialog(this.mDispatcher, this.mOwner, this.mAlert);
        AccessibleContext accessibleContext = this.mDialog.getAccessibleContext();
        accessibleContext.setAccessibleDescription(this.mMsgLine);
        accessibleContext.setAccessibleName(this.mMsgLine);
    }

    private DialogThread(Runform runform, LWComponent lWComponent, String string) {
        this.mUsage = 1;
        this.mPrintFrame = runform.getApplet().getFrame();
        this.mPrintComponent = lWComponent;
        this.mPrintTitle = string;
        this.mDispatcher = runform;
    }

    public static Thread print(Runform runform, LWComponent lWComponent, String string) {
        Thread thread = new Thread((Runnable)new DialogThread(runform, lWComponent, string), "Forms-PrintThread" + DialogThread.getNextPrintThreadNum());
        thread.start();
        return thread;
    }

    private static synchronized int getNextPrintThreadNum() {
        return mPrintThreadCount++;
    }

    private static synchronized int getNextDialogThreadNum() {
        return mDialogThreadCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Thread startThread(DialogThread dialogThread, Component component) {
        Thread thread = new Thread((Runnable)dialogThread, "Forms-DialogThread" + DialogThread.getNextDialogThreadNum());
        thread.start();
        while (true) {
            Object object;
            if (component.isVisible() || dialogThread.isDismissed()) {
                dialogThread.setDismissed(false);
                if (!(component instanceof ExtendedFrame)) break;
                FormWindow formWindow = ((ExtendedFrame)component).getHandler();
                Object object2 = object = formWindow.activationLock();
                synchronized (object2) {
                    if (formWindow.isDialogThreadSync()) {
                        try {
                            object.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
            try {
                Thread.yield();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                object = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault());
                System.out.println(((MessageGenerator)object).getMessage("FRM-92450", Thread.currentThread().getName()));
            }
        }
        return thread;
    }

    public static Thread showAlert(LWWindow lWWindow, Runform runform, String string, String string2) {
        DialogThread dialogThread = new DialogThread(lWWindow, runform, string, string2);
        return DialogThread.startThread(dialogThread, dialogThread.mDialog);
    }

    public static Thread showUserAlert(LWWindow lWWindow, AlertPane alertPane, int n, MessageHandler messageHandler, Runform runform) {
        DialogThread dialogThread = new DialogThread(lWWindow, alertPane, n, messageHandler, runform);
        return DialogThread.startThread(dialogThread, lWWindow);
    }

    public static Thread showDialog(LWWindow lWWindow) {
        return DialogThread.startThread(new DialogThread(lWWindow), lWWindow);
    }

    @Override
    public void run() {
        switch (this.mUsage) {
            case 0: {
                this.doDialog();
                break;
            }
            case 1: {
                this.doPrint();
                break;
            }
            case 2: {
                if (this.mDispatcher.getApplet().isBeepAllowed()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.doAlert();
                break;
            }
            case 3: {
                if (this.mDispatcher.getApplet().isBeepAllowed()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.doUserAlert();
                break;
            }
        }
    }

    private void doAlert() {
        String string = null;
        MessageGenerator messageGenerator = this.mDispatcher.getApplet().getTranslatedPhraseGenerator();
        this.mAlert.setMessage(this.mMsgLine);
        String string2 = messageGenerator.getText("OK");
        this.mAlert.setButtonLabel(4, string2);
        this.setAlertButtonMnemonic(this.mAlert, 4, string2);
        if (this.mDetails != null) {
            string = messageGenerator.getText("DETAILS");
            this.mAlert.setButtonLabel(2, string);
            this.setAlertButtonMnemonic(this.mAlert, 2, string);
        }
        this.mAlert.addActionListener(this);
        DialogThread.centerWindow(this.mDispatcher, this.mDialog);
        this.mDialog.setTitle("Forms");
        this.mDispatcher.getApplet().getCursorGrabProvider().setBusy(false);
        this.mAlert.requestFocus();
        if (this.mAlert.getDefaultComponent() != null) {
            this.mAlert.getDefaultComponent().requestFocus();
        } else if (this.mAlert.getCancelComponent() != null) {
            this.mAlert.getCancelComponent().requestFocus();
        }
        this.mDialog.pack();
        this.mDialog.setResizable(false);
        this.mDialog.setVisible(true);
        this.mDialog.dispose();
        if (this.mResult == 2) {
            this.mAlert = new AlertPane(this.mDetails, 0, 4);
            Image[] imageArray = this.mDispatcher.getNewAlertImages();
            if (imageArray[0] != null) {
                this.mAlert.setIcon(imageArray[0]);
            }
            this.mAlert.setMessage(this.mMsgLine + "\n\n" + string + "\n" + this.mDetails);
            this.mAlert.setButtonLabel(4, string2);
            this.setAlertButtonMnemonic(this.mAlert, 4, string2);
            this.mDialog = DialogThread.createAlertDialog(this.mDispatcher, this.mOwner, this.mAlert);
            AccessibleContext accessibleContext = this.mDialog.getAccessibleContext();
            accessibleContext.setAccessibleDescription(this.mMsgLine + "\n\n" + string + "\n" + this.mDetails);
            accessibleContext.setAccessibleName(this.mMsgLine + "\n\n" + string + "\n" + this.mDetails);
            this.mDialog.setTitle("Forms");
            this.mAlert.addActionListener(this);
            this.mButtons = 4;
            DialogThread.centerWindow(this.mDispatcher, this.mDialog);
            this.mAlert.requestFocus();
            if (this.mAlert.getDefaultComponent() != null) {
                this.mAlert.getDefaultComponent().requestFocus();
            } else if (this.mAlert.getCancelComponent() != null) {
                this.mAlert.getCancelComponent().requestFocus();
            }
            this.mDialog.pack();
            this.mDialog.setVisible(true);
            this.mDialog.dispose();
        }
        if (this.mDispatcher.hasErrorOccured()) {
            this.mDispatcher.destroyHandlers();
            this.mDispatcher.getApplet().exitApplet();
        }
    }

    private void doUserAlert() {
        LWWindow lWWindow = this.mDialog;
        LWWindow lWWindow2 = ((AlertDialog)this.mHandler).getOwner();
        this.mUserAlert = true;
        this.mAlert.addActionListener(this);
        this.mDialog.addVetoableChangeListener(this);
        this.mAlert.setVisible(true);
        this.mDialog.pack();
        DialogThread.centerWindow(this.mDispatcher, this.mDialog);
        this.mDialog.setResizable(false);
        this.mDialog.setVisible(true);
        this.mUserAlert = false;
        if (!(lWWindow2 instanceof ExtendedFrame)) {
            Message message = new Message(this.mHandler, 476, (Object)((byte)this.mResult));
            this.mDispatcher.onMessage(message, 0);
        }
    }

    private void doDialog() {
        this.mDialog.setVisible(true);
    }

    private void doPrint() {
        if (this.mPrintFrame.getBackground() == null) {
            this.mPrintFrame.setBackground(Color.white);
        }
        Dimension dimension = this.mPrintComponent.getSize();
        Image image = this.mPrintFrame.createImage(dimension.width, dimension.height);
        Image image2 = Toolkit.getDefaultToolkit().createImage(image.getSource());
        Graphics graphics = image.getGraphics();
        if (image == null || image2 == null || graphics == null) {
            Toolkit.getDefaultToolkit().beep();
            if (image != null) {
                image.flush();
                image = null;
            }
            if (image2 != null) {
                image2.flush();
                image2 = null;
            }
            if (graphics != null) {
                graphics.dispose();
            }
            return;
        }
        if (System.getProperty("java.version").startsWith("1.1")) {
            PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this.mPrintFrame, this.mPrintTitle, null);
            if (printJob == null) {
                return;
            }
            Graphics graphics2 = printJob.getGraphics();
            Dimension dimension2 = printJob.getPageDimension();
            if (graphics2 == null) {
                Toolkit.getDefaultToolkit().beep();
                printJob.end();
                return;
            }
            graphics.setClip(0, 0, dimension.width, dimension.height);
            this.mPrintComponent.printAll(graphics);
            int n = dimension.height;
            int n2 = dimension.width;
            boolean bl = true;
            if (this.mDispatcher != null) {
                bl = this.mDispatcher.getApplet().getScalePrintedImage();
            }
            if (bl && (dimension.width > dimension2.width - PRINT_MARGIN * 2 || dimension.height > dimension2.height - PRINT_MARGIN * 2)) {
                float f = dimension.width - dimension2.width;
                float f2 = dimension.height - dimension2.height;
                if (f / (float)dimension.width > f2 / (float)dimension.height) {
                    n2 = dimension2.width - PRINT_MARGIN * 2;
                    n = dimension.height * dimension2.width / dimension.width - PRINT_MARGIN * 2;
                } else {
                    n = dimension2.height - PRINT_MARGIN * 2;
                    n2 = dimension.width * dimension2.height / dimension.height - PRINT_MARGIN * 2;
                }
            }
            graphics2.drawImage(image2, TITLE_OFFSET, TITLE_OFFSET, n2, n, null);
            graphics2.dispose();
            printJob.end();
        } else {
            graphics.setClip(0, 0, dimension.width, dimension.height);
            this.mPrintComponent.printAll(graphics);
            try {
                FormPrintableImpl formPrintableImpl = new FormPrintableImpl();
                if (formPrintableImpl != null) {
                    String string;
                    String string2 = this.mDispatcher.getApplet().getParameter("rotateLandscapeImage");
                    if (string2 != null && string2.equalsIgnoreCase("true")) {
                        formPrintableImpl.setRotateLandscapeImage(true);
                    }
                    if ((string = this.mDispatcher.getApplet().getParameter("JPSPrint")) != null && string.equalsIgnoreCase("false")) {
                        formPrintableImpl.setJPSPrint(false);
                    }
                    formPrintableImpl.setImage(image2, dimension.width, dimension.height);
                    formPrintableImpl.setJobName(this.mPrintTitle);
                    formPrintableImpl.doPrint();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        image.flush();
        image = null;
        image2.flush();
        image2 = null;
        graphics.dispose();
    }

    public static LWWindow createAlertDialog(Runform runform, LWWindow lWWindow, AlertPane alertPane) {
        FWindow fWindow = new FWindow(WindowType.DIALOG, lWWindow, true);
        MDIContainer mDIContainer = runform.getApplet().getMDIContainer();
        fWindow.setModalStyle(AppsModalStyle.getAppsModalStyle(mDIContainer.getMDIScrollBox()));
        fWindow.setContent(alertPane);
        runform.getApplet().getDesktop().addWindow(fWindow, false);
        fWindow.pack();
        FocusUtils.setDefaultFocusTraversalKeys(fWindow);
        return fWindow;
    }

    public static void centerWindow(Runform runform, LWWindow lWWindow) {
        int n;
        Serializable serializable;
        if (runform == null || lWWindow == null) {
            return;
        }
        Dimension dimension = runform.getApplet().getDesktop().getSize();
        Dimension dimension2 = lWWindow.getSize();
        DesktopContainer desktopContainer = runform.getApplet().getDesktop();
        Dimension dimension3 = null;
        Point point = new Point(0, 0);
        if (desktopContainer != null) {
            point = desktopContainer.getLocation();
            for (serializable = desktopContainer.getParent(); serializable != null && !(serializable instanceof ScrollBox); serializable = serializable.getParent()) {
            }
            if (serializable != null) {
                dimension3 = serializable.getSize();
            }
        }
        if (dimension3 != null) {
            dimension = dimension3;
        }
        if (dimension.width < dimension2.width) {
            int n2;
            n = 0;
            serializable = runform.getApplet().getLocale();
            if (serializable != null && (n2 = LocaleUtils.getReadingDirectionForLocale((Locale)serializable)) == 2) {
                int n3 = runform.getApplet().getSize().width;
                n = -n3;
            }
        } else {
            n = (dimension.width - dimension2.width) / 2 - point.x;
        }
        int n4 = dimension.height < dimension2.height ? 0 : (dimension.height - dimension2.height) / 2 - point.y;
        lWWindow.setLocation(n, n4);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LWWindow lWWindow;
        String string = ((PushButton)actionEvent.getSource()).getLabel();
        if (this.mDispatcher.getIdleThread() != null) {
            this.mDispatcher.getIdleThread().reset();
        }
        this.mResult = (this.mButtons & 4) != 0 && string.equals(this.mAlert.getButtonLabel(4)) ? 4 : ((this.mButtons & 2) != 0 && string.equals(this.mAlert.getButtonLabel(2)) ? 2 : ((this.mButtons & 1) != 0 && string.equals(this.mAlert.getButtonLabel(1)) ? 1 : 0));
        if (this.mUserAlert && (lWWindow = ((AlertDialog)this.mHandler).getOwner()) instanceof ExtendedFrame) {
            Message message = new Message(this.mHandler, 476, (Object)((byte)this.mResult));
            ((ExtendedFrame)lWWindow).setDialogResult(message);
        }
        this.mDialog.setVisible(false);
        this.setDismissed(true);
    }

    private void setAlertButtonMnemonic(AlertPane alertPane, int n, String string) {
        int n2 = StringUtils.getMnemonicIndex(string);
        if (n2 != -1) {
            alertPane.setButtonMnemonicIndex(n, n2);
        } else {
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            for (int i = 0; i < n3; ++i) {
                if (!Character.isUpperCase(cArray[i])) continue;
                alertPane.setButtonMnemonicIndex(n, i);
                break;
            }
        }
    }

    private boolean isDismissed() {
        return this.mDismissed;
    }

    private void setDismissed(boolean bl) {
        this.mDismissed = bl;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "closed" && propertyChangeEvent.getNewValue() == Boolean.TRUE && this.mUserAlert) {
            this.mResult = 4;
            LWWindow lWWindow = ((AlertDialog)this.mHandler).getOwner();
            if (lWWindow instanceof ExtendedFrame) {
                Message message = new Message(this.mHandler, 476, (Object)((byte)this.mResult));
                ((ExtendedFrame)lWWindow).setDialogResult(message);
            }
            this.setDismissed(true);
        }
    }
}

