/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.painter.GradientPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.splitter.Splitter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.InputEventUtils;
import oracle.forms.engine.KeyBinder;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.handler.BlockScroller;
import oracle.forms.handler.ComboBoxItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.Painter;
import oracle.forms.handler.TabControl;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.handler.TextFieldItem;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.AccessibilityUpdater;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.FSplitter;
import oracle.forms.ui.IView;
import oracle.forms.ui.TimerEvent;

public class ComponentItem
extends UICommon
implements FocusListener,
ItemListener,
CustomListener,
MouseListener,
MouseMotionListener,
Runnable {
    private int mEventMask = 0;
    protected Component mPopupMenuView = null;
    private int mXScroll = 0;
    private int mYScroll = 0;
    private String mOldAccessibleName = null;
    private static AccessibilityUpdater sAccTask;
    private Hashtable mCustomParams;
    Message mCustomMessage = null;
    private boolean mIsThisObjectDeleted = false;
    private boolean mGradientColorSet = false;
    public static final byte GRADIENT_NONE = 0;
    public static final byte GRADIENT_LEFT = 1;
    public static final byte GRADIENT_TOP = 2;
    public static final byte GRADIENT_RIGHT = 3;
    public static final byte GRADIENT_BOTTOM = 4;
    protected byte mGradientStart = 0;
    private byte mUIStyle = 0;

    public ComponentItem() {
    }

    public ComponentItem(MessageHandler messageHandler) {
        super(messageHandler);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 163: {
                this.setEventMask(object);
                break;
            }
            case 187: {
                this.doAutoScroll();
                break;
            }
            case 585: {
                this.mUIStyle = (Byte)object;
                break;
            }
            case 188: {
                this.doCheckObscurity((Message)object);
                break;
            }
            case 402: {
                boolean bl2 = this.getDispatcher().getApplet().isSendHeartBeatBean();
                if (bl2) {
                    Thread thread = new Thread((Runnable)this, "setCustomPropertyThread");
                    this.mCustomMessage = (Message)object;
                    thread.start();
                    break;
                }
                this.setCustomProperty((Message)object);
                break;
            }
            case 514: {
                Component component = this.getAccessibleComponent();
                if (!(component instanceof LWComponent)) break;
                AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
                accessibleContext.setAccessibleDescription((String)object);
                accessibleContext.setAccessibleName((String)object);
                if (((LWComponent)component).getMnemonicChar() == '\u0000') break;
                this.appendMnemonicToAccessibilityDesc((Character)this.getView().getProperty(ID.MNEMONIC));
                break;
            }
            case 541: {
                int n2 = (Integer)object;
                MessageHandler messageHandler = this.getDispatcher().getHandler(n2);
                if (!(messageHandler instanceof BlockScroller)) break;
                Component component = (Component)((Object)this.getView());
                ((BlockScroller)messageHandler).setMouseWheelListener(component);
                break;
            }
            case 236: {
                if (this.getView() == null) break;
                Cursor cursor = Cursor.getPredefinedCursor(((Number)object).byteValue());
                if (this instanceof TextAreaItem) {
                    LWCommonText lWCommonText = ((TextComponentItem)this).getLWCommonText();
                    if (lWCommonText == null) break;
                    lWCommonText.setCursor(cursor);
                    break;
                }
                ((Component)((Object)this.getView())).setCursor(cursor);
                if (!(this instanceof ComboBoxItem)) break;
                LWTextField lWTextField = null;
                lWTextField = ((ComboBox)((Object)this.getView())).getLWTextField();
                if (lWTextField == null) break;
                lWTextField.setCursor(cursor);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    public Component getAccessibleComponent() {
        return this.getComponent();
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getDispatcher().getFocusOwner() == this) {
            this.getDispatcher().setFocusOwner(null);
        }
        if (this.mCustomParams != null) {
            this.mCustomParams.clear();
            this.mCustomParams = null;
        }
        if (this.getView() != null) {
            this.getView().removeListener(CustomListener.class, this);
        }
        this.mIsThisObjectDeleted = true;
        super.onDestroy();
    }

    public void doAutoScroll() {
        DrawnPanel drawnPanel = (DrawnPanel)this.getComponent().getParent();
        drawnPanel.validate();
        if (drawnPanel.getCanvasType() == 0) {
            this.scrollContentCanvas();
        } else if (drawnPanel.getCanvasType() == 1 || drawnPanel.getCanvasType() == 2) {
            this.scrollStackedCanvas();
        }
    }

    public void doCheckObscurity(Message message) {
        Object object;
        Object object2;
        int n = message.size();
        Object var3_3 = null;
        Rectangle rectangle = null;
        DrawnPanel drawnPanel = this.getContentView();
        FSplitter fSplitter = null;
        Point point = this.isParentToolbar() ? new Point(0, 0) : drawnPanel.getLocation();
        Rectangle rectangle2 = this.getComponent().getBounds();
        if (this.getHandler() instanceof FormCanvas || this.getHandler() instanceof TabControl) {
            rectangle2.x += point.x;
            rectangle2.y += point.y;
        } else {
            DrawnPanel drawnPanel2 = (DrawnPanel)this.getComponent().getParent();
            Point point2 = drawnPanel2.getLocation();
            if (!this.isParentToolbar()) {
                Point point3;
                object2 = (ScrollBox)drawnPanel2.getParent().getParent();
                object = ((Component)object2).getLocation();
                if (((Component)object2).getParent() != null && ((Component)object2).getParent().getParent() != null && ((Component)object2).getParent().getParent() instanceof TabPanel) {
                    point3 = ((Component)object2).getParent().getLocation();
                    Point point4 = ((Component)object2).getParent().getParent().getLocation();
                    ((Point)object).x += point3.x + point4.x;
                    ((Point)object).y += point3.y + point4.y;
                } else if (((Component)object2).getParent() != null && ((Component)object2).getParent() instanceof FSplitter) {
                    fSplitter = (FSplitter)((Component)object2).getParent();
                    point3 = ((Component)object2).getParent().getLocation();
                    ((Point)object).x += point3.x;
                    ((Point)object).y += point3.y;
                }
            } else {
                object = new Point(0, 0);
            }
            rectangle2.x += point.x + ((Point)object).x + point2.x;
            rectangle2.y += point.y + ((Point)object).y + point2.y;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            object = message.getValueAt(i);
            int n3 = (Integer)object;
            MessageHandler messageHandler = this.getDispatcher().getHandler(n3);
            if (((UICommon)messageHandler).getComponent().getParent() instanceof FSplitter) {
                object2 = (FSplitter)((UICommon)messageHandler).getComponent().getParent();
                if (object2 == fSplitter) continue;
                rectangle = ((Component)object2).getBounds();
            } else {
                rectangle = ((UICommon)messageHandler).getComponent().getBounds();
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
            if (rectangle == null || !rectangle.intersects(rectangle2)) continue;
            object2 = Message.newMessage(this.getHandler(), 188, object);
            this.getDispatcher().onMessage((Message)object2, 2);
            break;
        }
    }

    public void scrollContentCanvas() {
        boolean bl;
        Object object;
        DrawnPanel drawnPanel;
        Serializable serializable;
        DrawnPanel drawnPanel2 = (DrawnPanel)this.getComponent().getParent();
        DrawnPanel drawnPanel3 = this.getContentView();
        Container container = drawnPanel3.getParent();
        Dimension dimension = container.getSize();
        Container container2 = drawnPanel3.getParent().getParent();
        Painter painter = drawnPanel3.getPainter();
        FormCanvas formCanvas = (FormCanvas)painter;
        boolean bl2 = formCanvas.isToLeft();
        if (bl2 && (serializable = (ExtendedFrame)this.getParentWindow()) != null && (drawnPanel = ((ExtendedFrame)serializable).getVerticalToolbar()) != null && drawnPanel.isVisible()) {
            ((Component)drawnPanel3).setSize(drawnPanel3.getSize().width - drawnPanel.getSize().width, drawnPanel3.getSize().height);
        }
        serializable = ((ScrollBox)container2).getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        int n = 0;
        if (bl2) {
            n = drawnPanel3.getSize().width - dimension.width;
        }
        if ((((ScrollBox)container2).getScrollPosition().x != n || ((ScrollBox)container2).getScrollPosition().y != 0) && drawnPanel3.getRecentScrollee() != null && drawnPanel3.getRecentScrollee() != drawnPanel2) {
            ((ScrollBox)container2).setScrollPosition(n, 0);
            drawnPanel3.setOrigin(drawnPanel3.getLocation());
            object = Message.newMessage(formCanvas.getHandler(), 139, drawnPanel3.getLocation());
            this.getDispatcher().onMessage((Message)object, 1);
        }
        if (bl = this.isScrollingNeeded((Point)(object = drawnPanel3.getLocation()), drawnPanel3.getSize(), dimension)) {
            ((ScrollBox)container2).setScrollPosition(this.mXScroll, this.mYScroll);
            drawnPanel3.setOrigin(drawnPanel3.getLocation());
            Message message = Message.newMessage(formCanvas.getHandler(), 139, drawnPanel3.getLocation());
            this.getDispatcher().onMessage(message, 1);
            drawnPanel3.setRecentScrollee(drawnPanel2);
        }
        if (!drawnPanel3.isValid()) {
            drawnPanel3.validate();
        }
    }

    public void scrollStackedCanvas() {
        Container container = this.getComponent().getParent();
        Point point = container.getLocation();
        Container container2 = container.getParent();
        Container container3 = container2.getParent();
        Dimension dimension = container2.getSize();
        Insets insets = ((ScrollBox)container3).getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        boolean bl = this.isScrollingNeeded(point, container.getSize(), dimension);
        if (bl) {
            ((ScrollBox)container3).setScrollPosition(this.mXScroll, this.mYScroll);
            ((DrawnPanel)container).setOrigin(container.getLocation());
            Painter painter = ((DrawnPanel)container).getPainter();
            FormCanvas formCanvas = (FormCanvas)painter;
            Message message = Message.newMessage(formCanvas.getHandler(), 139, container.getLocation());
            this.getDispatcher().onMessage(message, 1);
        }
        this.scrollContentView();
    }

    private boolean isScrollingNeeded(Point point, Dimension dimension, Dimension dimension2) {
        this.mXScroll = -point.x;
        this.mYScroll = -point.y;
        boolean bl = this.isXScrollingNeeded(point, dimension, dimension2);
        boolean bl2 = this.isYScrollingNeeded(point, dimension2);
        return bl || bl2;
    }

    private boolean isXScrollingNeeded(Point point, Dimension dimension, Dimension dimension2) {
        Object object;
        LWComponent lWComponent;
        Object object2;
        int n = point.x;
        boolean bl = false;
        Dimension dimension3 = this.getComponent().getSize();
        Point point2 = this.getComponent().getLocation();
        DrawnPanel drawnPanel = (DrawnPanel)this.getComponent().getParent();
        Painter painter = drawnPanel.getPainter();
        FormCanvas formCanvas = (FormCanvas)painter;
        if (this instanceof TextFieldItem && ((TextFieldItem)(object2 = (TextFieldItem)this)).isFieldShrunk() && ((TextFieldItem)object2).isLOVButtonDisplayed()) {
            lWComponent = (ExtendedFrame)this.getParentWindow();
            object = ((ExtendedFrame)lWComponent).getLovButton().getSize();
            double d = dimension3.getSize().width;
            dimension3.setSize(d + (double)((Dimension)object).getSize().width, dimension3.getHeight());
        }
        if ((object2 = formCanvas.getSplitter()) != null && !((Splitter)object2).isHorizontal()) {
            int n2;
            int n3 = ((Splitter)object2).getSplitterPosition();
            if (n3 == -1) {
                n3 = ((FSplitter)object2).getCachedPos();
            }
            int n4 = n2 = formCanvas.isToLeft() ? 1 : 0;
            if (((Container)object2).getComponent(n2) == formCanvas.getComponent()) {
                if (n3 < dimension3.width) {
                    ((Splitter)object2).setSplitterPosition(dimension3.width);
                    ((FSplitter)object2).setCachedPos(dimension3.width);
                    dimension2.width = dimension3.width;
                }
            } else if (((Component)object2).getSize().width - n3 - ((Splitter)object2).getDividerSize() < dimension3.width) {
                int n5 = ((Component)object2).getSize().width - ((Splitter)object2).getDividerSize() - dimension3.width;
                if (n5 < 0) {
                    n5 = 0;
                }
                ((Splitter)object2).setSplitterPosition(n5);
                ((FSplitter)object2).setCachedPos(n5);
                dimension2.width = dimension3.width;
            }
        }
        if (drawnPanel.getCanvasType() == 0) {
            lWComponent = null;
            lWComponent = this.getTabPanel();
            if (lWComponent != null) {
                for (object = this.getComponent().getParent(); object != lWComponent.getParent(); object = ((Component)object).getParent()) {
                    point2.x += ((Component)object).getLocation().x;
                }
            } else {
                point2.x += drawnPanel.getLocation().x;
            }
            if ((object = this.getDispatcher().getFocusOwner()) != null && ((UICommon)object).getComponent() != null && ((UICommon)object).getComponent() instanceof TabPanel) {
                point2.x = ((UICommon)object).getComponent().getLocation().x;
            }
        }
        if (dimension.width <= dimension2.width) {
            n = formCanvas.isToLeft() ? dimension2.width - dimension.width : 0;
        } else if (point.x == 0) {
            if (point2.x + dimension3.width <= dimension2.width) {
                return bl;
            }
            n = this.getCanvasXLocation(point, dimension, point2, dimension3, dimension2);
        } else if (point.x < 0) {
            if (point.x + point2.x > 0) {
                if (point.x + point2.x + dimension3.width <= dimension2.width) {
                    return bl;
                }
                n = this.getCanvasXLocation(point, dimension, point2, dimension3, dimension2);
            } else {
                n = point.x + point2.x + dimension3.width <= dimension2.width ? (point2.x + dimension3.width <= dimension2.width ? 0 : this.getCanvasXLocation(point, dimension, point2, dimension3, dimension2)) : this.getCanvasXLocation(point, dimension, point2, dimension3, dimension2);
            }
        } else if (point.x > 0) {
            if (point2.x + dimension3.width <= dimension2.width) {
                return bl;
            }
            n = this.getCanvasXLocation(point, dimension, point2, dimension3, dimension2);
        }
        if (n != point.x) {
            this.mXScroll = -n;
            bl = true;
        }
        return bl;
    }

    private int getCanvasXLocation(Point point, Dimension dimension, Point point2, Dimension dimension2, Dimension dimension3) {
        int n = 0;
        DrawnPanel drawnPanel = (DrawnPanel)this.getComponent().getParent();
        FormCanvas formCanvas = (FormCanvas)drawnPanel.getPainter();
        if (dimension2.width >= dimension3.width) {
            n = formCanvas.isToLeft() ? dimension3.width - (point2.x + dimension2.width) : -point2.x;
            if (this instanceof TextComponentItem) {
                String string = (String)this.getView().getProperty(ID.VALUE);
                int n2 = (Integer)this.getView().getProperty(ID.CURSOR_POSITION);
                if (n2 <= string.length()) {
                    string = string.substring(0, n2);
                }
                Font font = this.getComponent().getFont();
                FontMetrics fontMetrics = this.getComponent().getFontMetrics(font);
                int n3 = fontMetrics.stringWidth(string) + point2.x;
                if (n3 < dimension3.width - point.x && n3 > -1 * point.x && (n3 > dimension3.width - n || n3 < -1 * n)) {
                    n = point.x;
                }
            }
        } else {
            n = dimension.width - point2.x <= dimension3.width ? dimension3.width - dimension.width : dimension3.width - (point2.x + dimension2.width);
        }
        return n;
    }

    private boolean isYScrollingNeeded(Point point, Dimension dimension) {
        int n = 0;
        boolean bl = false;
        Dimension dimension2 = this.getComponent().getSize();
        Point point2 = this.getComponent().getLocation();
        DrawnPanel drawnPanel = (DrawnPanel)this.getComponent().getParent();
        FormCanvas formCanvas = (FormCanvas)drawnPanel.getPainter();
        FSplitter fSplitter = formCanvas.getSplitter();
        if (fSplitter != null && fSplitter.isHorizontal()) {
            int n2 = fSplitter.getSplitterPosition();
            if (n2 == -1) {
                n2 = fSplitter.getCachedPos();
            }
            if (fSplitter.getComponent(0) == formCanvas.getComponent()) {
                if (n2 < dimension2.height) {
                    fSplitter.setSplitterPosition(dimension2.height);
                    fSplitter.setCachedPos(dimension2.height);
                    dimension.height = dimension2.height;
                }
            } else if (fSplitter.getSize().height - n2 - fSplitter.getDividerSize() < dimension2.height) {
                int n3 = fSplitter.getSize().height - fSplitter.getDividerSize() - dimension2.height;
                if (n3 < 0) {
                    n3 = 0;
                }
                fSplitter.setSplitterPosition(n3);
                fSplitter.setCachedPos(n3);
                dimension.height = dimension2.height;
            }
        }
        if (drawnPanel.getCanvasType() == 0) {
            ComponentItem componentItem;
            TabPanel tabPanel = null;
            tabPanel = this.getTabPanel();
            if (tabPanel != null) {
                for (Container container = this.getComponent().getParent(); container != tabPanel.getParent(); container = container.getParent()) {
                    point2.y += container.getLocation().y;
                }
            }
            if ((componentItem = this.getDispatcher().getFocusOwner()) != null && componentItem.getComponent() != null && componentItem.getComponent() instanceof TabPanel) {
                point2.y = componentItem.getComponent().getLocation().y;
            }
        }
        if (point.y != 0) {
            this.mYScroll = n = Math.abs(point.y);
        }
        if (point2.y < n && point2.y + dimension2.height < dimension.height) {
            this.mYScroll = 0;
            bl = true;
        } else if (point2.y < n || point2.y + dimension2.height > dimension.height + n) {
            int n4;
            int n5 = (dimension.height - dimension2.height) / 2;
            this.mYScroll = n4 = point2.y - n5;
            bl = true;
        }
        return bl;
    }

    public void scrollContentView() {
        int n;
        int n2;
        Point point = this.getComponent().getLocation();
        Dimension dimension = this.getComponent().getSize();
        Container container = this.getComponent().getParent();
        Point point2 = container.getLocation();
        Container container2 = container.getParent().getParent();
        Point point3 = container2.getLocation();
        Dimension dimension2 = container2.getSize();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        DrawnPanel drawnPanel = this.getContentView();
        Dimension dimension3 = drawnPanel.getSize();
        Point point4 = drawnPanel.getLocation();
        Dimension dimension4 = drawnPanel.getParent().getSize();
        Container container3 = drawnPanel.getParent().getParent();
        Painter painter = drawnPanel.getPainter();
        FormCanvas formCanvas = (FormCanvas)painter;
        Insets insets = ((ScrollBox)container3).getInsets();
        dimension4.width += insets.left + insets.right;
        dimension4.height += insets.top + insets.bottom;
        if (point4.x + point3.x >= 0 && point4.x + point3.x + dimension2.width <= dimension4.width && point4.y + point3.y >= 0 && point4.y + point3.y + dimension2.height <= dimension4.height) {
            return;
        }
        int n5 = point4.x + point3.x + point2.x + point.x;
        int n6 = point4.y + point3.y + point2.y + point.y;
        n3 = -point4.x;
        n4 = -point4.y;
        if (!(point4.x + point3.x > 0 && point4.x + point3.x + dimension2.width <= dimension4.width || n5 + dimension.width <= dimension4.width && n5 >= 0)) {
            if (dimension2.width > dimension4.width) {
                n3 = n5 < 0 ? Math.abs(point3.x + point2.x + point.x) : Math.abs(point3.x + point2.x + point.x + dimension.width - dimension4.width);
            } else if (this.isToLeft()) {
                n3 = point3.x + dimension2.width - dimension4.width;
            } else {
                n2 = point3.x + dimension2.width / 2;
                n = dimension4.width / 2;
                n3 = n2 - n;
            }
            bl = true;
        }
        if (!(point4.y + point3.y > 0 && point4.y + point3.y + dimension2.height <= dimension4.height || n6 + dimension.height <= dimension4.height && n6 >= 0)) {
            if (dimension2.height > dimension4.height) {
                n4 = n6 < 0 ? Math.abs(point3.y + point2.y + point.y) : Math.abs(point3.y + point2.y + point.y + dimension.height - dimension4.height);
            } else {
                n2 = point3.y + dimension2.height / 2;
                n = dimension4.height / 2;
                n4 = n2 - n;
            }
            bl = true;
        }
        if (bl) {
            ((ScrollBox)container3).setScrollPosition(n3, n4);
            drawnPanel.setOrigin(drawnPanel.getLocation());
            Message message = Message.newMessage(formCanvas.getHandler(), 139, drawnPanel.getLocation());
            this.getDispatcher().onMessage(message, 1);
        }
        if (!drawnPanel.isValid()) {
            drawnPanel.validate();
        }
    }

    public DrawnPanel getContentView() {
        ExtendedFrame extendedFrame = (ExtendedFrame)this.getParentWindow();
        if (extendedFrame != null) {
            return extendedFrame.getContentView();
        }
        return null;
    }

    protected TabPanel getTabPanel() {
        for (Container container = this.getComponent().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof TabPanel)) continue;
            return (TabPanel)container;
        }
        return null;
    }

    public boolean isParentToolbar() {
        for (Container container = this.getComponent().getParent(); container != null; container = container.getParent()) {
            byte by;
            if (!(container instanceof DrawnPanel) || (by = ((DrawnPanel)container).getUsage()) != 2 && by != 3) continue;
            return true;
        }
        return false;
    }

    public void setEventMask(Object object) {
        this.mEventMask = (Integer)object;
    }

    public int getEventMask() {
        return this.mEventMask;
    }

    public boolean isMouseClickEnabled() {
        return (this.mEventMask & 1) != 0;
    }

    public boolean isMouseCrossEnabled() {
        return (this.mEventMask & 4) != 0;
    }

    public boolean isMouseKeyEnabled() {
        return (this.mEventMask & 8) != 0;
    }

    public boolean isMouseMoveEnabled() {
        return (this.mEventMask & 2) != 0;
    }

    public boolean isPopupMenuEnabled() {
        return (this.mEventMask & 0x100) != 0;
    }

    public void setMouseEventListeners() {
        if (this.isMouseClickEnabled() || this.isMouseCrossEnabled() || this.isPopupMenuEnabled()) {
            this.getEventComponent().addMouseListener(this);
        }
        if (this.isMouseMoveEnabled()) {
            this.getEventComponent().addMouseMotionListener(this);
        }
    }

    protected void sendFocusEvent(boolean bl, boolean bl2) {
        Message message = Message.newMessage(this, 174, bl ? Boolean.TRUE : Boolean.FALSE);
        int n = 0;
        n = bl2 ? 0 : 1;
        this.getDispatcher().onMessage(message, n);
        if (this.getDispatcher().isLoggingEnabled()) {
            int n2 = bl ? 0 : 1;
            this.getDispatcher().getFocusLogger().sendMessage(this, n2);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mIsThisObjectDeleted) {
            return;
        }
        boolean bl = false;
        if (this.isServerFocusRequest()) {
            bl = true;
            this.setServerFocusRequest(false);
        }
        if (this.getHandler() == null || ComponentItem.isFocusHidden()) {
            return;
        }
        ComponentItem componentItem = this.getDispatcher().getFocusOwner();
        if (Thread.currentThread().getName().endsWith("engine.Main") && !this.getApplet().useSeparateFrame()) {
            if (UICommon.isFocusRequest()) {
                UICommon.setFocusRequest(false);
            } else {
                if (componentItem != null && componentItem != this && componentItem.getComponent() != null) {
                    ComponentItem.setFocusHidden(true);
                    componentItem.getComponent().requestFocus();
                    ComponentItem.setFocusHidden(false);
                }
                return;
            }
        }
        if (this instanceof TextComponentItem || this instanceof ComboBoxItem) {
            FormMenu formMenu;
            ExtendedFrame extendedFrame;
            Boolean bl2 = (Boolean)this.getView().getProperty(ID.EDITABLE);
            Point point = (Point)this.getView().getProperty(ID.SELECTION);
            Boolean bl3 = Boolean.FALSE;
            Object object = this.getView().getProperty(ID.OK_TO_PASTE);
            if (object instanceof Boolean) {
                bl3 = (Boolean)object;
            }
            if ((bl3 == Boolean.TRUE || point.x != point.y) && (extendedFrame = (ExtendedFrame)this.getParentWindow()) != null && (formMenu = extendedFrame.getHandler().getMenu()) != null && formMenu.getMenuInfo() != null) {
                if (bl3.booleanValue()) {
                    formMenu.getMenuInfo().doEnablePaste(true);
                }
                if (point.x != point.y) {
                    formMenu.getMenuInfo().doEnableCopy(true, bl2);
                }
            }
        }
        if (componentItem == this) {
            return;
        }
        if (FocusUtils.areNewFocusAPIsAvailable() && !bl && this.getParentWindow() != null && !this.getParentWindow().isActive()) {
            return;
        }
        if (this.isNewTabPage(componentItem)) {
            this.addTabToAccessibleName();
        }
        if (componentItem != null) {
            componentItem.clearTabFromAccessibleName();
            if (componentItem.getComponent() == ComponentItem.getExpectedFocusOut()) {
                ComponentItem.setExpectedFocusOut(null);
            } else {
                if (this.getDispatcher().isInputLocaleCJK()) {
                    this.getDispatcher().setNextFocusOwner(this);
                }
                componentItem.sendFocusEvent(false, false);
                if (this.getDispatcher().isInputLocaleCJK()) {
                    this.getDispatcher().setNextFocusOwner(null);
                }
            }
        }
        this.getDispatcher().setObserver(this);
        this.getDispatcher().setFocusOwner(this);
        if (this.getComponent() == ComponentItem.getExpectedFocusIn()) {
            ComponentItem.setExpectedFocusIn(null);
        } else {
            this.sendFocusEvent(true, true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        FormMenu formMenu;
        ExtendedFrame extendedFrame;
        this.clearTabFromAccessibleName();
        if ((this instanceof TextComponentItem || this instanceof ComboBoxItem) && (extendedFrame = (ExtendedFrame)this.getParentWindow()) != null && (formMenu = extendedFrame.getHandler().getMenu()) != null && formMenu.getMenuInfo() != null) {
            formMenu.getMenuInfo().doEnablePaste(false);
            formMenu.getMenuInfo().doEnableCopy(false, false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.getHandler() == null) {
            return;
        }
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (this.getDispatcher().isLoggingEnabled() && this.getDispatcher().getFocusLogger().isEventOn(4) && keyEvent.getModifiersEx() == 704 && keyEvent.getKeyCode() == 70) {
            System.out.println("Sending message to clear Focus Recepient Queue");
            this.getDispatcher().getFocusLogger().sendMessage(null, 4);
            keyEvent.consume();
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getDispatcher().isTabAccessKey(keyEvent)) {
            this.showDropDownMenu();
            keyEvent.consume();
            return;
        }
        if (keyEvent.getKeyCode() == 10 && this.isForDefaultButton()) {
            return;
        }
        String string = this.getApplet().getOsName();
        if (string.startsWith("Windows") && keyEvent.getModifiersEx() == 64 && keyEvent.getKeyCode() == 121) {
            if (this.isPopupMenuEnabled()) {
                this.sendShowOptionsEvent(keyEvent);
            }
            return;
        }
        if (KeyBinder.getFormAction(keyEvent) == null) {
            super.keyPressedImpl(keyEvent);
        } else {
            this.sendFinalMessage(false);
            this.sendFunctionKey(keyEvent.getKeyCode(), InputEventUtils.getMods(keyEvent));
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleasedImpl(KeyEvent keyEvent) {
        if (this.getDispatcher().isTabAccessKey(keyEvent) || keyEvent.getKeyCode() == 112) {
            keyEvent.consume();
            return;
        }
    }

    private void showDropDownMenu() {
        TabPanel tabPanel = this.getParentTabPanel();
        if (tabPanel != null) {
            tabPanel.showDropDownMenu();
        }
    }

    public void sendButtonPressedMessage(MessageHandler messageHandler) {
        Message message = Message.newMessage(messageHandler, 325, null);
        this.getDispatcher().onMessage(message, 0);
    }

    public void sendLOVButtonPressedMessage() {
        this.sendButtonPressedMessage(this.getHandler());
    }

    private void sendFunctionKey(int n, int n2) {
        Message message = Message.newMessage(this.getHandler(), 176, new Point(n, n2));
        this.getHandler().getDispatcher().onMessage(message, 0);
    }

    protected void sendFinalMessage(boolean bl) {
        Message message = this.getHandler().getFinalMessage();
        int n = 0;
        n = bl ? 0 : 1;
        if (message != null) {
            this.getHandler().getDispatcher().onMessage(message, n);
        }
    }

    protected void sendMouseEvent(MouseEvent mouseEvent, boolean bl) {
        Message message = Message.newMessage(this.getHandler(), 185, mouseEvent.getPoint());
        Message message2 = Message.newMessage(this.getHandler(), bl ? 180 : 181, message);
        int n = 15;
        int n2 = mouseEvent.getModifiers() & n;
        Byte by = (byte)((mouseEvent.getClickCount() << 4) + n2);
        Byte by2 = (byte)mouseEvent.getButton();
        message.add(186, by);
        message.add(325, by2);
        if (this.isMouseClickEnabled() || !bl) {
            this.getHandler().getDispatcher().onMessage(message2, 0);
        } else {
            this.getHandler().getDispatcher().onMessage(message2, 1);
        }
        if (bl) {
            this.getHandler().getDispatcher().setIsMouseDownMessageSent(true);
        } else {
            this.getHandler().getDispatcher().setIsMouseDownMessageSent(false);
        }
    }

    protected void sendShowOptionsEvent(AWTEvent aWTEvent) {
        Point point;
        Message message = null;
        if (aWTEvent instanceof MouseEvent) {
            point = ((MouseEvent)aWTEvent).getPoint();
        } else {
            int n = this.getEventComponent().getSize().width;
            point = new Point(n, 0);
        }
        message = Message.newMessage(this.getHandler(), 481, point);
        this.getHandler().getDispatcher().onMessage(message, 0);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
        String string = this.getApplet().getOsName();
        boolean bl = false;
        if (string.startsWith("Windows")) {
            if ((mouseEvent.getModifiersEx() & 0x1000) == 4096) {
                if ((mouseEvent.getModifiersEx() & 0x400) != 1024) {
                    bl = true;
                }
            }
        } else {
            bl = mouseEvent.isPopupTrigger();
        }
        if (bl && this.isPopupMenuEnabled()) {
            this.sendShowOptionsEvent(mouseEvent);
            this.mPopupMenuView = mouseEvent.getComponent();
            mouseEvent.consume();
        } else if (this.isMouseClickEnabled()) {
            this.sendMouseEvent(mouseEvent, true);
            this.retargetKeyEvent(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getHandler() != null && this.getEventComponent().isEnabled()) {
            if (mouseEvent.getComponent() == this.mPopupMenuView) {
                mouseEvent.consume();
            } else if (this.isMouseClickEnabled()) {
                this.sendMouseEvent(mouseEvent, false);
            }
        }
        this.mPopupMenuView = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getHandler() == null || !this.getEventComponent().isEnabled()) {
            return;
        }
    }

    public static void destroyAccessibilityUpdater() {
        sAccTask = null;
    }

    public static void scheduleAccessibilityTask(ComponentItem componentItem) {
        if (sAccTask != null) {
            TaskScheduler.getDefaultTaskScheduler().cancel(sAccTask);
            sAccTask = null;
        }
        sAccTask = new AccessibilityUpdater(componentItem);
        TaskScheduler.getDefaultTaskScheduler().schedule(sAccTask, 500);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private void setCustomProperty(Message message) {
        int n = message.size();
        String string = null;
        Object object = null;
        IView iView = this.getView();
        if (iView != null) {
            block4: for (int i = 0; i < n; ++i) {
                int n2 = message.getPropertyAt(i);
                Object object2 = message.getValueAt(i);
                switch (n2) {
                    case 403: {
                        string = (String)object2;
                        continue block4;
                    }
                    case 404: {
                        object = object2;
                        if (string == null || !ID.isRegistered(string)) continue block4;
                        ID iD = ID.registerProperty(string);
                        iView.setProperty(iD, object);
                        string = null;
                        continue block4;
                    }
                }
            }
        }
    }

    private boolean isForDefaultButton() {
        Component component = null;
        for (Component component2 = this.getComponent(); component2 != null; component2 = component2.getParent()) {
            if (component2.isVisible() && component2.isEnabled() && component2 instanceof PushButton && ((PushButton)component2).isDefault()) {
                return true;
            }
            if (component2 instanceof Container && this.findDefaultButtonInCont((Container)component2, component)) {
                return true;
            }
            if (component2 instanceof LWWindow) break;
            component = component2;
        }
        return false;
    }

    private boolean findDefaultButtonInCont(Container container, Component component) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = container.getComponent(i);
            if (component2 == component || !component2.isVisible() || !component2.isEnabled()) continue;
            if (component2 instanceof PushButton && ((PushButton)component2).isDefault()) {
                return true;
            }
            if (!(component2 instanceof Container) || !this.findDefaultButtonInCont((Container)component2, null)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewTabPage(ComponentItem componentItem) {
        TabPanel tabPanel = this.getParentTabPanel();
        TabPanel tabPanel2 = null;
        Container container = this.getComponent().getParent();
        Container container2 = null;
        boolean bl = false;
        if (componentItem != null) {
            tabPanel2 = componentItem.getParentTabPanel();
            container2 = componentItem.getComponent().getParent();
        }
        if (tabPanel != null && (tabPanel != tabPanel2 || container != container2)) {
            bl = true;
        }
        return bl;
    }

    private void addTabToAccessibleName() {
        Component component;
        String string = this.getParentTabName();
        if (string != null && (component = this.getAccessibleComponent()) instanceof LWComponent) {
            AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
            this.mOldAccessibleName = accessibleContext.getAccessibleName();
            accessibleContext.setAccessibleName(string + " tab page " + this.mOldAccessibleName);
        }
    }

    private void appendMnemonicToAccessibilityDesc(Character c) {
        Component component = this.getAccessibleComponent();
        MessageGenerator messageGenerator = this.getApplet().getTranslatedPhraseGenerator();
        if (component instanceof LWComponent) {
            AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
            String string = accessibleContext.getAccessibleDescription();
            string = string + messageGenerator.getText("ALT") + c.toString();
            accessibleContext.setAccessibleDescription(string);
            accessibleContext.setAccessibleName(string);
        }
    }

    private void clearTabFromAccessibleName() {
        if (this.mOldAccessibleName != null) {
            Component component = this.getComponent();
            if (component instanceof LWComponent) {
                AccessibleContext accessibleContext = ((LWComponent)component).getAccessibleContext();
                accessibleContext.setAccessibleName(this.mOldAccessibleName);
            }
            this.mOldAccessibleName = null;
        }
    }

    private String getParentTabName() {
        TabPanelPage tabPanelPage;
        String string = null;
        TabPanel tabPanel = this.getParentTabPanel();
        if (tabPanel != null && (tabPanelPage = tabPanel.getSelectedPage()) != null) {
            string = tabPanelPage.getLabel();
        }
        return string;
    }

    private TabPanel getParentTabPanel() {
        TabPanel tabPanel = null;
        Component component = this.getComponent();
        if (component instanceof TabPanel) {
            tabPanel = (TabPanel)component;
        } else {
            while (component != null && !(component instanceof DrawnPanel)) {
                component = component.getParent();
            }
            if (component != null) {
                block1: for (Container container = component.getParent(); container != null; container = container.getParent()) {
                    if (container instanceof TabPanel) {
                        tabPanel = (TabPanel)container;
                        break;
                    }
                    if (container instanceof DrawnPanel) {
                        int n;
                        Component[] componentArray = container.getComponents();
                        for (n = 0; n < componentArray.length && componentArray[n] != component; ++n) {
                        }
                        Point point = component.getLocation();
                        ++n;
                        while (n < componentArray.length) {
                            if (componentArray[n].isVisible() && componentArray[n] instanceof TabPanel) {
                                Rectangle rectangle = componentArray[n].getBounds();
                                if (rectangle.x <= point.x && point.x < rectangle.x + rectangle.width && rectangle.y <= point.y && point.y < rectangle.y + rectangle.height) {
                                    tabPanel = (TabPanel)componentArray[n];
                                    break block1;
                                }
                            }
                            ++n;
                        }
                        break;
                    }
                    component = container;
                }
            }
        }
        return tabPanel;
    }

    public boolean isParentTabPanel() {
        return this.getTabPanel() != null;
    }

    @Override
    public void customActionPerformed(CustomEvent customEvent) {
        Message message = new Message(this);
        Message message2 = new Message(this, 398, message);
        message.add(399, customEvent.getName().toString());
        this.addHandlerParams(message);
        this.addEventParams(message, customEvent);
        String string = Thread.currentThread().getName();
        if (!string.startsWith("AWT-EventQueue-")) {
            try {
                Component component = this.getApplet().getDesktop().getDesktopComponent();
                TimerEvent timerEvent = new TimerEvent(component, 2029, message2);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(timerEvent);
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.getDispatcher().onMessage(message2, 0);
            }
        } else {
            this.getDispatcher().onMessage(message2, 0);
        }
    }

    private void addHandlerParams(Message message) {
        if (this.mCustomParams == null || this.mCustomParams.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.mCustomParams.keys();
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            String string = this.mCustomParams.get(iD).toString();
            message.add(400, iD.toString());
            message.add(401, string);
        }
        this.mCustomParams.clear();
    }

    private void addEventParams(Message message, CustomEvent customEvent) {
        Enumeration enumeration = customEvent.getParameters();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            message.add(400, iD.toString());
            Object object = customEvent.getProperty(iD);
            if (object == null) {
                object = "";
            }
            message.add(401, object.toString());
        }
    }

    @Override
    public void setProperty(ID iD, Object object) {
        if (iD != null) {
            if (this.mCustomParams == null) {
                this.mCustomParams = new Hashtable();
            }
            if (object == null) {
                object = "";
            }
            this.mCustomParams.put(iD, object);
        }
    }

    @Override
    public void run() {
        this.setCustomProperty(this.mCustomMessage);
        this.mCustomMessage = null;
    }

    public byte getUIStyle() {
        return this.mUIStyle;
    }

    public boolean getGradientColorSet() {
        return this.mGradientColorSet;
    }

    public void setGradientColorSet(boolean bl) {
        this.mGradientColorSet = bl;
    }

    public void applyGradient(DrawnPanel drawnPanel, LWComponent lWComponent, Color color) {
        Container container;
        GradientPainter gradientPainter;
        if (this.mGradientStart == 0) {
            return;
        }
        Color color2 = this.mGradientColorSet && color != null ? color : UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.DARK_INTENSITY);
        Color color3 = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.LIGHT_INTENSITY);
        if (this.mGradientColorSet) {
            int n = this.getDispatcher().getGradientRedOffset();
            int n2 = this.getDispatcher().getGradientGreenOffset();
            int n3 = this.getDispatcher().getGradientBlueOffset();
            int n4 = color.getRed() + n;
            int n5 = color.getGreen() + n2;
            int n6 = color.getBlue() + n3;
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > 255) {
                n5 = 255;
            } else if (n5 < 0) {
                n5 = 0;
            }
            if (n6 > 255) {
                n6 = 255;
            } else if (n6 < 0) {
                n6 = 0;
            }
            color3 = new Color(n4, n5, n6);
        }
        GradientPainter gradientPainter2 = gradientPainter = this.mGradientStart == 1 || this.mGradientStart == 2 ? new GradientPainter(color2, color3) : new GradientPainter(color3, color2);
        if (this.mGradientStart == 1 || this.mGradientStart == 3) {
            gradientPainter.setVertical(true);
        }
        if (lWComponent != null) {
            lWComponent.setFill(gradientPainter);
            return;
        }
        drawnPanel.setFill(null);
        if (drawnPanel.getMDIFlag()) {
            ((LWComponent)container).setFill(gradientPainter);
            return;
        }
        for (container = drawnPanel; container != null; container = container.getParent()) {
            if (container == drawnPanel || !(container instanceof LWComponent)) continue;
            ((LWComponent)container).setFill(gradientPainter);
            break;
        }
    }
}

