/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintStream;
import java.util.EventObject;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.PushButton;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.Message;
import oracle.forms.handler.AppsModalStyle;
import oracle.forms.handler.DialogThread;
import oracle.forms.handler.UICommon;
import oracle.forms.ui.FWindow;
import oracle.forms.ui.mdi.MDIContainer;

public abstract class CommonDialog
extends UICommon
implements MouseListener,
PropertyChangeListener,
VetoableChangeListener,
ComponentListener {
    protected LWWindow mDialog;
    private EwtContainer mContent;
    private PushButton mCancelButton;
    private boolean mIsResizable;
    private boolean mIsAutoCenter = true;
    private boolean mIsAutoSize = true;
    private boolean mDialogClosing = false;

    public abstract void actionPerformed(ActionEvent var1);

    public LWWindow createDialog(LWWindow lWWindow, boolean bl) {
        FWindow fWindow = new FWindow(WindowType.DIALOG, lWWindow, bl);
        MDIContainer mDIContainer = this.getApplet().getMDIContainer();
        fWindow.setModalStyle(AppsModalStyle.getAppsModalStyle(mDIContainer.getMDIScrollBox()));
        fWindow.addKeyListener(this);
        fWindow.addMouseListener(this);
        fWindow.addPropertyChangeListener(this);
        fWindow.addVetoableChangeListener(this);
        this.mContent = new EwtContainer();
        fWindow.setContent(this.mContent);
        FocusUtils.setDefaultFocusTraversalKeys(fWindow);
        this.getApplet().getDesktop().addWindow(fWindow, false);
        this.setIcon(null);
        return fWindow;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 539: {
                this.mDialog.setName((String)object);
                break;
            }
            case 137: {
                Insets insets = ((Container)this.getComponent()).getInsets();
                Point point = new Point((Point)object);
                point.x += insets.left + insets.right;
                point.y += insets.top + insets.bottom;
                this.setSize(point);
                this.getComponent().setSize(point.x, point.y);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        LWWindow lWWindow = (LWWindow)this.getComponent();
        if (lWWindow != null) {
            this.getApplet().getDesktop().removeWindow(lWWindow);
            lWWindow.setModalStyle(null);
            lWWindow.removeKeyListener(this);
            lWWindow.removeMouseListener(this);
            lWWindow.removePropertyChangeListener(this);
            lWWindow.removeVetoableChangeListener(this);
            lWWindow.setContent(null);
            lWWindow.setLeader(null);
        }
        super.onDestroy();
        this.mDialog = null;
        this.mCancelButton = null;
    }

    protected void setCancelButton(PushButton pushButton) {
        this.mCancelButton = pushButton;
    }

    public void setAutoCenter(boolean bl) {
        this.mIsAutoCenter = bl;
    }

    public void setAutoSize(boolean bl) {
        this.mIsAutoSize = bl;
    }

    public boolean isAutoCenter() {
        return this.mIsAutoCenter;
    }

    public boolean isAutoSize() {
        return this.mIsAutoSize;
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.getDispatcher().getIdleThread() != null) {
            this.getDispatcher().getIdleThread().reset();
        }
        this.retargetKeyEvent(keyEvent.getSource());
        this.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.getKeyEventTarget() != keyEvent.getSource()) {
            keyEvent.consume();
            return;
        }
        this.keyTypedImpl(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.getHandler() == null || this.getDispatcher() == null) {
            return;
        }
        if (this.getKeyEventTarget() != keyEvent.getSource()) {
            keyEvent.consume();
            this.retargetKeyEvent(keyEvent.getSource());
            return;
        }
        this.keyReleasedImpl(keyEvent);
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            keyEvent.consume();
            this.doCancelDialog();
        }
    }

    protected void sendCancelDialogEvent() {
        Message message = Message.newMessage(this, 105, null);
        this.getDispatcher().onMessage(message, 0);
    }

    protected void doCancelDialog() {
        if (this.mCancelButton == null) {
            this.disposeDialog();
            this.sendCancelDialogEvent();
        } else {
            ActionEvent actionEvent = new ActionEvent(this.mCancelButton, 1001, null);
            this.actionPerformed(actionEvent);
        }
    }

    @Override
    public void doShowComponent(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.mDialog.setVisible(false);
        }
    }

    public void show() {
        if (this.mIsAutoSize) {
            this.mDialog.pack();
        } else {
            Dimension dimension = this.getComponent().getSize();
            Dimension dimension2 = this.getComponent().getMinimumSize();
            if (dimension.width < dimension2.width || dimension.height < dimension2.height) {
                if (dimension.width < dimension2.width) {
                    dimension.width = dimension2.width;
                }
                if (dimension.height < dimension2.height) {
                    dimension.height = dimension2.height;
                }
                this.getComponent().setSize(dimension);
            }
        }
        if (this.mIsAutoCenter) {
            this.center();
        }
        DialogThread.showDialog(this.mDialog);
        if (!this.mIsResizable) {
            this.mDialog.setResizable(this.mIsResizable);
        }
    }

    public void setResizable(boolean bl) {
        this.mIsResizable = bl;
    }

    public boolean isResizable() {
        return this.mIsResizable;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    protected String processLabel(String string, LWComponent lWComponent) {
        String string2 = string == null || string.equals("") ? " " : string;
        int n = StringUtils.getMnemonicIndex(string2);
        if (n != -1) {
            lWComponent.setMnemonicIndex(n);
        } else {
            char[] cArray = string2.toCharArray();
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!Character.isUpperCase(cArray[i])) continue;
                lWComponent.setMnemonicIndex(i);
                break;
            }
        }
        return StringUtils.stripMnemonic(string2);
    }

    private void center() {
        Dimension dimension = this.mDialog.getSize();
        Point point = this.mDialog.getParent().getLocation();
        Dimension dimension2 = this.mDialog.getParent().getParent().getSize();
        int n = (dimension2.width - dimension.width) / 2 - point.x;
        int n2 = (dimension2.height - dimension.height) / 2 - point.y;
        if (n < 0 || n2 < 0) {
            if (this.getDirection() == 2) {
                Dimension dimension3 = this.getApplet().getSize();
                n = -dimension3.width;
                n2 = 0;
            } else {
                n = 100;
                n2 = 100;
            }
        }
        this.mDialog.setLocation(n, n2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getPropertyName() == "closed" && !this.mDialogClosing && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.mDialogClosing = true;
            this.handleWindowClosing(propertyChangeEvent);
            this.mDialogClosing = false;
        }
    }

    protected void handleWindowClosing(EventObject eventObject) {
        this.doCancelDialog();
    }

    public EwtContainer getContent() {
        return this.mContent;
    }

    protected void disposeDialog() {
        if (!this.mDialogClosing && this.mDialog != null) {
            this.mDialogClosing = true;
            this.mDialog.dispose();
            this.mDialogClosing = false;
        }
    }

    public void setIcon(Image image) {
        if (this.mDialog != null) {
            if (image != null && !ImageUtils.loadImage(image)) {
                image = null;
            }
            if (image == null) {
                image = this.getDefaultFrameIcon();
            }
            if (image != null) {
                this.mDialog.setFrameIcon(image);
            }
        }
    }
}

