/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.PrintStream;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.SelectionEvent;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.FormMenu;
import oracle.forms.handler.PopListItem;
import oracle.forms.properties.ID;
import oracle.forms.ui.ExtendedFrame;
import oracle.forms.ui.IView;
import oracle.forms.ui.VComboBox;

public class ComboBoxItem
extends PopListItem
implements TextListener,
SelectionListener {
    private static int sHandlerClassId = 0;
    private boolean mDirty = false;
    private String mUserItem = "";
    private boolean mSelectionEmpty = true;
    private boolean mMaxLengthIsBytes = false;
    private int mMaxLength = Integer.MAX_VALUE;
    private boolean mAutoComplete = false;

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.getView().addListener(TextListener.class, this);
        this.getView().addListener(SelectionListener.class, this);
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(TextListener.class, this);
            this.getView().removeListener(SelectionListener.class, this);
        }
        super.onDestroy();
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 338: {
                this.mUserItem = (String)object;
                this.setDirty(false);
                this.mUserLength = -1;
                break;
            }
            case 528: {
                this.mMaxLengthIsBytes = (Boolean)object;
                break;
            }
            case 117: {
                this.mMaxLength = (Integer)object;
                if (this.getDispatcher().isSurrogatePairSupportEnabled()) {
                    object = Integer.MAX_VALUE;
                }
                this.getView().setProperty(ID.MAX_LENGTH, (Integer)object);
                break;
            }
            case 583: {
                this.mAutoComplete = (Boolean)object;
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public synchronized Object onGet(int n) {
        switch (n) {
            case 338: {
                return this.mUserItem;
            }
        }
        return super.onGet(n);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.setBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mRolloverEntryPainter != null || this.mRolloverPainter != null) {
            this.clearBorderRolloverColor();
            ((Component)((Object)this.getView())).repaint();
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this.mSavedIndex = this.mOldIndex;
            this.mOldIndex = (Integer)this.getView().getProperty(ID.SELECTEDINDEX);
            Message message = new Message(this, 131, this.getView().getProperty(ID.SELECTEDINDEX));
            this.getDispatcher().onMessage(message, 0);
            this.mDirty = bl;
        }
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown() && (keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 35)) {
            return;
        }
        if (keyEvent.isControlDown() && (keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 86 || keyEvent.getKeyCode() == 88)) {
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    public void keyReleasedImpl(KeyEvent keyEvent) {
        super.keyReleasedImpl(keyEvent);
    }

    @Override
    public void keyTypedImpl(KeyEvent keyEvent) {
        if ((keyEvent.getModifiersEx() & 0x380) != 0) {
            keyEvent.consume();
        }
        super.keyTypedImpl(keyEvent);
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getView()) {
            String string = (String)this.getView().getProperty(ID.USERTEXT);
            int n = (Integer)this.getView().getProperty(ID.SELECTEDINDEX);
            if (n == -1 && this.getDispatcher().compareStringAgainstMaxLength(string, this.mMaxLength, this.mMaxLengthIsBytes, false, null) > 0) {
                int n2 = -1;
                Object object = this.getView().getProperty(ID.CURSOR_POSITION);
                if (object instanceof Integer) {
                    n2 = (Integer)object;
                } else {
                    Object object2 = this.getView().getProperty(ID.SELECTION);
                    if (object2 instanceof Point) {
                        n2 = ((Point)object2).y;
                    }
                }
                this.getView().setProperty(ID.SELECT, this.mUserItem);
                if (n2 >= 0) {
                    if ((n2 -= string.length() - this.mUserItem.length()) < 0) {
                        n2 = 0;
                    }
                    if (!this.getView().setProperty(ID.CURSOR_POSITION, n2)) {
                        this.getView().setProperty(ID.SELECTION, new Point(n2, n2));
                    }
                }
                Toolkit.getDefaultToolkit().beep();
            } else {
                boolean bl = false;
                boolean bl2 = false;
                if (this.mAutoComplete && string.length() > 0) {
                    int n3 = ((ComboBox)((Object)this.getView())).getItemCount();
                    for (int i = 0; i < n3; ++i) {
                        if (!((ComboBox)((Object)this.getView())).getItem(i).startsWith(string)) continue;
                        if (this.mOldIndex == i && string.length() <= this.mUserLength) {
                            this.mUserLength = -1;
                            bl2 = true;
                            break;
                        }
                        this.selectValue(i);
                        this.getView().setProperty(ID.SELECTION, new Point(string.length(), ((ComboBox)((Object)this.getView())).getItem(i).length()));
                        this.mUserLength = string.length();
                        if (this.mOldIndex == i) {
                            return;
                        }
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    String string2 = string.toLowerCase();
                    if (!bl2) {
                        for (int i = 0; i < n3; ++i) {
                            if (!((ComboBox)((Object)this.getView())).getItem(i).toLowerCase().startsWith(string2)) continue;
                            if (this.mOldIndex == i && string2.length() <= this.mUserLength) {
                                this.mUserLength = -1;
                                break;
                            }
                            this.selectValue(i);
                            this.getView().setProperty(ID.SELECTION, new Point(string2.length(), ((ComboBox)((Object)this.getView())).getItem(i).length()));
                            this.mUserLength = string2.length();
                            if (this.mOldIndex == i) {
                                return;
                            }
                            bl = true;
                            break;
                        }
                    }
                }
                this.mUserItem = string;
                this.setDirty(true);
                if (bl) {
                    this.mSavedIndex = -2;
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.getHandler() == null) {
            return;
        }
        this.mUserLength = -1;
        super.focusLost(focusEvent);
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        if (selectionEvent.isSelectionEmpty() != this.mSelectionEmpty) {
            FormMenu formMenu;
            boolean bl = this.mSelectionEmpty = !this.mSelectionEmpty;
            if (this.getDispatcher().getFocusOwner() == this && (formMenu = ((ExtendedFrame)this.getParentWindow()).getHandler().getMenu()) != null && formMenu.getMenuInfo() != null && this.getView() instanceof LWComponent) {
                LWTextField lWTextField = null;
                lWTextField = ((ComboBox)((Object)this.getView())).getLWTextField();
                formMenu.getMenuInfo().doEnableCopy(!this.mSelectionEmpty, lWTextField.isEditable());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        IView iView = this.getView();
        if (iView instanceof ComboBox) {
            ComboBox comboBox = (ComboBox)((Object)iView);
            String string = "false";
            if (this.getParameter("disallowDisabledComboTraversal") != null) {
                string = this.getParameter("disallowDisabledComboTraversal");
            }
            if (mouseEvent.getSource() == comboBox.getLWTextField() && (comboBox.isEnabled() || string.equalsIgnoreCase("False"))) {
                Message message = new Message(this, 332, null);
                this.getDispatcher().onMessage(message, 0);
            }
        }
        super.mouseReleased(mouseEvent);
    }

    @Override
    protected Class getDefaultClass() {
        return VComboBox.class;
    }

    @Override
    protected void setUserItemFromSelection() {
        this.mUserItem = (String)this.getView().getProperty(ID.USERTEXT);
    }

    @Override
    protected void selectValue(Integer n) {
        if (n == -1) {
            this.getView().setProperty(ID.SELECT, this.mUserItem);
        } else {
            this.getView().setProperty(ID.SELECT, n);
            this.setUserItemFromSelection();
        }
        this.setDirty(false);
    }
}

