/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintStream;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.properties.ID;
import oracle.forms.ui.IView;
import oracle.forms.ui.VButton;

public class ButtonItem
extends ComponentItem
implements ActionListener {
    private static int sHandlerClassId = 0;
    private boolean mSwapColors = false;
    private boolean mUseRolloverBorderColor = false;
    private Color mSwapBG = null;
    private Color mSwapFG = null;
    private Color mBackground = IView.DEFAULT_COLOR;
    public static final byte BUTTON_ROUND_NONE = 0;
    public static final byte BUTTON_ROUND_LEFT = 1;
    public static final byte BUTTON_ROUND_RIGHT = 2;
    public static final byte BUTTON_ROUND_BOTH = 3;

    public ButtonItem() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.setComponent((Component)((Object)this.getView()));
        this.getView().addListener(ActionListener.class, this);
        this.getView().addListener(FocusListener.class, this);
        this.getView().addListener(KeyListener.class, this);
        this.getView().addListener(MouseListener.class, this);
        this.getView().addListener(MouseMotionListener.class, this);
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 324: {
                this.getView().setProperty(ID.IS_DEFAULT, object);
                break;
            }
            case 116: {
                this.getView().setProperty(ID.LABEL, (String)object);
                break;
            }
            case 580: {
                this.getView().setProperty(ID.BUTTON_ROUND, (Byte)object);
                break;
            }
            case 572: {
                this.mSwapColors = (Boolean)object;
                break;
            }
            case 568: {
                this.mGradientStart = (Byte)object;
                this.applyGradient(null, (LWComponent)((Object)this.getView()), this.mBackground);
                break;
            }
            case 148: {
                super.onUpdate(n, object);
                this.applyGradient(null, (LWComponent)((Object)this.getView()), this.mBackground);
                break;
            }
            case 147: {
                super.onUpdate(n, object);
                int n2 = (Integer)object;
                this.mBackground = this.getHandler().getDispatcher().getColorEntry(n2);
                if (n2 != 255) {
                    this.setGradientColorSet(true);
                } else {
                    this.setGradientColorSet(false);
                }
                this.applyGradient(null, (LWComponent)((Object)this.getView()), this.mBackground);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.getView() != null) {
            this.getView().removeListener(ActionListener.class, this);
            this.getView().removeListener(FocusListener.class, this);
            this.getView().removeListener(KeyListener.class, this);
            this.getView().removeListener(MouseListener.class, this);
            this.getView().removeListener(MouseMotionListener.class, this);
        }
        super.onDestroy();
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getHandler() == null || this.getParentWindow() != null && !this.getParentWindow().isActive()) {
            return;
        }
        this.sendButtonPressedMessage(this.getHandler());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (((Boolean)this.getView().getProperty(ID.ROLLOVER_EDGE)).booleanValue() && ((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            this.mUseRolloverBorderColor = true;
            ((Component)((Object)this.getView())).repaint();
        }
        if (!this.mSwapColors || !((Boolean)this.getView().getProperty(ID.ENABLED)).booleanValue()) {
            return;
        }
        Color color = (Color)this.getView().getProperty(ID.BACKGROUND);
        Color color2 = (Color)this.getView().getProperty(ID.FOREGROUND);
        Color color3 = null;
        ColorScheme colorScheme = UIManager.getLookAndFeel().getDefaultColorScheme();
        String string = colorScheme.getName();
        if (!string.equalsIgnoreCase("BLAF") && !string.equalsIgnoreCase("Swan") && color.equals(UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.LIGHT_INTENSITY))) {
            color3 = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.NORMAL_INTENSITY);
            this.getView().setProperty(ID.BACKGROUND, color3);
            this.mSwapBG = color;
            this.mSwapFG = null;
        } else if (string.equalsIgnoreCase("Swan") && color.equals(UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.PINSTRIPE3))) {
            color3 = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.VERY_DARK_INTENSITY);
            this.getView().setProperty(ID.BACKGROUND, color3);
            this.mSwapBG = color;
            this.mSwapFG = null;
        } else {
            this.getView().setProperty(ID.BACKGROUND, color2);
            this.getView().setProperty(ID.FOREGROUND, color);
            this.mSwapBG = color;
            this.mSwapFG = color2;
            color3 = color2;
        }
        if (this.mGradientStart == 0) {
            this.updatePattern((Component)((Object)this.getView()), false);
        } else {
            this.applyGradient(null, (LWComponent)((Object)this.getView()), color3);
        }
    }

    public boolean useRolloverBorderColor() {
        return this.mUseRolloverBorderColor;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mUseRolloverBorderColor) {
            this.mUseRolloverBorderColor = false;
            ((Component)((Object)this.getView())).repaint();
        }
        if (!this.mSwapColors) {
            return;
        }
        if (this.mSwapBG != null) {
            this.getView().setProperty(ID.BACKGROUND, this.mSwapBG);
        }
        if (this.mSwapFG != null) {
            this.getView().setProperty(ID.FOREGROUND, this.mSwapFG);
        }
        this.mSwapFG = null;
        this.mSwapBG = null;
        if (this.mGradientStart == 0) {
            this.updatePattern((Component)((Object)this.getView()), false);
        } else {
            this.applyGradient(null, (LWComponent)((Object)this.getView()), this.mBackground);
        }
    }

    @Override
    public void keyPressedImpl(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            return;
        }
        super.keyPressedImpl(keyEvent);
    }

    @Override
    protected Class getDefaultClass() {
        return VButton.class;
    }
}

