/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import oracle.ewt.lwAWT.LWScrollbar;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.UICommon;

public class BlockScroller
extends ComponentItem
implements AdjustmentListener,
MouseListener {
    private static int sHandlerClassId = 0;
    private LWScrollbar mScrollbar = null;
    private int mValue = 0;
    private Point mRange = new Point(0, 0);
    private int mThumbSize = 0;
    private int mScrollType = 0;
    private boolean mReversed;
    private boolean isLastRecord = false;
    private Object mFrmWheelHandler = null;
    public static final int MSG_PAGEDOWN = 1;
    public static final int MSG_PAGEUP = 2;
    public static final int MSG_LINEDOWN = 3;
    public static final int MSG_LINEUP = 4;
    public static final int MSG_TOP = 5;
    public static final int MSG_BOTTON = 6;
    public static final int MSG_DRAG = 7;
    public static final int MSG_POSITION = 8;

    public BlockScroller() {
        this.setHandler(this);
    }

    @Override
    public void onRegister(int n) {
        sHandlerClassId = n;
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        super.onCreate(runform, message);
        this.mScrollbar = new LWScrollbar();
        this.mScrollbar.addAdjustmentListener(this);
        this.mScrollbar.addMouseListener(this);
        this.setComponent(this.mScrollbar);
        if (this.getApplet().getJDKVersionNumber() >= 1.4) {
            try {
                Class<?> clazz = Class.forName("oracle.forms.handler.FormsMouseWheelHandler");
                Class[] classArray = new Class[]{BlockScroller.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                this.mFrmWheelHandler = constructor.newInstance(objectArray);
                this.setMouseWheelListener(this.mScrollbar);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        this.onUpdate(message);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        boolean bl = true;
        Object var4_4 = null;
        switch (n) {
            case 254: {
                if (((Boolean)object).booleanValue()) {
                    this.mScrollbar.setOrientation(0);
                    break;
                }
                this.mScrollbar.setOrientation(1);
                break;
            }
            case 131: {
                this.mValue = (Integer)object;
                if (this.isLastRecord) {
                    this.isLastRecord = false;
                }
                this.setValues();
                break;
            }
            case 121: {
                this.mRange = (Point)object;
                if (this.mScrollbar.getMaximum() != this.mRange.y && this.isLastRecord) {
                    this.isLastRecord = false;
                }
                this.setValues();
                break;
            }
            case 250: {
                this.mThumbSize = (Integer)object;
                this.setValues();
                break;
            }
            case 251: {
                this.mScrollbar.setUnitIncrement((Integer)object);
                break;
            }
            case 252: {
                this.mScrollbar.setBlockIncrement((Integer)object);
                break;
            }
            case 255: {
                boolean bl2 = this.mReversed = object == Boolean.TRUE;
                if (this.getDirection() != 2 || this.mScrollbar.getOrientation() != 0) break;
                this.mReversed = !this.mReversed;
                break;
            }
            case 518: {
                this.mScrollbar.addMouseListener(this);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public synchronized Object onGet(int n) {
        switch (n) {
            case 251: {
                return this.mScrollbar.getUnitIncrement();
            }
            case 252: {
                return this.mScrollbar.getBlockIncrement();
            }
        }
        return super.onGet(n);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mScrollbar.removeMouseListener(this);
        this.mFrmWheelHandler = null;
        this.mScrollbar = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        UICommon.setNeedScrollbarMouseReleasedEvent(new MouseEvent(this.getComponent(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        UICommon.setNeedScrollbarMouseReleasedEvent(null);
        if (this.mScrollType == 8) {
            this.mScrollType = 0;
            Message message = new Message(this);
            Message message2 = new Message(this, 479, message);
            message.add(131, this.getValue());
            message.add(250, this.mThumbSize);
            message.add(256, 8);
            this.getDispatcher().onMessage(message2, 0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getAdjustmentType();
        if (this.getDispatcher() == null) {
            return;
        }
        Message message = new Message(this);
        Message message2 = new Message(this, 479, message);
        this.mValue = this.mScrollbar.getValue();
        message.add(131, this.getValue());
        message.add(250, this.mThumbSize);
        switch (n) {
            case 4: {
                message.add(256, this.mReversed ? 2 : 1);
                break;
            }
            case 3: {
                message.add(256, this.mReversed ? 1 : 2);
                if (!this.isLastRecord) break;
                this.isLastRecord = false;
                break;
            }
            case 1: {
                message.add(256, this.mReversed ? 4 : 3);
                break;
            }
            case 2: {
                message.add(256, this.mReversed ? 3 : 4);
                if (!this.isLastRecord) break;
                this.isLastRecord = false;
                break;
            }
            case 5: {
                if (this.isLastRecord) {
                    this.isLastRecord = false;
                }
                this.mScrollType = 8;
                message = null;
                message2 = null;
                return;
            }
        }
        this.getDispatcher().onMessage(message2, 0);
    }

    private final int getValue() {
        return this.mReversed ? this.mRange.y - this.mThumbSize - this.mValue : this.mValue;
    }

    private void setValues() {
        this.mScrollbar.setValues(this.getValue(), this.mThumbSize, this.mRange.x, this.mRange.y);
    }

    @Override
    protected void updatePattern(Component component, boolean bl) {
    }

    public void handleMouseWheelMotion(int n) {
        if (this.mThumbSize == this.mScrollbar.getMaximum() || !this.getParentWindow().isActive() || !this.mScrollbar.isEnabled()) {
            return;
        }
        if (n > 0 && this.mValue == this.mScrollbar.getMaximum() - this.mThumbSize && this.isLastRecord) {
            return;
        }
        Message message = new Message(this);
        Message message2 = new Message(this, 479, message);
        this.mValue = this.mValue == 0 && n < 0 ? 0 : (this.mValue += n);
        if (n < 0 && this.isLastRecord) {
            this.isLastRecord = false;
        }
        if (this.mValue > this.mScrollbar.getMaximum() - this.mThumbSize) {
            this.mValue = this.mScrollbar.getMaximum() - this.mThumbSize;
            this.isLastRecord = true;
        }
        this.setValues();
        message.add(131, this.getValue());
        message.add(250, this.mThumbSize);
        if (n > 0) {
            message.add(256, 3);
            this.getDispatcher().onMessage(message2, 0);
        } else if (n < 0) {
            message.add(256, 4);
            this.getDispatcher().onMessage(message2, 0);
        }
    }

    public void setMouseWheelListener(Component component) {
        if (this.mFrmWheelHandler == null) {
            return;
        }
        try {
            Class<?> clazz = this.mFrmWheelHandler.getClass();
            Class[] classArray = new Class[]{Component.class};
            Object[] objectArray = new Object[]{component};
            Method method = clazz.getMethod("addMouseWheelListener", classArray);
            method.invoke(this.mFrmWheelHandler, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

