/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.handler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.PrintStream;
import javax.accessibility.AccessibleContext;
import oracle.ewt.alert.AlertPane;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.CommonDialog;
import oracle.forms.handler.DialogThread;
import oracle.forms.handler.UICommon;
import oracle.forms.registry.MessageGenerator;

public class AlertDialog
extends CommonDialog
implements ActionListener {
    private static int sHandlerClassId = 0;
    private AlertPane mAlert;
    private String mYesBtnLabel;
    private String mNoBtnLabel;
    private String mCancelBtnLabel;
    private String mMessage;
    private int mIcon;
    private byte mButtons = (byte)-1;
    private byte mDefaultButtonCode = (byte)-1;
    private String mTitle = null;
    private Color mForeground = null;
    private Color mBackground = null;
    private LWWindow mOwner;
    private byte mDirection = 1;
    private LWWindow mAlertDialog;
    private String mName = null;
    public static final String DEFAULT_ALERT_DLG_NAME = "Forms_Alert_Dialog";
    private static final byte MNEMONIC_INDEX_DEFAULT = 0;
    public static final byte ALERT_ICON_STOP = 1;
    public static final byte ALERT_ICON_CAUTION = 2;
    public static final byte ALERT_ICON_NOTE = 3;
    public static final byte ALERT_BUTTON_NONE = 0;
    public static final byte ALERT_BUTTON_YES = 1;
    public static final byte ALERT_BUTTON_NO = 2;
    public static final byte ALERT_BUTTON_CANCEL = 4;

    public AlertDialog() {
        this.setHandler(this);
    }

    @Override
    public synchronized void onRegister(int n) {
        sHandlerClassId = n;
    }

    private void createAlert() {
        Runform runform = this.getDispatcher();
        this.mAlert = new AlertPane("", this.mIcon, this.mButtons);
        this.mAlertDialog = DialogThread.createAlertDialog(runform, runform.getFrame(), this.mAlert);
        this.setComponent(this.mAlertDialog);
        this.mAlertDialog.addPropertyChangeListener(this);
        Image[] imageArray = this.getDispatcher().getNewAlertImages();
        if (imageArray[this.mIcon] != null) {
            this.mAlert.setIcon(imageArray[this.mIcon]);
        }
        if (this.mYesBtnLabel != null && (this.mButtons & 1) > 0) {
            this.setAlertButtonLabel(1, this.mYesBtnLabel);
        }
        if (this.mNoBtnLabel != null && (this.mButtons & 2) > 0) {
            this.setAlertButtonLabel(2, this.mNoBtnLabel);
        }
        if (this.mCancelBtnLabel != null && (this.mButtons & 4) > 0) {
            this.setAlertButtonLabel(4, this.mCancelBtnLabel);
        }
        if (this.mTitle != null) {
            this.mAlertDialog.setTitle(this.mTitle);
        }
        if (this.mName != null) {
            if (this.mName.length() == 0 && this.getDispatcher().getRecordNames()) {
                this.mName = DEFAULT_ALERT_DLG_NAME;
            }
            this.mAlertDialog.setName(this.mName);
        }
        if (this.mMessage != null) {
            this.mAlert.setMessage(this.mMessage);
        }
        if (this.mForeground != null) {
            this.mAlert.setForeground(this.mForeground);
            this.propagateColor(this.mAlert, true);
        }
        if (this.mBackground != null) {
            this.mAlert.setBackground(this.mBackground);
            this.propagateColor(this.mAlert, false);
        }
        if (this.mDirection == 2) {
            this.mAlert.setReadingDirection(2);
            this.mAlertDialog.setReadingDirection(2);
        } else {
            this.mAlert.setReadingDirection(1);
            this.mAlertDialog.setReadingDirection(1);
        }
    }

    @Override
    public synchronized void onCreate(Runform runform, Message message) {
        Object object = null;
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        runform.setBIDIText();
        super.onCreate(runform, message);
        this.mOwner = runform.getFrame();
        int n = message.size();
        block19: for (int i = 0; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            object = message.getValueAt(i);
            switch (n2) {
                case 119: {
                    this.mYesBtnLabel = (String)object;
                    continue block19;
                }
                case 118: {
                    this.mNoBtnLabel = (String)object;
                    continue block19;
                }
                case 106: {
                    this.mCancelBtnLabel = (String)object;
                    continue block19;
                }
                case 539: {
                    this.mName = (String)object;
                    continue block19;
                }
                case 129: {
                    this.mTitle = (String)object;
                    continue block19;
                }
                case 172: {
                    this.mMessage = (String)object;
                    continue block19;
                }
                case 294: {
                    switch ((Byte)object) {
                        case 1: {
                            this.mIcon = 0;
                            continue block19;
                        }
                        case 2: {
                            this.mIcon = 1;
                            continue block19;
                        }
                        case 3: {
                            this.mIcon = 2;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case 146: {
                    this.mForeground = this.getDispatcher().getColorEntry((Integer)object);
                    continue block19;
                }
                case 147: {
                    this.mBackground = this.getDispatcher().getColorEntry((Integer)object);
                    continue block19;
                }
                case 295: {
                    this.mButtons = (Byte)object;
                    continue block19;
                }
                case 296: {
                    this.mDefaultButtonCode = (Byte)object;
                    continue block19;
                }
                case 165: {
                    this.mDirection = (Byte)object;
                    continue block19;
                }
            }
        }
        if (this.mButtons == -1) {
            this.mButtons = (byte)7;
        }
        this.createAlert();
        this.mAlertDialog.addComponentListener(this);
        AccessibleContext accessibleContext = this.mAlertDialog.getAccessibleContext();
        String string = this.mTitle + " " + this.mMessage;
        accessibleContext.setAccessibleDescription(string);
        accessibleContext.setAccessibleName(string);
    }

    @Override
    public synchronized boolean onUpdate(int n, Object object) {
        Object var3_3 = null;
        boolean bl = true;
        switch (n) {
            case 114: {
                Image image = this.getApplet().getCustomImage((String)object);
                MediaTracker mediaTracker = new MediaTracker(this.mAlertDialog);
                try {
                    mediaTracker.addImage(image, 0);
                    mediaTracker.waitForAll();
                    if (mediaTracker.isErrorAny()) {
                        image = this.getApplet().getDefaultImage("badimage");
                        MessageGenerator messageGenerator = this.getApplet().getErrorMessageGenerator();
                        System.out.println(messageGenerator.getMessage("FRM-92474", (String)object));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAlert.setIcon(image);
                break;
            }
            default: {
                bl = super.onUpdate(n, object);
            }
        }
        return bl;
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.getDispatcher().getFrame() != this.mOwner) {
            this.doShowComponent(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getDispatcher() == null) {
            return;
        }
    }

    @Override
    public synchronized void onGet(Message message) {
    }

    @Override
    public synchronized void onDestroy() {
        super.onDestroy();
        if (this.mAlertDialog != null) {
            this.mAlertDialog.dispose();
            this.mAlertDialog = null;
        }
        this.mAlert = null;
        this.mOwner = null;
    }

    @Override
    public int getHandlerClassId() {
        return sHandlerClassId;
    }

    public LWWindow getOwner() {
        return this.mOwner;
    }

    @Override
    public void doShowComponent(boolean bl) {
        if (bl) {
            LWWindow lWWindow = this.getDispatcher().getFrame();
            if (lWWindow != this.mOwner) {
                this.mOwner = lWWindow;
                this.createAlert();
            }
            Dimension dimension = this.getApplet().getFrame().getSize();
            this.mAlert.setSize(dimension);
            this.mAlert.validate();
            dimension = this.mAlert.getMinimumSize();
            this.mAlert.setSize(dimension);
            this.mAlertDialog.setSize(dimension);
            this.mAlertDialog.validate();
            MouseEvent mouseEvent = UICommon.getNeedScrollbarMouseReleasedEvent();
            if (mouseEvent != null) {
                Object object = mouseEvent.getSource();
                if (object instanceof LWComponent) {
                    ((LWComponent)object).redispatchEvent(mouseEvent);
                }
                UICommon.setNeedScrollbarMouseReleasedEvent(null);
            }
            DialogThread.showUserAlert(this.mAlertDialog, this.mAlert, this.mButtons, this, this.getDispatcher());
        } else {
            this.mAlert.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getPropertyName() == "active" && object == Boolean.TRUE && this.mDefaultButtonCode != -1) {
            this.mAlert.setDefaultButton(this.mDefaultButtonCode);
        }
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    private void setAlertButtonLabel(int n, String string) {
        int n2 = StringUtils.getMnemonicIndex(string);
        if (n2 != -1) {
            String string2 = StringUtils.stripMnemonic(string);
            this.mAlert.setButtonLabel(n, string2);
            this.mAlert.setButtonMnemonicIndex(n, n2);
        } else {
            this.mAlert.setButtonLabel(n, string);
            if (this.getDispatcher().getMaxServerBytesPerChar() > 1 && this.isClientLanguageCJK()) {
                this.mAlert.setButtonMnemonicIndex(n, -1);
            } else {
                char[] cArray = string.toCharArray();
                int n3 = cArray.length;
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    if (!Character.isUpperCase(cArray[i])) continue;
                    this.mAlert.setButtonMnemonicIndex(n, i);
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.mAlert.setButtonMnemonicIndex(n, 0);
                }
            }
        }
    }

    private boolean isClientLanguageCJK() {
        boolean bl = false;
        String string = this.mAlert.getLocale().getLanguage();
        if (string == "zh" || string == "ja" || string == "ko") {
            bl = true;
        }
        return bl;
    }

    private void propagateColor(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof PushButton) continue;
                if (bl) {
                    componentArray[i].setForeground(this.mForeground);
                } else {
                    componentArray[i].setBackground(this.mBackground);
                }
                if (!(componentArray[i] instanceof Container)) continue;
                this.propagateColor((Container)componentArray[i], bl);
            }
        }
    }
}

