/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.fd;

import java.applet.AudioClip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.forms.fd.AppletSoundList;

public class SoundApplet
extends JApplet
implements ActionListener,
ItemListener {
    AppletSoundList soundList;
    String auFile = "spacemusic.au";
    String aiffFile = "flute+hrn+mrmba.aif";
    String midiFile = "trippygaia1.mid";
    String rmfFile = "jungle.rmf";
    String wavFile = "bottle-open.wav";
    String chosenFile;
    AudioClip onceClip;
    AudioClip loopClip;
    JComboBox formats;
    JButton playButton;
    JButton loopButton;
    JButton stopButton;
    boolean looping = false;

    public void init() {
        String[] fileTypes = new String[]{this.auFile, this.aiffFile, this.midiFile, this.rmfFile, this.wavFile};
        this.formats = new JComboBox<String>(fileTypes);
        this.formats.setSelectedIndex(0);
        this.chosenFile = (String)this.formats.getSelectedItem();
        this.formats.addItemListener(this);
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(this);
        this.loopButton = new JButton("Loop");
        this.loopButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.formats);
        controlPanel.add(this.playButton);
        controlPanel.add(this.loopButton);
        controlPanel.add(this.stopButton);
        this.getContentPane().add(controlPanel);
        this.startLoadingSounds();
    }

    public void itemStateChanged(ItemEvent e) {
        this.chosenFile = (String)this.formats.getSelectedItem();
        this.soundList.startLoading(this.chosenFile);
    }

    void startLoadingSounds() {
        this.soundList = new AppletSoundList(this, this.getCodeBase());
        this.soundList.startLoading(this.auFile);
        this.soundList.startLoading(this.aiffFile);
        this.soundList.startLoading(this.midiFile);
        this.soundList.startLoading(this.rmfFile);
        this.soundList.startLoading(this.wavFile);
    }

    public void stop() {
        this.onceClip.stop();
        if (this.looping) {
            this.loopClip.stop();
        }
    }

    public void start() {
        if (this.looping) {
            this.loopClip.loop();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.playButton) {
            this.onceClip = this.soundList.getClip(this.chosenFile);
            this.onceClip.play();
            this.stopButton.setEnabled(true);
            this.showStatus("Playing sound " + this.chosenFile + ".");
            if (this.onceClip == null) {
                this.showStatus("Sound " + this.chosenFile + " not loaded yet.");
            }
            return;
        }
        if (source == this.loopButton) {
            this.loopClip = this.soundList.getClip(this.chosenFile);
            this.looping = true;
            this.loopClip.loop();
            this.loopButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.showStatus("Playing sound " + this.chosenFile + " continuously.");
            if (this.loopClip == null) {
                this.showStatus("Sound " + this.chosenFile + " not loaded yet.");
            }
            return;
        }
        if (source == this.stopButton) {
            if (this.looping) {
                this.looping = false;
                this.loopClip.stop();
                this.loopButton.setEnabled(true);
            } else if (this.onceClip != null) {
                this.onceClip.stop();
            }
            this.stopButton.setEnabled(false);
            this.showStatus("Stopped playing " + this.chosenFile + ".");
            return;
        }
    }
}

