/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.forms.engine.FormsMessage;
import oracle.forms.engine.Message;
import oracle.forms.test.Test;

public class TerminalMessage
implements Test {
    private int mResponseCode;
    public static final int MSG_EXCEPTION = -1;
    public static final int MSG_ACTION_UNKNOWN = 0;
    public static final int MSG_ACTION_SET = 1;
    public static final int MSG_ACTION_SET_REPEAT = 2;
    public static final int MSG_ACTION_GET = 3;

    public TerminalMessage() {
        this(1);
    }

    public TerminalMessage(int n) {
        this.mResponseCode = n;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public void writeDetails(DataOutputStream dataOutputStream) throws IOException {
        Message.writeTerminal(dataOutputStream);
        dataOutputStream.writeByte(this.mResponseCode);
    }

    public static TerminalMessage readDetails(DataInputStream dataInputStream) throws IOException {
        return new TerminalMessage(dataInputStream.readByte());
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public FormsMessage convertToFormsMessage() {
        return new FormsMessage(this.mResponseCode);
    }

    public static TerminalMessage convertToTerminal(FormsMessage formsMessage) throws Exception {
        if (formsMessage == null) {
            return null;
        }
        if (formsMessage.getMessageType() != 7) {
            throw new Exception("Invalid Message Type");
        }
        return new TerminalMessage(formsMessage.getResponseCode());
    }
}

