/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import oracle.forms.common.Charsets;
import oracle.forms.net.FURLConnection;
import oracle.forms.test.Test;

public class Registry
implements Test {
    private Properties mRegistry = new Properties();
    private String mApplication = "default";
    public static final String CLASS_BYID = "oracle.classById";
    public static final String SYSPREFS = "default";
    public static final String FONT_SYSPREFS = "fontMap";
    public static final String TAB_SYSPREFS = "tabLabel";
    public static final String TABBAR_SYSPREFS = "tabBar";
    public static final String PLACEHOLDER_SYSPREFS = "placeholder";
    public static final String LOVROWLINE_SYSPREFS = "lovRowLine";
    public static final String TAB_FGCOLOR = "unselectedFgColor";
    public static final String TAB_SELECTEDFGCOLOR = "selectedFgColor";
    public static final String TAB_BGCOLOR = "unselectedBgColor";
    public static final String TAB_SELECTEDBGCOLOR = "selectedBgColor";
    public static final String TABBAR_TRANSPARENT = "transparent";
    public static final String APP_UI_PREFS = "app.ui";
    public static final String COLOR_SCHEME_PREFS = "colorScheme";
    public static final String GRADIENT_SYSPREFS = "gradient";
    public static final String GRADIENT_RED_DELTA = "redDelta";
    public static final String GRADIENT_GREEN_DELTA = "greenDelta";
    public static final String GRADIENT_BLUE_DELTA = "blueDelta";
    public static final String CONCEALED_SYSPREFS = "concealedData";
    public static final String CONCEALED_CHAR = "character";
    public static final String BORDER = "border";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String COLOR = "color";
    public static final String HIGHLIGHTCOLOR = "highlightColor";
    public static final String ROLLOVERCOLOR = "rolloverColor";
    public static final String CHARCOUNTER = "charCounter";
    public static final String LUMINANCE = "luminance";
    public static final String DARK = "dark";

    public Registry(String string) {
        this.mApplication = string == null ? SYSPREFS : string;
    }

    public void loadRegistry(URL uRL) throws IOException {
        FURLConnection fURLConnection = FURLConnection.create(uRL);
        fURLConnection.setRequestProperty("Accept", "text/plain");
        if (!FURLConnection.getUseHttp2()) {
            fURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        }
        fURLConnection.connect();
        InputStream inputStream = fURLConnection.getInputStream();
        if ("gzip".equalsIgnoreCase(fURLConnection.getContentEncoding())) {
            inputStream = new GZIPInputStream(inputStream, 4096);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.UTF_8);
        this.mRegistry.load(inputStreamReader);
        this.mRegistry.put("oracle.classById.1", "oracle.forms.engine.Runform");
        this.mRegistry.put("oracle.classById.4", "oracle.forms.handler.FormWindow");
        this.mRegistry.put("oracle.classById.5", "oracle.forms.handler.AlertDialog");
        this.mRegistry.put("oracle.classById.6", "oracle.forms.handler.DisplayList");
        this.mRegistry.put("oracle.classById.7", "oracle.forms.handler.LogonDialog");
        this.mRegistry.put("oracle.classById.8", "oracle.forms.handler.DisplayErrorDialog");
        this.mRegistry.put("oracle.classById.9", "oracle.forms.handler.ListValuesDialog");
        this.mRegistry.put("oracle.classById.10", "oracle.forms.handler.EditorDialog");
        this.mRegistry.put("oracle.classById.11", "oracle.forms.handler.HelpDialog");
        this.mRegistry.put("oracle.classById.12", "oracle.forms.handler.FormStatusBar");
        this.mRegistry.put("oracle.classById.13", "oracle.forms.handler.MenuInfo");
        this.mRegistry.put("oracle.classById.14", "oracle.forms.handler.FieldDialog");
        this.mRegistry.put("oracle.classById.15", "oracle.forms.handler.ApplicationTimer");
        this.mRegistry.put("oracle.classById.16", "oracle.forms.handler.MenuParametersDialog");
        this.mRegistry.put("oracle.classById.17", "oracle.forms.handler.PromptListItem");
        this.mRegistry.put("oracle.classById.18", "oracle.forms.handler.CancelQueryDialog");
        this.mRegistry.put("oracle.classById.257", "oracle.forms.handler.TextFieldItem");
        this.mRegistry.put("oracle.classById.258", "oracle.forms.handler.TextAreaItem");
        this.mRegistry.put("oracle.classById.259", "oracle.forms.handler.FormCanvas");
        this.mRegistry.put("oracle.classById.261", "oracle.forms.handler.ButtonItem");
        this.mRegistry.put("oracle.classById.262", "oracle.forms.handler.CheckboxItem");
        this.mRegistry.put("oracle.classById.263", "oracle.forms.handler.PopListItem");
        this.mRegistry.put("oracle.classById.264", "oracle.forms.handler.TListItem");
        this.mRegistry.put("oracle.classById.265", "oracle.forms.handler.CfmVBX");
        this.mRegistry.put("oracle.classById.266", "oracle.forms.handler.CfmOLE");
        this.mRegistry.put("oracle.classById.267", "oracle.forms.handler.RadioButtonItem");
        this.mRegistry.put("oracle.classById.268", "oracle.forms.handler.ImageItem");
        this.mRegistry.put("oracle.classById.269", "oracle.forms.handler.IconicButtonItem");
        this.mRegistry.put("oracle.classById.270", "oracle.forms.handler.BlockScroller");
        this.mRegistry.put("oracle.classById.271", "oracle.forms.handler.JavaContainer");
        this.mRegistry.put("oracle.classById.272", "oracle.forms.handler.TabControl");
        this.mRegistry.put("oracle.classById.273", "oracle.forms.handler.ComboBoxItem");
        this.mRegistry.put("oracle.classById.274", "oracle.forms.handler.TreeItem");
        this.mRegistry.put("oracle.classById.275", "oracle.forms.handler.SpinListItem");
        this.mRegistry.put("oracle.classById.276", "oracle.forms.handler.ProgressItem");
        this.mRegistry.put("oracle.classById.277", "oracle.forms.handler.SliderItem");
        this.mRegistry.put("oracle.classById.281", "oracle.forms.handler.PopupHelpItem");
        inputStreamReader.close();
    }

    public void addEntry(String string, String string2, String string3) {
        String string4 = string + "." + string2;
        Object object = this.mRegistry.put(string4, string3);
        if (object != null) {
            this.mRegistry.put(string4, object);
        }
    }

    public void updateEntry(String string, String string2, String string3) {
        String string4 = string + "." + string2;
        Object object = this.mRegistry.put(string4, string3);
        if (object == null) {
            this.mRegistry.remove(string4);
        }
    }

    public String getEntry(String string, String string2) {
        if (!(string.equals(CLASS_BYID) || string.equals(APP_UI_PREFS) || string.equals(COLOR_SCHEME_PREFS))) {
            String string3 = this.mRegistry.getProperty(this.mApplication + "." + string + "." + string2);
            if (string3 != null) {
                return string3;
            }
            return this.mRegistry.getProperty("default." + string + "." + string2);
        }
        return this.mRegistry.getProperty(string + "." + string2);
    }

    private boolean validateSectionName(String string) {
        return true;
    }

    private boolean validateEntryName(String string) {
        return true;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }
}

