/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import oracle.forms.engine.PatternKey;

public class PatternProducer {
    private static PatternProducer sProducer;
    private static final int sPatternHeight = 64;
    private static final int sPatternWidth = 64;
    private Hashtable mPatternList = new Hashtable();
    private Component mComponent;
    private int[] mBitmap = new int[]{575834811, 1914872357, 2088549190, -943211676, 566231812, 134745106, 0x404FF40, 0x4040FF04, -33750817, -539033347, 299909152, 268960992, 271599748, 50463752, 1084231946, 67240320, -2139062048, -1069522848, -2143223808, 135528448, -960069119, 0, -2007660471, 708200840, 0xF0F0F0F, -252645136, 0x55885522, 0x55885522, 405029505, 0x1800180, 92819488, 1351091458, -2126371816, 405029505, 271074372, 1145340417, 0x33000000, -872415232, 264725, -1441461756, 99271, -272137471, -16148881, 1872103935, -1719786472, 404241474, -2004351742, 67768593, 1291354, 1488196352, -1441527800, -1438613376, -1442504110, -1428656096, -7337726, 67735807, 0x1010000, 0x1010000, 0x44001100, 0x44001100, 0x55002200, 0x55002200, 0x55005500, 0x55005500, 289673634, 0x11441144, 0x44114411, 0x44114411, 0x55205500, 0x55025500, 0x10000000, 0x1000000, 0x55885500, 0x55885500, 1426216328, 1428182408, 0x55885522, 0x55885522, 0x55225588, 0x55225588, 0x55A8558A, 0x55A8558A, 0x55A855AA, 0x558A55AA, 0x55AA55AA, 0x55AA55AA, -1435129259, -1437095339, -1437095307, -1437095307, 0x40000400, 0x40000400, -1428313513, -1428313483, -1434998051, -1434998051, -1428313481, -1426216329, -1434998017, -1434998017, -1426216193, -1428182273, -1141982226, -1141982226, -289673515, -289673541, -1426085121, -1426085121, -1426072065, -1426072065, -1140855041, -1140855041, -285212673, -285212673, -1073742849, -1073742849, -257, -257, -15658735, -15658735, -16711423, 0x1010101, -16711936, -16711936, 65280, 65280, 65280, 65280, -65281, -65281, 0, 65280, -1, -65281, 65535, 65535, -6747802, 1711905279, 19697122, 870860424, 0x55000400, 0x44000400, 287851649, 0x11005500, 1351100296, 0x50202020, 0x66FFFF66, 1115783490, -1426085121, -1426085121, -1042255816, 470681475, -1048377586, 473460960, -865717351, -865717351, -1724684596, -1724684596, 571574340, 571574340, 1149767970, 1149767970, 608344446, 0x3CFFFF3C, 741637566, 2109615156, 524320, 0x4000020, -337789313, -1092752393, -1620052231, -101290081, 0xBBBBBB, 0xBBBBBB, -16908034, -16843010, 142607392, 17826368, 684130561, -2105798640, -1, -1, 208429313, 808896192, 67152469, -1426063602, 875886336, -134794188, 0x10000180, 0x40000408, 1426067842, 1143476480, -1140855041, -1140855041, -571574341, -571574341, -287458441, -287458441, 0x55005500, 0x55005500, 134480385, -2143281136, 16909320, 270549120, 134785601, -2139051500, 0, 0, 0x22111122, 0x44888844, 0x20200202, 0x20200202, 0x55555555, 0x55555555, 0x44444444, 0x44444444, 0x11111111, 0x11111111, -1145324613, -1145324613, 0x10101010, 0x10101010, 0x3030303, 0x3030303, -858993460, -858993460, 0x66FFFF66, 610122276, 1115756580, 1115756580, -1920132325, 336069642, -1566406075, 1162191522, -1431655851, 0x5555AAAA, 1150164782, 1155723752, 686784321, 2138009583, -2075594527, 1109663247};
    private String[] mName = new String[]{"arrows", "balls", "bamboo", "brick", "brickrev", "brickside", "brickside2", "bricksideways", "bumps", "carrot", "carrot2", "chair", "checker", "checker2", "corn", "crisscross", "crisscrossthin", "curves1", "dashhline", "diamond", "diamonddark", "diamonds", "fans", "fence", "fish", "flowers", "flowers2", "goldchain", "gray10", "gray13.3", "gray16.6", "gray20", "gray23.3", "gray25", "gray26.6", "gray3.3", "gray30", "gray33.3", "gray36.6", "gray40", "gray43.3", "gray46.6", "gray50", "gray53.3", "gray56.6", "gray6.6", "gray60", "gray63.3", "gray66.6", "gray70", "gray73.3", "gray75", "gray76.6", "gray80", "gray83.3", "gray86.6", "gray90", "gray93.3", "gray96.6", "grid", "gridthin", "hlines1", "hlines2", "hlines3", "hlines4", "hlines5", "hlines6", "hlines7", "hopi", "kangaroo", "linoleum1", "linoleum2", "linoleum3", "loops", "medbox", "medline135", "medline45", "multimed135", "multimed45", "multithin135", "multithin45", "pagodas", "plaid", "powder", "revcrissthick", "revcrissthin", "revgrid", "revsquares", "sandpaper", "shingles", "solid", "specs", "spikes", "squares", "stitching", "sweaterpattern", "thickbox", "thickline135", "thickline45", "thinbox", "thinline135", "thinline45", "tile1", "transparent", "v45waves", "vdashline", "vlines1", "vlines2", "vlines3", "vlines4", "vlines5", "vlines6", "vlines7", "walker", "wave45", "waves", "wavy", "wavy2", "weave1", "weave2", "weave3"};

    private PatternProducer(Component component) {
        this.mComponent = component;
    }

    public static PatternProducer getProducer(Component component) {
        if (sProducer == null) {
            sProducer = new PatternProducer(component);
        }
        return sProducer;
    }

    public Image getPattern(String string, Color color, Color color2) {
        int n = 0;
        int n2 = this.mName.length - 1;
        while (n2 >= n) {
            int n3 = (n + n2) / 2;
            int n4 = this.mName[n3].compareTo(string);
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 == 0) {
                return this.getPattern(n3, color, color2);
            }
            n = n3 + 1;
        }
        return null;
    }

    private final Image getPattern(int n, Color color, Color color2) {
        int n2;
        int n3 = color.getRGB() | 0xFF000000;
        PatternKey patternKey = new PatternKey(n, n3, n2 = color2.getRGB() | 0xFF000000);
        Image image = (Image)this.mPatternList.get(patternKey);
        if (image == null) {
            int n4 = 4096;
            int[] nArray = new int[n4];
            int n5 = 8;
            int n6 = 8;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int n7 = i * 8 + j;
                    int n8 = n * 2 + n7 / 32;
                    int n9 = 1 << n7 % 32;
                    int n10 = (this.mBitmap[n8] & n9) != 0 ? n3 : n2;
                    for (int k = 0; k < n6; ++k) {
                        for (int i2 = 0; i2 < n5; ++i2) {
                            nArray[(i + i2 * 8) * 64 + (j + k * 8)] = n10;
                        }
                    }
                }
            }
            image = this.mComponent.createImage(new MemoryImageSource(64, 64, nArray, 0, 64));
            this.mPatternList.put(patternKey, image);
        }
        return image;
    }
}

