/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import oracle.forms.engine.ChronosMessage;
import oracle.forms.engine.ChronosWriter;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;

public class Monitor {
    private ChronosWriter mChronosWriter;
    private String mChronosURL;
    private Runform mDispatcher;
    private long mBlockEnd = 0L;
    private static final int COMMIT_EVENT = 1;
    private static final int QUERY_EVENT = 2;
    private static final int RUNFORM_EVENT = 4;
    private static final int CALLFORM_EVENT = 8;
    private static final int NEWFORM_EVENT = 16;
    private static final int OPENFORM_EVENT = 32;

    public Monitor(Runform runform, String string, ChronosWriter chronosWriter) throws Exception {
        this.mDispatcher = runform;
        this.mChronosURL = string;
        this.mChronosWriter = chronosWriter;
    }

    public void updateMonitor(Message message) throws Exception {
        String string;
        int n = (Integer)message.getValueAt(0);
        if (this.mBlockEnd == 0L) {
            this.mBlockEnd = System.currentTimeMillis();
        }
        switch (n) {
            case 1: {
                string = "COMMIT";
                break;
            }
            case 2: {
                string = "QUERY";
                break;
            }
            case 4: {
                string = "RUNFORM";
                break;
            }
            case 8: {
                string = "CALLFORM";
                break;
            }
            case 16: {
                string = "NEWFORM";
                break;
            }
            case 32: {
                string = "OPENFORM";
                break;
            }
            default: {
                string = "UNKNOWN(" + n + ")";
            }
        }
        long l = 0L;
        byte[] byArray = (byte[])message.getValueAt(5);
        for (int i = 7; i >= 0; --i) {
            byte by = byArray[i];
            l = by < 0 ? l * 256L + 256L + (long)byArray[i] : l * 256L + (long)byArray[i];
        }
        ChronosMessage chronosMessage = new ChronosMessage(this.mDispatcher, this.mChronosURL, string, (String)message.getValueAt(1), (String)message.getValueAt(2), (int)(this.mBlockEnd - l), (Integer)message.getValueAt(3), (Integer)message.getValueAt(4));
        this.mChronosWriter.put(chronosMessage);
    }

    protected void clearBlockEnd() {
        this.mBlockEnd = 0L;
    }

    protected byte[] getBlockStart() {
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[8];
        long l2 = l;
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l2 % 256L);
            l2 /= 256L;
        }
        return byArray;
    }
}

