/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import oracle.forms.engine.DeleteMask;
import oracle.forms.engine.FDataInputStream;
import oracle.forms.engine.FDataOutputStream;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.FormsMessage;
import oracle.forms.engine.IndexTag;
import oracle.forms.engine.MessageHandler;
import oracle.forms.properties.ID;
import oracle.forms.test.Test;

public class Message
implements Test {
    private static final int DFLT_PROPS = 8;
    private byte mAction;
    private int mHandlerClassId;
    private int mHandlerId;
    private int[] mPropId = new int[8];
    private Object[] mPropVal = new Object[8];
    private int mPropCount = 0;
    private int mDeltaIndex = 0;
    private static final int mIntOffset = -10;
    private static final Integer[] mIntCache = new Integer[256];
    private static int mCacheSize = 0;
    private static final Message[] mCacheArray = new Message[100];
    private static int mMaxCache;
    private static final byte MSG_UNKNOWN_TYPE = 0;
    private static final int MAX_DICT_STRINGS = 256;
    private static final int MSG_NUM_BUFFERED = 8;
    private static int mNewCacheId;
    private static Vector mCreateMessageCaches;
    private static Vector mUpdateMessageCaches;
    private static Vector mStringDictionaries;
    private static final int PROP_ID_MASK = 4095;
    private static final int PROP_TYPE_MASK = 61440;
    private static final int PROP_TERMINAL = 61440;
    private static final int PROP_TERMINAL_BYTE = 240;
    private static final int PROP_TYPE_MASK_BYTE = 240;
    private static final int PROP_INTEGER = 0;
    private static final int PROP_INTEGER_0 = 4096;
    private static final int PROP_INTEGER_BYTE = 8192;
    private static final int PROP_INTEGER_SHORT = 12288;
    private static final int PROP_STRING = 16384;
    private static final int PROP_BOOLEAN_TRUE = 20480;
    private static final int PROP_BOOLEAN_FALSE = 24576;
    private static final int PROP_BYTE = 28672;
    private static final int PROP_VOID = 32768;
    private static final int PROP_DICT_STR = 36864;
    private static final int PROP_POINT = 40960;
    private static final int PROP_INDEX_TAG = 45056;
    private static final int PROP_BYTE_POINT = 49152;
    private static final int PROP_DEL_MASK = 53248;
    private static final int PROP_EXTENDED = 57344;
    private static final byte EXTENDED_STRING_ARRAY = 2;
    private static final byte EXTENDED_CHARACTER = 4;
    private static final byte EXTENDED_FLOAT = 5;
    private static final byte EXTENDED_DATE = 6;
    private static final byte EXTENDED_BYTE_ARRAY = 7;
    private static final byte EXTENDED_MESSAGE = 8;
    private static final byte EXTENDED_POINT = 9;
    private static final byte EXTENDED_RECTANGLE = 10;
    private static final byte EXTENDED_NF_BYTE_ARRAY = 15;
    private static final byte PROP_T_UNKNOWN = 0;
    private static final byte PROP_T_STRING = 1;
    private static final byte PROP_T_STRING_ARRAY = 2;
    private static final byte PROP_T_INTEGER = 3;
    private static final byte PROP_T_CHARACTER = 4;
    private static final byte PROP_T_FLOAT = 5;
    private static final byte PROP_T_DATE = 6;
    private static final byte PROP_T_BYTE_ARRAY = 7;
    private static final byte PROP_T_CFM_MESSAGE = 8;
    private static final byte PROP_T_POINT = 9;
    private static final byte PROP_T_RECTANGLE = 10;
    private static final byte PROP_T_VOID = 12;
    private static final byte PROP_T_BOOLEAN = 13;
    private static final byte PROP_T_BYTE = 14;
    private static final byte PROP_T_NF_BYTE_ARRAY = 15;
    private static final byte PROP_T_INDEX_TAG = 16;
    private static final byte PROP_T_DEL_MASK = 17;
    private static final byte PROP_T_DICT_STR = 18;
    private static final int CLASS_ID_MASK = 1023;
    private static final int ACTION_TYPE_MASK = 61440;
    private static final int ACTION_CREATE_ENCODED = 0;
    private static final int ACTION_UPDATE_ENCODED = 4096;
    private static final int ACTION_DESTROY_ENCODED = 8192;
    private static final int ACTION_GET_ENCODED = 12288;
    private static final int ACTION_CREATE_ENCODED_DELTA = 16384;
    private static final int ACTION_UPDATE_ENCODED_DELTA = 20480;
    private static final int ACTION_CLIENT_GET_ENCODED = 24576;
    private static final int ACTION_CLIENT_SET_ENCODED = 28672;
    private static final int MSG_TERMINAL = 61440;
    private static final int MSG_TERMINAL_BYTE = 240;
    private static final int MSG_OPT_MAX_BYTE = 128;
    private static final int MSG_OPT_MAX_INT = Integer.MIN_VALUE;
    private static final int MSG_OPT_MAX_SHORT = 32768;
    private static final int MSG_APPS_BASE_CLASSID = 2000;
    private static final int MSG_APPS_OLD_BASE_CLASSID = 5000;
    protected static final byte MSG_UNKNOWN_ACTION = 0;
    public static final byte MSG_CREATE = 1;
    public static final byte MSG_UPDATE = 2;
    public static final byte MSG_DESTROY = 3;
    public static final byte MSG_GET = 4;
    private static final byte MSG_CREATE_DELTA = 5;
    private static final byte MSG_UPDATE_DELTA = 6;
    public static final byte MSG_CLIENT_GET = 7;
    public static final byte MSG_CLIENT_SET = 8;
    public static final int MSG_UNKNOWN_HANDLER = 0;
    public static final int MSG_UNKNOWN_PROPERTY = 0;
    private static final int MAX_DELTA_PROPS = 16;

    public Message(byte by, MessageHandler messageHandler) {
        this(by, messageHandler.getHandlerClassId(), messageHandler.getHandlerId());
    }

    public Message(MessageHandler messageHandler) {
        this(2, messageHandler);
    }

    public Message(byte by, MessageHandler messageHandler, int n, Object object) {
        this(by, messageHandler);
        this.add(n, object);
    }

    public Message(MessageHandler messageHandler, int n, Object object) {
        this(2, messageHandler, n, object);
    }

    public Message(byte by, int n, int n2) {
        this.mAction = by;
        this.mHandlerClassId = n;
        this.mHandlerId = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cacheMessage() {
        switch (this.mAction) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return;
            }
        }
        if (mCacheSize == mCacheArray.length) return;
        Message[] messageArray = mCacheArray;
        synchronized (mCacheArray) {
            if (mCacheSize != mCacheArray.length) {
                int n = this.mPropCount;
                while (n-- != 0) {
                    this.mPropVal[n] = null;
                }
                Message.mCacheArray[Message.mCacheSize++] = this;
            }
            this.mAction = 0;
            this.mPropCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Message newMessage(byte by, int n, int n2) {
        if (mCacheSize == 0) return new Message(by, n, n2);
        Message[] messageArray = mCacheArray;
        synchronized (mCacheArray) {
            Message message;
            if (mCacheSize != 0) {
                message = mCacheArray[--mCacheSize];
                Message.mCacheArray[Message.mCacheSize] = null;
            } else {
                message = null;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (message == null) return new Message(by, n, n2);
            message.mAction = by;
            message.mHandlerClassId = n;
            message.mHandlerId = n2;
            message.mDeltaIndex = 0;
            return message;
        }
    }

    public static Message newMessage(MessageHandler messageHandler, int n, Object object) {
        Message message = Message.newMessage((byte)2, messageHandler.getHandlerClassId(), messageHandler.getHandlerId());
        message.add(n, object);
        return message;
    }

    public void add(int n, Object object) {
        int n2;
        if (this.mPropCount == this.mPropId.length) {
            n2 = this.mPropId.length * 2;
            int[] nArray = new int[n2];
            System.arraycopy(this.mPropId, 0, nArray, 0, this.mPropCount);
            this.mPropId = nArray;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.mPropVal, 0, objectArray, 0, this.mPropCount);
            this.mPropVal = objectArray;
        }
        n2 = this.mPropCount++;
        this.mPropId[n2] = n;
        this.mPropVal[n2] = object;
    }

    private void checkProperty(int n, Object object) {
    }

    public int getPropertyAt(int n) {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.mPropCount);
        }
        return this.mPropId[n];
    }

    public int getPropertyTypeAt(int n) {
        int n2;
        Object object = this.getValueAt(n);
        if (object instanceof Integer) {
            n2 = 3;
        } else if (object instanceof String) {
            n2 = 1;
        } else if (object instanceof Boolean) {
            n2 = 13;
        } else if (object instanceof Byte) {
            n2 = 14;
        } else if (object == null) {
            n2 = 12;
        } else if (object instanceof Character) {
            n2 = 4;
        } else if (object instanceof String[]) {
            n2 = 2;
        } else if (object instanceof Float) {
            n2 = 5;
        } else if (object instanceof Date) {
            n2 = 6;
        } else if (object instanceof byte[]) {
            n2 = 7;
        } else if (object instanceof Point) {
            n2 = 9;
        } else if (object instanceof Rectangle) {
            n2 = 10;
        } else if (object instanceof Message) {
            n2 = 8;
        } else if (object instanceof IndexTag) {
            n2 = 16;
        } else if (object instanceof DeleteMask) {
            n2 = 17;
        } else {
            throw new IllegalArgumentException("Attempt to write out an object of type " + object.getClass().getName());
        }
        return n2;
    }

    public Object getValueAt(int n) {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.mPropCount);
        }
        return this.mPropVal[n];
    }

    public void setValueAt(int n, Object object) {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.mPropCount);
        }
        this.mPropVal[n] = object;
    }

    private void removePropertyAt(int n) {
        if (n < 0 || n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.mPropCount);
        }
        if (n != this.mPropCount - 1) {
            System.arraycopy(this.mPropId, n + 1, this.mPropId, n, this.mPropCount - n - 1);
            System.arraycopy(this.mPropVal, n + 1, this.mPropVal, n, this.mPropCount - n - 1);
        }
        this.mPropVal[--this.mPropCount] = null;
    }

    public int size() {
        return this.mPropCount;
    }

    public byte getActionCode() {
        return this.mAction;
    }

    public int getHandlerClassId() {
        return this.mHandlerClassId;
    }

    public int getHandlerId() {
        return this.mHandlerId;
    }

    private boolean isDeltaMessage() {
        return this.mAction == 5 || this.mAction == 6;
    }

    private void setDeltaIndex(int n) {
        this.mDeltaIndex = n;
    }

    protected int getDeltaIndex() {
        return this.mDeltaIndex;
    }

    protected static void writeTerminal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(240);
    }

    private static int readOptimizedUnsignedInt(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3 = dataInputStream.read();
        if ((n3 | (n2 = dataInputStream.read())) < 0) {
            throw new EOFException();
        }
        if ((n3 & 0x80) == 128) {
            int n4 = dataInputStream.read();
            int n5 = dataInputStream.read();
            n3 &= 0xFFFFFF7F;
            if ((n4 | n5) < 0) {
                throw new EOFException();
            }
            n = (n3 << 24) + (n2 << 16) + (n4 << 8) + n5;
        } else {
            n = (n3 << 8) + n2;
        }
        return n;
    }

    private static void writeOptimizedUnsignedInt(DataOutputStream dataOutputStream, int n) throws IOException {
        if ((n & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Optimized int should be < 2^31");
        }
        if (n < 32768) {
            dataOutputStream.write(n >>> 8 & 0xFF);
            dataOutputStream.write(n & 0xFF);
        } else {
            dataOutputStream.write((n |= Integer.MIN_VALUE) >>> 24 & 0xFF);
            dataOutputStream.write(n >>> 16 & 0xFF);
            dataOutputStream.write(n >>> 8 & 0xFF);
            dataOutputStream.write(n & 0xFF);
        }
    }

    public void writeDetails(FormsDispatcher formsDispatcher, DataOutputStream dataOutputStream) throws IOException {
        this.writeDetails(formsDispatcher, 0, dataOutputStream);
    }

    public void writeDetails(FormsDispatcher formsDispatcher, int n, DataOutputStream dataOutputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        switch (this.mAction) {
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 4096;
                break;
            }
            case 3: {
                n3 = 8192;
                break;
            }
            case 4: {
                n3 = 12288;
                break;
            }
            case 7: {
                n3 = 24576;
                break;
            }
            case 8: {
                n3 = 28672;
            }
        }
        int n4 = this.mHandlerClassId;
        if (n4 >= 5000) {
            n4 -= 3000;
        }
        if (this.mAction == 1 || this.mAction == 5) {
            dataOutputStream.writeShort(n3 | n4);
        } else {
            dataOutputStream.writeByte(n3 >> 8);
        }
        Message.writeOptimizedUnsignedInt(dataOutputStream, this.mHandlerId);
        int n5 = this.mPropCount;
        int[] nArray = this.mPropId;
        Object[] objectArray = this.mPropVal;
        while (n5-- > 0) {
            int n6 = nArray[n2];
            Object object = objectArray[n2];
            if (object instanceof Integer) {
                int n7 = (Integer)object;
                if (n7 == 0) {
                    dataOutputStream.writeShort(0x1000 | n6);
                } else if (n7 > 0 && n7 <= 255) {
                    dataOutputStream.writeShort(0x2000 | n6);
                    dataOutputStream.writeByte(((Integer)object).byteValue());
                } else if (n7 > 255 && n7 <= 65535) {
                    dataOutputStream.writeShort(0x3000 | n6);
                    dataOutputStream.writeShort(((Integer)object).shortValue());
                } else {
                    dataOutputStream.writeShort(0 | n6);
                    dataOutputStream.writeInt((Integer)object);
                }
            } else if (object instanceof String || object instanceof char[]) {
                dataOutputStream.writeShort(0x4000 | n6);
                dataOutputStream.writeByte(99);
                FDataOutputStream.writeUTF(object, dataOutputStream, true);
                if (object instanceof char[]) {
                    Arrays.fill((char[])object, '\u0000');
                }
            } else if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    dataOutputStream.writeShort(0x5000 | n6);
                } else {
                    dataOutputStream.writeShort(0x6000 | n6);
                }
            } else if (object instanceof Byte) {
                dataOutputStream.writeShort(0x7000 | n6);
                dataOutputStream.writeByte(((Byte)object).byteValue());
            } else if (object == null) {
                dataOutputStream.writeShort(0x8000 | n6);
            } else if (object instanceof String[]) {
                int n8 = 0;
                int n9 = ((String[])object).length;
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(2);
                dataOutputStream.writeInt(n9);
                while (n9-- > 0) {
                    FDataOutputStream.writeUTF(((String[])object)[n8++], dataOutputStream, true);
                }
            } else if (object instanceof Float) {
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(5);
                dataOutputStream.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Date) {
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(6);
                dataOutputStream.writeLong(((Date)object).getTime());
            } else if (object instanceof byte[]) {
                int n10 = ((byte[])object).length;
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(7);
                dataOutputStream.writeInt(n10);
                if (n10 != 0) {
                    dataOutputStream.write((byte[])object, 0, n10);
                }
            } else if (object instanceof Point) {
                Point point = (Point)object;
                if (point.x > 0 && point.x <= 255 && point.y > 0 && point.y <= 255) {
                    dataOutputStream.writeShort(0xC000 | n6);
                    dataOutputStream.writeByte(((Point)object).x);
                    dataOutputStream.writeByte(((Point)object).y);
                } else {
                    dataOutputStream.writeShort(0xA000 | n6);
                    dataOutputStream.writeShort(((Point)object).x);
                    dataOutputStream.writeShort(((Point)object).y);
                }
            } else if (object instanceof Rectangle) {
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(10);
                dataOutputStream.writeShort(((Rectangle)object).x);
                dataOutputStream.writeShort(((Rectangle)object).y);
                dataOutputStream.writeShort(((Rectangle)object).width);
                dataOutputStream.writeShort(((Rectangle)object).height);
            } else if (object instanceof Message) {
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(8);
                ((Message)object).writeDetails(formsDispatcher, n, dataOutputStream);
            } else if (object instanceof Character) {
                int n11 = Character.getNumericValue(((Character)object).charValue());
                dataOutputStream.writeShort(0xE000 | n6);
                dataOutputStream.writeByte(4);
                dataOutputStream.writeChar(n11);
            } else {
                throw new IllegalArgumentException("Attempt to write out an object of type " + object.getClass().getName());
            }
            ++n2;
        }
        dataOutputStream.writeByte(240);
    }

    public static Message readDetails(int n, DataInputStream dataInputStream) throws IOException {
        if (n < 0) {
            throw new IOException("Invalid CachedID for reading the message");
        }
        String[] stringArray = (String[])mStringDictionaries.elementAt(n);
        return Message.processDeltaMessage(n, Message.readDetails(dataInputStream, stringArray));
    }

    public static Message readDetails(DataInputStream dataInputStream) throws IOException {
        return Message.readDetails(dataInputStream, null);
    }

    public static Message readDetails(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        Message message;
        block51: {
            int n;
            int n2;
            int n3;
            int n4;
            block50: {
                n4 = 0;
                int n5 = dataInputStream.readUnsignedByte();
                if (n5 == 240) {
                    n3 = 61440;
                } else {
                    int n6;
                    n3 = n6 = n5 << 8;
                    switch (n6 & 0xF000) {
                        case 0: 
                        case 16384: {
                            n3 |= dataInputStream.readUnsignedByte();
                            break;
                        }
                    }
                }
                if (n3 != 61440) break block50;
                message = null;
                break block51;
            }
            byte by = -1;
            String[] stringArray2 = null;
            switch (n3 & 0xF000) {
                case 0: {
                    by = 1;
                    break;
                }
                case 4096: {
                    by = 2;
                    break;
                }
                case 8192: {
                    by = 3;
                    break;
                }
                case 12288: {
                    by = 4;
                    break;
                }
                case 16384: {
                    by = 5;
                    break;
                }
                case 20480: {
                    by = 6;
                    break;
                }
                case 24576: {
                    by = 7;
                    break;
                }
                case 28672: {
                    by = 8;
                }
            }
            if (by == 5 || by == 6) {
                n4 = dataInputStream.readUnsignedByte();
            }
            if ((n2 = n3 & 0x3FF) >= 2000) {
                n2 += 3000;
            }
            int n7 = Message.readOptimizedUnsignedInt(dataInputStream);
            message = Message.newMessage(by, n2, n7);
            message.setDeltaIndex(n4);
            while ((n = dataInputStream.readUnsignedByte()) != 240) {
                int n8;
                block53: {
                    int n9;
                    int n10;
                    block52: {
                        switch (n & 0xF0) {
                            case 176: {
                                n10 = 45056;
                                n8 = 16;
                                stringArray2 = new IndexTag(n & 0xFFFFFF0F);
                                break;
                            }
                            case 208: {
                                n10 = 53248;
                                n8 = 17;
                                break;
                            }
                            default: {
                                int n11 = (n << 8) + dataInputStream.readUnsignedByte();
                                n10 = n11 & 0xF000;
                                n8 = n11 & 0xFFF;
                            }
                        }
                        if (n10 == 57344) break block52;
                        switch (n10) {
                            case 0: {
                                stringArray2 = Message.mToInteger(dataInputStream.readInt());
                                break block53;
                            }
                            case 4096: {
                                stringArray2 = Message.mToInteger(0);
                                break block53;
                            }
                            case 8192: {
                                stringArray2 = Message.mToInteger(dataInputStream.readUnsignedByte());
                                break block53;
                            }
                            case 12288: {
                                stringArray2 = Message.mToInteger(dataInputStream.readUnsignedShort());
                                break block53;
                            }
                            case 16384: {
                                n9 = dataInputStream.readUnsignedByte();
                                String string = FDataInputStream.readUTF(dataInputStream);
                                stringArray2 = string;
                                if (stringArray != null) {
                                    stringArray[n9] = string;
                                }
                                break block53;
                            }
                            case 20480: {
                                stringArray2 = Boolean.TRUE;
                                break block53;
                            }
                            case 24576: {
                                stringArray2 = Boolean.FALSE;
                                break block53;
                            }
                            case 28672: {
                                stringArray2 = dataInputStream.readByte();
                                break block53;
                            }
                            case 32768: {
                                stringArray2 = null;
                                break block53;
                            }
                            case 40960: {
                                n9 = dataInputStream.readShort();
                                stringArray2 = new Point(n9, dataInputStream.readShort());
                                break block53;
                            }
                            case 49152: {
                                n9 = dataInputStream.readUnsignedByte();
                                stringArray2 = new Point(n9, dataInputStream.readUnsignedByte());
                                break block53;
                            }
                            case 53248: {
                                stringArray2 = new DeleteMask(dataInputStream.readUnsignedShort());
                                break block53;
                            }
                            case 36864: {
                                if (stringArray != null) {
                                    n9 = dataInputStream.readUnsignedByte();
                                    int n12 = dataInputStream.readUnsignedByte();
                                    stringArray[n9] = stringArray[n12];
                                    stringArray2 = stringArray[n9];
                                }
                                break block53;
                            }
                            case 45056: {
                                break block53;
                            }
                            default: {
                                throw new IllegalArgumentException("Attempt to read in an object of type " + n10);
                            }
                        }
                    }
                    n10 = dataInputStream.readByte();
                    switch (n10) {
                        case 2: {
                            n9 = 0;
                            int n13 = dataInputStream.readInt();
                            String[] stringArray3 = new String[n13];
                            while (n13-- > 0) {
                                stringArray3[n9++] = FDataInputStream.readUTF(dataInputStream);
                            }
                            stringArray2 = stringArray3;
                            break;
                        }
                        case 5: {
                            stringArray2 = Float.valueOf(dataInputStream.readFloat());
                            break;
                        }
                        case 6: {
                            stringArray2 = new Date();
                            ((Date)stringArray2).setTime(dataInputStream.readLong());
                            break;
                        }
                        case 7: 
                        case 15: {
                            byte[] byArray = new byte[dataInputStream.readInt()];
                            dataInputStream.readFully(byArray);
                            stringArray2 = (String[])byArray;
                            break;
                        }
                        case 10: {
                            stringArray2 = new Rectangle();
                            ((Rectangle)stringArray2).x = dataInputStream.readShort();
                            ((Rectangle)stringArray2).y = dataInputStream.readShort();
                            ((Rectangle)stringArray2).width = dataInputStream.readShort();
                            ((Rectangle)stringArray2).height = dataInputStream.readShort();
                            break;
                        }
                        case 8: {
                            stringArray2 = Message.readDetails(dataInputStream, stringArray);
                            break;
                        }
                        case 4: {
                            stringArray2 = Character.valueOf(dataInputStream.readChar());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Attempt to read in an object of type " + n10);
                        }
                    }
                }
                message.add(n8, stringArray2);
            }
        }
        return message;
    }

    private static Integer mToInteger(int n) {
        if ((n += 10) < 0 || n >= mIntCache.length) {
            return n + -10;
        }
        if (mIntCache[n] == null) {
            Message.mIntCache[n] = n + -10;
        }
        return mIntCache[n];
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    protected Message createMessageFromDeltaMessage(Message message) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        Object[] objectArray = new Object[16];
        if (message == this || message == null) {
            return null;
        }
        if (this.mAction != 1 && this.mAction != 2) {
            throw new IllegalArgumentException("Error while creating message from Delta message");
        }
        if (this.isDeltaMessage() || !message.isDeltaMessage()) {
            throw new IllegalArgumentException("Error while creating message from Delta message");
        }
        byte by = message.getActionCode() == 5 ? (byte)1 : 2;
        Message message2 = Message.newMessage(by, message.mHandlerClassId, message.mHandlerId);
        int n6 = message.size();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            int n10 = message.getPropertyTypeAt(n4);
            Object object = message.getValueAt(n4);
            if (n10 == 17) {
                n8 = ((DeleteMask)object).mMask;
                continue;
            }
            if (n10 == 16) {
                n9 = ((IndexTag)object).mIndex;
                n10 = message.getPropertyTypeAt(++n4);
                object = message.getValueAt(n4);
            }
            int n11 = message.getPropertyAt(n4);
            n7 |= 1 << n9;
            nArray[n5] = n11;
            objectArray[n5] = object;
            nArray2[n5] = n9++;
            ++n5;
        }
        n4 = this.size();
        for (n3 = 0; n3 < n4; ++n3) {
            if ((1 << n3 & n8) != 0) continue;
            int n12 = this.getPropertyAt(n3);
            Object object = this.getValueAt(n3);
            n2 = 1;
            for (n = 0; n < n5; ++n) {
                if (nArray[n] != n12) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            n9 = message2.getNextIndex(n7);
            nArray[n5] = n12;
            objectArray[n5] = object;
            nArray2[n5] = n9;
            ++n5;
            n7 |= 1 << n9;
        }
        block3: for (n2 = 0; n2 < n5; ++n2) {
            n3 = nArray2[n2];
            if (n3 == n2) {
                message2.add(nArray[n2], objectArray[n2]);
                continue;
            }
            for (n = 0; n < n5; ++n) {
                n3 = nArray2[n];
                if (n3 != n2) continue;
                message2.add(nArray[n], objectArray[n]);
                continue block3;
            }
        }
        return message2;
    }

    private int getNextIndex(int n) {
        for (int i = 0; i < 16; ++i) {
            if ((1 << i & n) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int createMessageCache() {
        mCreateMessageCaches.addElement(new Vector());
        mUpdateMessageCaches.addElement(new Vector());
        mStringDictionaries.addElement(new String[256]);
        return mNewCacheId++;
    }

    public static void destroyMessageCache(int n) {
        if (n < 0) {
            return;
        }
        Vector vector = (Vector)mCreateMessageCaches.elementAt(n);
        Vector vector2 = (Vector)mUpdateMessageCaches.elementAt(n);
        mCreateMessageCaches.setElementAt(null, n);
        mUpdateMessageCaches.setElementAt(null, n);
        mStringDictionaries.setElementAt(null, n);
        if (vector != null) {
            vector.removeAllElements();
        }
        if (vector2 != null) {
            vector2.removeAllElements();
        }
    }

    private static Message processDeltaMessage(int n, Message message) {
        Message message2 = message;
        if (message == null) {
            return null;
        }
        Vector vector = (Vector)mCreateMessageCaches.elementAt(n);
        Vector vector2 = (Vector)mUpdateMessageCaches.elementAt(n);
        switch (message.getActionCode()) {
            case 6: {
                int n2 = message.getDeltaIndex();
                message2 = (Message)vector2.elementAt(n2);
                message2 = message2.createMessageFromDeltaMessage(message);
            }
            case 2: {
                vector2.insertElementAt(message2, 0);
                int n3 = vector2.size();
                if (n3 <= 8) break;
                vector2.removeElementAt(n3 - 1);
                break;
            }
            case 5: {
                int n4 = message.getDeltaIndex();
                message2 = (Message)vector.elementAt(n4);
                message2 = message2.createMessageFromDeltaMessage(message);
            }
            case 1: {
                vector.insertElementAt(message2, 0);
                int n5 = vector.size();
                if (n5 <= 8) break;
                vector.removeElementAt(n5 - 1);
                break;
            }
        }
        return message2;
    }

    public static Message convertToMessage(FormsMessage formsMessage) {
        int n = 0;
        if (formsMessage.getMessageType() == 7) {
            return null;
        }
        byte by = Message.getFormsMessageType(formsMessage.getMessageType());
        Message message = new Message(by, formsMessage.getHandlerClassId(), formsMessage.getHandlerId());
        for (int i = 0; i < formsMessage.size(); ++i) {
            String string = formsMessage.getPropertyAt(i);
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = ID.registerProperty(string).toID();
            }
            if (formsMessage.getTypeAt(i) == 10) {
                Object object = formsMessage.getValueAt(i);
                Message message2 = Message.convertToMessage((FormsMessage)object);
                message.add(n, message2);
                continue;
            }
            message.add(n, formsMessage.getValueAt(i));
        }
        return message;
    }

    public FormsMessage convertToFormsMessage() {
        byte by = Message.getGenericMessageType(this.getActionCode());
        FormsMessage formsMessage = new FormsMessage(by, this.getHandlerId(), this.getHandlerClassId());
        for (int i = 0; i < this.size(); ++i) {
            Object object;
            int n = this.getPropertyTypeAt(i);
            String string = null;
            byte by2 = Message.getPropType(n);
            try {
                int n2 = this.getPropertyAt(i);
                ID iD = ID.getInstance(n2);
                string = iD == null ? Integer.toString(n2) : ID.getInstance(n2).getName();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == 8) {
                object = ((Message)this.getValueAt(i)).convertToFormsMessage();
                formsMessage.addProperty(string, by2, object);
                continue;
            }
            object = this.getValueAt(i);
            formsMessage.addProperty(string, by2, object);
        }
        return formsMessage;
    }

    public static byte getPropType(int n) {
        byte by = 0;
        switch (n) {
            case 0: {
                by = 0;
                break;
            }
            case 1: {
                by = 1;
                break;
            }
            case 2: {
                by = 2;
                break;
            }
            case 3: {
                by = 3;
                break;
            }
            case 14: {
                by = 4;
                break;
            }
            case 7: {
                by = 5;
                break;
            }
            case 13: {
                by = 6;
                break;
            }
            case 9: {
                by = 7;
                break;
            }
            case 10: {
                by = 8;
                break;
            }
            case 12: {
                by = 9;
                break;
            }
            case 4: {
                by = 11;
                break;
            }
            case 8: {
                by = 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown property type:" + n);
            }
        }
        return by;
    }

    private static byte getFormsMessageType(byte by) {
        byte by2 = 0;
        switch (by) {
            case 1: {
                by2 = 1;
                break;
            }
            case 2: {
                by2 = 2;
                break;
            }
            case 3: {
                by2 = 3;
                break;
            }
            case 4: {
                by2 = 4;
                break;
            }
            case 5: {
                by2 = 7;
                break;
            }
            case 6: {
                by2 = 8;
                break;
            }
            case 7: 
            case 10: {
                by2 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown message type:" + by);
            }
        }
        return by2;
    }

    private static byte getGenericMessageType(byte by) {
        byte by2 = 0;
        switch (by) {
            case 1: {
                by2 = 1;
                break;
            }
            case 2: {
                by2 = 2;
                break;
            }
            case 3: {
                by2 = 3;
                break;
            }
            case 4: {
                by2 = 4;
                break;
            }
            case 7: {
                by2 = 5;
                break;
            }
            case 8: {
                by2 = 6;
                break;
            }
        }
        return by2;
    }

    static {
        mNewCacheId = 0;
        mCreateMessageCaches = new Vector();
        mUpdateMessageCaches = new Vector();
        mStringDictionaries = new Vector();
    }
}

