/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.laf.oracle.OracleLookAndFeel;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWDataSourceChoice;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuListener;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.im.InputMethodManager;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.popup.PopupFrame;
import oracle.ewt.scrolling.MouseWheelUtils;
import oracle.ewt.swing.JBufferedApplet;
import oracle.ewt.swing.JBufferedFrame;
import oracle.ewt.util.FocusUtils;
import oracle.forms.common.CheckSumUtil;
import oracle.forms.common.ssl.CertificateHandler;
import oracle.forms.engine.FormsImageLoader;
import oracle.forms.engine.FormsJSException;
import oracle.forms.engine.FormsJSUtils;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Registry;
import oracle.forms.engine.Runform;
import oracle.forms.engine.RunformException;
import oracle.forms.engine.Splashscreen;
import oracle.forms.engine.Version;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.UICommon;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.test.Test;
import oracle.forms.ui.FormDesktopContainer;
import oracle.forms.ui.FormMouseGrabProvider;
import oracle.forms.ui.mdi.MDIContainer;
import oracle.forms.ui.mdi.MDIUtils;
import oracle.forms.ui.mdi.MDIWindowMenu;

public class Main
extends JBufferedApplet
implements Test,
ActionListener,
ComponentListener,
MouseListener,
WindowListener {
    protected Vector mClientList;
    protected static final String APP_ARG = "serverApp";
    protected static final String ARGS_ARG = "serverArgs";
    protected static final String PORT_ARG = "serverPort";
    protected static final String HOST_ARG = "serverHost";
    protected static final String PRINT_DETAILS = "printServerDetails";
    protected static final String SERVER_URL_ARG = "serverURL";
    protected static final String BROWSER_ARG = "clientBrowser";
    protected static final String ENCODE_URL = "encodeURL";
    protected static final String DPI_ARG = "clientDPI";
    protected static final String DPIRATIO_ARG = "clientDPIRatio";
    protected static final String MODE_ARG = "connectMode";
    protected static final String REGISTRY_PATH_ARG = "registryPath";
    protected static final String SEPARATE_FRAME = "separateFrame";
    protected static final String COLOR_SCHEME = "colorScheme";
    protected static final String CUSTOM_COLOR_SCHEME = "customColorScheme";
    protected static final String LOOKANDFEEL = "lookAndFeel";
    protected static final String SPLASHSCREEN = "splashScreen";
    protected static final String LOGO = "logo";
    protected static final String BACKGROUND = "background";
    protected static final String WEBFORMS_TITLE = "webformsTitle";
    protected static final String DEFAULT_TITLE = "Oracle Fusion Middleware Forms Services";
    protected static final String APP_UI_PREFS_COLORTABLE = "colorTable";
    protected static final String NETWORK_STATS = "networkStats";
    protected static final String PING_STATS = "pingStats";
    protected static final String PING_WAIT = "pingWait";
    protected static final String LIST_TYPEAHEAD_DELAY = "listTypeAheadDelay";
    protected static final String DARK_LOOK = "darkLook";
    protected static final String HEARTBEAT = "heartBeat";
    protected static final String IDLE_TIMEOUT = "idleTimeout";
    protected static final String MAXEVENTWAIT = "maxEventWait";
    protected static final String SERVER_USER_PARAMS = "serverUserParams";
    protected static final String DATETIME_LOCAL_TZ = "datetimeLocalTZ";
    protected static final String IMAGEBASE = "imageBase";
    protected static final String SCALEPRINTEDIMAGE = "scalePrintedImage";
    protected static final String MSG_LISTENER = "formsMessageListener";
    protected static final String MAP_FONTS = "mapFonts";
    protected static final String DISABLEMDISCROLLBARS = "disableMDIScrollbars";
    protected static final String CHRONOS_ENABLED = "EndUserMonitoringEnabled";
    protected static final String CHRONOS_URL = "EndUserMonitoringURL";
    protected static final String DYNAMIC_LAYOUT = "dynamicLayout";
    protected static final String LOADJARSONSTART = "loadJarsOnStart";
    protected static final String EVEN_FONTS = "forceEvenFontSize";
    protected static final String BIDIPARENTHESIS = "bidiparenthesis";
    public static final String VALIDATE_CLIPBOARD = "disableValidateClipboard";
    public static final String ALERT_CLIPBOARD = "allowAlertClipboard";
    public static final String HIGH_CONTRAST = "highContrast";
    public static final String USE_ANTI_ALIAS = "useAntiAlias";
    public static final String HONOR_LINE_WIDTH = "honorLineWidth";
    public static final String TAB_STOP = "tabStop";
    public static final String DONTTRUNCATETABS = "dontTruncateTabs";
    public static final String LATENCY_CHECK = "latencyCheck";
    public static final String NLS_LANG = "nlsLang";
    public static final String ASYNC_EVENT_DELAY_ARG = "asyncEventDelay";
    public static final String CURSOR_BLINK_RATE = "cursorBlinkRate";
    public static final String JPS_PRINT = "JPSPrint";
    public static final String ROTATE_LANDSCAPE_IMAGE = "rotateLandscapeImage";
    protected static final String INLINE_IME = "inlineIME";
    public static final String SCROLL_CONTROL = "scrollControl";
    public static final String DIGITSUBSTITUTION = "digitSubstitution";
    public static final String ENABLE_JAVASCRIPT_EVENT = "enableJavascriptEvent";
    public static final String SEND_TEXTCHANGED = "sendTextChanged";
    public static final String JAVASCRIPT_BLOCKS_HEARTBEAT = "JavaScriptBlocksHeartBeat";
    public static final String ALWAYS_ON_TOP = "alwaysOnTop";
    public static final String IS_RESIZABLE = "isResizable";
    public static final String CENTER_ON_STARTUP = "centerOnStartup";
    public static final String GUI_MODE = "guiMode";
    public static final String HIDE_WINDOW_MENU_ITEM = "hideWindowMenuItem";
    public static final String LOGOUT_TARGET_URL_PARAMNAME = "logoutTargetURLParamname";
    public static final String SSO_MODE = "ssoMode";
    public static final String HIDE_APPLET_VERSION = "hideAppletVersion";
    public static final String SSO_LOGOUT_REDIRECT = "ssoLogoutRedirect";
    public static final String SSO_LOGOUT = "ssoLogout";
    public static final String SEND_HEARTBEAT_BEAN = "sendHeartBeatBean";
    public static final String HIDE_ACTIVITY_BAR = "hideActivityBar";
    public static final String WEBSTART_REQUEST = "WebstartRequest";
    public static final String WEBUTILVERSION = "webUtilVersion";
    private static final String STANDALONEAPP = "standaloneapp";
    public static final String HIDE_EXCEPTIONS = "hideClientExceptions";
    public static final String CONSOLE_USE_REGISTRY_FONT = "consoleUseRegistryFont";
    private static final String SMOOTH_SCALING_MAX_ZOOM = "smoothScalingMaxZoom";
    private static final String IMAGE_SCALE_IS_PERCENT = "imageScaleIsPercent";
    public static final String SMARTBAR_HEIGHT = "smartBarHeight";
    public static final String SMARTBAR_ICON_SCALING = "smartBarIconScaling";
    public static final String TREEICON_HEIGHT = "treeIconHeight";
    public static final String TREE_ICON_SCALING = "treeIconScaling";
    public static final String SCALE_LOGO = "scaleLogo";
    public static final String LOGO_CLICK_URL = "logoClickURL";
    public static final String SHOW_MDI_TITLEBAR = "showMDITitleBar";
    private static final String EMPTY_STRING = "";
    private static final int CASCADE_DELTA_X = 20;
    private static final int CASCADE_DELTA_Y = 20;
    private static boolean sSplashScreenRunning = false;
    private boolean mDispatcherRunning = false;
    private boolean mAllowBeep = true;
    private DesktopContainer mDesktop;
    private MDIContainer mMDIContainer;
    private Frame mFrame;
    private FormMouseGrabProvider mMouseGrab;
    private boolean mShowNetStats;
    private boolean mSeparateFrame;
    private boolean mOracleLF;
    private boolean mDarkLook;
    private boolean mScalePrintedImage;
    private boolean mDisableValidateClipboard;
    private boolean mAllowAlertDialog;
    private boolean mHighContrast;
    private boolean mUseAntiAlias;
    private boolean mHonorLineWidth;
    private int mTabStop;
    private boolean mDisableMDIScrollbars;
    private boolean mSendTextChanged;
    private boolean mSendHeartBeatBean;
    private LWPopupMenu mWindowPopup;
    private Locale mLocale;
    private Frame mAppletFrame;
    private boolean mAlreadyTriedDispatching;
    private String mProxyHost;
    private int mProxyPort;
    private String mJDKVersion;
    private String mJDKVendor;
    private String mOsVersion;
    private String mOsName;
    private double mJDKVersionNum = 0.0;
    private boolean mErrorOccured = false;
    private Runform mToDestroyHandlers = null;
    private boolean mParentWindowActive = true;
    private Vector mActionEventSources = new Vector();
    private Vector mWindowsToCenter = new Vector();
    private Registry mRegistry = null;
    private static boolean firstTimeDeactivated = false;
    private MouseWheelUtils mMouseWheelUtils = null;
    private boolean mFocusRequestedForApplet = false;
    private boolean mEnableJavascriptEvent = true;
    private boolean mJavaScriptBlocksHeartBeat = false;
    private boolean mDestroying = false;
    private boolean mWebstartRequest = false;
    private boolean mStandAloneAppRequest = false;
    private String mFSALCheckSum = null;
    private String mServerURL = "";
    private double mSmoothScalingMaxZoom = 0.0;
    private boolean mImageScaleIsPercent = false;
    private boolean mWebSocketJSIBeanAvailable = false;
    private boolean mDrawTopBorder = true;
    private boolean mDrawBottomBorder = true;
    private boolean mDrawLeftBorder = true;
    private boolean mDrawRightBorder = true;
    private Color mSmartBarColor = null;
    private boolean mIsIdcsEnabled = false;
    private String mLogoClickURL = null;
    private FormCanvas mHidingToolbar = null;
    private boolean mCustomColorSchemeSet = false;
    private CertificateHandler mCertHandler = null;
    private ShutdownHook mShutdownHook = new ShutdownHook();
    private int mGUIMode = 0;
    private static final int MDI_GUI_MODE_MASK = 1;
    private static final int NO_WINDOW_TITLEBAR_MASK = 2;
    protected final MessageGenerator mTPG = new MessageGenerator("oracle.forms.engine.RunformBundle"){

        @Override
        protected Locale getLocale() {
            return Main.this.getLocale();
        }
    };
    protected final MessageGenerator mEMG = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle"){

        @Override
        protected Locale getLocale() {
            return Main.this.getLocale();
        }

        @Override
        protected boolean showMessageKey(String string) {
            return !Main.isInfoMessage(string);
        }
    };

    static boolean isInfoMessage(String string) {
        char c = string.charAt(6);
        return c >= '7' && c <= '8';
    }

    public Main() {
        this.mClientList = new Vector();
        this.mMouseWheelUtils = new MouseWheelUtils();
        MouseWheelUtils.setWheelScrollingEnabled(true);
        try {
            Runtime.getRuntime().addShutdownHook(this.mShutdownHook);
        }
        catch (SecurityException securityException) {
            this.mShutdownHook = null;
        }
        try {
            this.mJDKVersion = System.getProperty("java.version");
            this.mJDKVendor = System.getProperty("java.vendor");
            this.mOsName = System.getProperty("os.name");
            this.mOsVersion = System.getProperty("os.version");
            this.mJDKVersionNum = this.mJDKVersion.startsWith("9") ? 9.0 : (!this.mJDKVersion.startsWith("1.") ? Double.parseDouble(this.mJDKVersion.substring(0, 2)) : Double.parseDouble(this.mJDKVersion.substring(0, 3)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void init() {
        Object object;
        block12: {
            String string = this.getParameter(LOADJARSONSTART);
            if (string != null && string.equalsIgnoreCase("true")) {
                this.loadClassesOnStart();
            }
            super.init();
            String string2 = this.getParameter(SMOOTH_SCALING_MAX_ZOOM);
            if (string2 != null && string2.length() > 0) {
                try {
                    this.mSmoothScalingMaxZoom = new BigDecimal(string2).doubleValue() / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ("true".equalsIgnoreCase(this.getParameter(IMAGE_SCALE_IS_PERCENT))) {
                this.mImageScaleIsPercent = true;
            }
            LWPopupMenu.setConsumeGrabEvent(false);
            try {
                if (!System.getProperty("os.name").startsWith("Windows")) break block12;
                for (object = this.getParent(); object != null; object = ((Component)object).getParent()) {
                    if (!object.getClass().getName().equals("sun.applet.AppletViewer")) continue;
                    this.mAppletFrame = (Frame)object;
                    this.removeBanner();
                    this.mAppletFrame.addComponentListener(this);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getParameter(GUI_MODE);
        if (object != null) {
            try {
                this.mGUIMode = Integer.parseInt((String)object);
                if (this.mGUIMode > 3 || this.mGUIMode < 0) {
                    this.mGUIMode = 0;
                }
            }
            catch (Exception exception) {
                this.mGUIMode = 0;
            }
        }
    }

    private void loadClassesOnStart() {
        try {
            Enumeration<URL> enumeration = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public final void start() {
        this.addComponentListener(this);
        this.correctSize();
        if (!this.isRunning()) {
            this.mDispatcherRunning = true;
            this.mServerURL = EMPTY_STRING;
            try {
                this.initDesktop();
            }
            catch (Throwable throwable) {
                String string = this.mEMG.getMessage("FRM-92089");
                System.out.println(string);
                throwable.printStackTrace(System.out);
                this.showStatus(string);
                this.mDispatcherRunning = false;
                return;
            }
            this.createRunform(null);
        } else {
            Container container;
            for (container = this.mMDIContainer.getParent(); container != null && !(container instanceof Frame); container = container.getParent()) {
            }
            this.mFrame = (Frame)container;
            this.mFrame.addWindowListener(this);
        }
    }

    @Override
    public void stop() {
        this.removeComponentListener(this);
        if (this.mFrame != null) {
            this.mFrame.removeWindowListener(this);
        }
        this.mFocusRequestedForApplet = false;
        if (this.mClientList != null) {
            Enumeration enumeration = this.mClientList.elements();
            while (enumeration.hasMoreElements()) {
                Runform runform = (Runform)enumeration.nextElement();
                runform.clearInputContext();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        try {
            this.mDestroying = true;
            String string = System.getProperty("java.version");
            if (string != null && !string.startsWith("1.1")) {
                this.mdiClosing();
            }
            while (this.mClientList.size() > 0) {
                this.destroyRunform((Runform)this.mClientList.lastElement());
            }
            if (this.mFrame != null) {
                this.mFrame.removeWindowListener(this);
            }
            if (this.mToDestroyHandlers != null) {
                if (this.mToDestroyHandlers.hasErrorOccured()) {
                    this.mToDestroyHandlers.destroyHandlers();
                }
                this.mToDestroyHandlers = null;
            }
            if (this.mAppletFrame != null) {
                this.mAppletFrame.removeComponentListener(this);
                this.mAppletFrame = null;
            }
            for (int i = 0; i < this.mActionEventSources.size(); ++i) {
                LWMenuItem lWMenuItem = (LWMenuItem)this.mActionEventSources.elementAt(i);
                lWMenuItem.removeActionListener(this);
            }
            this.mActionEventSources.removeAllElements();
            super.destroy();
            if (FormsImageLoader.sharedInstance().getApplet() == this) {
                FormsImageLoader.sharedInstance().setApplet(null);
            }
            this.initLocals();
        }
        finally {
            if (this.mShutdownHook != null) {
                this.mShutdownHook.terminate();
            }
        }
    }

    protected void createRunform(Runform runform) {
        if (this.isRunning()) {
            Runform runform2 = this.newRunform(this, runform);
            this.mClientList.addElement(runform2);
            runform2.startRunform();
        }
    }

    protected synchronized void destroyRunform(Runform runform) {
        runform.shutdownRunform();
        if (runform.hasErrorOccured()) {
            this.mToDestroyHandlers = runform;
        }
        this.mClientList.removeElement(runform);
        if (this.mClientList.size() == 0) {
            this.mDispatcherRunning = false;
            if (!runform.hasErrorOccured()) {
                this.getMDIContainer().removeAll();
                this.getMDIContainer().validate();
                this.removeAll();
                this.mErrorOccured = true;
                this.exitApplet();
            }
        }
    }

    public boolean isRunning() {
        return this.mDispatcherRunning;
    }

    public boolean hasCustomColorScheme() {
        return this.mCustomColorSchemeSet;
    }

    public final MessageGenerator getErrorMessageGenerator() {
        return this.mEMG;
    }

    public final MessageGenerator getTranslatedPhraseGenerator() {
        return this.mTPG;
    }

    @Override
    public String getAppletInfo() {
        return "Web Developer, Forms Java Client " + Version.getString() + "\nCopyright (c) 1998, 2024, Oracle and/or its affiliates.";
    }

    @Override
    public String[][] getParameterInfo() {
        String string = this.mTPG.getText("STRING");
        String string2 = this.mTPG.getText("INTEGER");
        String[][] stringArray = new String[][]{{HOST_ARG, string, this.mTPG.getText("SRVHOST")}, {PORT_ARG, string2, this.mTPG.getText("SRVPORT")}, {APP_ARG, string, this.mTPG.getText("SRVAPP")}, {ARGS_ARG, string, this.mTPG.getText("SRVARGS")}};
        return stringArray;
    }

    public String getJDKVersion() {
        if (this.mJDKVersion != null) {
            return this.mJDKVersion;
        }
        return EMPTY_STRING;
    }

    public double getJDKVersionNumber() {
        return this.mJDKVersionNum;
    }

    public String getJDKVendor() {
        if (this.mJDKVendor != null) {
            return this.mJDKVendor;
        }
        return EMPTY_STRING;
    }

    public String getOsName() {
        if (this.mOsName != null) {
            return this.mOsName;
        }
        return EMPTY_STRING;
    }

    public String getOsVersion() {
        if (this.mOsVersion != null) {
            return this.mOsVersion;
        }
        return EMPTY_STRING;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public Frame getFrame() {
        return this.mFrame;
    }

    public DesktopContainer getDesktop() {
        return this.mDesktop;
    }

    public MDIContainer getMDIContainer() {
        return this.mMDIContainer;
    }

    public FormMouseGrabProvider getCursorGrabProvider() {
        return this.mMouseGrab;
    }

    public Image getDefaultImage(String string) {
        if (FormsImageLoader.sharedInstance().getApplet() != this) {
            FormsImageLoader.sharedInstance().setApplet(this);
        }
        return FormsImageLoader.sharedInstance().getDefaultImage(string);
    }

    public Image getCustomImage(String string) {
        if (FormsImageLoader.sharedInstance().getApplet() != this) {
            FormsImageLoader.sharedInstance().setApplet(this);
        }
        return FormsImageLoader.sharedInstance().getCustomImage(string);
    }

    public LWMenuBar createDefaultMenuBar() {
        String string;
        LWMenuBar lWMenuBar = new LWMenuBar();
        if (!this.hasOracleLF()) {
            lWMenuBar.setForeground(SystemColor.menuText);
            lWMenuBar.setBackground(SystemColor.menu);
        }
        if ((string = this.getParameter(HIDE_WINDOW_MENU_ITEM)) == null || !string.equalsIgnoreCase("true")) {
            lWMenuBar.add(this.getWindowMenu());
        }
        return lWMenuBar;
    }

    public LWMenuItem getCascadeMenuItem() {
        LWMenuItem lWMenuItem = new LWMenuItem(this.mTPG.getText("MENUCASCADE"));
        lWMenuItem.addActionListener(this);
        lWMenuItem.setActionCommand("CASCADE");
        this.mActionEventSources.addElement(lWMenuItem);
        lWMenuItem.setMnemonicChar(this.mTPG.getText("MENUCASCADEKEY").charAt(0));
        return lWMenuItem;
    }

    public LWMenuItem getTileHMenuItem() {
        LWMenuItem lWMenuItem = new LWMenuItem(this.mTPG.getText("MENUTILEH"));
        lWMenuItem.addActionListener(this);
        lWMenuItem.setActionCommand("TILEH");
        this.mActionEventSources.addElement(lWMenuItem);
        lWMenuItem.setMnemonicChar(this.mTPG.getText("MENUTILEHKEY").charAt(0));
        return lWMenuItem;
    }

    public LWMenuItem getTileVMenuItem() {
        LWMenuItem lWMenuItem = new LWMenuItem(this.mTPG.getText("MENUTILEV"));
        lWMenuItem.addActionListener(this);
        lWMenuItem.setActionCommand("TILEV");
        this.mActionEventSources.addElement(lWMenuItem);
        lWMenuItem.setMnemonicChar(this.mTPG.getText("MENUTILEVKEY").charAt(0));
        return lWMenuItem;
    }

    public LWMenu getWindowMenu() {
        this.mWindowPopup = new LWPopupMenu();
        LWMenuItem lWMenuItem = this.getCascadeMenuItem();
        LWMenuItem lWMenuItem2 = this.getTileHMenuItem();
        LWMenuItem lWMenuItem3 = this.getTileVMenuItem();
        Runform runform = null;
        if (this.mClientList != null) {
            runform = (Runform)this.mClientList.lastElement();
        }
        this.mWindowPopup.add(lWMenuItem);
        this.mWindowPopup.add(lWMenuItem2);
        this.mWindowPopup.add(lWMenuItem3);
        this.mWindowPopup.add(new LWMenuSeparator());
        this.mWindowPopup.add(new MDIWindowMenu(this.mDesktop, this.mWindowPopup, runform));
        LWMenu lWMenu = new LWMenu(this.mTPG.getText("MENUWINDOW"), null);
        lWMenu.setSubMenu(this.mWindowPopup);
        lWMenu.setMnemonicChar(this.mTPG.getText("MENUWINDOWKEY").charAt(0));
        if (this.hasDarkLook() && this.hasCustomColorScheme()) {
            Color color = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.MENU);
            if (runform != null) {
                if (ColorUtils.getApproximateLuminance(color) <= runform.getDarkLuminance()) {
                    lWMenuItem.setForeground(Color.white);
                    lWMenuItem2.setForeground(Color.white);
                    lWMenuItem3.setForeground(Color.white);
                }
                if ((color = lWMenu.getBackground()) == null) {
                    color = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.DESKTOP);
                }
                if (ColorUtils.getApproximateLuminance(color) <= runform.getDarkLuminance()) {
                    lWMenu.setForeground(Color.white);
                }
            }
        }
        return lWMenu;
    }

    public void cleanupWindowMenu(LWMenu lWMenu) {
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        Container container = lWPopupMenu.getContent();
        if (container == null) {
            return;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            LWComponent lWComponent;
            Component component = container.getComponent(i);
            if (component instanceof MDIWindowMenu) {
                lWComponent = (MDIWindowMenu)component;
                lWPopupMenu.removePopupMenuListener((LWPopupMenuListener)((Object)lWComponent));
                continue;
            }
            if (!(component instanceof LWMenuItem)) continue;
            lWComponent = (LWMenuItem)component;
            this.mActionEventSources.remove(lWComponent);
        }
        lWPopupMenu.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof LWMenuItem)) {
            return;
        }
        String string = ((LWMenuItem)actionEvent.getSource()).getActionCommand();
        if (string != null) {
            if (string.equals("CASCADE")) {
                MDIUtils.cascadeWindows(this.mDesktop, 20, 20);
            } else if (string.equals("TILEH")) {
                MDIUtils.tileWindowsHorizontally(this.mDesktop);
            } else {
                MDIUtils.tileWindowsVertically(this.mDesktop);
            }
        }
    }

    public boolean isNetStatsVisible() {
        return this.mShowNetStats;
    }

    public boolean useSeparateFrame() {
        return this.isSeparateFrameRequest() || this.isWebstartRequest() || this.isStandAloneAppRequest();
    }

    public Image getParamImage(String string, String string2) {
        Image image = null;
        String string3 = this.getParameter(string);
        if (string3 == null || string3.equals(EMPTY_STRING)) {
            if (string2 != null) {
                image = this.getDefaultImage(string2);
            }
        } else if (!string3.equalsIgnoreCase("no")) {
            image = this.getCustomImage(string3);
        }
        return image;
    }

    public final boolean isWebstartRequest() {
        return this.mWebstartRequest;
    }

    public final boolean isStandAloneAppRequest() {
        return this.mStandAloneAppRequest;
    }

    private final boolean isSeparateFrameRequest() {
        return this.mSeparateFrame;
    }

    public final boolean isRunningSSOMode() {
        String string = this.getParameter(SSO_MODE);
        return string != null && (string.equalsIgnoreCase("webgate") || string.equalsIgnoreCase("true"));
    }

    public final boolean hasDarkLook() {
        return this.mDarkLook;
    }

    public final boolean getScalePrintedImage() {
        return this.mScalePrintedImage;
    }

    public final boolean hasOracleLF() {
        return this.mOracleLF;
    }

    public void exitSplashscreen() {
        if (sSplashScreenRunning) {
            Splashscreen.exitSplashscreen();
            sSplashScreenRunning = false;
        }
    }

    private void initLocals() {
        if (this.mErrorOccured) {
            this.getMDIContainer().removeAll();
            this.getMDIContainer().validate();
            this.removeAll();
            this.mErrorOccured = false;
        }
        if (this.mWindowPopup != null) {
            this.mWindowPopup.removeAll();
        }
        this.mOracleLF = false;
        this.mShowNetStats = false;
        this.mSeparateFrame = false;
        this.mDisableValidateClipboard = false;
        this.mAllowAlertDialog = false;
        this.mHighContrast = false;
        this.mUseAntiAlias = true;
        this.mHonorLineWidth = false;
        this.mTabStop = -1;
        this.mDarkLook = false;
        this.mScalePrintedImage = true;
        this.mAlreadyTriedDispatching = false;
        this.mSendTextChanged = false;
        this.mSendHeartBeatBean = false;
        this.mProxyHost = null;
        this.mProxyPort = 0;
        this.mWindowPopup = null;
        this.mMouseGrab = null;
        this.mDesktop = null;
        if (this.mMDIContainer != null && this.mMDIContainer.getImageCanvas() != null) {
            this.mMDIContainer.getImageCanvas().removeMouseListener(this);
        }
        this.mMDIContainer = null;
        this.mDisableMDIScrollbars = false;
    }

    private void initDesktop() throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        Object[] objectArray;
        Object object;
        Object object2;
        String string11;
        String string12;
        Object object3;
        Object object4;
        ColorScheme colorScheme;
        String string13;
        Object object5;
        Object[] objectArray2;
        Object object6;
        Object object7;
        Class<?> clazz;
        if (this.getJDKVersionNumber() >= 1.5) {
            clazz = "sun.java2d.SunGraphicsEnvironment";
            if (this.getJDKVersionNumber() >= 9.0) {
                clazz = "com.oracle.awt.AWTUtils";
            }
            try {
                object7 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                object6 = object7.getClass();
                if (this.getJDKVersionNumber() < 11.0) {
                    objectArray2 = Class.forName(clazz);
                    object5 = objectArray2.getMethod("useAlternateFontforJALocales", null);
                    ((Method)object5).invoke(null, null);
                }
                objectArray2 = ((Class)object6).getMethod("preferLocaleFonts", null);
                object5 = ((Class)object6).getMethod("preferProportionalFonts", null);
                objectArray2.invoke(object7, null);
                ((Method)object5).invoke(object7, null);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        } else if (this.getJDKVersionNumber() == 1.4 && FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                clazz = Class.forName("sun.java2d.SunGraphicsEnvironment");
                object7 = new Class[]{String.class};
                object6 = clazz.getMethod("setFallbackFont", (Class<?>)object7);
                objectArray2 = new Object[]{new String("Albany WT J")};
                ((Method)object6).invoke(null, objectArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            try {
                clazz = Class.forName("sun.java2d.SunGraphicsEnvironment");
                object7 = clazz.getMethod("preferLocaleSpecificFonts", null);
                ((Method)object7).invoke(null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        if ((clazz = this.getParameter(INLINE_IME)) != null && ((String)((Object)clazz)).equalsIgnoreCase("false")) {
            InputMethodManager.setInlineIMEEnabled(false);
        }
        if ((object7 = this.getParameter(WEBSTART_REQUEST)) != null && ((String)object7).equalsIgnoreCase("true")) {
            this.mWebstartRequest = true;
            object6 = new CookieManager();
            ((CookieManager)object6).setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault((CookieHandler)object6);
        }
        this.initLocals();
        this.mLocale = Locale.getDefault();
        object6 = this.getParameter(DARK_LOOK);
        if (object6 != null && ((String)object6).equalsIgnoreCase("true")) {
            this.mDarkLook = true;
        }
        objectArray2 = "unknown";
        try {
            objectArray2 = System.getProperty("java.vendor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        object5 = this.getParameter(SCALEPRINTEDIMAGE);
        this.mScalePrintedImage = object5 == null || !((String)object5).equalsIgnoreCase("false") || !objectArray2.toUpperCase().startsWith("MICROSOFT");
        String string14 = this.getParameter(LOOKANDFEEL);
        if (string14 == null || string14.equals(EMPTY_STRING) || string14.equalsIgnoreCase("Generic")) {
            string14 = "Generic";
        } else if (string14.equalsIgnoreCase("Oracle")) {
            string14 = "Oracle";
            this.mOracleLF = true;
        } else {
            String string15 = this.mEMG.getMessage("FRM-92210", string14, "Generic");
            System.out.println(string15);
            this.showStatus(string15);
            string14 = "Generic";
        }
        UIManager.setLookAndFeelByName(string14);
        boolean bl = false;
        String string16 = string13 = this.mOracleLF ? this.getParameter(CUSTOM_COLOR_SCHEME) : null;
        if (string13 != null && !string13.equals(EMPTY_STRING) && (colorScheme = this.fetchCustomColorScheme(string13)) != null) {
            UIManager.getLookAndFeel().setDefaultColorScheme(colorScheme);
            bl = true;
            this.mCustomColorSchemeSet = true;
        }
        ColorScheme colorScheme2 = colorScheme = this.mOracleLF && !bl ? this.getParameter(COLOR_SCHEME) : null;
        if (colorScheme != null && !((String)((Object)colorScheme)).equals(EMPTY_STRING)) {
            if (((String)((Object)colorScheme)).equalsIgnoreCase("Teal") || ((String)((Object)colorScheme)).equalsIgnoreCase("Titanium") || ((String)((Object)colorScheme)).equalsIgnoreCase("Red") || ((String)((Object)colorScheme)).equalsIgnoreCase("Khaki") || ((String)((Object)colorScheme)).equalsIgnoreCase("Blue") || ((String)((Object)colorScheme)).equalsIgnoreCase("Olive") || ((String)((Object)colorScheme)).equalsIgnoreCase("Purple") || ((String)((Object)colorScheme)).equalsIgnoreCase("BLAF") || ((String)((Object)colorScheme)).equalsIgnoreCase("Swan")) {
                object4 = UIManager.getLookAndFeel();
                object3 = ((LookAndFeel)object4).getColorSchemes();
                for (int i = 0; i < ((ColorScheme[])object3).length; ++i) {
                    if (!object3[i].getName().equalsIgnoreCase((String)((Object)colorScheme))) continue;
                    ((LookAndFeel)object4).setDefaultColorScheme(object3[i]);
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object4 = this.mEMG.getMessage("FRM-92211", colorScheme);
                System.out.println((String)object4);
                this.showStatus((String)object4);
            }
        }
        FormsImageLoader.sharedInstance().setApplet(this);
        this.initSplashscreen();
        if (!this.getJDKVersion().startsWith("1.1") && !this.isVisible()) {
            this.setVisible(true);
        }
        this.mDesktop = new FormDesktopContainer();
        this.mMDIContainer = new MDIContainer(this.mDesktop, this.getMdiGuiMode(), this.getLogo());
        this.mLogoClickURL = this.getParameter(LOGO_CLICK_URL);
        if (this.mMDIContainer.getImageCanvas() != null && this.mLogoClickURL != null && !this.mLogoClickURL.equals(EMPTY_STRING)) {
            this.mMDIContainer.getImageCanvas().addMouseListener(this);
            this.mMDIContainer.getImageCanvas().setCursor(Cursor.getPredefinedCursor(12));
            this.mMDIContainer.getImageCanvas().setToolTipValue(this.mLogoClickURL);
        }
        if ((object4 = this.getParameter(DISABLEMDISCROLLBARS)) != null && ((String)object4).equalsIgnoreCase("true")) {
            this.mDisableMDIScrollbars = true;
        }
        if (this.mDisableMDIScrollbars) {
            this.mMDIContainer.getMDIScrollBox().setHDisplayPolicy(2);
            this.mMDIContainer.getMDIScrollBox().setVDisplayPolicy(2);
        }
        this.setBackground(UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.DESKTOP));
        this.mMDIContainer.setDefaultHorizontalToolBar(null);
        this.mMDIContainer.setDefaultVerticalToolBar(null);
        this.mMDIContainer.setDefaultStatusBar(null);
        this.setupBackgroundImage(this.getDesktop());
        if (this.mMouseGrab == null) {
            this.mMouseGrab = new FormMouseGrabProvider();
        }
        if ((object3 = this.getParameter(STANDALONEAPP)) != null && ((String)object3).equalsIgnoreCase("true")) {
            this.mStandAloneAppRequest = true;
            this.mFSALCheckSum = this.computeFSALCheckSum();
            if (this.mFSALCheckSum == null) {
                String string17 = this.mEMG.getMessage("FRM-92496");
                System.out.println(string17);
                this.exitApplet();
                return;
            }
        }
        if ((string12 = this.getParameter(SEPARATE_FRAME)) != null && !string12.equals(EMPTY_STRING) && string12.equalsIgnoreCase("true")) {
            this.mSeparateFrame = true;
        }
        if ((string11 = this.getParameter(WEBFORMS_TITLE)) == null || string11.equals(EMPTY_STRING)) {
            string11 = DEFAULT_TITLE;
        }
        if (!(this.isStandAloneAppRequest() || this.isSeparateFrameRequest() && this.mAppletFrame == null && !this.isWebstartRequest())) {
            if (this.isWebstartRequest() && (object2 = this.getParameter(DYNAMIC_LAYOUT)) != null) {
                if (((String)object2).equalsIgnoreCase("False")) {
                    Toolkit.getDefaultToolkit().setDynamicLayout(false);
                } else if (((String)object2).equalsIgnoreCase("True")) {
                    Toolkit.getDefaultToolkit().setDynamicLayout(true);
                }
            }
            if (this.getMouseGrabProvider() == null) {
                this.setMouseGrabProvider(this.mMouseGrab);
            }
            this.setLayout(new BorderLayout());
            this.add("Center", this.mMDIContainer);
            for (object2 = this.mMDIContainer.getParent(); object2 != null && !(object2 instanceof Frame); object2 = ((Component)object2).getParent()) {
            }
            this.mFrame = (Frame)object2;
            this.mFrame.setMenuBar(null);
            this.mFrame.setTitle(string11);
            if (this.mFrame instanceof JFrame && this.isWebstartRequest()) {
                object = this.mFrame.getWindowListeners();
                for (int i = 0; i < ((WindowListener[])object).length; ++i) {
                    this.mFrame.removeWindowListener(object[i]);
                }
                ((JFrame)this.mFrame).setDefaultCloseOperation(0);
            }
            this.mFrame.addWindowListener(this);
        } else {
            String string18;
            object2 = this.getParameter(DYNAMIC_LAYOUT);
            if (object2 != null) {
                if (((String)object2).equalsIgnoreCase("False")) {
                    Toolkit.getDefaultToolkit().setDynamicLayout(false);
                } else if (((String)object2).equalsIgnoreCase("True")) {
                    Toolkit.getDefaultToolkit().setDynamicLayout(true);
                }
            }
            object = new JBufferedFrame();
            if (this.isStandAloneAppRequest() && (string18 = this.getParameter(SHOW_MDI_TITLEBAR)) != null && string18.equalsIgnoreCase("false")) {
                ((Frame)object).setUndecorated(true);
            }
            ((Frame)object).setBackground(this.getBackground());
            if (((PopupFrame)object).getMouseGrabProvider() == null) {
                ((PopupFrame)object).setMouseGrabProvider(this.mMouseGrab);
            }
            ((PopupFrame)object).setLayout(new BorderLayout());
            ((Container)object).add("Center", this.mMDIContainer);
            string18 = this.getJDKVersion();
            if (string18.indexOf("1.5") != -1 && string18.indexOf("0_01") == -1 && string18.indexOf("0_03") == -1 && string18.indexOf("0_04") == -1 && string18.indexOf("0_05") == -1 && string18.indexOf("0_06") == -1 && string18.indexOf("0_07") == -1) {
                firstTimeDeactivated = true;
            }
            if (this.isStandAloneAppRequest()) {
                for (objectArray = this.getParent(); objectArray != null && !(objectArray instanceof Frame); objectArray = objectArray.getParent()) {
                }
                ((Window)object).setBounds(objectArray.getBounds());
                ((Window)object).setSize(objectArray.getSize());
            } else {
                ((Window)object).setBounds(this.getBounds());
                ((Window)object).setSize(this.getSize());
            }
            this.mFrame = object;
            this.mFrame.setTitle(string11);
            this.mFrame.setVisible(true);
            this.mFrame.addWindowListener(this);
            this.mFrame.setLocale(this.getLocale());
        }
        if (this.useSeparateFrame()) {
            object2 = this.getParameter(ALWAYS_ON_TOP);
            if (object2 != null && ((String)object2).trim().equalsIgnoreCase("true")) {
                this.mFrame.setAlwaysOnTop(true);
            }
            if ((object = this.getParameter(IS_RESIZABLE)) != null && ((String)object).trim().equalsIgnoreCase("false")) {
                this.mFrame.setResizable(false);
            } else {
                this.mFrame.setResizable(true);
            }
            String string19 = this.getParameter(CENTER_ON_STARTUP);
            if (string19 != null && string19.trim().equalsIgnoreCase("true")) {
                this.centerMDI();
            }
        }
        if (FocusUtils.areNewFocusAPIsAvailable() && this.getJDKVersionNumber() < 11.0) {
            try {
                object2 = null;
                object2 = this.getJDKVersionNumber() >= 9.0 ? "com.oracle.awt.AWTUtils" : "sun.awt.SunToolkit";
                object = new Class[]{Window.class, Boolean.TYPE};
                Method method = Class.forName((String)object2).getMethod("setLWRequestStatus", (Class<?>)object);
                objectArray = new Object[]{this.mFrame, true};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        FocusUtils.setDefaultFocusTraversalPolicy(this.mFrame);
        object2 = this.getParameter(NETWORK_STATS);
        if (object2 != null && ((String)object2).equalsIgnoreCase("true")) {
            this.mShowNetStats = true;
        }
        if (this.useSeparateFrame()) {
            object = System.getProperty("os.name");
            if (((String)object).indexOf("Linux") != -1 || ((String)object).indexOf("XP") != -1 || ((String)object).indexOf("2003") != -1 || ((String)object).indexOf("Vista") != -1 || ((String)object).indexOf("7") != -1) {
                this.mFrame.toFront();
            } else {
                this.mFrame.requestFocus();
            }
        } else {
            this.requestFocus();
        }
        object = this.getParameter(CURSOR_BLINK_RATE);
        if (object != null) {
            try {
                long l = Long.parseLong((String)object);
                LWTextComponent.setBlinkRate(l);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ("true".equalsIgnoreCase(string10 = this.getParameter(VALIDATE_CLIPBOARD))) {
            this.mDisableValidateClipboard = true;
        }
        if ("true".equalsIgnoreCase((String)(objectArray = this.getParameter(HIGH_CONTRAST)))) {
            this.mHighContrast = true;
        }
        if ("false".equalsIgnoreCase(string9 = this.getParameter(USE_ANTI_ALIAS))) {
            this.mUseAntiAlias = false;
        }
        if ("true".equalsIgnoreCase(string8 = this.getParameter(HONOR_LINE_WIDTH))) {
            this.mHonorLineWidth = true;
        }
        if ((string7 = this.getParameter(TAB_STOP)) != null) {
            try {
                this.mTabStop = Integer.parseInt(string7);
                if (this.mTabStop <= 0) {
                    this.mTabStop = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.mTabStop = -1;
            }
        }
        if ((string6 = this.getParameter(LIST_TYPEAHEAD_DELAY)) != null) {
            try {
                long l = Long.parseLong(string6);
                if (l >= 0L) {
                    LWDataSourceChoice.setDefaultTypeAheadDelay(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ("true".equalsIgnoreCase(string5 = this.getParameter(ALERT_CLIPBOARD))) {
            this.mAllowAlertDialog = true;
        }
        if (this.getParameter(APP_ARG) != null && this.getParameter(APP_ARG).startsWith("OracleApplications")) {
            LWTextField.setTextAlwaysLeftAligned(true);
        }
        if ((string4 = this.getParameter(ENABLE_JAVASCRIPT_EVENT)) != null && string4.trim().equalsIgnoreCase("false")) {
            this.mEnableJavascriptEvent = false;
        }
        if ((string3 = this.getParameter(SEND_TEXTCHANGED)) != null && string3.equalsIgnoreCase("true")) {
            this.mSendTextChanged = true;
        }
        if ((string2 = this.getParameter(SEND_HEARTBEAT_BEAN)) != null && string2.equalsIgnoreCase("true")) {
            this.mSendHeartBeatBean = true;
        }
        if ((string = this.getParameter(JAVASCRIPT_BLOCKS_HEARTBEAT)) != null && string.trim().equalsIgnoreCase("true")) {
            this.mJavaScriptBlocksHeartBeat = true;
        }
    }

    public void centerMDI() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Point point = new Point(0, 0);
        Dimension dimension = this.mFrame.getSize();
        if (rectangle != null) {
            point.x = rectangle.width - dimension.width;
            point.x = point.x > 0 ? point.x / 2 : 0;
            point.y = rectangle.height - dimension.height;
            point.y = point.y > 0 ? point.y / 2 : 0;
        }
        this.mFrame.setLocation(point);
    }

    public void setBeepAllowed(boolean bl) {
        this.mAllowBeep = bl;
    }

    public boolean isBeepAllowed() {
        return this.mAllowBeep;
    }

    public boolean getDrawTopBorder() {
        return this.mDrawTopBorder;
    }

    public boolean getDrawBottomBorder() {
        return this.mDrawBottomBorder;
    }

    public boolean getDrawLeftBorder() {
        return this.mDrawLeftBorder;
    }

    public boolean getDrawRightBorder() {
        return this.mDrawRightBorder;
    }

    public void setDrawTopBorder(boolean bl) {
        this.mDrawTopBorder = bl;
    }

    public void setDrawBottomBorder(boolean bl) {
        this.mDrawBottomBorder = bl;
    }

    public void setDrawLeftBorder(boolean bl) {
        this.mDrawLeftBorder = bl;
    }

    public void setDrawRightBorder(boolean bl) {
        this.mDrawRightBorder = bl;
    }

    public boolean isClipboardValidationDisabled() {
        return this.mDisableValidateClipboard;
    }

    public boolean isAlertDialogAllowed() {
        return this.mAllowAlertDialog;
    }

    public boolean isHighContrast() {
        return this.mHighContrast;
    }

    public boolean isUseAntiAlias() {
        return this.mUseAntiAlias;
    }

    public boolean isHonorLineWidth() {
        return this.mHonorLineWidth;
    }

    public int getTabStop() {
        return this.mTabStop;
    }

    public boolean isSendTextChanged() {
        return this.mSendTextChanged;
    }

    public boolean isSendHeartBeatBean() {
        return this.mSendHeartBeatBean;
    }

    private void initSplashscreen() {
        if (sSplashScreenRunning) {
            return;
        }
        Image image = this.getParamImage(SPLASHSCREEN, "splash");
        if (image != null && ImageUtils.loadImage(image)) {
            Toolkit toolkit = this.getToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Point point = dimension != null ? new Point(dimension.width / 2, dimension.height / 2) : new Point(200, 100);
            Splashscreen.initSplashscreen(image, point);
            sSplashScreenRunning = true;
        }
    }

    private void setupBackgroundImage(LWComponent lWComponent) {
        Image image = this.getParamImage(BACKGROUND, "bgnd");
        if (image != null) {
            lWComponent.setFill(new FixedImagePainter(image));
            this.getToolkit().prepareImage(image, -1, -1, null);
        } else {
            lWComponent.setFill(new NullPainter());
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.mWindowPopup = null;
        this.mLocale = locale;
        if (this.useSeparateFrame() && this.mFrame != null) {
            this.mFrame.setLocale(locale);
        }
    }

    public Vector getWindowsToCenter() {
        return this.mWindowsToCenter;
    }

    public Image getLogo() {
        boolean bl;
        String string = this.getParameter(COLOR_SCHEME);
        boolean bl2 = bl = this.mOracleLF && string != null && (string.equalsIgnoreCase("BLAF") || string.equalsIgnoreCase("Swan"));
        String string2 = this.hasOracleLF() ? (bl ? "oracle_logo_light" : "oracle_logo") : null;
        Image image = this.getParamImage(LOGO, string2);
        if (image == null) {
            return null;
        }
        String string3 = this.getParameter(SCALE_LOGO);
        if (string3 == null || !string3.equalsIgnoreCase("false")) {
            int n;
            int n2 = image.getWidth(this);
            int n3 = image.getHeight(this);
            if ((n2 == -1 || n3 == -1) && ImageUtils.loadImage(image)) {
                n2 = image.getWidth(this);
                n3 = image.getHeight(this);
            }
            String string4 = this.getParameter(DPI_ARG);
            int n4 = n = this.getToolkit().getScreenResolution();
            if (string4 != null && !string4.equals(EMPTY_STRING)) {
                try {
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n != n4) {
                n2 = n2 * n4 / n;
                n3 = n3 * n4 / n;
                image = image.getScaledInstance(n2, n3, 2);
            }
        }
        return image;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mLogoClickURL != null && !this.mLogoClickURL.equals(EMPTY_STRING)) {
            Runform runform = (Runform)this.mClientList.get(0);
            String[] stringArray = new String[]{this.mLogoClickURL, "_blank"};
            runform.doHyperLink(stringArray);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.mAppletFrame != null) {
            this.mAppletFrame.removeComponentListener(this);
        }
        this.tryDispatching();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.mClientList != null) {
            Enumeration enumeration = this.mClientList.elements();
            while (enumeration.hasMoreElements()) {
                Runform runform = (Runform)enumeration.nextElement();
                ComponentItem componentItem = runform.getFocusOwner();
                if (componentItem == null) continue;
                componentItem.getComponent().requestFocus();
                this.mFocusRequestedForApplet = true;
                break;
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void requestFocus() {
        if (!this.mFocusRequestedForApplet) {
            super.requestFocus();
        }
    }

    public void tryDispatching() {
        if (!this.mAlreadyTriedDispatching) {
            this.mAlreadyTriedDispatching = true;
            EventQueue eventQueue = null;
            try {
                eventQueue = this.getToolkit().getSystemEventQueue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eventQueue != null) {
                this.dispatchEvents(eventQueue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvents(EventQueue eventQueue) {
        while (this.isRunning()) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                Object object = aWTEvent.getSource();
                if (object == this.mAppletFrame && aWTEvent.getID() == 201) {
                    this.mdiClosing();
                    continue;
                }
                boolean bl = false;
                try {
                    Class<?> clazz = null;
                    Method method = aWTEvent.getClass().getMethod("dispatch", null);
                    try {
                        clazz = Class.forName("java.awt.ActiveEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Class.forName("java.awt.peer.ActiveEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            classNotFoundException2.printStackTrace(System.out);
                        }
                    }
                    if (method == null || clazz == null) continue;
                    method = clazz.getMethod("dispatch", null);
                    method.invoke((Object)aWTEvent, null);
                    bl = true;
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (bl) continue;
                    if (object instanceof Component) {
                        ((Component)object).dispatchEvent(aWTEvent);
                        continue;
                    }
                    if (!(object instanceof MenuComponent)) continue;
                    ((MenuComponent)object).dispatchEvent(aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void mdiClosing() {
        Enumeration enumeration = this.mClientList.elements();
        while (enumeration.hasMoreElements()) {
            Runform runform = (Runform)enumeration.nextElement();
            MessageHandler messageHandler = runform.getRootWindow();
            if (messageHandler == null) continue;
            Message message = Message.newMessage(messageHandler, 216, Boolean.TRUE);
            runform.onMessage(message, 0);
        }
    }

    public void correctSize() {
        Container container;
        if (this.mAppletFrame != null && (container = this.getParent()) != null) {
            this.setSize(container.getSize());
        }
    }

    public void correctMDISize() {
        Container container = this.getParent();
        if (container != null) {
            this.setSize(container.getSize());
            if (this.getMDIContainer() != null) {
                this.getMDIContainer().getMDIScrollBox().setSize(container.getSize());
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this.isRunning()) {
            this.mFrame.dispose();
            if (this.isStandAloneAppRequest() || this.isWebstartRequest()) {
                this.exitApplet();
            }
        } else if (this.useSeparateFrame()) {
            this.mdiClosing();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.mParentWindowActive = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UICommon.doDeferredRequestFocusForInactiveApplet(Main.this.mFrame);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        Runform runform;
        if (firstTimeDeactivated) {
            firstTimeDeactivated = false;
            this.getFrame().toFront();
            return;
        }
        this.mParentWindowActive = false;
        if (this.mClientList != null && this.mClientList.size() > 0 && (runform = (Runform)this.mClientList.get(0)) != null && runform.getIsMouseDownMessageSent()) {
            Message message = Message.newMessage(runform, 555, Boolean.TRUE);
            runform.onMessage(message, 0);
            runform.setIsMouseDownMessageSent(false);
        }
    }

    public boolean isParentWindowActive() {
        return this.mParentWindowActive;
    }

    protected Runform newRunform(Main main2, Runform runform) {
        try {
            return new Runform(main2, runform);
        }
        catch (Throwable throwable) {
            String string = this.mEMG.getMessage("FRM-92090");
            System.out.println(string);
            throwable.printStackTrace(System.out);
            this.showStatus(string);
            this.mDispatcherRunning = false;
            throw throwable;
        }
    }

    protected void removeBanner() {
        Component[] componentArray = this.mAppletFrame.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Label)) continue;
            this.mAppletFrame.remove(componentArray[i]);
            break;
        }
        this.mAppletFrame.pack();
    }

    public void exitApplet() {
        if (this.isWebstartRequest() && this.mShutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.mShutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mShutdownHook = null;
        }
        if (this.mAppletFrame != null) {
            try {
                this.mAppletFrame.removeAll();
                this.mAppletFrame.removeComponentListener(this);
                this.mAppletFrame = null;
                System.exit(0);
            }
            catch (Exception exception) {}
        } else if (this.useSeparateFrame()) {
            try {
                if (this.mSeparateFrame || this.isWebstartRequest()) {
                    this.mFrame.dispose();
                    if (this.isWebstartRequest()) {
                        System.exit(0);
                    }
                }
                if (this.isStandAloneAppRequest()) {
                    this.stop();
                    this.destroy();
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getServerURL() throws RunformException {
        if (EMPTY_STRING.equals(this.mServerURL)) {
            this.mServerURL = this.extractServerURL();
        }
        return this.mServerURL;
    }

    protected String extractServerURL() throws RunformException {
        String string = this.getParameter(SERVER_URL_ARG);
        if ("?".equals(string)) {
            try {
                FormsJSUtils formsJSUtils = new FormsJSUtils();
                String string2 = this.getJavascriptExpressionForServerURL();
                string = formsJSUtils.eval(this, string2);
            }
            catch (FormsJSException formsJSException) {
                throw new RunformException(this.mEMG.getMessage("FRM-92180"), formsJSException.getCause());
            }
        }
        return EMPTY_STRING.equals(string) ? null : string;
    }

    protected String getJavascriptExpressionForServerURL() {
        return "document.getElementById('forms_plugin_info').getAttribute('serverURL')";
    }

    public boolean isHeartBeatBlockedByJavaScript() {
        return this.mJavaScriptBlocksHeartBeat;
    }

    public boolean isJavascriptEventEnabled() {
        return this.mEnableJavascriptEvent;
    }

    public boolean isDestroying() {
        return this.mDestroying;
    }

    public void raiseEvent() {
        this.raiseEvent(null, null);
    }

    public void raiseEvent(String string) {
        this.raiseEvent(string, null);
    }

    public void raiseEvent(final String string, final String string2) {
        if (this.isRunning() && this.isJavascriptEventEnabled() && (this.isWebSocketJSIBeanAvailable() || !this.isWebstartRequest() && !this.isStandAloneAppRequest())) {
            Runform runform = (Runform)this.mClientList.get(0);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Main.this.isRunning() && Main.this.isJavascriptEventEnabled()) {
                                Runform runform = (Runform)Main.this.mClientList.get(0);
                                if (runform.getFocusOwner() != null) {
                                    runform.getFocusOwner().getComponent().requestFocus();
                                }
                                if (runform != null) {
                                    Message message = Message.newMessage(runform, 546, Boolean.TRUE);
                                    if (string != null) {
                                        message.add(547, string);
                                    }
                                    if (string2 != null) {
                                        message.add(548, string2);
                                    }
                                    runform.onMessage(message, 0);
                                }
                            }
                        }
                    });
                    return null;
                }
            });
        } else if (this.isWebstartRequest()) {
            String string3 = this.mEMG.getMessage("FRM-92170");
            System.out.println(string3);
            this.showStatus(string3);
        } else if (this.isStandAloneAppRequest()) {
            String string4 = this.mEMG.getMessage("FRM-92130");
            System.out.println(string4);
            this.showStatus(string4);
        }
    }

    private int getMdiGuiMode() {
        return this.mGUIMode & 1;
    }

    public boolean isWindowModeTitleLess() {
        return (this.mGUIMode & 2) != 0;
    }

    private ColorScheme fetchCustomColorScheme(String string) {
        try {
            int n;
            Registry registry = this.getRegistry(this.getRegistryName());
            String string2 = string + ".description";
            String string3 = registry.getEntry(COLOR_SCHEME, string2);
            String string4 = string3 == null ? "Custom Color Scheme" : string3;
            String[] stringArray = new String[]{"lightest", "lighter", "light", "dark", "darker", "darkest", "selection", "pinstripe1", "pinstripe2"};
            int[] nArray = new int[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string + "." + stringArray[n];
                string3 = registry.getEntry(COLOR_SCHEME, string2);
                if (string3 == null) {
                    String string5 = this.mEMG.getMessage("FRM-92213", "colorScheme." + string2, this.getRegistryName());
                    System.out.println(string5);
                    return null;
                }
                nArray[n] = this.parseColorValue(string3.trim());
                if (nArray[n] != -1) continue;
                String string6 = this.mEMG.getMessage("FRM-92214", "colorScheme." + string2);
                System.out.println(string6);
                return null;
            }
            n = -1;
            string3 = registry.getEntry(COLOR_SCHEME, string + ".desktop");
            if (string3 != null && (n = this.parseColorValue(string3.trim())) == -1) {
                String string7 = this.mEMG.getMessage("FRM-92215", "colorScheme." + string + ".desktop");
                System.out.println(string7);
            }
            int n2 = -1;
            string3 = registry.getEntry(COLOR_SCHEME, string + ".smartBar");
            if (string3 != null && (n2 = this.parseColorValue(string3.trim())) == -1) {
                String string8 = this.mEMG.getMessage("FRM-92215", "colorScheme." + string + ".smartBar");
                System.out.println(string8);
            }
            if (n2 != -1) {
                this.mSmartBarColor = new Color(n2);
            }
            return OracleLookAndFeel.configureCustomColorScheme(string, string4, nArray, n);
        }
        catch (RunformException runformException) {
            String string9 = this.mEMG.getMessage("FRM-92212", this.getRegistryName());
            System.out.println(string9);
            return null;
        }
    }

    private int parseColorValue(String string) {
        if (string == null || string.equals(EMPTY_STRING)) {
            return -1;
        }
        if (string.startsWith("0x")) {
            int n = -1;
            try {
                n = Integer.parseInt(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n;
        }
        String[] stringArray = string.split(",");
        if (stringArray != null && stringArray.length == 3) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                if (n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255) {
                    return n * 256 * 256 + n2 * 256 + n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected Registry getRegistry(String string) throws RunformException {
        if (this.mRegistry != null && (string == null || this.getRegistryName().equals(string))) {
            return this.mRegistry;
        }
        URL uRL = null;
        String string2 = this.getParameter(APP_ARG);
        Registry registry = new Registry(string2);
        String string3 = null;
        try {
            if (string == null) {
                string = this.getRegistryName();
            }
            if (this.getCodeBase().getProtocol().startsWith("http")) {
                String string4 = this.getServerURL();
                if (string4 == null || string4.trim().length() == 0) {
                    uRL = new URL(this.getCodeBase().getProtocol(), this.getCodeBase().getHost(), this.getCodeBase().getPort(), "/forms/registry/" + string);
                } else {
                    int n = string4.indexOf("?");
                    if (n == -1) {
                        string3 = string4 + "?";
                    } else {
                        char c;
                        int n2;
                        string3 = string4.substring(0, n + 1);
                        int n3 = string4.indexOf("ifcfs=", n + 1);
                        if (n3 > 0 && (n2 = string4.indexOf("ifsessid=", n3)) >= 0 && ((c = string4.charAt(n2 - 1)) == '?' || c == '&')) {
                            string3 = string3 + string4.substring(n2) + "&";
                        }
                    }
                    string3 = string3 + "ifcmd=regFile=";
                    uRL = new URL(this.getCodeBase(), string3 + string);
                }
                registry.loadRegistry(uRL);
                if (string2 != null && !string2.equals(EMPTY_STRING)) {
                    String string5 = this.getParameter(REGISTRY_PATH_ARG);
                    if (string5 != null && !string5.equals(EMPTY_STRING)) {
                        if (!string5.endsWith("/")) {
                            string5 = string5 + "/";
                        }
                        uRL = new URL(this.getCodeBase().getProtocol(), this.getCodeBase().getHost(), this.getCodeBase().getPort(), string5 + string2 + ".dat");
                    } else {
                        uRL = new URL(this.getCodeBase(), string3 + string2 + ".dat");
                    }
                    try {
                        registry.loadRegistry(uRL);
                    }
                    catch (IOException iOException) {}
                }
            } else if (this.getCodeBase().getProtocol().equals("file")) {
                uRL = new URL(this.getCodeBase(), string);
                registry.loadRegistry(uRL);
            }
        }
        catch (RunformException runformException) {
            throw runformException;
        }
        catch (IOException iOException) {
            String string6 = this.mEMG.getMessage("FRM-92120", uRL.toExternalForm());
            throw new RunformException(string6, iOException);
        }
        if (this.getRegistryName().equals(string)) {
            this.mRegistry = registry;
        }
        return registry;
    }

    protected String getRegistryName() {
        return "oracle/forms/registry/Registry.dat";
    }

    public String getFSALCheckSum() {
        return this.mFSALCheckSum;
    }

    public Color getSmartBarColor() {
        return this.mSmartBarColor;
    }

    private String computeFSALCheckSum() {
        try {
            Class<?> clazz;
            int n;
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            String string = this.getClass().getName();
            for (n = 0; n < stackTraceElementArray.length && ((String)((Object)(clazz = stackTraceElementArray[n].getClassName()))).equals(string); ++n) {
            }
            if (n == stackTraceElementArray.length) {
                return null;
            }
            clazz = Class.forName(stackTraceElementArray[n].getClassName());
            URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (uRL == null) {
                return null;
            }
            String string2 = uRL.toURI().getPath();
            return CheckSumUtil.generateSecureCheckSumOfFile(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final boolean isWebSocketJSIBeanAvailable() {
        return this.mWebSocketJSIBeanAvailable;
    }

    public void setWebSocketJSIBeanAvailableFlag() {
        this.mWebSocketJSIBeanAvailable = true;
    }

    public final boolean getIsIdcsEnabled() {
        return this.mIsIdcsEnabled;
    }

    public void setIsIdcsEnabled(boolean bl) {
        this.mIsIdcsEnabled = bl;
    }

    public double getSmoothScalingMaxZoom() {
        return this.mSmoothScalingMaxZoom;
    }

    public boolean isImageScaleIsPercent() {
        return this.mImageScaleIsPercent;
    }

    public FormCanvas getHidingToolbar() {
        return this.mHidingToolbar;
    }

    public void setHidingToolbar(FormCanvas formCanvas) {
        this.mHidingToolbar = formCanvas;
    }

    public CertificateHandler getCertificateHandler() {
        if (this.mCertHandler == null) {
            try {
                this.mCertHandler = new CertificateHandler(null, null, Boolean.valueOf(this.getParameter("mEnableCertDownload")), Boolean.valueOf(this.getParameter("mDebugSSL")), false, false, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.mCertHandler;
    }

    private static class ShutdownHook
    extends Thread {
        private boolean mFinished = false;

        private ShutdownHook() {
        }

        @Override
        public synchronized void run() {
            long l = 30000L;
            long l2 = System.currentTimeMillis();
            while (!this.mFinished && l > 0L) {
                try {
                    this.wait(l);
                    this.mFinished = true;
                }
                catch (InterruptedException interruptedException) {
                    l -= l2 - System.currentTimeMillis();
                }
            }
        }

        synchronized void terminate() {
            this.mFinished = true;
            this.notify();
        }
    }
}

