/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.properties.FormAction;

public class KeyMapTable {
    private Hashtable mHashtable = null;
    private Runform mDispatcher = null;

    KeyMapTable(Runform runform) {
        this.mDispatcher = runform;
    }

    public synchronized FormAction getFormAction(KeyEvent keyEvent) {
        if (this.mHashtable == null || keyEvent == null) {
            return null;
        }
        int n = keyEvent.getKeyCode();
        Enumeration enumeration = this.mHashtable.keys();
        Enumeration enumeration2 = this.mHashtable.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            KeyEvent keyEvent2;
            FormAction formAction = (FormAction)enumeration.nextElement();
            Object v = enumeration2.nextElement();
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                for (int i = 0; i < vector.size(); ++i) {
                    keyEvent2 = (KeyEvent)vector.elementAt(i);
                    if (keyEvent2.getModifiersEx() != keyEvent.getModifiersEx() || keyEvent2.getKeyCode() != keyEvent.getKeyCode()) continue;
                    return formAction;
                }
                continue;
            }
            keyEvent2 = (KeyEvent)v;
            if (keyEvent2.getModifiersEx() != keyEvent.getModifiersEx() || keyEvent2.getKeyCode() != keyEvent.getKeyCode()) continue;
            return formAction;
        }
        return null;
    }

    public synchronized void doKeyBinding(Message message) {
        int n = message.size();
        if (n > 0 && this.mHashtable == null) {
            this.mHashtable = new Hashtable();
        }
        for (int i = 1; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            Object object = message.getValueAt(i);
            String[] stringArray = (String[])object;
            int n3 = Integer.valueOf(stringArray[0]);
            int n4 = Integer.valueOf(stringArray[1]);
            int n5 = Integer.valueOf(stringArray[2]);
            FormAction formAction = FormAction.getInstance(n5);
            if (formAction == null) {
                formAction = new FormAction(n5);
            }
            KeyEvent keyEvent = new KeyEvent(this.mDispatcher.getApplet(), 0, 0L, n4, n3, (char)n3);
            if (this.mHashtable.containsKey(formAction)) {
                Object v = this.mHashtable.get(formAction);
                if (v instanceof Vector) {
                    ((Vector)v).addElement(keyEvent);
                    this.mHashtable.put(formAction, v);
                    continue;
                }
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(keyEvent);
                this.mHashtable.put(formAction, vector);
                continue;
            }
            this.mHashtable.put(formAction, keyEvent);
        }
    }

    public void destroyKeyMapTable() {
        this.mDispatcher = null;
        if (this.mHashtable != null) {
            this.mHashtable.clear();
            this.mHashtable = null;
        }
    }
}

