/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Button;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.forms.engine.Message;
import oracle.forms.properties.FormAction;

public class KeyBinder {
    private static Hashtable sHashtable = null;
    private static Component sButton = new Button();

    private KeyBinder() {
    }

    public static synchronized void downloadKeyBindings() {
    }

    public static synchronized Hashtable getKeyBindings() {
        if (sHashtable == null) {
            return null;
        }
        return (Hashtable)sHashtable.clone();
    }

    public static synchronized boolean isKeyBindingsAvailable() {
        return sHashtable != null;
    }

    public static synchronized Vector getKeySequences(FormAction formAction) {
        if (sHashtable == null || formAction == null) {
            return null;
        }
        Object v = sHashtable.get(formAction);
        if (v == null) {
            return null;
        }
        if (!(v instanceof Vector)) {
            Vector vector = new Vector();
            vector.addElement(v);
            return vector;
        }
        return (Vector)v;
    }

    public static synchronized KeyEvent getKeySequence(FormAction formAction) {
        if (sHashtable == null || formAction == null) {
            return null;
        }
        Object v = sHashtable.get(formAction);
        if (v == null) {
            return null;
        }
        KeyEvent keyEvent = v instanceof Vector ? (KeyEvent)((Vector)v).elementAt(0) : (KeyEvent)v;
        KeyEvent keyEvent2 = new KeyEvent((Button)keyEvent.getSource(), 0, 0L, keyEvent.getModifiersEx(), keyEvent.getKeyCode(), (char)keyEvent.getKeyCode());
        return keyEvent2;
    }

    public static synchronized FormAction getFormAction(KeyEvent keyEvent) {
        if (sHashtable == null || keyEvent == null) {
            return null;
        }
        int n = keyEvent.getKeyCode();
        Enumeration enumeration = sHashtable.keys();
        Enumeration enumeration2 = sHashtable.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            KeyEvent keyEvent2;
            FormAction formAction = (FormAction)enumeration.nextElement();
            Object v = enumeration2.nextElement();
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                for (int i = 0; i < vector.size(); ++i) {
                    keyEvent2 = (KeyEvent)vector.elementAt(i);
                    if (keyEvent2.getModifiersEx() != keyEvent.getModifiersEx() || keyEvent2.getKeyCode() != keyEvent.getKeyCode()) continue;
                    return formAction;
                }
                continue;
            }
            keyEvent2 = (KeyEvent)v;
            if (keyEvent2.getModifiersEx() != keyEvent.getModifiersEx() || keyEvent2.getKeyCode() != keyEvent.getKeyCode()) continue;
            return formAction;
        }
        return null;
    }

    static synchronized void doKeyBinding(Message message) {
        int n = message.size();
        if (n > 0 && sHashtable == null) {
            sHashtable = new Hashtable();
        }
        for (int i = 1; i < n; ++i) {
            int n2 = message.getPropertyAt(i);
            Object object = message.getValueAt(i);
            String[] stringArray = (String[])object;
            int n3 = Integer.valueOf(stringArray[0]);
            int n4 = Integer.valueOf(stringArray[1]);
            int n5 = Integer.valueOf(stringArray[2]);
            FormAction formAction = FormAction.getInstance(n5);
            if (formAction == null) {
                formAction = new FormAction(n5);
            }
            KeyEvent keyEvent = new KeyEvent(sButton, 0, 0L, n4, n3, (char)n3);
            if (sHashtable.containsKey(formAction)) {
                Object v = sHashtable.get(formAction);
                if (v instanceof Vector && !((Vector)v).contains(keyEvent)) {
                    ((Vector)v).addElement(keyEvent);
                    sHashtable.put(formAction, v);
                    continue;
                }
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(keyEvent);
                sHashtable.put(formAction, vector);
                continue;
            }
            sHashtable.put(formAction, keyEvent);
        }
    }

    static KeyBinder getKeyBinder() {
        return new KeyBinder();
    }
}

