/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import oracle.forms.engine.FDataInputStream;
import oracle.forms.engine.FDataOutputStream;

public class FormsMessage {
    private static final int DFLT_PROPS = 8;
    private byte mMsgType;
    private int mHandlerClassId;
    private int mHandlerId;
    private String mObjectName;
    private String[] mPropName = new String[8];
    private byte[] mPropType = new byte[8];
    private Object[] mPropVal = new Object[8];
    private int mPropCount = 0;
    private int mResponseCode;
    public static final byte MSG_TYPE_CREATE = 1;
    public static final byte MSG_TYPE_UPDATE = 2;
    public static final byte MSG_TYPE_DESTROY = 3;
    public static final byte MSG_TYPE_GET = 4;
    public static final byte MSG_TYPE_CLIENT_GET = 5;
    public static final byte MSG_TYPE_CLIENT_SET = 6;
    public static final byte MSG_TYPE_TERMINAL = 7;
    public static final byte MSG_TYPE_LOOP_START = 8;
    public static final byte MSG_TYPE_LOOP_END = 9;
    public static final byte MSG_TYPE_UNKNOWN = 10;
    public static final byte PROP_TYPE_UNKNOWN = 0;
    public static final byte PROP_TYPE_STRING = 1;
    public static final byte PROP_TYPE_STRING_ARRAY = 2;
    public static final byte PROP_TYPE_INTEGER = 3;
    public static final byte PROP_TYPE_BYTE = 4;
    public static final byte PROP_TYPE_BYTE_ARRAY = 5;
    public static final byte PROP_TYPE_BOOLEAN = 6;
    public static final byte PROP_TYPE_POINT = 7;
    public static final byte PROP_TYPE_RECTANGLE = 8;
    public static final byte PROP_TYPE_VOID = 9;
    public static final byte PROP_TYPE_SUB_MESSAGE = 10;
    public static final byte PROP_TYPE_CHARACTER = 11;
    public static final byte PROP_TYPE_PARAMETERIZE = 12;
    public static final byte PROP_TYPE_TERMINAL = -1;

    public void addProperty(String string, byte by, Object object) {
        int n;
        if (this.mPropCount == this.mPropName.length) {
            n = this.mPropName.length * 2;
            String[] stringArray = new String[n];
            System.arraycopy(this.mPropName, 0, stringArray, 0, this.mPropCount);
            this.mPropName = stringArray;
            byte[] byArray = new byte[n];
            System.arraycopy(this.mPropType, 0, byArray, 0, this.mPropCount);
            this.mPropType = byArray;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.mPropVal, 0, objectArray, 0, this.mPropCount);
            this.mPropVal = objectArray;
        }
        n = this.mPropCount++;
        this.mPropName[n] = string;
        this.mPropType[n] = by;
        this.mPropVal[n] = object;
    }

    public FormsMessage(byte by, int n, int n2) {
        this.mMsgType = by;
        this.mHandlerId = n;
        this.mHandlerClassId = n2;
    }

    public FormsMessage(int n) {
        this.mResponseCode = n;
        this.mMsgType = (byte)7;
    }

    public byte getMessageType() {
        return this.mMsgType;
    }

    public int getHandlerClassId() {
        return this.mHandlerClassId;
    }

    public int getHandlerId() {
        return this.mHandlerId;
    }

    public void setHandlerId(int n) {
        this.mHandlerId = n;
    }

    public void setObjectName(String string) {
        this.mObjectName = string;
    }

    public String getObjectName() {
        return this.mObjectName;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public int size() {
        return this.mPropCount;
    }

    public String getPropertyAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.mPropCount);
        }
        return this.mPropName[n];
    }

    public Object getValueAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.mPropCount);
        }
        return this.mPropVal[n];
    }

    public byte getTypeAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.mPropCount) {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.mPropCount);
        }
        return this.mPropType[n];
    }

    public static FormsMessage read(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            return null;
        }
        FormsMessage formsMessage = null;
        byte by = dataInputStream.readByte();
        if (by == 7) {
            int n = dataInputStream.readInt();
            formsMessage = new FormsMessage(n);
        } else {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            String string = FDataInputStream.readUTF(dataInputStream);
            formsMessage = new FormsMessage(by, n2, n);
            formsMessage.setObjectName(string);
            int n3 = dataInputStream.readInt();
            for (int i = 0; i < n3; ++i) {
                String string2 = FDataInputStream.readUTF(dataInputStream);
                byte by2 = dataInputStream.readByte();
                Object object = null;
                switch (by2) {
                    case 12: {
                        object = FDataInputStream.readUTF(dataInputStream);
                        break;
                    }
                    case 1: {
                        object = FDataInputStream.readUTF(dataInputStream);
                        break;
                    }
                    case 2: {
                        int n4;
                        int n5 = dataInputStream.readInt();
                        String[] stringArray = new String[n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            stringArray[n4] = FDataInputStream.readUTF(dataInputStream);
                        }
                        object = stringArray;
                        break;
                    }
                    case 3: {
                        object = dataInputStream.readInt();
                        break;
                    }
                    case 4: {
                        object = dataInputStream.readByte();
                        break;
                    }
                    case 5: {
                        int n4 = dataInputStream.readInt();
                        byte[] byArray = new byte[n4];
                        dataInputStream.readFully(byArray, 0, n4);
                        object = byArray;
                        break;
                    }
                    case 6: {
                        object = dataInputStream.readBoolean();
                        break;
                    }
                    case 7: {
                        Point point = new Point();
                        point.x = dataInputStream.readInt();
                        point.y = dataInputStream.readInt();
                        object = point;
                        break;
                    }
                    case 8: {
                        Rectangle rectangle = new Rectangle();
                        rectangle.height = dataInputStream.readInt();
                        rectangle.width = dataInputStream.readInt();
                        rectangle.x = dataInputStream.readInt();
                        rectangle.y = dataInputStream.readInt();
                        object = rectangle;
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        FormsMessage formsMessage2 = FormsMessage.read(dataInputStream);
                        object = formsMessage2;
                        break;
                    }
                    case 11: {
                        object = Character.valueOf(dataInputStream.readChar());
                        break;
                    }
                }
                formsMessage.addProperty(string2, by2, object);
            }
        }
        return formsMessage;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        if (dataOutputStream == null) {
            return;
        }
        dataOutputStream.writeByte(this.mMsgType);
        if (this.mMsgType == 7) {
            dataOutputStream.writeInt(this.mResponseCode);
        } else {
            dataOutputStream.writeInt(this.mHandlerClassId);
            dataOutputStream.writeInt(this.mHandlerId);
            if (this.mObjectName == null) {
                this.mObjectName = " ";
            }
            FDataOutputStream.writeUTF(this.mObjectName, dataOutputStream, false);
            dataOutputStream.writeInt(this.mPropCount);
            block13: for (int i = 0; i < this.mPropCount; ++i) {
                FDataOutputStream.writeUTF(this.getPropertyAt(i), dataOutputStream, false);
                dataOutputStream.writeByte(this.getTypeAt(i));
                Object object = this.getValueAt(i);
                switch (this.getTypeAt(i)) {
                    case 1: 
                    case 12: {
                        FDataOutputStream.writeUTF((String)object, dataOutputStream, false);
                        continue block13;
                    }
                    case 2: {
                        int n;
                        String[] stringArray = (String[])object;
                        int n2 = stringArray.length;
                        dataOutputStream.writeInt(n2);
                        for (n = 0; n < n2; ++n) {
                            FDataOutputStream.writeUTF(stringArray[n], dataOutputStream, false);
                        }
                        continue block13;
                    }
                    case 3: {
                        int n = (Integer)object;
                        dataOutputStream.writeInt(n);
                        continue block13;
                    }
                    case 4: {
                        byte by = (Byte)object;
                        dataOutputStream.writeByte(by);
                        continue block13;
                    }
                    case 5: {
                        byte[] byArray = (byte[])object;
                        int n = byArray.length;
                        dataOutputStream.writeInt(n);
                        dataOutputStream.write(byArray, 0, n);
                        continue block13;
                    }
                    case 6: {
                        boolean bl = (Boolean)object;
                        dataOutputStream.writeBoolean(bl);
                        continue block13;
                    }
                    case 7: {
                        Point point = (Point)object;
                        dataOutputStream.writeInt(point.x);
                        dataOutputStream.writeInt(point.y);
                        continue block13;
                    }
                    case 8: {
                        Rectangle rectangle = (Rectangle)object;
                        dataOutputStream.writeInt(rectangle.height);
                        dataOutputStream.writeInt(rectangle.width);
                        dataOutputStream.writeInt(rectangle.x);
                        dataOutputStream.writeInt(rectangle.y);
                        continue block13;
                    }
                    case 9: {
                        continue block13;
                    }
                    case 10: {
                        FormsMessage formsMessage = (FormsMessage)object;
                        formsMessage.write(dataOutputStream);
                        continue block13;
                    }
                    case 11: {
                        int n = Character.getNumericValue(((Character)object).charValue());
                        dataOutputStream.writeChar(n);
                        continue block13;
                    }
                }
            }
        }
    }

    public void writeAsXml(DataOutputStream dataOutputStream) throws IOException {
        String string = null;
        if (dataOutputStream == null) {
            return;
        }
        PrintStream printStream = new PrintStream(dataOutputStream);
        printStream.println("<mesg type=\"" + this.mMsgType + "\" handlerClassId=\"" + this.mHandlerClassId + "\" handlerId=\"" + this.mHandlerId + "\" objectName=\"" + this.mObjectName + "\"/>");
        printStream.println("<property>");
        block13: for (int i = 0; i < this.mPropCount; ++i) {
            printStream.print("<prop name=\"" + this.getPropertyAt(i) + "\" datatype=\"");
            Object object = this.getValueAt(i);
            if (object != null) {
                string = object.getClass().getName();
            }
            switch (this.getTypeAt(i)) {
                case 1: {
                    printStream.println(string + "\" value=\"" + (String)object + "\" />");
                    continue block13;
                }
                case 2: {
                    String[] stringArray = (String[])object;
                    int n = stringArray.length;
                    printStream.print(string + "\" length=\"" + n + "\" value=\"");
                    for (int j = 0; j < n; ++j) {
                        printStream.print(stringArray[j] + " ");
                    }
                    printStream.println("\" />");
                    continue block13;
                }
                case 3: {
                    printStream.println(string + "\" value=\"" + (Integer)object + "\" />");
                    continue block13;
                }
                case 4: {
                    printStream.println(string + "\" value=\"" + (Byte)object + "\" />");
                    continue block13;
                }
                case 5: {
                    byte[] byArray = (byte[])object;
                    int n = byArray.length;
                    printStream.print(string + "\" length=\"" + n + "\" value=\"");
                    for (int j = 0; j < n; ++j) {
                        printStream.print(byArray[j] + " ");
                    }
                    printStream.println("\" />");
                    continue block13;
                }
                case 6: {
                    printStream.println(string + "\" value=\"" + (Boolean)object + "\" />");
                    continue block13;
                }
                case 7: {
                    printStream.println(string + "\" value=\"" + (Point)object + "\" />");
                    continue block13;
                }
                case 8: {
                    printStream.println(string + "\" value=\"" + (Rectangle)object + "\" />");
                    continue block13;
                }
                case 9: {
                    printStream.println("java.lang.Void\" value=\" \" />");
                    continue block13;
                }
                case 10: {
                    printStream.println(string + "\" value=\"\"");
                    FormsMessage formsMessage = (FormsMessage)object;
                    formsMessage.writeAsXml(dataOutputStream);
                    continue block13;
                }
                case 11: {
                    printStream.println(string + "\" value=\"" + Character.getNumericValue(((Character)object).charValue()) + "\" />");
                    continue block13;
                }
            }
        }
        printStream.println("</property>");
    }

    public static FormsMessage readFromXml(DataInputStream dataInputStream) throws IOException {
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        String string3 = "file";
        String string4 = null;
        Boolean bl = false;
        if (dataInputStream == null) {
            return null;
        }
        try {
            while (true) {
                String string5;
                if ((string5 = dataInputStream.readLine()) == null) {
                    return null;
                }
                if ((string5 = string5.trim()).equals("") || string5.startsWith("<message>") || string5.startsWith("<messageblock") || string5.startsWith("</messageblock>")) continue;
                if (string5.startsWith("<terminal")) {
                    stringTokenizer = new StringTokenizer(string5, " <>=\"/");
                    FormsMessage formsMessage = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        if (!string.equals("response")) continue;
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        formsMessage = new FormsMessage(n);
                    }
                    return formsMessage;
                }
                if (string5.startsWith("<mesg")) {
                    return FormsMessage.parseMessage(string5, dataInputStream);
                }
                if (string5.startsWith("<loop")) {
                    stringTokenizer = new StringTokenizer(string5, " =<>\"");
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        if (string.equalsIgnoreCase("source")) {
                            string3 = stringTokenizer.nextToken();
                        }
                        if (string.equalsIgnoreCase("classname")) {
                            string4 = stringTokenizer.nextToken();
                        }
                        if (string.equalsIgnoreCase("paramfile")) {
                            string2 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (!string.equalsIgnoreCase("trim")) continue;
                        bl = Boolean.valueOf(stringTokenizer.nextToken());
                    }
                    if (!string3.equalsIgnoreCase("class") && !string3.equalsIgnoreCase("file")) {
                        throw new IllegalArgumentException("source=" + string3 + " is invalid it can only be class/file");
                    }
                    if (string3.equalsIgnoreCase("file") && string2 == null) {
                        throw new IllegalArgumentException("when source=file paramfile cannot be null");
                    }
                    if (string3.equalsIgnoreCase("class") && string4 == null) {
                        throw new IllegalArgumentException("when source=file classname cannot be null");
                    }
                    FormsMessage formsMessage = new FormsMessage(8, 0, 0);
                    formsMessage.addProperty("SOURCE", (byte)1, string3);
                    if (string4 != null) {
                        formsMessage.addProperty("CLASSNAME", (byte)1, string4);
                    }
                    if (string2 != null) {
                        formsMessage.addProperty("FILENAME", (byte)1, string2);
                    }
                    formsMessage.addProperty("TRIM", (byte)6, bl);
                    return formsMessage;
                }
                if (string5.startsWith("</loop>")) break;
            }
            FormsMessage formsMessage = new FormsMessage(9, 0, 0);
            return formsMessage;
        }
        catch (IOException iOException) {
            System.out.println("End of Input file");
            return null;
        }
    }

    private static FormsMessage parseMessage(String string, DataInputStream dataInputStream) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = null;
        FormsMessage formsMessage = null;
        String string4 = null;
        String string5 = null;
        Object object = null;
        boolean bl2 = false;
        String string6 = null;
        formsMessage = FormsMessage.getMessageHeaders(string);
        try {
            while (true) {
                String string7;
                if ((string7 = dataInputStream.readLine()) == null || (string2 = string7.trim()).equals("")) {
                    continue;
                }
                if (string2.equals("<property>")) {
                    bl = true;
                    continue;
                }
                if (string2.equals("</property>")) {
                    bl = false;
                    break;
                }
                if (bl && string2.startsWith("<parameter")) {
                    stringTokenizer = new StringTokenizer(string2, " =<>\"");
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (!string3.equalsIgnoreCase("paramName")) continue;
                        string6 = stringTokenizer.nextToken();
                    }
                    bl2 = true;
                }
                if (bl && string2.startsWith("</parameter")) {
                    bl2 = false;
                }
                if (!bl || !string2.startsWith("<prop")) continue;
                int n3 = string2.lastIndexOf("value=");
                string3 = string2.substring(0, n3);
                stringTokenizer = new StringTokenizer(string3, " =<\"");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("prop")) continue;
                    if (string3.equals("name")) {
                        string4 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string3.equals("datatype")) {
                        string5 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (!string3.equals("length")) continue;
                    n = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (bl2) {
                    if (!string4.equalsIgnoreCase("VALUE")) {
                        System.out.println("Cannot parameterize the property");
                        bl2 = false;
                    } else {
                        string4 = string6;
                    }
                }
                if ((string3 = string2.substring(n3, string2.length())).startsWith("value")) {
                    int n4 = string3.indexOf("=") + 2;
                    int n5 = string3.lastIndexOf("\"");
                    String string8 = string3.substring(n4, n5);
                    if (string5.endsWith("engine.Message")) {
                        n2 = 10;
                        String string9 = dataInputStream.readLine();
                        object = FormsMessage.parseMessage(string9, dataInputStream);
                    } else if (string5.endsWith("String[]")) {
                        n2 = 2;
                        String[] stringArray = new String[n];
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string8, " ");
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = stringTokenizer2.nextToken();
                        }
                        object = stringArray;
                    } else if (string5.equals("java.lang.Integer")) {
                        int n6 = Integer.parseInt(string8);
                        object = n6;
                        n2 = 3;
                    } else if (string5.equals("java.lang.String")) {
                        n2 = bl2 ? 12 : 1;
                        object = string8;
                    } else if (string5.equals("java.lang.Byte")) {
                        n2 = 4;
                        byte by = Byte.parseByte(string8);
                        object = by;
                    } else if (string5.endsWith("byte[]")) {
                        byte[] byArray = new byte[n];
                        StringTokenizer stringTokenizer3 = new StringTokenizer(string8, " ");
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = Byte.parseByte(stringTokenizer3.nextToken(), 16);
                        }
                        if (stringTokenizer3.hasMoreTokens()) {
                            System.out.println("Incorrect length for byte array:");
                            System.out.println(string8);
                            System.exit(1);
                        }
                        object = byArray;
                        n2 = 5;
                    } else if (string5.equals("java.lang.Boolean")) {
                        object = Boolean.valueOf(string8);
                        n2 = 6;
                    } else if (string5.equals("java.lang.Void")) {
                        object = null;
                        n2 = 9;
                    } else if (string5.equals("java.awt.Point")) {
                        int n7 = 0;
                        int n8 = 0;
                        StringTokenizer stringTokenizer4 = new StringTokenizer(string8, "[=,]");
                        while (stringTokenizer4.hasMoreTokens()) {
                            string8 = stringTokenizer4.nextToken();
                            if (string8.equals("x")) {
                                n7 = Integer.parseInt(stringTokenizer4.nextToken());
                            }
                            if (!string8.equals("y")) continue;
                            n8 = Integer.parseInt(stringTokenizer4.nextToken());
                        }
                        Point point = new Point(n7, n8);
                        n2 = 7;
                        object = point;
                    } else if (string5.equals("java.awt.Rectangle")) {
                        int n9 = 0;
                        int n10 = 0;
                        int n11 = 0;
                        int n12 = 0;
                        StringTokenizer stringTokenizer5 = new StringTokenizer(string8, "[=]");
                        while (stringTokenizer5.hasMoreTokens()) {
                            string8 = stringTokenizer5.nextToken();
                            if (string8.equals("x")) {
                                n9 = Integer.parseInt(stringTokenizer5.nextToken());
                            }
                            if (string8.equals("y")) {
                                n10 = Integer.parseInt(stringTokenizer5.nextToken());
                            }
                            if (string8.equals("height")) {
                                n12 = Integer.parseInt(stringTokenizer5.nextToken());
                            }
                            if (!string8.equals("width")) continue;
                            n11 = Integer.parseInt(stringTokenizer5.nextToken());
                        }
                        Rectangle rectangle = new Rectangle(n9, n10, n12, n11);
                        object = rectangle;
                        n2 = 8;
                    } else if (string5.equals("java.lang.Character")) {
                        Character c = Character.valueOf(string8.charAt(0));
                        object = c;
                        n2 = 11;
                    }
                } else {
                    System.out.println("Parse error with line:");
                    object = null;
                }
                formsMessage.addProperty(string4, (byte)n2, object);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("EOF in parseMessage: Error in input file");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return formsMessage;
    }

    private static FormsMessage getMessageHeaders(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>=\"/");
        byte by = 0;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("mesg type")) {
                by = Byte.parseByte(stringTokenizer.nextToken());
                continue;
            }
            if (string3.equals(" handlerClassId")) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            if (string3.equals(" handlerId")) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                continue;
            }
            if (!string3.equals(" objectName")) continue;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            string2 = " ";
        }
        FormsMessage formsMessage = new FormsMessage(by, n2, n);
        formsMessage.setObjectName(string2);
        return formsMessage;
    }
}

