/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.applet.Applet;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import oracle.forms.common.ssl.CertificateHandler;
import oracle.forms.engine.Main;
import oracle.forms.engine.Registry;

public final class FormsImageLoader {
    private Vector mDefaultImages;
    private URL mImageBase;
    private String mImagePath = "";
    private String mImageExtension = "";
    private boolean mIconNewStyle = true;
    private Applet mApplet;
    private boolean mJarFileUsed = false;
    private String[] mImages = new String[]{"badimage", "canqry", "copy", "cut", "delrec", "ellipsis", "entqry", "exeqry", "exit", "frame", "help", "insrec", "lockrec", "nxtblk", "nxtrec", "paste", "print", "prvblk", "prvrec", "pset", "save", "splash", "bgnd", "oracle_logo", "oracle_logo_light", "unlock", "stop", "note", "caution"};
    private static FormsImageLoader sInstance = new FormsImageLoader();

    private FormsImageLoader() {
    }

    public static FormsImageLoader sharedInstance() {
        return sInstance;
    }

    public Applet getApplet() {
        return this.mApplet;
    }

    public void setApplet(Applet applet) {
        this.mApplet = applet;
        if (applet != null) {
            String string = this.mApplet.getParameter("imageBase");
            if (string != null && string.equalsIgnoreCase("codebase")) {
                this.mImageBase = this.mApplet.getCodeBase();
                this.mJarFileUsed = true;
            } else {
                this.mImageBase = this.mApplet.getDocumentBase();
            }
        }
    }

    public void setRegistry(Registry registry) {
        if (registry != null) {
            this.mImagePath = registry.getEntry("icons", "iconpath");
            String string = registry.getEntry("icons", "style");
            boolean bl = this.mIconNewStyle = string == null || !string.trim().toLowerCase().equals("legacy");
            if (this.mImagePath != null && !this.mImagePath.equals("") && !this.mImagePath.endsWith("/")) {
                this.mImagePath = this.mImagePath + "/";
            }
            this.mImageExtension = registry.getEntry("icons", "iconextension");
            if (this.mImageExtension == null || this.mImageExtension.equals("")) {
                this.mImageExtension = ".gif";
            } else if (!this.mImageExtension.startsWith(".")) {
                this.mImageExtension = "." + this.mImageExtension;
            }
        }
    }

    public Image getCustomImage(String string) {
        Image image;
        if (this.mApplet == null) {
            return null;
        }
        String string2 = this.mApplet.getParameter("imageBase");
        if (!(string.trim().toLowerCase().startsWith("http://") || string.trim().toLowerCase().startsWith("https://") || string.trim().toLowerCase().startsWith("ftp://"))) {
            String string3 = string.trim().toLowerCase().endsWith(".gif") || string.trim().toLowerCase().endsWith(".jpg") || string.trim().toLowerCase().endsWith(".jpeg") || string.trim().toLowerCase().endsWith(".png") ? this.mImagePath + string : this.mImagePath + string + this.mImageExtension;
            if (string2 != null && !string2.equalsIgnoreCase("codebase")) {
                this.mJarFileUsed = false;
            }
            image = this.loadFormsImage(this.mImageBase, string3);
        } else {
            image = this.loadFormsImage(string);
        }
        return image;
    }

    private Image loadFormsImage(String string) {
        Image image;
        Object object;
        boolean bl = false;
        CertificateHandler certificateHandler = null;
        if (this.mApplet == null) {
            return null;
        }
        if (string.trim().toLowerCase().startsWith("https://") && ((Main)this.mApplet).isStandAloneAppRequest() && !Boolean.valueOf(this.mApplet.getParameter("useJavaDefaultTrustStore")).booleanValue()) {
            bl = true;
            certificateHandler = ((Main)this.mApplet).getCertificateHandler();
            object = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    if (FormsImageLoader.this.mApplet.getParameter("verifiedHost") != null && FormsImageLoader.this.mApplet.getParameter("verifiedHost").equals(string)) {
                        return true;
                    }
                    int n = Integer.parseInt(FormsImageLoader.this.mApplet.getParameter("skipCertNameDialog"));
                    if (n != 1) {
                        System.out.println(((Main)FormsImageLoader.this.mApplet).getErrorMessageGenerator().getMessage("FRM-92577", string));
                        return false;
                    }
                    System.out.println("");
                    System.out.println(((Main)FormsImageLoader.this.mApplet).getErrorMessageGenerator().getMessage("FRM-92575", string));
                    System.out.println("");
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)object);
        }
        try {
            object = new URL(string);
            int n = Integer.parseInt(this.mApplet.getParameter("mShowDetails"));
            if (bl && (certificateHandler == null || !certificateHandler.checkCerts((URL)object, false, n == 1))) {
                return null;
            }
            image = this.mApplet.getImage((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            image = null;
        }
        return image;
    }

    public Image getDefaultImage(String string) {
        String string2;
        URL uRL;
        if (this.mApplet == null) {
            return null;
        }
        if (string.contains("SwitchStrip")) {
            uRL = this.mApplet.getCodeBase();
            string2 = string;
        } else if (this.isDefaultImage(string)) {
            uRL = this.mApplet.getCodeBase();
            string2 = this.mIconNewStyle ? "oracle/forms/icons/" + string + ".png" : "oracle/forms/icons/" + string + ".gif";
        } else {
            string2 = string.trim().toLowerCase().endsWith(".gif") || string.trim().toLowerCase().endsWith(".jpg") || string.trim().toLowerCase().endsWith(".jpeg") || string.trim().toLowerCase().endsWith(".png") ? this.mImagePath + string : this.mImagePath + string + this.mImageExtension;
            uRL = this.mImageBase;
        }
        this.mJarFileUsed = true;
        return this.loadFormsImage(uRL, string2);
    }

    private Image loadFormsImage(URL uRL, String string) {
        Image image;
        if (this.mApplet == null) {
            return null;
        }
        URL uRL2 = null;
        String string2 = ((Main)this.mApplet).getJDKVersion();
        try {
            if (string2.startsWith("1.1")) {
                uRL2 = new URL(uRL, string);
            } else {
                if (string != null && this.mJarFileUsed) {
                    uRL2 = FormsImageLoader.class.getResource("/" + string);
                }
                if (uRL2 == null) {
                    uRL2 = new URL(uRL, string);
                }
            }
            image = this.mApplet.getImage(uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            image = null;
        }
        return image;
    }

    private boolean isDefaultImage(String string) {
        if (this.mDefaultImages == null) {
            this.mDefaultImages = new Vector(this.mImages.length);
            for (int i = 0; i < this.mImages.length; ++i) {
                this.mDefaultImages.addElement(this.mImages[i]);
            }
        }
        return this.mDefaultImages.contains(string);
    }
}

