/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import oracle.forms.engine.DefaultDispatcherEnvironment;
import oracle.forms.engine.DispatcherEnvironment;
import oracle.forms.engine.FormsDispatcherInterface;
import oracle.forms.engine.FormsMessage;
import oracle.forms.engine.FormsMessageListener;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.Connection;
import oracle.forms.net.ConnectionException;
import oracle.forms.net.FURLConnection;
import oracle.forms.net.HTTPConnection;
import oracle.forms.net.MessageQueue;
import oracle.forms.net.SocketConnection;
import oracle.forms.registry.MessageGenerator;

public class FormsDispatcher
implements FormsDispatcherInterface {
    protected int mConnectionType = 2;
    protected String mServerHost = null;
    protected int mServerPort = 0;
    protected boolean mSrvDetails = true;
    protected String mServerURL = null;
    protected String mPageURL = null;
    private Connection mServerConnection;
    private boolean mDispatcherRunning = false;
    private boolean mIsReaderActive = true;
    private DispatcherEnvironment mEnvironment;
    private MessageGenerator mEMG;
    private FormsMessageListener mMessageListener;
    private Object mBlock = new Object();
    private static final String ISERVER_CMD = "frmservlet/iserver";

    public void addMessageListener(Object object) {
        this.mServerConnection.addMessageListener(object);
    }

    public void addTerminalListener(Object object) {
        this.mServerConnection.addTerminalListener(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(FormsMessage formsMessage) throws Exception {
        if (formsMessage == null || formsMessage.getMessageType() == 10) {
            return;
        }
        if (formsMessage.getMessageType() == 7) {
            TerminalMessage terminalMessage = TerminalMessage.convertToTerminal(formsMessage);
            this.mServerConnection.putTerminal(terminalMessage);
            Object object = this.mBlock;
            synchronized (object) {
                this.mBlock.wait();
            }
        } else {
            Message message = Message.convertToMessage(formsMessage);
            this.mServerConnection.putMessage(message);
        }
        if (this.mMessageListener != null) {
            this.mMessageListener.toServer(formsMessage);
        }
    }

    public final URL getCodeBase() {
        return this.mEnvironment.getCodeBase();
    }

    public final Connection getConnection() {
        return this.mServerConnection;
    }

    public final MessageHandler getHandler(int n) {
        return this.mEnvironment.getHandler(n);
    }

    public MessageQueue getInputMessageQueue() {
        return this.mServerConnection.getInputMessageQueue();
    }

    public final Locale getLocale() {
        return this.mEnvironment.getLocale();
    }

    public MessageQueue getOutputMessageQueue() {
        return this.mServerConnection.getOutputMessageQueue();
    }

    public final String getParameter(String string) {
        return this.mEnvironment.getParameter(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(int n, String string, int n2, String string2, String string3, FormsMessageListener formsMessageListener, DispatcherEnvironment dispatcherEnvironment, boolean bl) throws ConnectionException, IOException, Exception {
        Main main2;
        this.mConnectionType = n;
        this.mServerHost = string;
        this.mServerPort = n2;
        this.mServerURL = string2;
        this.mPageURL = string3;
        this.mMessageListener = formsMessageListener;
        this.mSrvDetails = bl;
        this.mEnvironment = dispatcherEnvironment;
        if (this.mEnvironment == null) {
            this.mEnvironment = new DefaultDispatcherEnvironment();
        }
        this.mEMG = (main2 = this.mEnvironment.getApplet()) == null ? new MessageGenerator("oracle.forms.engine.ErrorMessageBundle"){

            @Override
            protected Locale getLocale() {
                return FormsDispatcher.this.mEnvironment.getLocale();
            }

            @Override
            protected boolean showMessageKey(String string) {
                return !Main.isInfoMessage(string);
            }
        } : main2.getErrorMessageGenerator();
        if (string2 != null && string2.indexOf(ISERVER_CMD) > 0) {
            URL uRL = new URL(string2);
            FURLConnection fURLConnection = FURLConnection.create(uRL);
            fURLConnection.setAllowUserInteraction(true);
            fURLConnection.setUseCaches(false);
            InputStream inputStream = fURLConnection.getInputStream();
            int n3 = fURLConnection.getContentLength();
            byte[] byArray = new byte[n3];
            int n4 = n3;
            int n5 = 0;
            int n6 = 0;
            try {
                n6 = inputStream.read(byArray, n5, n4);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            String string4 = new String(byArray);
            this.mServerURL = "http://" + uRL.getHost() + ":" + uRL.getPort() + string4;
        }
        this.initConnection();
    }

    public boolean isReaderActive() {
        return this.mIsReaderActive;
    }

    public void setReaderActive(boolean bl) {
        this.mIsReaderActive = bl;
    }

    @Override
    public void shutdown() throws Exception {
        if (this.mServerConnection != null) {
            this.mServerConnection.disconnect();
        }
    }

    public void messageDelivered(Message message) {
        if (this.mMessageListener != null && message != null) {
            this.mMessageListener.fromServer(message.convertToFormsMessage());
        }
    }

    public void putMessage(Message message) throws Exception {
        this.mServerConnection.putMessage(message);
        if (this.mMessageListener != null) {
            this.mMessageListener.toServer(message.convertToFormsMessage());
        }
    }

    public void putTerminal(TerminalMessage terminalMessage) throws Exception {
        if (this.mMessageListener != null) {
            this.mMessageListener.toServer(terminalMessage.convertToFormsMessage());
        }
        this.mServerConnection.putTerminal(terminalMessage);
    }

    public void removeMessageListener(Object object) {
        this.mServerConnection.removeMessageListener(object);
    }

    public void removeTerminalListener(Object object) {
        this.mServerConnection.removeTerminalListener(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminalDelivered(TerminalMessage terminalMessage) {
        if (this.mMessageListener != null && terminalMessage != null) {
            this.mMessageListener.fromServer(terminalMessage.convertToFormsMessage());
        }
        Object object = this.mBlock;
        synchronized (object) {
            this.mBlock.notify();
        }
    }

    public final DispatcherEnvironment getDispatcherEnvironment() {
        return this.mEnvironment;
    }

    public final MessageGenerator getErrorMessageGenerator() {
        return this.mEMG;
    }

    private void initConnection() throws ConnectionException, IOException, Exception {
        switch (this.mConnectionType) {
            case 1: {
                this.mServerConnection = new SocketConnection(this, this.mServerHost, this.mServerPort, this.mSrvDetails);
                break;
            }
            case 2: {
                this.mServerConnection = new HTTPConnection(this, this.mServerHost, this.mServerPort, this.mServerURL, this.mConnectionType, this.mSrvDetails);
                break;
            }
            default: {
                throw new IllegalArgumentException("init() was passed invalid connectMode");
            }
        }
        this.mServerConnection.connect(this);
    }
}

