/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Font;
import oracle.forms.engine.FontTable;
import oracle.forms.engine.Runform;

class FontEntry {
    public final String mName;
    public final int mSize;
    public final byte mStyle;
    public final byte mWeight;
    public final byte mWidth;
    public final int mCharset;
    private Font mFont;
    private Runform mRunform;
    public static Boolean sMapFonts = null;
    public static FontTable sFontTable = null;
    public static int[] sDialog = null;
    public static int[] sDialogInput = null;
    public static int[] sMonoSpaced = null;
    public static int[] sSansSerif = null;
    public static int[] sSerif = null;
    private static final boolean mIsWindows;

    public FontEntry(String string, int n, byte by, byte by2, byte by3, int n2, Runform runform) {
        this.mName = string;
        this.mSize = n;
        this.mStyle = by;
        this.mWeight = by2;
        this.mWidth = by3;
        this.mCharset = n2;
        this.mRunform = runform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(boolean bl) {
        if (this.mFont == null) {
            FontEntry fontEntry = this;
            synchronized (fontEntry) {
                if (this.mFont == null) {
                    String string;
                    int n;
                    String string2 = this.mRunform.getFontMapUsage() == 1 ? this.mName : this.mRunform.getJavaFontName(this.mName);
                    int n2 = this.mSize;
                    int n3 = n = this.mStyle == 1 ? 2 : 0;
                    if (this.mWeight > 5) {
                        n |= 1;
                    }
                    n2 = n2 * this.mRunform.getScreenRes() / 72;
                    n2 += 50;
                    n2 /= 100;
                    if (bl) {
                        n2 = this.mapFontSize(this.mRunform, string2, n2);
                    }
                    if ((string = this.mRunform.getDispatcher().getApplet().getParameter("forceEvenFontSize")) != null && string.equalsIgnoreCase("true")) {
                        int n4 = this.mSize / 100;
                        if (n2 > 2 && n2 % 2 != 0 && n4 % 2 == 0) {
                            n2 = n2 > n4 ? --n2 : ++n2;
                        }
                    }
                    this.mFont = new Font(string2, n, n2);
                }
            }
        }
        return this.mFont;
    }

    private FontTable getMappingTable() {
        String string = "FontMapping";
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.version").toLowerCase();
        FontTable fontTable = null;
        Class<?> clazz = null;
        if (string2.startsWith("windows 2000") || this.mRunform.isPlatformWindowsXP() || string2.equals("windows 7") || string2.equals("windows 2003") || string2.equals("windows 10")) {
            string = string + "_windows2000";
        } else if (string2.startsWith("windows nt")) {
            string = string3.startsWith("5.0") ? string + "_windows2000" : string + "_windowsNT";
        } else if (string2.startsWith("sunos") || string2.startsWith("solaris")) {
            string = string + "_sunos";
        }
        try {
            clazz = Class.forName("oracle.forms.engine." + string);
            if (clazz != null) {
                fontTable = (FontTable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fontTable;
    }

    private int mapFontSize(Runform runform, String string, int n) {
        if (sMapFonts == null) {
            String string2;
            String string3 = System.getProperty("java.version");
            sMapFonts = string3 != null && !string3.startsWith("1.1") ? ((string2 = runform.getApplet().getParameter("mapFonts")) != null && string2.equalsIgnoreCase("yes") ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
        }
        if (sMapFonts == Boolean.TRUE && n >= 1 && n <= 72) {
            if (sFontTable == null) {
                sFontTable = this.getMappingTable();
            }
            if (sFontTable != null) {
                if ("Dialog".equals(string)) {
                    if (sDialog == null) {
                        sDialog = sFontTable.getFontArray(string);
                    }
                    if (sDialog != null) {
                        n = sDialog[n - 1];
                    }
                }
                if ("DialogInput".equals(string)) {
                    if (sDialogInput == null) {
                        sDialogInput = sFontTable.getFontArray(string);
                    }
                    if (sDialogInput != null) {
                        n = sDialogInput[n - 1];
                    }
                }
                if ("MonoSpaced".equals(string)) {
                    if (sMonoSpaced == null) {
                        sMonoSpaced = sFontTable.getFontArray(string);
                    }
                    if (sMonoSpaced != null) {
                        n = sMonoSpaced[n - 1];
                    }
                }
                if ("SansSerif".equals(string)) {
                    if (sSansSerif == null) {
                        sSansSerif = sFontTable.getFontArray(string);
                    }
                    if (sSansSerif != null) {
                        n = sSansSerif[n - 1];
                    }
                }
                if ("Serif".equals(string)) {
                    if (sSerif == null) {
                        sSerif = sFontTable.getFontArray(string);
                    }
                    if (sSerif != null) {
                        n = sSerif[n - 1];
                    }
                }
            }
        }
        return n;
    }

    static {
        String string = System.getProperty("os.name");
        mIsWindows = string.startsWith("Windows");
    }
}

