/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import java.awt.Component;
import oracle.ewt.lwAWT.LWComponent;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;

public class FocusLogger {
    private Runform mDispatcher = null;
    private boolean[] sEventStatus;
    private static final int TOTAL_EVENTS = 32;
    public static final int GAINED = 0;
    public static final int LOST = 1;
    public static final int DEFERRED = 2;
    public static final int FOCUSLIST_REMOVE = 3;
    public static final int CLEAR_FRQ = 4;
    public static final int WARNING = 6;
    public static final int DEFERRED2 = 8;
    private static final int WARN_EWT = 1;

    public FocusLogger(Runform runform) {
        this.mDispatcher = runform;
        this.sEventStatus = new boolean[32];
    }

    public void setAllEventStatus(int n) {
        for (int i = 0; i < 32; ++i) {
            this.sEventStatus[i] = (n >> i & 1) != 0;
        }
    }

    public boolean isEventOn(int n) {
        return this.sEventStatus[n];
    }

    private void addWarnings(Message message, int n) {
        LWComponent lWComponent;
        ComponentItem componentItem = this.mDispatcher.getFocusOwner();
        Component component = null;
        if (componentItem != null) {
            component = componentItem.getComponent();
        }
        if (component != (lWComponent = LWComponent.getFocusedComponent()) && n != 1 && (component != null || lWComponent != null)) {
            message.add(557, 1);
        }
    }

    public void sendMessage(MessageHandler messageHandler, int n) {
        if (!this.isEventOn(n)) {
            return;
        }
        if (messageHandler == null) {
            messageHandler = this.mDispatcher;
        }
        Message message = Message.newMessage(messageHandler, 556, (Object)n);
        if (this.isEventOn(6)) {
            this.addWarnings(message, n);
        }
        if (n != 0 && n != 1 && n != 3 || message.size() > 1) {
            this.mDispatcher.onMessage(message, 0);
        }
    }
}

