/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import oracle.forms.engine.Runform;

public class FlushQueue
implements Runnable {
    private Runform mParent = null;
    private long mFlushTime = 0L;

    public FlushQueue(Runform runform) {
        this.mParent = runform;
    }

    @Override
    public synchronized void run() {
        while (this.mFlushTime >= 0L) {
            try {
                if (this.mFlushTime > 0L) {
                    long l = this.mFlushTime - System.currentTimeMillis();
                    if (l > 0L) {
                        this.wait(l);
                        continue;
                    }
                    this.mFlushTime = 0L;
                    this.mParent.onMessage(null, 0);
                    continue;
                }
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void clearLooper() {
        this.mFlushTime = -1L;
        this.notify();
    }

    public synchronized void setFlush() {
        if (this.mFlushTime == 0L) {
            this.mFlushTime = 1000L + System.currentTimeMillis();
            this.notify();
        }
    }

    public void clearFlush() {
        this.mFlushTime = 0L;
    }
}

