/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import oracle.forms.engine.ChronosMessage;
import oracle.forms.engine.Runform;
import oracle.forms.net.SingleAccessorQueue;

public class ChronosWriter
extends Thread {
    private static final int DEFAULT_MESSAGE_QUEUE_LENGTH = 20;
    private SingleAccessorQueue mQueue;
    private boolean mKilled = false;
    private Runform mDispatcher;

    public ChronosWriter(Runform runform, int n) {
        super("Forms-ChronosWriter");
        this.mQueue = new SingleAccessorQueue(n);
        this.mDispatcher = runform;
    }

    public ChronosWriter(Runform runform) {
        this(runform, 20);
    }

    public void put(Object object) throws InterruptedException {
        if (this.isAlive()) {
            this.mQueue.put(object);
        }
    }

    public void kill() {
        if (this.mKilled) {
            return;
        }
        this.mKilled = true;
        this.mQueue.destroy();
        this.mQueue = null;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Object object = this.mQueue.get();
                if (!this.mKilled) {
                    if (!(object instanceof ChronosMessage)) continue;
                    ((ChronosMessage)object).writeDetails();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

