/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.engine;

import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.properties.ID;

public class ASyncThread
extends Thread {
    protected static final int DEFAULT_ASYNC_EVENT_DELAY = 5;
    private static final int MIN_ASYNC_EVENT_DELAY = 2000;
    private Runform mDispatcher;
    private long mPollingDelayms;
    private boolean mUsePolling = true;
    private boolean mKilled = false;
    private static int sCount = 0;

    public ASyncThread(Runform runform) {
        this.mDispatcher = runform;
        this.setName("Forms-ASyncThread-" + sCount++);
    }

    public ASyncThread(Runform runform, int n) {
        this(runform);
        this.mPollingDelayms = n * 1000;
        if (this.mPollingDelayms > 0L) {
            if (this.mPollingDelayms == 0L) {
                this.mPollingDelayms = 2000L;
            } else if (this.mPollingDelayms < 2000L) {
                this.mPollingDelayms = 2000L;
            }
        }
        this.mUsePolling = true;
    }

    @Override
    public void run() {
        this.runPolling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPolling() {
        while (true) {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    this.wait(this.mPollingDelayms);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isKilled()) break;
            try {
                object = new Message(2, this.mDispatcher);
                ((Message)object).add(ID.ASYNC_MESSAGE.toID(), null);
                this.mDispatcher.onMessage((Message)object, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
    }

    protected synchronized void kill() {
        this.mKilled = true;
        this.notify();
    }

    private synchronized boolean isKilled() {
        return this.mKilled;
    }
}

