/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.debug;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

final class TimestampedOutputStream
extends FilterOutputStream {
    private boolean mTimeStampNeeded = true;
    private byte[] mBuf1 = new byte[1];
    private byte mEolByte;
    private DateFormat mDateFormat;

    public TimestampedOutputStream(OutputStream outputStream) {
        this(outputStream, "HH:mm:ss.SSS ");
    }

    public TimestampedOutputStream(OutputStream outputStream, String string) {
        super(outputStream);
        byte[] byArray;
        this.mDateFormat = new SimpleDateFormat(string);
        String string2 = System.getProperty("line.separator", "\n");
        if (string2.length() > 1) {
            if (!string2.equals("\r\n")) {
                throw new UnsupportedOperationException("Unsupported line separator");
            }
            string2 = "\n";
        }
        if ((byArray = string2.getBytes()).length > 1) {
            String string3 = Charset.defaultCharset().name();
            throw new UnsupportedOperationException("Unsupported charset " + string3);
        }
        this.mEolByte = byArray[0];
    }

    private void writeTimeStampIfNeeded() throws IOException {
        if (this.mTimeStampNeeded) {
            this.mTimeStampNeeded = false;
            this.write(this.mDateFormat.format(new Date()).getBytes());
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.mBuf1[0] = (byte)n;
        this.write(this.mBuf1);
    }

    @Override
    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        n2 += n;
        while (n3 < n2) {
            if (byArray[n3++] != this.mEolByte) continue;
            this.writeTimeStampIfNeeded();
            this.out.write(byArray, n, n3 - n);
            this.out.flush();
            n = n3;
            this.mTimeStampNeeded = true;
        }
        if (n < n2) {
            this.writeTimeStampIfNeeded();
            this.out.write(byArray, n, n2 - n);
        }
    }
}

